/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.HostFirmwareSettingsStatus;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.SchemaReference;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.SchemaReferenceBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.SchemaReferenceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class HostFirmwareSettingsStatusFluent<A extends HostFirmwareSettingsStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private List<Condition> conditions = new ArrayList<Condition>();
    private String lastUpdated;
    private SchemaReferenceBuilder schema;
    private Map<String, String> settings;

    public HostFirmwareSettingsStatusFluent() {
    }

    public HostFirmwareSettingsStatusFluent(HostFirmwareSettingsStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)((Object)this);
    }

    public A addToSettings(Map<String, String> map) {
        if (this.settings == null && map != null) {
            this.settings = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.settings.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToSettings(String key, String value) {
        if (this.settings == null && key != null && value != null) {
            this.settings = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.settings.put(key, value);
        }
        return (A)((Object)this);
    }

    public SchemaReference buildSchema() {
        return this.schema != null ? this.schema.build() : null;
    }

    protected void copyInstance(HostFirmwareSettingsStatus instance) {
        HostFirmwareSettingsStatus hostFirmwareSettingsStatus = instance = instance != null ? instance : new HostFirmwareSettingsStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withLastUpdated(instance.getLastUpdated());
            this.withSchema(instance.getSchema());
            this.withSettings(instance.getSettings());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SchemaNested<A> editOrNewSchema() {
        return this.withNewSchemaLike(Optional.ofNullable(this.buildSchema()).orElse(new SchemaReferenceBuilder().build()));
    }

    public SchemaNested<A> editOrNewSchemaLike(SchemaReference item) {
        return this.withNewSchemaLike(Optional.ofNullable(this.buildSchema()).orElse(item));
    }

    public SchemaNested<A> editSchema() {
        return this.withNewSchemaLike(Optional.ofNullable(this.buildSchema()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HostFirmwareSettingsStatusFluent that = (HostFirmwareSettingsStatusFluent)((Object)o);
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.lastUpdated, that.lastUpdated)) {
            return false;
        }
        if (!Objects.equals((Object)this.schema, (Object)that.schema)) {
            return false;
        }
        if (!Objects.equals(this.settings, that.settings)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasLastUpdated() {
        return this.lastUpdated != null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSchema() {
        return this.schema != null;
    }

    public boolean hasSettings() {
        return this.settings != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conditions, this.lastUpdated, this.schema, this.settings, this.additionalProperties});
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromSettings(String key) {
        if (this.settings == null) {
            return (A)((Object)this);
        }
        if (key != null && this.settings != null) {
            this.settings.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromSettings(Map<String, String> map) {
        if (this.settings == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.settings == null) continue;
                this.settings.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.lastUpdated != null) {
            sb.append("lastUpdated:");
            sb.append(this.lastUpdated);
            sb.append(",");
        }
        if (this.schema != null) {
            sb.append("schema:");
            sb.append((Object)this.schema);
            sb.append(",");
        }
        if (this.settings != null && !this.settings.isEmpty()) {
            sb.append("settings:");
            sb.append(this.settings);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public A withLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
        return (A)((Object)this);
    }

    public SchemaNested<A> withNewSchema() {
        return new SchemaNested(null);
    }

    public A withNewSchema(String name, String namespace) {
        return this.withSchema(new SchemaReference(name, namespace));
    }

    public SchemaNested<A> withNewSchemaLike(SchemaReference item) {
        return new SchemaNested(item);
    }

    public A withSchema(SchemaReference schema) {
        this._visitables.remove((Object)"schema");
        if (schema != null) {
            this.schema = new SchemaReferenceBuilder(schema);
            this._visitables.get((Object)"schema").add(this.schema);
        } else {
            this.schema = null;
            this._visitables.get((Object)"schema").remove((Object)this.schema);
        }
        return (A)((Object)this);
    }

    public <K, V> A withSettings(Map<String, String> settings) {
        this.settings = settings == null ? null : new LinkedHashMap<String, String>(settings);
        return (A)((Object)this);
    }

    public class SchemaNested<N>
    extends SchemaReferenceFluent<SchemaNested<N>>
    implements Nested<N> {
        SchemaReferenceBuilder builder;

        SchemaNested(SchemaReference item) {
            this.builder = new SchemaReferenceBuilder(this, item);
        }

        public N and() {
            return (N)HostFirmwareSettingsStatusFluent.this.withSchema(this.builder.build());
        }

        public N endSchema() {
            return this.and();
        }
    }
}

