/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.VSpherePermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class VSpherePermissionFluent<A extends VSpherePermissionFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private List<String> privileges = new ArrayList<String>();

    public VSpherePermissionFluent() {
    }

    public VSpherePermissionFluent(VSpherePermission instance) {
        this.copyInstance(instance);
    }

    public A addAllToPrivileges(Collection<String> items) {
        if (this.privileges == null) {
            this.privileges = new ArrayList<String>();
        }
        for (String item : items) {
            this.privileges.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToPrivileges(String ... items) {
        if (this.privileges == null) {
            this.privileges = new ArrayList<String>();
        }
        for (String item : items) {
            this.privileges.add(item);
        }
        return (A)((Object)this);
    }

    public A addToPrivileges(int index, String item) {
        if (this.privileges == null) {
            this.privileges = new ArrayList<String>();
        }
        this.privileges.add(index, item);
        return (A)((Object)this);
    }

    protected void copyInstance(VSpherePermission instance) {
        VSpherePermission vSpherePermission = instance = instance != null ? instance : new VSpherePermission();
        if (instance != null) {
            this.withPrivileges(instance.getPrivileges());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VSpherePermissionFluent that = (VSpherePermissionFluent)((Object)o);
        if (!Objects.equals(this.privileges, that.privileges)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getFirstPrivilege() {
        return this.privileges.get(0);
    }

    public String getLastPrivilege() {
        return this.privileges.get(this.privileges.size() - 1);
    }

    public String getMatchingPrivilege(Predicate<String> predicate) {
        for (String item : this.privileges) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getPrivilege(int index) {
        return this.privileges.get(index);
    }

    public List<String> getPrivileges() {
        return this.privileges;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMatchingPrivilege(Predicate<String> predicate) {
        for (String item : this.privileges) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPrivileges() {
        return this.privileges != null && !this.privileges.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.privileges, this.additionalProperties);
    }

    public A removeAllFromPrivileges(Collection<String> items) {
        if (this.privileges == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.privileges.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromPrivileges(String ... items) {
        if (this.privileges == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.privileges.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToPrivileges(int index, String item) {
        if (this.privileges == null) {
            this.privileges = new ArrayList<String>();
        }
        this.privileges.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.privileges != null && !this.privileges.isEmpty()) {
            sb.append("privileges:");
            sb.append(this.privileges);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withPrivileges(List<String> privileges) {
        if (privileges != null) {
            this.privileges = new ArrayList<String>();
            for (String item : privileges) {
                this.addToPrivileges(item);
            }
        } else {
            this.privileges = null;
        }
        return (A)((Object)this);
    }

    public A withPrivileges(String ... privileges) {
        if (this.privileges != null) {
            this.privileges.clear();
            this._visitables.remove((Object)"privileges");
        }
        if (privileges != null) {
            for (String item : privileges) {
                this.addToPrivileges(item);
            }
        }
        return (A)((Object)this);
    }
}

