/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.StatementEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class StatementEntryFluent<A extends StatementEntryFluent<A>>
extends BaseFluent<A> {
    private List<String> action = new ArrayList<String>();
    private Map<String, Object> additionalProperties;
    private String effect;
    private Map<String, Map<String, Object>> policyCondition;
    private String resource;

    public StatementEntryFluent() {
    }

    public StatementEntryFluent(StatementEntry instance) {
        this.copyInstance(instance);
    }

    public A addAllToAction(Collection<String> items) {
        if (this.action == null) {
            this.action = new ArrayList<String>();
        }
        for (String item : items) {
            this.action.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAction(String ... items) {
        if (this.action == null) {
            this.action = new ArrayList<String>();
        }
        for (String item : items) {
            this.action.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAction(int index, String item) {
        if (this.action == null) {
            this.action = new ArrayList<String>();
        }
        this.action.add(index, item);
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToPolicyCondition(Map<String, Map<String, Object>> map) {
        if (this.policyCondition == null && map != null) {
            this.policyCondition = new LinkedHashMap<String, Map<String, Object>>();
        }
        if (map != null) {
            this.policyCondition.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToPolicyCondition(String key, Map<String, Object> value) {
        if (this.policyCondition == null && key != null && value != null) {
            this.policyCondition = new LinkedHashMap<String, Map<String, Object>>();
        }
        if (key != null && value != null) {
            this.policyCondition.put(key, value);
        }
        return (A)((Object)this);
    }

    protected void copyInstance(StatementEntry instance) {
        StatementEntry statementEntry = instance = instance != null ? instance : new StatementEntry();
        if (instance != null) {
            this.withAction(instance.getAction());
            this.withEffect(instance.getEffect());
            this.withPolicyCondition(instance.getPolicyCondition());
            this.withResource(instance.getResource());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatementEntryFluent that = (StatementEntryFluent)((Object)o);
        if (!Objects.equals(this.action, that.action)) {
            return false;
        }
        if (!Objects.equals(this.effect, that.effect)) {
            return false;
        }
        if (!Objects.equals(this.policyCondition, that.policyCondition)) {
            return false;
        }
        if (!Objects.equals(this.resource, that.resource)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public List<String> getAction() {
        return this.action;
    }

    public String getAction(int index) {
        return this.action.get(index);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getEffect() {
        return this.effect;
    }

    public String getFirstAction() {
        return this.action.get(0);
    }

    public String getLastAction() {
        return this.action.get(this.action.size() - 1);
    }

    public String getMatchingAction(Predicate<String> predicate) {
        for (String item : this.action) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public Map<String, Map<String, Object>> getPolicyCondition() {
        return this.policyCondition;
    }

    public String getResource() {
        return this.resource;
    }

    public boolean hasAction() {
        return this.action != null && !this.action.isEmpty();
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasEffect() {
        return this.effect != null;
    }

    public boolean hasMatchingAction(Predicate<String> predicate) {
        for (String item : this.action) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPolicyCondition() {
        return this.policyCondition != null;
    }

    public boolean hasResource() {
        return this.resource != null;
    }

    public int hashCode() {
        return Objects.hash(this.action, this.effect, this.policyCondition, this.resource, this.additionalProperties);
    }

    public A removeAllFromAction(Collection<String> items) {
        if (this.action == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.action.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAction(String ... items) {
        if (this.action == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.action.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromPolicyCondition(String key) {
        if (this.policyCondition == null) {
            return (A)((Object)this);
        }
        if (key != null && this.policyCondition != null) {
            this.policyCondition.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromPolicyCondition(Map<String, Map<String, Object>> map) {
        if (this.policyCondition == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.policyCondition == null) continue;
                this.policyCondition.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A setToAction(int index, String item) {
        if (this.action == null) {
            this.action = new ArrayList<String>();
        }
        this.action.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.action != null && !this.action.isEmpty()) {
            sb.append("action:");
            sb.append(this.action);
            sb.append(",");
        }
        if (this.effect != null) {
            sb.append("effect:");
            sb.append(this.effect);
            sb.append(",");
        }
        if (this.policyCondition != null && !this.policyCondition.isEmpty()) {
            sb.append("policyCondition:");
            sb.append(this.policyCondition);
            sb.append(",");
        }
        if (this.resource != null) {
            sb.append("resource:");
            sb.append(this.resource);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAction(List<String> action) {
        if (action != null) {
            this.action = new ArrayList<String>();
            for (String item : action) {
                this.addToAction(item);
            }
        } else {
            this.action = null;
        }
        return (A)((Object)this);
    }

    public A withAction(String ... action) {
        if (this.action != null) {
            this.action.clear();
            this._visitables.remove((Object)"action");
        }
        if (action != null) {
            for (String item : action) {
                this.addToAction(item);
            }
        }
        return (A)((Object)this);
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withEffect(String effect) {
        this.effect = effect;
        return (A)((Object)this);
    }

    public <K, V> A withPolicyCondition(Map<String, Map<String, Object>> policyCondition) {
        this.policyCondition = policyCondition == null ? null : new LinkedHashMap<String, Map<String, Object>>(policyCondition);
        return (A)((Object)this);
    }

    public A withResource(String resource) {
        this.resource = resource;
        return (A)((Object)this);
    }
}

