/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.AccessPolicy;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.ResourceAttribute;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.ResourceAttributeBuilder;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.ResourceAttributeFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AccessPolicyFluent<A extends AccessPolicyFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ResourceAttributeBuilder> attributes = new ArrayList();
    private List<String> roles = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public AccessPolicyFluent() {
    }

    public AccessPolicyFluent(AccessPolicy instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AccessPolicy instance) {
        AccessPolicy accessPolicy = instance = instance != null ? instance : new AccessPolicy();
        if (instance != null) {
            this.withAttributes(instance.getAttributes());
            this.withRoles(instance.getRoles());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAttributes(int index, ResourceAttribute item) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        ResourceAttributeBuilder builder = new ResourceAttributeBuilder(item);
        if (index < 0 || index >= this.attributes.size()) {
            this._visitables.get((Object)"attributes").add(builder);
            this.attributes.add(builder);
        } else {
            this._visitables.get((Object)"attributes").add(index, builder);
            this.attributes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAttributes(int index, ResourceAttribute item) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        ResourceAttributeBuilder builder = new ResourceAttributeBuilder(item);
        if (index < 0 || index >= this.attributes.size()) {
            this._visitables.get((Object)"attributes").add(builder);
            this.attributes.add(builder);
        } else {
            this._visitables.get((Object)"attributes").set(index, builder);
            this.attributes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAttributes(ResourceAttribute ... items) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        for (ResourceAttribute item : items) {
            ResourceAttributeBuilder builder = new ResourceAttributeBuilder(item);
            this._visitables.get((Object)"attributes").add(builder);
            this.attributes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAttributes(Collection<ResourceAttribute> items) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        for (ResourceAttribute item : items) {
            ResourceAttributeBuilder builder = new ResourceAttributeBuilder(item);
            this._visitables.get((Object)"attributes").add(builder);
            this.attributes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAttributes(ResourceAttribute ... items) {
        if (this.attributes == null) {
            return (A)((Object)this);
        }
        for (ResourceAttribute item : items) {
            ResourceAttributeBuilder builder = new ResourceAttributeBuilder(item);
            this._visitables.get((Object)"attributes").remove((Object)builder);
            this.attributes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAttributes(Collection<ResourceAttribute> items) {
        if (this.attributes == null) {
            return (A)((Object)this);
        }
        for (ResourceAttribute item : items) {
            ResourceAttributeBuilder builder = new ResourceAttributeBuilder(item);
            this._visitables.get((Object)"attributes").remove((Object)builder);
            this.attributes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAttributes(Predicate<ResourceAttributeBuilder> predicate) {
        if (this.attributes == null) {
            return (A)((Object)this);
        }
        Iterator<ResourceAttributeBuilder> each = this.attributes.iterator();
        List visitables = this._visitables.get((Object)"attributes");
        while (each.hasNext()) {
            ResourceAttributeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ResourceAttribute> buildAttributes() {
        return this.attributes != null ? AccessPolicyFluent.build(this.attributes) : null;
    }

    public ResourceAttribute buildAttribute(int index) {
        return this.attributes.get(index).build();
    }

    public ResourceAttribute buildFirstAttribute() {
        return this.attributes.get(0).build();
    }

    public ResourceAttribute buildLastAttribute() {
        return this.attributes.get(this.attributes.size() - 1).build();
    }

    public ResourceAttribute buildMatchingAttribute(Predicate<ResourceAttributeBuilder> predicate) {
        for (ResourceAttributeBuilder item : this.attributes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAttribute(Predicate<ResourceAttributeBuilder> predicate) {
        for (ResourceAttributeBuilder item : this.attributes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAttributes(List<ResourceAttribute> attributes) {
        if (this.attributes != null) {
            this._visitables.get((Object)"attributes").clear();
        }
        if (attributes != null) {
            this.attributes = new ArrayList();
            for (ResourceAttribute item : attributes) {
                this.addToAttributes(item);
            }
        } else {
            this.attributes = null;
        }
        return (A)((Object)this);
    }

    public A withAttributes(ResourceAttribute ... attributes) {
        if (this.attributes != null) {
            this.attributes.clear();
            this._visitables.remove((Object)"attributes");
        }
        if (attributes != null) {
            for (ResourceAttribute item : attributes) {
                this.addToAttributes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public A addNewAttribute(String name, String operator, String value) {
        return this.addToAttributes(new ResourceAttribute(name, operator, value));
    }

    public AttributesNested<A> addNewAttribute() {
        return new AttributesNested(-1, null);
    }

    public AttributesNested<A> addNewAttributeLike(ResourceAttribute item) {
        return new AttributesNested(-1, item);
    }

    public AttributesNested<A> setNewAttributeLike(int index, ResourceAttribute item) {
        return new AttributesNested(index, item);
    }

    public AttributesNested<A> editAttribute(int index) {
        if (this.attributes.size() <= index) {
            throw new RuntimeException("Can't edit attributes. Index exceeds size.");
        }
        return this.setNewAttributeLike(index, this.buildAttribute(index));
    }

    public AttributesNested<A> editFirstAttribute() {
        if (this.attributes.size() == 0) {
            throw new RuntimeException("Can't edit first attributes. The list is empty.");
        }
        return this.setNewAttributeLike(0, this.buildAttribute(0));
    }

    public AttributesNested<A> editLastAttribute() {
        int index = this.attributes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last attributes. The list is empty.");
        }
        return this.setNewAttributeLike(index, this.buildAttribute(index));
    }

    public AttributesNested<A> editMatchingAttribute(Predicate<ResourceAttributeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (!predicate.test(this.attributes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching attributes. No match found.");
        }
        return this.setNewAttributeLike(index, this.buildAttribute(index));
    }

    public A addToRoles(int index, String item) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        this.roles.add(index, item);
        return (A)((Object)this);
    }

    public A setToRoles(int index, String item) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        this.roles.set(index, item);
        return (A)((Object)this);
    }

    public A addToRoles(String ... items) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        for (String item : items) {
            this.roles.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToRoles(Collection<String> items) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        for (String item : items) {
            this.roles.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromRoles(String ... items) {
        if (this.roles == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.roles.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRoles(Collection<String> items) {
        if (this.roles == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.roles.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public String getRole(int index) {
        return this.roles.get(index);
    }

    public String getFirstRole() {
        return this.roles.get(0);
    }

    public String getLastRole() {
        return this.roles.get(this.roles.size() - 1);
    }

    public String getMatchingRole(Predicate<String> predicate) {
        for (String item : this.roles) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingRole(Predicate<String> predicate) {
        for (String item : this.roles) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRoles(List<String> roles) {
        if (roles != null) {
            this.roles = new ArrayList<String>();
            for (String item : roles) {
                this.addToRoles(item);
            }
        } else {
            this.roles = null;
        }
        return (A)((Object)this);
    }

    public A withRoles(String ... roles) {
        if (this.roles != null) {
            this.roles.clear();
            this._visitables.remove((Object)"roles");
        }
        if (roles != null) {
            for (String item : roles) {
                this.addToRoles(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRoles() {
        return this.roles != null && !this.roles.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AccessPolicyFluent that = (AccessPolicyFluent)((Object)o);
        if (!Objects.equals(this.attributes, that.attributes)) {
            return false;
        }
        if (!Objects.equals(this.roles, that.roles)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.roles, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attributes != null && !this.attributes.isEmpty()) {
            sb.append("attributes:");
            sb.append(this.attributes + ",");
        }
        if (this.roles != null && !this.roles.isEmpty()) {
            sb.append("roles:");
            sb.append(this.roles + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class AttributesNested<N>
    extends ResourceAttributeFluent<AttributesNested<N>>
    implements Nested<N> {
        ResourceAttributeBuilder builder;
        int index;

        AttributesNested(int index, ResourceAttribute item) {
            this.index = index;
            this.builder = new ResourceAttributeBuilder(this, item);
        }

        public N and() {
            return (N)AccessPolicyFluent.this.setToAttributes(this.index, this.builder.build());
        }

        public N endAttribute() {
            return this.and();
        }
    }
}

