/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RootDeviceHints;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RootDeviceHintsBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RootDeviceHintsFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.SoftwareRAIDVolume;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class SoftwareRAIDVolumeFluent<A extends SoftwareRAIDVolumeFluent<A>>
extends BaseFluent<A> {
    private String level;
    private ArrayList<RootDeviceHintsBuilder> physicalDisks = new ArrayList();
    private Integer sizeGibibytes;
    private Map<String, Object> additionalProperties;

    public SoftwareRAIDVolumeFluent() {
    }

    public SoftwareRAIDVolumeFluent(SoftwareRAIDVolume instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SoftwareRAIDVolume instance) {
        SoftwareRAIDVolume softwareRAIDVolume = instance = instance != null ? instance : new SoftwareRAIDVolume();
        if (instance != null) {
            this.withLevel(instance.getLevel());
            this.withPhysicalDisks(instance.getPhysicalDisks());
            this.withSizeGibibytes(instance.getSizeGibibytes());
            this.withLevel(instance.getLevel());
            this.withPhysicalDisks(instance.getPhysicalDisks());
            this.withSizeGibibytes(instance.getSizeGibibytes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getLevel() {
        return this.level;
    }

    public A withLevel(String level) {
        this.level = level;
        return (A)((Object)this);
    }

    public boolean hasLevel() {
        return this.level != null;
    }

    public A addToPhysicalDisks(int index, RootDeviceHints item) {
        if (this.physicalDisks == null) {
            this.physicalDisks = new ArrayList();
        }
        RootDeviceHintsBuilder builder = new RootDeviceHintsBuilder(item);
        if (index < 0 || index >= this.physicalDisks.size()) {
            this._visitables.get((Object)"physicalDisks").add(builder);
            this.physicalDisks.add(builder);
        } else {
            this._visitables.get((Object)"physicalDisks").add(index, builder);
            this.physicalDisks.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPhysicalDisks(int index, RootDeviceHints item) {
        if (this.physicalDisks == null) {
            this.physicalDisks = new ArrayList();
        }
        RootDeviceHintsBuilder builder = new RootDeviceHintsBuilder(item);
        if (index < 0 || index >= this.physicalDisks.size()) {
            this._visitables.get((Object)"physicalDisks").add(builder);
            this.physicalDisks.add(builder);
        } else {
            this._visitables.get((Object)"physicalDisks").set(index, builder);
            this.physicalDisks.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPhysicalDisks(RootDeviceHints ... items) {
        if (this.physicalDisks == null) {
            this.physicalDisks = new ArrayList();
        }
        for (RootDeviceHints item : items) {
            RootDeviceHintsBuilder builder = new RootDeviceHintsBuilder(item);
            this._visitables.get((Object)"physicalDisks").add(builder);
            this.physicalDisks.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPhysicalDisks(Collection<RootDeviceHints> items) {
        if (this.physicalDisks == null) {
            this.physicalDisks = new ArrayList();
        }
        for (RootDeviceHints item : items) {
            RootDeviceHintsBuilder builder = new RootDeviceHintsBuilder(item);
            this._visitables.get((Object)"physicalDisks").add(builder);
            this.physicalDisks.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPhysicalDisks(RootDeviceHints ... items) {
        if (this.physicalDisks == null) {
            return (A)((Object)this);
        }
        for (RootDeviceHints item : items) {
            RootDeviceHintsBuilder builder = new RootDeviceHintsBuilder(item);
            this._visitables.get((Object)"physicalDisks").remove((Object)builder);
            this.physicalDisks.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPhysicalDisks(Collection<RootDeviceHints> items) {
        if (this.physicalDisks == null) {
            return (A)((Object)this);
        }
        for (RootDeviceHints item : items) {
            RootDeviceHintsBuilder builder = new RootDeviceHintsBuilder(item);
            this._visitables.get((Object)"physicalDisks").remove((Object)builder);
            this.physicalDisks.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPhysicalDisks(Predicate<RootDeviceHintsBuilder> predicate) {
        if (this.physicalDisks == null) {
            return (A)((Object)this);
        }
        Iterator<RootDeviceHintsBuilder> each = this.physicalDisks.iterator();
        List visitables = this._visitables.get((Object)"physicalDisks");
        while (each.hasNext()) {
            RootDeviceHintsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<RootDeviceHints> buildPhysicalDisks() {
        return this.physicalDisks != null ? SoftwareRAIDVolumeFluent.build(this.physicalDisks) : null;
    }

    public RootDeviceHints buildPhysicalDisk(int index) {
        return this.physicalDisks.get(index).build();
    }

    public RootDeviceHints buildFirstPhysicalDisk() {
        return this.physicalDisks.get(0).build();
    }

    public RootDeviceHints buildLastPhysicalDisk() {
        return this.physicalDisks.get(this.physicalDisks.size() - 1).build();
    }

    public RootDeviceHints buildMatchingPhysicalDisk(Predicate<RootDeviceHintsBuilder> predicate) {
        for (RootDeviceHintsBuilder item : this.physicalDisks) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPhysicalDisk(Predicate<RootDeviceHintsBuilder> predicate) {
        for (RootDeviceHintsBuilder item : this.physicalDisks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPhysicalDisks(List<RootDeviceHints> physicalDisks) {
        if (this.physicalDisks != null) {
            this._visitables.get((Object)"physicalDisks").clear();
        }
        if (physicalDisks != null) {
            this.physicalDisks = new ArrayList();
            for (RootDeviceHints item : physicalDisks) {
                this.addToPhysicalDisks(item);
            }
        } else {
            this.physicalDisks = null;
        }
        return (A)((Object)this);
    }

    public A withPhysicalDisks(RootDeviceHints ... physicalDisks) {
        if (this.physicalDisks != null) {
            this.physicalDisks.clear();
            this._visitables.remove((Object)"physicalDisks");
        }
        if (physicalDisks != null) {
            for (RootDeviceHints item : physicalDisks) {
                this.addToPhysicalDisks(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPhysicalDisks() {
        return this.physicalDisks != null && !this.physicalDisks.isEmpty();
    }

    public PhysicalDisksNested<A> addNewPhysicalDisk() {
        return new PhysicalDisksNested(-1, null);
    }

    public PhysicalDisksNested<A> addNewPhysicalDiskLike(RootDeviceHints item) {
        return new PhysicalDisksNested(-1, item);
    }

    public PhysicalDisksNested<A> setNewPhysicalDiskLike(int index, RootDeviceHints item) {
        return new PhysicalDisksNested(index, item);
    }

    public PhysicalDisksNested<A> editPhysicalDisk(int index) {
        if (this.physicalDisks.size() <= index) {
            throw new RuntimeException("Can't edit physicalDisks. Index exceeds size.");
        }
        return this.setNewPhysicalDiskLike(index, this.buildPhysicalDisk(index));
    }

    public PhysicalDisksNested<A> editFirstPhysicalDisk() {
        if (this.physicalDisks.size() == 0) {
            throw new RuntimeException("Can't edit first physicalDisks. The list is empty.");
        }
        return this.setNewPhysicalDiskLike(0, this.buildPhysicalDisk(0));
    }

    public PhysicalDisksNested<A> editLastPhysicalDisk() {
        int index = this.physicalDisks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last physicalDisks. The list is empty.");
        }
        return this.setNewPhysicalDiskLike(index, this.buildPhysicalDisk(index));
    }

    public PhysicalDisksNested<A> editMatchingPhysicalDisk(Predicate<RootDeviceHintsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.physicalDisks.size(); ++i) {
            if (!predicate.test(this.physicalDisks.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching physicalDisks. No match found.");
        }
        return this.setNewPhysicalDiskLike(index, this.buildPhysicalDisk(index));
    }

    public Integer getSizeGibibytes() {
        return this.sizeGibibytes;
    }

    public A withSizeGibibytes(Integer sizeGibibytes) {
        this.sizeGibibytes = sizeGibibytes;
        return (A)((Object)this);
    }

    public boolean hasSizeGibibytes() {
        return this.sizeGibibytes != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SoftwareRAIDVolumeFluent that = (SoftwareRAIDVolumeFluent)((Object)o);
        if (!Objects.equals(this.level, that.level)) {
            return false;
        }
        if (!Objects.equals(this.physicalDisks, that.physicalDisks)) {
            return false;
        }
        if (!Objects.equals(this.sizeGibibytes, that.sizeGibibytes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.level, this.physicalDisks, this.sizeGibibytes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.level != null) {
            sb.append("level:");
            sb.append(this.level + ",");
        }
        if (this.physicalDisks != null && !this.physicalDisks.isEmpty()) {
            sb.append("physicalDisks:");
            sb.append(this.physicalDisks + ",");
        }
        if (this.sizeGibibytes != null) {
            sb.append("sizeGibibytes:");
            sb.append(this.sizeGibibytes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PhysicalDisksNested<N>
    extends RootDeviceHintsFluent<PhysicalDisksNested<N>>
    implements Nested<N> {
        RootDeviceHintsBuilder builder;
        int index;

        PhysicalDisksNested(int index, RootDeviceHints item) {
            this.index = index;
            this.builder = new RootDeviceHintsBuilder(this, item);
        }

        public N and() {
            return (N)SoftwareRAIDVolumeFluent.this.setToPhysicalDisks(this.index, this.builder.build());
        }

        public N endPhysicalDisk() {
            return this.and();
        }
    }
}

