/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.SecretReference;
import io.fabric8.kubernetes.api.model.Taint;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.BMCDetails;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.BMCDetailsBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.BMCDetailsFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.BareMetalHostSpec;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.CustomDeploy;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.CustomDeployBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.CustomDeployFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.FirmwareConfig;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.FirmwareConfigBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.FirmwareConfigFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.Image;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.ImageBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.ImageFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RAIDConfig;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RAIDConfigBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RAIDConfigFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RootDeviceHints;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RootDeviceHintsBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RootDeviceHintsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class BareMetalHostSpecFluent<A extends BareMetalHostSpecFluent<A>>
extends BaseFluent<A> {
    private String architecture;
    private String automatedCleaningMode;
    private BMCDetailsBuilder bmc;
    private String bootMACAddress;
    private String bootMode;
    private ObjectReferenceBuilder consumerRef;
    private CustomDeployBuilder customDeploy;
    private String description;
    private Boolean externallyProvisioned;
    private FirmwareConfigBuilder firmware;
    private String hardwareProfile;
    private ImageBuilder image;
    private SecretReference metaData;
    private SecretReference networkData;
    private Boolean online;
    private String preprovisioningNetworkDataName;
    private RAIDConfigBuilder raid;
    private RootDeviceHintsBuilder rootDeviceHints;
    private List<Taint> taints = new ArrayList<Taint>();
    private SecretReference userData;
    private Map<String, Object> additionalProperties;

    public BareMetalHostSpecFluent() {
    }

    public BareMetalHostSpecFluent(BareMetalHostSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(BareMetalHostSpec instance) {
        BareMetalHostSpec bareMetalHostSpec = instance = instance != null ? instance : new BareMetalHostSpec();
        if (instance != null) {
            this.withArchitecture(instance.getArchitecture());
            this.withAutomatedCleaningMode(instance.getAutomatedCleaningMode());
            this.withBmc(instance.getBmc());
            this.withBootMACAddress(instance.getBootMACAddress());
            this.withBootMode(instance.getBootMode());
            this.withConsumerRef(instance.getConsumerRef());
            this.withCustomDeploy(instance.getCustomDeploy());
            this.withDescription(instance.getDescription());
            this.withExternallyProvisioned(instance.getExternallyProvisioned());
            this.withFirmware(instance.getFirmware());
            this.withHardwareProfile(instance.getHardwareProfile());
            this.withImage(instance.getImage());
            this.withMetaData(instance.getMetaData());
            this.withNetworkData(instance.getNetworkData());
            this.withOnline(instance.getOnline());
            this.withPreprovisioningNetworkDataName(instance.getPreprovisioningNetworkDataName());
            this.withRaid(instance.getRaid());
            this.withRootDeviceHints(instance.getRootDeviceHints());
            this.withTaints(instance.getTaints());
            this.withUserData(instance.getUserData());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public A withArchitecture(String architecture) {
        this.architecture = architecture;
        return (A)((Object)this);
    }

    public boolean hasArchitecture() {
        return this.architecture != null;
    }

    public String getAutomatedCleaningMode() {
        return this.automatedCleaningMode;
    }

    public A withAutomatedCleaningMode(String automatedCleaningMode) {
        this.automatedCleaningMode = automatedCleaningMode;
        return (A)((Object)this);
    }

    public boolean hasAutomatedCleaningMode() {
        return this.automatedCleaningMode != null;
    }

    public BMCDetails buildBmc() {
        return this.bmc != null ? this.bmc.build() : null;
    }

    public A withBmc(BMCDetails bmc) {
        this._visitables.remove((Object)"bmc");
        if (bmc != null) {
            this.bmc = new BMCDetailsBuilder(bmc);
            this._visitables.get((Object)"bmc").add(this.bmc);
        } else {
            this.bmc = null;
            this._visitables.get((Object)"bmc").remove((Object)this.bmc);
        }
        return (A)((Object)this);
    }

    public boolean hasBmc() {
        return this.bmc != null;
    }

    public A withNewBmc(String address, String credentialsName, Boolean disableCertificateVerification) {
        return this.withBmc(new BMCDetails(address, credentialsName, disableCertificateVerification));
    }

    public BmcNested<A> withNewBmc() {
        return new BmcNested(null);
    }

    public BmcNested<A> withNewBmcLike(BMCDetails item) {
        return new BmcNested(item);
    }

    public BmcNested<A> editBmc() {
        return this.withNewBmcLike(Optional.ofNullable(this.buildBmc()).orElse(null));
    }

    public BmcNested<A> editOrNewBmc() {
        return this.withNewBmcLike(Optional.ofNullable(this.buildBmc()).orElse(new BMCDetailsBuilder().build()));
    }

    public BmcNested<A> editOrNewBmcLike(BMCDetails item) {
        return this.withNewBmcLike(Optional.ofNullable(this.buildBmc()).orElse(item));
    }

    public String getBootMACAddress() {
        return this.bootMACAddress;
    }

    public A withBootMACAddress(String bootMACAddress) {
        this.bootMACAddress = bootMACAddress;
        return (A)((Object)this);
    }

    public boolean hasBootMACAddress() {
        return this.bootMACAddress != null;
    }

    public String getBootMode() {
        return this.bootMode;
    }

    public A withBootMode(String bootMode) {
        this.bootMode = bootMode;
        return (A)((Object)this);
    }

    public boolean hasBootMode() {
        return this.bootMode != null;
    }

    public ObjectReference buildConsumerRef() {
        return this.consumerRef != null ? this.consumerRef.build() : null;
    }

    public A withConsumerRef(ObjectReference consumerRef) {
        this._visitables.remove((Object)"consumerRef");
        if (consumerRef != null) {
            this.consumerRef = new ObjectReferenceBuilder(consumerRef);
            this._visitables.get((Object)"consumerRef").add(this.consumerRef);
        } else {
            this.consumerRef = null;
            this._visitables.get((Object)"consumerRef").remove(this.consumerRef);
        }
        return (A)((Object)this);
    }

    public boolean hasConsumerRef() {
        return this.consumerRef != null;
    }

    public ConsumerRefNested<A> withNewConsumerRef() {
        return new ConsumerRefNested(null);
    }

    public ConsumerRefNested<A> withNewConsumerRefLike(ObjectReference item) {
        return new ConsumerRefNested(item);
    }

    public ConsumerRefNested<A> editConsumerRef() {
        return this.withNewConsumerRefLike(Optional.ofNullable(this.buildConsumerRef()).orElse(null));
    }

    public ConsumerRefNested<A> editOrNewConsumerRef() {
        return this.withNewConsumerRefLike(Optional.ofNullable(this.buildConsumerRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public ConsumerRefNested<A> editOrNewConsumerRefLike(ObjectReference item) {
        return this.withNewConsumerRefLike(Optional.ofNullable(this.buildConsumerRef()).orElse(item));
    }

    public CustomDeploy buildCustomDeploy() {
        return this.customDeploy != null ? this.customDeploy.build() : null;
    }

    public A withCustomDeploy(CustomDeploy customDeploy) {
        this._visitables.remove((Object)"customDeploy");
        if (customDeploy != null) {
            this.customDeploy = new CustomDeployBuilder(customDeploy);
            this._visitables.get((Object)"customDeploy").add(this.customDeploy);
        } else {
            this.customDeploy = null;
            this._visitables.get((Object)"customDeploy").remove((Object)this.customDeploy);
        }
        return (A)((Object)this);
    }

    public boolean hasCustomDeploy() {
        return this.customDeploy != null;
    }

    public A withNewCustomDeploy(String method) {
        return this.withCustomDeploy(new CustomDeploy(method));
    }

    public CustomDeployNested<A> withNewCustomDeploy() {
        return new CustomDeployNested(null);
    }

    public CustomDeployNested<A> withNewCustomDeployLike(CustomDeploy item) {
        return new CustomDeployNested(item);
    }

    public CustomDeployNested<A> editCustomDeploy() {
        return this.withNewCustomDeployLike(Optional.ofNullable(this.buildCustomDeploy()).orElse(null));
    }

    public CustomDeployNested<A> editOrNewCustomDeploy() {
        return this.withNewCustomDeployLike(Optional.ofNullable(this.buildCustomDeploy()).orElse(new CustomDeployBuilder().build()));
    }

    public CustomDeployNested<A> editOrNewCustomDeployLike(CustomDeploy item) {
        return this.withNewCustomDeployLike(Optional.ofNullable(this.buildCustomDeploy()).orElse(item));
    }

    public String getDescription() {
        return this.description;
    }

    public A withDescription(String description) {
        this.description = description;
        return (A)((Object)this);
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public Boolean getExternallyProvisioned() {
        return this.externallyProvisioned;
    }

    public A withExternallyProvisioned(Boolean externallyProvisioned) {
        this.externallyProvisioned = externallyProvisioned;
        return (A)((Object)this);
    }

    public boolean hasExternallyProvisioned() {
        return this.externallyProvisioned != null;
    }

    public FirmwareConfig buildFirmware() {
        return this.firmware != null ? this.firmware.build() : null;
    }

    public A withFirmware(FirmwareConfig firmware) {
        this._visitables.remove((Object)"firmware");
        if (firmware != null) {
            this.firmware = new FirmwareConfigBuilder(firmware);
            this._visitables.get((Object)"firmware").add(this.firmware);
        } else {
            this.firmware = null;
            this._visitables.get((Object)"firmware").remove((Object)this.firmware);
        }
        return (A)((Object)this);
    }

    public boolean hasFirmware() {
        return this.firmware != null;
    }

    public A withNewFirmware(Boolean simultaneousMultithreadingEnabled, Boolean sriovEnabled, Boolean virtualizationEnabled) {
        return this.withFirmware(new FirmwareConfig(simultaneousMultithreadingEnabled, sriovEnabled, virtualizationEnabled));
    }

    public FirmwareNested<A> withNewFirmware() {
        return new FirmwareNested(null);
    }

    public FirmwareNested<A> withNewFirmwareLike(FirmwareConfig item) {
        return new FirmwareNested(item);
    }

    public FirmwareNested<A> editFirmware() {
        return this.withNewFirmwareLike(Optional.ofNullable(this.buildFirmware()).orElse(null));
    }

    public FirmwareNested<A> editOrNewFirmware() {
        return this.withNewFirmwareLike(Optional.ofNullable(this.buildFirmware()).orElse(new FirmwareConfigBuilder().build()));
    }

    public FirmwareNested<A> editOrNewFirmwareLike(FirmwareConfig item) {
        return this.withNewFirmwareLike(Optional.ofNullable(this.buildFirmware()).orElse(item));
    }

    public String getHardwareProfile() {
        return this.hardwareProfile;
    }

    public A withHardwareProfile(String hardwareProfile) {
        this.hardwareProfile = hardwareProfile;
        return (A)((Object)this);
    }

    public boolean hasHardwareProfile() {
        return this.hardwareProfile != null;
    }

    public Image buildImage() {
        return this.image != null ? this.image.build() : null;
    }

    public A withImage(Image image) {
        this._visitables.remove((Object)"image");
        if (image != null) {
            this.image = new ImageBuilder(image);
            this._visitables.get((Object)"image").add(this.image);
        } else {
            this.image = null;
            this._visitables.get((Object)"image").remove((Object)this.image);
        }
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public A withNewImage(String checksum, String checksumType, String format, String url) {
        return this.withImage(new Image(checksum, checksumType, format, url));
    }

    public ImageNested<A> withNewImage() {
        return new ImageNested(null);
    }

    public ImageNested<A> withNewImageLike(Image item) {
        return new ImageNested(item);
    }

    public ImageNested<A> editImage() {
        return this.withNewImageLike(Optional.ofNullable(this.buildImage()).orElse(null));
    }

    public ImageNested<A> editOrNewImage() {
        return this.withNewImageLike(Optional.ofNullable(this.buildImage()).orElse(new ImageBuilder().build()));
    }

    public ImageNested<A> editOrNewImageLike(Image item) {
        return this.withNewImageLike(Optional.ofNullable(this.buildImage()).orElse(item));
    }

    public SecretReference getMetaData() {
        return this.metaData;
    }

    public A withMetaData(SecretReference metaData) {
        this.metaData = metaData;
        return (A)((Object)this);
    }

    public boolean hasMetaData() {
        return this.metaData != null;
    }

    public A withNewMetaData(String name, String namespace) {
        return this.withMetaData(new SecretReference(name, namespace));
    }

    public SecretReference getNetworkData() {
        return this.networkData;
    }

    public A withNetworkData(SecretReference networkData) {
        this.networkData = networkData;
        return (A)((Object)this);
    }

    public boolean hasNetworkData() {
        return this.networkData != null;
    }

    public A withNewNetworkData(String name, String namespace) {
        return this.withNetworkData(new SecretReference(name, namespace));
    }

    public Boolean getOnline() {
        return this.online;
    }

    public A withOnline(Boolean online) {
        this.online = online;
        return (A)((Object)this);
    }

    public boolean hasOnline() {
        return this.online != null;
    }

    public String getPreprovisioningNetworkDataName() {
        return this.preprovisioningNetworkDataName;
    }

    public A withPreprovisioningNetworkDataName(String preprovisioningNetworkDataName) {
        this.preprovisioningNetworkDataName = preprovisioningNetworkDataName;
        return (A)((Object)this);
    }

    public boolean hasPreprovisioningNetworkDataName() {
        return this.preprovisioningNetworkDataName != null;
    }

    public RAIDConfig buildRaid() {
        return this.raid != null ? this.raid.build() : null;
    }

    public A withRaid(RAIDConfig raid) {
        this._visitables.remove((Object)"raid");
        if (raid != null) {
            this.raid = new RAIDConfigBuilder(raid);
            this._visitables.get((Object)"raid").add(this.raid);
        } else {
            this.raid = null;
            this._visitables.get((Object)"raid").remove((Object)this.raid);
        }
        return (A)((Object)this);
    }

    public boolean hasRaid() {
        return this.raid != null;
    }

    public RaidNested<A> withNewRaid() {
        return new RaidNested(null);
    }

    public RaidNested<A> withNewRaidLike(RAIDConfig item) {
        return new RaidNested(item);
    }

    public RaidNested<A> editRaid() {
        return this.withNewRaidLike(Optional.ofNullable(this.buildRaid()).orElse(null));
    }

    public RaidNested<A> editOrNewRaid() {
        return this.withNewRaidLike(Optional.ofNullable(this.buildRaid()).orElse(new RAIDConfigBuilder().build()));
    }

    public RaidNested<A> editOrNewRaidLike(RAIDConfig item) {
        return this.withNewRaidLike(Optional.ofNullable(this.buildRaid()).orElse(item));
    }

    public RootDeviceHints buildRootDeviceHints() {
        return this.rootDeviceHints != null ? this.rootDeviceHints.build() : null;
    }

    public A withRootDeviceHints(RootDeviceHints rootDeviceHints) {
        this._visitables.remove((Object)"rootDeviceHints");
        if (rootDeviceHints != null) {
            this.rootDeviceHints = new RootDeviceHintsBuilder(rootDeviceHints);
            this._visitables.get((Object)"rootDeviceHints").add(this.rootDeviceHints);
        } else {
            this.rootDeviceHints = null;
            this._visitables.get((Object)"rootDeviceHints").remove((Object)this.rootDeviceHints);
        }
        return (A)((Object)this);
    }

    public boolean hasRootDeviceHints() {
        return this.rootDeviceHints != null;
    }

    public RootDeviceHintsNested<A> withNewRootDeviceHints() {
        return new RootDeviceHintsNested(null);
    }

    public RootDeviceHintsNested<A> withNewRootDeviceHintsLike(RootDeviceHints item) {
        return new RootDeviceHintsNested(item);
    }

    public RootDeviceHintsNested<A> editRootDeviceHints() {
        return this.withNewRootDeviceHintsLike(Optional.ofNullable(this.buildRootDeviceHints()).orElse(null));
    }

    public RootDeviceHintsNested<A> editOrNewRootDeviceHints() {
        return this.withNewRootDeviceHintsLike(Optional.ofNullable(this.buildRootDeviceHints()).orElse(new RootDeviceHintsBuilder().build()));
    }

    public RootDeviceHintsNested<A> editOrNewRootDeviceHintsLike(RootDeviceHints item) {
        return this.withNewRootDeviceHintsLike(Optional.ofNullable(this.buildRootDeviceHints()).orElse(item));
    }

    public A addToTaints(int index, Taint item) {
        if (this.taints == null) {
            this.taints = new ArrayList<Taint>();
        }
        this.taints.add(index, item);
        return (A)((Object)this);
    }

    public A setToTaints(int index, Taint item) {
        if (this.taints == null) {
            this.taints = new ArrayList<Taint>();
        }
        this.taints.set(index, item);
        return (A)((Object)this);
    }

    public A addToTaints(Taint ... items) {
        if (this.taints == null) {
            this.taints = new ArrayList<Taint>();
        }
        for (Taint item : items) {
            this.taints.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTaints(Collection<Taint> items) {
        if (this.taints == null) {
            this.taints = new ArrayList<Taint>();
        }
        for (Taint item : items) {
            this.taints.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTaints(Taint ... items) {
        if (this.taints == null) {
            return (A)((Object)this);
        }
        for (Taint item : items) {
            this.taints.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTaints(Collection<Taint> items) {
        if (this.taints == null) {
            return (A)((Object)this);
        }
        for (Taint item : items) {
            this.taints.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Taint> getTaints() {
        return this.taints;
    }

    public Taint getTaint(int index) {
        return this.taints.get(index);
    }

    public Taint getFirstTaint() {
        return this.taints.get(0);
    }

    public Taint getLastTaint() {
        return this.taints.get(this.taints.size() - 1);
    }

    public Taint getMatchingTaint(Predicate<Taint> predicate) {
        for (Taint item : this.taints) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTaint(Predicate<Taint> predicate) {
        for (Taint item : this.taints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTaints(List<Taint> taints) {
        if (taints != null) {
            this.taints = new ArrayList<Taint>();
            for (Taint item : taints) {
                this.addToTaints(item);
            }
        } else {
            this.taints = null;
        }
        return (A)((Object)this);
    }

    public A withTaints(Taint ... taints) {
        if (this.taints != null) {
            this.taints.clear();
            this._visitables.remove((Object)"taints");
        }
        if (taints != null) {
            for (Taint item : taints) {
                this.addToTaints(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTaints() {
        return this.taints != null && !this.taints.isEmpty();
    }

    public A addNewTaint(String effect, String key, String timeAdded, String value) {
        return this.addToTaints(new Taint(effect, key, timeAdded, value));
    }

    public SecretReference getUserData() {
        return this.userData;
    }

    public A withUserData(SecretReference userData) {
        this.userData = userData;
        return (A)((Object)this);
    }

    public boolean hasUserData() {
        return this.userData != null;
    }

    public A withNewUserData(String name, String namespace) {
        return this.withUserData(new SecretReference(name, namespace));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BareMetalHostSpecFluent that = (BareMetalHostSpecFluent)((Object)o);
        if (!Objects.equals(this.architecture, that.architecture)) {
            return false;
        }
        if (!Objects.equals(this.automatedCleaningMode, that.automatedCleaningMode)) {
            return false;
        }
        if (!Objects.equals((Object)this.bmc, (Object)that.bmc)) {
            return false;
        }
        if (!Objects.equals(this.bootMACAddress, that.bootMACAddress)) {
            return false;
        }
        if (!Objects.equals(this.bootMode, that.bootMode)) {
            return false;
        }
        if (!Objects.equals(this.consumerRef, that.consumerRef)) {
            return false;
        }
        if (!Objects.equals((Object)this.customDeploy, (Object)that.customDeploy)) {
            return false;
        }
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.externallyProvisioned, that.externallyProvisioned)) {
            return false;
        }
        if (!Objects.equals((Object)this.firmware, (Object)that.firmware)) {
            return false;
        }
        if (!Objects.equals(this.hardwareProfile, that.hardwareProfile)) {
            return false;
        }
        if (!Objects.equals((Object)this.image, (Object)that.image)) {
            return false;
        }
        if (!Objects.equals(this.metaData, that.metaData)) {
            return false;
        }
        if (!Objects.equals(this.networkData, that.networkData)) {
            return false;
        }
        if (!Objects.equals(this.online, that.online)) {
            return false;
        }
        if (!Objects.equals(this.preprovisioningNetworkDataName, that.preprovisioningNetworkDataName)) {
            return false;
        }
        if (!Objects.equals((Object)this.raid, (Object)that.raid)) {
            return false;
        }
        if (!Objects.equals((Object)this.rootDeviceHints, (Object)that.rootDeviceHints)) {
            return false;
        }
        if (!Objects.equals(this.taints, that.taints)) {
            return false;
        }
        if (!Objects.equals(this.userData, that.userData)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.architecture, this.automatedCleaningMode, this.bmc, this.bootMACAddress, this.bootMode, this.consumerRef, this.customDeploy, this.description, this.externallyProvisioned, this.firmware, this.hardwareProfile, this.image, this.metaData, this.networkData, this.online, this.preprovisioningNetworkDataName, this.raid, this.rootDeviceHints, this.taints, this.userData, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.architecture != null) {
            sb.append("architecture:");
            sb.append(this.architecture + ",");
        }
        if (this.automatedCleaningMode != null) {
            sb.append("automatedCleaningMode:");
            sb.append(this.automatedCleaningMode + ",");
        }
        if (this.bmc != null) {
            sb.append("bmc:");
            sb.append((Object)((Object)this.bmc) + ",");
        }
        if (this.bootMACAddress != null) {
            sb.append("bootMACAddress:");
            sb.append(this.bootMACAddress + ",");
        }
        if (this.bootMode != null) {
            sb.append("bootMode:");
            sb.append(this.bootMode + ",");
        }
        if (this.consumerRef != null) {
            sb.append("consumerRef:");
            sb.append(this.consumerRef + ",");
        }
        if (this.customDeploy != null) {
            sb.append("customDeploy:");
            sb.append((Object)((Object)this.customDeploy) + ",");
        }
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description + ",");
        }
        if (this.externallyProvisioned != null) {
            sb.append("externallyProvisioned:");
            sb.append(this.externallyProvisioned + ",");
        }
        if (this.firmware != null) {
            sb.append("firmware:");
            sb.append((Object)((Object)this.firmware) + ",");
        }
        if (this.hardwareProfile != null) {
            sb.append("hardwareProfile:");
            sb.append(this.hardwareProfile + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append((Object)((Object)this.image) + ",");
        }
        if (this.metaData != null) {
            sb.append("metaData:");
            sb.append(this.metaData + ",");
        }
        if (this.networkData != null) {
            sb.append("networkData:");
            sb.append(this.networkData + ",");
        }
        if (this.online != null) {
            sb.append("online:");
            sb.append(this.online + ",");
        }
        if (this.preprovisioningNetworkDataName != null) {
            sb.append("preprovisioningNetworkDataName:");
            sb.append(this.preprovisioningNetworkDataName + ",");
        }
        if (this.raid != null) {
            sb.append("raid:");
            sb.append((Object)((Object)this.raid) + ",");
        }
        if (this.rootDeviceHints != null) {
            sb.append("rootDeviceHints:");
            sb.append((Object)((Object)this.rootDeviceHints) + ",");
        }
        if (this.taints != null && !this.taints.isEmpty()) {
            sb.append("taints:");
            sb.append(this.taints + ",");
        }
        if (this.userData != null) {
            sb.append("userData:");
            sb.append(this.userData + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withExternallyProvisioned() {
        return this.withExternallyProvisioned(true);
    }

    public A withOnline() {
        return this.withOnline(true);
    }

    public class RootDeviceHintsNested<N>
    extends RootDeviceHintsFluent<RootDeviceHintsNested<N>>
    implements Nested<N> {
        RootDeviceHintsBuilder builder;

        RootDeviceHintsNested(RootDeviceHints item) {
            this.builder = new RootDeviceHintsBuilder(this, item);
        }

        public N and() {
            return (N)BareMetalHostSpecFluent.this.withRootDeviceHints(this.builder.build());
        }

        public N endRootDeviceHints() {
            return this.and();
        }
    }

    public class RaidNested<N>
    extends RAIDConfigFluent<RaidNested<N>>
    implements Nested<N> {
        RAIDConfigBuilder builder;

        RaidNested(RAIDConfig item) {
            this.builder = new RAIDConfigBuilder(this, item);
        }

        public N and() {
            return (N)BareMetalHostSpecFluent.this.withRaid(this.builder.build());
        }

        public N endRaid() {
            return this.and();
        }
    }

    public class ImageNested<N>
    extends ImageFluent<ImageNested<N>>
    implements Nested<N> {
        ImageBuilder builder;

        ImageNested(Image item) {
            this.builder = new ImageBuilder(this, item);
        }

        public N and() {
            return (N)BareMetalHostSpecFluent.this.withImage(this.builder.build());
        }

        public N endImage() {
            return this.and();
        }
    }

    public class FirmwareNested<N>
    extends FirmwareConfigFluent<FirmwareNested<N>>
    implements Nested<N> {
        FirmwareConfigBuilder builder;

        FirmwareNested(FirmwareConfig item) {
            this.builder = new FirmwareConfigBuilder(this, item);
        }

        public N and() {
            return (N)BareMetalHostSpecFluent.this.withFirmware(this.builder.build());
        }

        public N endFirmware() {
            return this.and();
        }
    }

    public class CustomDeployNested<N>
    extends CustomDeployFluent<CustomDeployNested<N>>
    implements Nested<N> {
        CustomDeployBuilder builder;

        CustomDeployNested(CustomDeploy item) {
            this.builder = new CustomDeployBuilder(this, item);
        }

        public N and() {
            return (N)BareMetalHostSpecFluent.this.withCustomDeploy(this.builder.build());
        }

        public N endCustomDeploy() {
            return this.and();
        }
    }

    public class ConsumerRefNested<N>
    extends ObjectReferenceFluent<ConsumerRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        ConsumerRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)BareMetalHostSpecFluent.this.withConsumerRef(this.builder.build());
        }

        public N endConsumerRef() {
            return this.and();
        }
    }

    public class BmcNested<N>
    extends BMCDetailsFluent<BmcNested<N>>
    implements Nested<N> {
        BMCDetailsBuilder builder;

        BmcNested(BMCDetails item) {
            this.builder = new BMCDetailsBuilder(this, item);
        }

        public N and() {
            return (N)BareMetalHostSpecFluent.this.withBmc(this.builder.build());
        }

        public N endBmc() {
            return this.and();
        }
    }
}

