/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machineconfiguration.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machineconfiguration.v1.CertExpiry;
import io.fabric8.openshift.api.model.machineconfiguration.v1.CertExpiryBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1.CertExpiryFluent;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineConfigPoolCondition;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineConfigPoolConditionBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineConfigPoolConditionFluent;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineConfigPoolStatus;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineConfigPoolStatusConfiguration;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineConfigPoolStatusConfigurationBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineConfigPoolStatusConfigurationFluent;
import io.fabric8.openshift.api.model.machineconfiguration.v1.PoolSynchronizerStatus;
import io.fabric8.openshift.api.model.machineconfiguration.v1.PoolSynchronizerStatusBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1.PoolSynchronizerStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachineConfigPoolStatusFluent<A extends MachineConfigPoolStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<CertExpiryBuilder> certExpirys = new ArrayList();
    private ArrayList<MachineConfigPoolConditionBuilder> conditions = new ArrayList();
    private MachineConfigPoolStatusConfigurationBuilder configuration;
    private Integer degradedMachineCount;
    private Integer machineCount;
    private Long observedGeneration;
    private ArrayList<PoolSynchronizerStatusBuilder> poolSynchronizersStatus = new ArrayList();
    private Integer readyMachineCount;
    private Integer unavailableMachineCount;
    private Integer updatedMachineCount;

    public MachineConfigPoolStatusFluent() {
    }

    public MachineConfigPoolStatusFluent(MachineConfigPoolStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToCertExpirys(Collection<CertExpiry> items) {
        if (this.certExpirys == null) {
            this.certExpirys = new ArrayList();
        }
        for (CertExpiry item : items) {
            CertExpiryBuilder builder = new CertExpiryBuilder(item);
            this._visitables.get((Object)"certExpirys").add(builder);
            this.certExpirys.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<MachineConfigPoolCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (MachineConfigPoolCondition item : items) {
            MachineConfigPoolConditionBuilder builder = new MachineConfigPoolConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPoolSynchronizersStatus(Collection<PoolSynchronizerStatus> items) {
        if (this.poolSynchronizersStatus == null) {
            this.poolSynchronizersStatus = new ArrayList();
        }
        for (PoolSynchronizerStatus item : items) {
            PoolSynchronizerStatusBuilder builder = new PoolSynchronizerStatusBuilder(item);
            this._visitables.get((Object)"poolSynchronizersStatus").add(builder);
            this.poolSynchronizersStatus.add(builder);
        }
        return (A)((Object)this);
    }

    public CertExpirysNested<A> addNewCertExpiry() {
        return new CertExpirysNested(-1, null);
    }

    public A addNewCertExpiry(String bundle, String expiry, String subject) {
        return this.addToCertExpirys(new CertExpiry(bundle, expiry, subject));
    }

    public CertExpirysNested<A> addNewCertExpiryLike(CertExpiry item) {
        return new CertExpirysNested(-1, item);
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new MachineConfigPoolCondition(lastTransitionTime, message, reason, status, type));
    }

    public ConditionsNested<A> addNewConditionLike(MachineConfigPoolCondition item) {
        return new ConditionsNested(-1, item);
    }

    public PoolSynchronizersStatusNested<A> addNewPoolSynchronizersStatus() {
        return new PoolSynchronizersStatusNested(-1, null);
    }

    public PoolSynchronizersStatusNested<A> addNewPoolSynchronizersStatusLike(PoolSynchronizerStatus item) {
        return new PoolSynchronizersStatusNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToCertExpirys(CertExpiry ... items) {
        if (this.certExpirys == null) {
            this.certExpirys = new ArrayList();
        }
        for (CertExpiry item : items) {
            CertExpiryBuilder builder = new CertExpiryBuilder(item);
            this._visitables.get((Object)"certExpirys").add(builder);
            this.certExpirys.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToCertExpirys(int index, CertExpiry item) {
        if (this.certExpirys == null) {
            this.certExpirys = new ArrayList();
        }
        CertExpiryBuilder builder = new CertExpiryBuilder(item);
        if (index < 0 || index >= this.certExpirys.size()) {
            this._visitables.get((Object)"certExpirys").add(builder);
            this.certExpirys.add(builder);
        } else {
            this._visitables.get((Object)"certExpirys").add(builder);
            this.certExpirys.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(MachineConfigPoolCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (MachineConfigPoolCondition item : items) {
            MachineConfigPoolConditionBuilder builder = new MachineConfigPoolConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(int index, MachineConfigPoolCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        MachineConfigPoolConditionBuilder builder = new MachineConfigPoolConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPoolSynchronizersStatus(PoolSynchronizerStatus ... items) {
        if (this.poolSynchronizersStatus == null) {
            this.poolSynchronizersStatus = new ArrayList();
        }
        for (PoolSynchronizerStatus item : items) {
            PoolSynchronizerStatusBuilder builder = new PoolSynchronizerStatusBuilder(item);
            this._visitables.get((Object)"poolSynchronizersStatus").add(builder);
            this.poolSynchronizersStatus.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToPoolSynchronizersStatus(int index, PoolSynchronizerStatus item) {
        if (this.poolSynchronizersStatus == null) {
            this.poolSynchronizersStatus = new ArrayList();
        }
        PoolSynchronizerStatusBuilder builder = new PoolSynchronizerStatusBuilder(item);
        if (index < 0 || index >= this.poolSynchronizersStatus.size()) {
            this._visitables.get((Object)"poolSynchronizersStatus").add(builder);
            this.poolSynchronizersStatus.add(builder);
        } else {
            this._visitables.get((Object)"poolSynchronizersStatus").add(builder);
            this.poolSynchronizersStatus.add(index, builder);
        }
        return (A)((Object)this);
    }

    public CertExpiry buildCertExpiry(int index) {
        return this.certExpirys.get(index).build();
    }

    public List<CertExpiry> buildCertExpirys() {
        return this.certExpirys != null ? MachineConfigPoolStatusFluent.build(this.certExpirys) : null;
    }

    public MachineConfigPoolCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public List<MachineConfigPoolCondition> buildConditions() {
        return this.conditions != null ? MachineConfigPoolStatusFluent.build(this.conditions) : null;
    }

    public MachineConfigPoolStatusConfiguration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public CertExpiry buildFirstCertExpiry() {
        return this.certExpirys.get(0).build();
    }

    public MachineConfigPoolCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public PoolSynchronizerStatus buildFirstPoolSynchronizersStatus() {
        return this.poolSynchronizersStatus.get(0).build();
    }

    public CertExpiry buildLastCertExpiry() {
        return this.certExpirys.get(this.certExpirys.size() - 1).build();
    }

    public MachineConfigPoolCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public PoolSynchronizerStatus buildLastPoolSynchronizersStatus() {
        return this.poolSynchronizersStatus.get(this.poolSynchronizersStatus.size() - 1).build();
    }

    public CertExpiry buildMatchingCertExpiry(Predicate<CertExpiryBuilder> predicate) {
        for (CertExpiryBuilder item : this.certExpirys) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public MachineConfigPoolCondition buildMatchingCondition(Predicate<MachineConfigPoolConditionBuilder> predicate) {
        for (MachineConfigPoolConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public PoolSynchronizerStatus buildMatchingPoolSynchronizersStatus(Predicate<PoolSynchronizerStatusBuilder> predicate) {
        for (PoolSynchronizerStatusBuilder item : this.poolSynchronizersStatus) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public List<PoolSynchronizerStatus> buildPoolSynchronizersStatus() {
        return this.poolSynchronizersStatus != null ? MachineConfigPoolStatusFluent.build(this.poolSynchronizersStatus) : null;
    }

    public PoolSynchronizerStatus buildPoolSynchronizersStatus(int index) {
        return this.poolSynchronizersStatus.get(index).build();
    }

    protected void copyInstance(MachineConfigPoolStatus instance) {
        MachineConfigPoolStatus machineConfigPoolStatus = instance = instance != null ? instance : new MachineConfigPoolStatus();
        if (instance != null) {
            this.withCertExpirys(instance.getCertExpirys());
            this.withConditions(instance.getConditions());
            this.withConfiguration(instance.getConfiguration());
            this.withDegradedMachineCount(instance.getDegradedMachineCount());
            this.withMachineCount(instance.getMachineCount());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withPoolSynchronizersStatus(instance.getPoolSynchronizersStatus());
            this.withReadyMachineCount(instance.getReadyMachineCount());
            this.withUnavailableMachineCount(instance.getUnavailableMachineCount());
            this.withUpdatedMachineCount(instance.getUpdatedMachineCount());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public CertExpirysNested<A> editCertExpiry(int index) {
        if (this.certExpirys.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "certExpirys"));
        }
        return this.setNewCertExpiryLike(index, this.buildCertExpiry(index));
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public CertExpirysNested<A> editFirstCertExpiry() {
        if (this.certExpirys.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "certExpirys"));
        }
        return this.setNewCertExpiryLike(0, this.buildCertExpiry(0));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public PoolSynchronizersStatusNested<A> editFirstPoolSynchronizersStatus() {
        if (this.poolSynchronizersStatus.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "poolSynchronizersStatus"));
        }
        return this.setNewPoolSynchronizersStatusLike(0, this.buildPoolSynchronizersStatus(0));
    }

    public CertExpirysNested<A> editLastCertExpiry() {
        int index = this.certExpirys.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "certExpirys"));
        }
        return this.setNewCertExpiryLike(index, this.buildCertExpiry(index));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public PoolSynchronizersStatusNested<A> editLastPoolSynchronizersStatus() {
        int index = this.poolSynchronizersStatus.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "poolSynchronizersStatus"));
        }
        return this.setNewPoolSynchronizersStatusLike(index, this.buildPoolSynchronizersStatus(index));
    }

    public CertExpirysNested<A> editMatchingCertExpiry(Predicate<CertExpiryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.certExpirys.size(); ++i) {
            if (!predicate.test(this.certExpirys.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "certExpirys"));
        }
        return this.setNewCertExpiryLike(index, this.buildCertExpiry(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<MachineConfigPoolConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public PoolSynchronizersStatusNested<A> editMatchingPoolSynchronizersStatus(Predicate<PoolSynchronizerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.poolSynchronizersStatus.size(); ++i) {
            if (!predicate.test(this.poolSynchronizersStatus.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "poolSynchronizersStatus"));
        }
        return this.setNewPoolSynchronizersStatusLike(index, this.buildPoolSynchronizersStatus(index));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new MachineConfigPoolStatusConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(MachineConfigPoolStatusConfiguration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public PoolSynchronizersStatusNested<A> editPoolSynchronizersStatus(int index) {
        if (this.poolSynchronizersStatus.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "poolSynchronizersStatus"));
        }
        return this.setNewPoolSynchronizersStatusLike(index, this.buildPoolSynchronizersStatus(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineConfigPoolStatusFluent that = (MachineConfigPoolStatusFluent)((Object)o);
        if (!Objects.equals(this.certExpirys, that.certExpirys)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.degradedMachineCount, that.degradedMachineCount)) {
            return false;
        }
        if (!Objects.equals(this.machineCount, that.machineCount)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.poolSynchronizersStatus, that.poolSynchronizersStatus)) {
            return false;
        }
        if (!Objects.equals(this.readyMachineCount, that.readyMachineCount)) {
            return false;
        }
        if (!Objects.equals(this.unavailableMachineCount, that.unavailableMachineCount)) {
            return false;
        }
        if (!Objects.equals(this.updatedMachineCount, that.updatedMachineCount)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Integer getDegradedMachineCount() {
        return this.degradedMachineCount;
    }

    public Integer getMachineCount() {
        return this.machineCount;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public Integer getReadyMachineCount() {
        return this.readyMachineCount;
    }

    public Integer getUnavailableMachineCount() {
        return this.unavailableMachineCount;
    }

    public Integer getUpdatedMachineCount() {
        return this.updatedMachineCount;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCertExpirys() {
        return this.certExpirys != null && !this.certExpirys.isEmpty();
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public boolean hasDegradedMachineCount() {
        return this.degradedMachineCount != null;
    }

    public boolean hasMachineCount() {
        return this.machineCount != null;
    }

    public boolean hasMatchingCertExpiry(Predicate<CertExpiryBuilder> predicate) {
        for (CertExpiryBuilder item : this.certExpirys) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingCondition(Predicate<MachineConfigPoolConditionBuilder> predicate) {
        for (MachineConfigPoolConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingPoolSynchronizersStatus(Predicate<PoolSynchronizerStatusBuilder> predicate) {
        for (PoolSynchronizerStatusBuilder item : this.poolSynchronizersStatus) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public boolean hasPoolSynchronizersStatus() {
        return this.poolSynchronizersStatus != null && !this.poolSynchronizersStatus.isEmpty();
    }

    public boolean hasReadyMachineCount() {
        return this.readyMachineCount != null;
    }

    public boolean hasUnavailableMachineCount() {
        return this.unavailableMachineCount != null;
    }

    public boolean hasUpdatedMachineCount() {
        return this.updatedMachineCount != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.certExpirys, this.conditions, this.configuration, this.degradedMachineCount, this.machineCount, this.observedGeneration, this.poolSynchronizersStatus, this.readyMachineCount, this.unavailableMachineCount, this.updatedMachineCount, this.additionalProperties});
    }

    public A removeAllFromCertExpirys(Collection<CertExpiry> items) {
        if (this.certExpirys == null) {
            return (A)((Object)this);
        }
        for (CertExpiry item : items) {
            CertExpiryBuilder builder = new CertExpiryBuilder(item);
            this._visitables.get((Object)"certExpirys").remove((Object)builder);
            this.certExpirys.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<MachineConfigPoolCondition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (MachineConfigPoolCondition item : items) {
            MachineConfigPoolConditionBuilder builder = new MachineConfigPoolConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPoolSynchronizersStatus(Collection<PoolSynchronizerStatus> items) {
        if (this.poolSynchronizersStatus == null) {
            return (A)((Object)this);
        }
        for (PoolSynchronizerStatus item : items) {
            PoolSynchronizerStatusBuilder builder = new PoolSynchronizerStatusBuilder(item);
            this._visitables.get((Object)"poolSynchronizersStatus").remove((Object)builder);
            this.poolSynchronizersStatus.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromCertExpirys(CertExpiry ... items) {
        if (this.certExpirys == null) {
            return (A)((Object)this);
        }
        for (CertExpiry item : items) {
            CertExpiryBuilder builder = new CertExpiryBuilder(item);
            this._visitables.get((Object)"certExpirys").remove((Object)builder);
            this.certExpirys.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(MachineConfigPoolCondition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (MachineConfigPoolCondition item : items) {
            MachineConfigPoolConditionBuilder builder = new MachineConfigPoolConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPoolSynchronizersStatus(PoolSynchronizerStatus ... items) {
        if (this.poolSynchronizersStatus == null) {
            return (A)((Object)this);
        }
        for (PoolSynchronizerStatus item : items) {
            PoolSynchronizerStatusBuilder builder = new PoolSynchronizerStatusBuilder(item);
            this._visitables.get((Object)"poolSynchronizersStatus").remove((Object)builder);
            this.poolSynchronizersStatus.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromCertExpirys(Predicate<CertExpiryBuilder> predicate) {
        if (this.certExpirys == null) {
            return (A)((Object)this);
        }
        Iterator<CertExpiryBuilder> each = this.certExpirys.iterator();
        List visitables = this._visitables.get((Object)"certExpirys");
        while (each.hasNext()) {
            CertExpiryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<MachineConfigPoolConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<MachineConfigPoolConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            MachineConfigPoolConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPoolSynchronizersStatus(Predicate<PoolSynchronizerStatusBuilder> predicate) {
        if (this.poolSynchronizersStatus == null) {
            return (A)((Object)this);
        }
        Iterator<PoolSynchronizerStatusBuilder> each = this.poolSynchronizersStatus.iterator();
        List visitables = this._visitables.get((Object)"poolSynchronizersStatus");
        while (each.hasNext()) {
            PoolSynchronizerStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public CertExpirysNested<A> setNewCertExpiryLike(int index, CertExpiry item) {
        return new CertExpirysNested(index, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, MachineConfigPoolCondition item) {
        return new ConditionsNested(index, item);
    }

    public PoolSynchronizersStatusNested<A> setNewPoolSynchronizersStatusLike(int index, PoolSynchronizerStatus item) {
        return new PoolSynchronizersStatusNested(index, item);
    }

    public A setToCertExpirys(int index, CertExpiry item) {
        if (this.certExpirys == null) {
            this.certExpirys = new ArrayList();
        }
        CertExpiryBuilder builder = new CertExpiryBuilder(item);
        if (index < 0 || index >= this.certExpirys.size()) {
            this._visitables.get((Object)"certExpirys").add(builder);
            this.certExpirys.add(builder);
        } else {
            this._visitables.get((Object)"certExpirys").add(builder);
            this.certExpirys.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, MachineConfigPoolCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        MachineConfigPoolConditionBuilder builder = new MachineConfigPoolConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPoolSynchronizersStatus(int index, PoolSynchronizerStatus item) {
        if (this.poolSynchronizersStatus == null) {
            this.poolSynchronizersStatus = new ArrayList();
        }
        PoolSynchronizerStatusBuilder builder = new PoolSynchronizerStatusBuilder(item);
        if (index < 0 || index >= this.poolSynchronizersStatus.size()) {
            this._visitables.get((Object)"poolSynchronizersStatus").add(builder);
            this.poolSynchronizersStatus.add(builder);
        } else {
            this._visitables.get((Object)"poolSynchronizersStatus").add(builder);
            this.poolSynchronizersStatus.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.certExpirys != null && !this.certExpirys.isEmpty()) {
            sb.append("certExpirys:");
            sb.append(this.certExpirys);
            sb.append(",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append((Object)this.configuration);
            sb.append(",");
        }
        if (this.degradedMachineCount != null) {
            sb.append("degradedMachineCount:");
            sb.append(this.degradedMachineCount);
            sb.append(",");
        }
        if (this.machineCount != null) {
            sb.append("machineCount:");
            sb.append(this.machineCount);
            sb.append(",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration);
            sb.append(",");
        }
        if (this.poolSynchronizersStatus != null && !this.poolSynchronizersStatus.isEmpty()) {
            sb.append("poolSynchronizersStatus:");
            sb.append(this.poolSynchronizersStatus);
            sb.append(",");
        }
        if (this.readyMachineCount != null) {
            sb.append("readyMachineCount:");
            sb.append(this.readyMachineCount);
            sb.append(",");
        }
        if (this.unavailableMachineCount != null) {
            sb.append("unavailableMachineCount:");
            sb.append(this.unavailableMachineCount);
            sb.append(",");
        }
        if (this.updatedMachineCount != null) {
            sb.append("updatedMachineCount:");
            sb.append(this.updatedMachineCount);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withCertExpirys(List<CertExpiry> certExpirys) {
        if (this.certExpirys != null) {
            this._visitables.get((Object)"certExpirys").clear();
        }
        if (certExpirys != null) {
            this.certExpirys = new ArrayList();
            for (CertExpiry item : certExpirys) {
                this.addToCertExpirys(item);
            }
        } else {
            this.certExpirys = null;
        }
        return (A)((Object)this);
    }

    public A withCertExpirys(CertExpiry ... certExpirys) {
        if (this.certExpirys != null) {
            this.certExpirys.clear();
            this._visitables.remove((Object)"certExpirys");
        }
        if (certExpirys != null) {
            for (CertExpiry item : certExpirys) {
                this.addToCertExpirys(item);
            }
        }
        return (A)((Object)this);
    }

    public A withConditions(List<MachineConfigPoolCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (MachineConfigPoolCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(MachineConfigPoolCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (MachineConfigPoolCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public A withConfiguration(MachineConfigPoolStatusConfiguration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new MachineConfigPoolStatusConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public A withDegradedMachineCount(Integer degradedMachineCount) {
        this.degradedMachineCount = degradedMachineCount;
        return (A)((Object)this);
    }

    public A withMachineCount(Integer machineCount) {
        this.machineCount = machineCount;
        return (A)((Object)this);
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(MachineConfigPoolStatusConfiguration item) {
        return new ConfigurationNested(item);
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public A withPoolSynchronizersStatus(List<PoolSynchronizerStatus> poolSynchronizersStatus) {
        if (this.poolSynchronizersStatus != null) {
            this._visitables.get((Object)"poolSynchronizersStatus").clear();
        }
        if (poolSynchronizersStatus != null) {
            this.poolSynchronizersStatus = new ArrayList();
            for (PoolSynchronizerStatus item : poolSynchronizersStatus) {
                this.addToPoolSynchronizersStatus(item);
            }
        } else {
            this.poolSynchronizersStatus = null;
        }
        return (A)((Object)this);
    }

    public A withPoolSynchronizersStatus(PoolSynchronizerStatus ... poolSynchronizersStatus) {
        if (this.poolSynchronizersStatus != null) {
            this.poolSynchronizersStatus.clear();
            this._visitables.remove((Object)"poolSynchronizersStatus");
        }
        if (poolSynchronizersStatus != null) {
            for (PoolSynchronizerStatus item : poolSynchronizersStatus) {
                this.addToPoolSynchronizersStatus(item);
            }
        }
        return (A)((Object)this);
    }

    public A withReadyMachineCount(Integer readyMachineCount) {
        this.readyMachineCount = readyMachineCount;
        return (A)((Object)this);
    }

    public A withUnavailableMachineCount(Integer unavailableMachineCount) {
        this.unavailableMachineCount = unavailableMachineCount;
        return (A)((Object)this);
    }

    public A withUpdatedMachineCount(Integer updatedMachineCount) {
        this.updatedMachineCount = updatedMachineCount;
        return (A)((Object)this);
    }

    public class PoolSynchronizersStatusNested<N>
    extends PoolSynchronizerStatusFluent<PoolSynchronizersStatusNested<N>>
    implements Nested<N> {
        PoolSynchronizerStatusBuilder builder;
        int index;

        PoolSynchronizersStatusNested(int index, PoolSynchronizerStatus item) {
            this.index = index;
            this.builder = new PoolSynchronizerStatusBuilder(this, item);
        }

        public N and() {
            return (N)MachineConfigPoolStatusFluent.this.setToPoolSynchronizersStatus(this.index, this.builder.build());
        }

        public N endPoolSynchronizersStatus() {
            return this.and();
        }
    }

    public class ConfigurationNested<N>
    extends MachineConfigPoolStatusConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        MachineConfigPoolStatusConfigurationBuilder builder;

        ConfigurationNested(MachineConfigPoolStatusConfiguration item) {
            this.builder = new MachineConfigPoolStatusConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)MachineConfigPoolStatusFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends MachineConfigPoolConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        MachineConfigPoolConditionBuilder builder;
        int index;

        ConditionsNested(int index, MachineConfigPoolCondition item) {
            this.index = index;
            this.builder = new MachineConfigPoolConditionBuilder(this, item);
        }

        public N and() {
            return (N)MachineConfigPoolStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class CertExpirysNested<N>
    extends CertExpiryFluent<CertExpirysNested<N>>
    implements Nested<N> {
        CertExpiryBuilder builder;
        int index;

        CertExpirysNested(int index, CertExpiry item) {
            this.index = index;
            this.builder = new CertExpiryBuilder(this, item);
        }

        public N and() {
            return (N)MachineConfigPoolStatusFluent.this.setToCertExpirys(this.index, this.builder.build());
        }

        public N endCertExpiry() {
            return this.and();
        }
    }
}

