package io.fabric8.openshift.api.model.machineconfiguration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.Condition;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachineConfigNodeStatusFluent<A extends MachineConfigNodeStatusFluent<A>> extends BaseFluent<A>{
  public MachineConfigNodeStatusFluent() {
  }
  
  public MachineConfigNodeStatusFluent(MachineConfigNodeStatus instance) {
    this.copyInstance(instance);
  }
  private List<Condition> conditions = new ArrayList<Condition>();
  private MachineConfigNodeStatusMachineConfigVersionBuilder configVersion;
  private Long observedGeneration;
  private ArrayList<MachineConfigNodeStatusPinnedImageSetBuilder> pinnedImageSets = new ArrayList<MachineConfigNodeStatusPinnedImageSetBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachineConfigNodeStatus instance) {
    instance = (instance != null ? instance : new MachineConfigNodeStatus());
    if (instance != null) {
          this.withConditions(instance.getConditions());
          this.withConfigVersion(instance.getConfigVersion());
          this.withObservedGeneration(instance.getObservedGeneration());
          this.withPinnedImageSets(instance.getPinnedImageSets());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<Condition> items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public List<Condition> getConditions() {
    return this.conditions;
  }
  
  public Condition getCondition(int index) {
    return this.conditions.get(index);
  }
  
  public Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  
  public Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  
  public Condition getMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<Condition> conditions) {
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (Condition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (Condition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public MachineConfigNodeStatusMachineConfigVersion buildConfigVersion() {
    return this.configVersion != null ? this.configVersion.build() : null;
  }
  
  public A withConfigVersion(MachineConfigNodeStatusMachineConfigVersion configVersion) {
    this._visitables.remove("configVersion");
    if (configVersion != null) {
        this.configVersion = new MachineConfigNodeStatusMachineConfigVersionBuilder(configVersion);
        this._visitables.get("configVersion").add(this.configVersion);
    } else {
        this.configVersion = null;
        this._visitables.get("configVersion").remove(this.configVersion);
    }
    return (A) this;
  }
  
  public boolean hasConfigVersion() {
    return this.configVersion != null;
  }
  
  public A withNewConfigVersion(String current,String desired) {
    return (A)withConfigVersion(new MachineConfigNodeStatusMachineConfigVersion(current, desired));
  }
  
  public ConfigVersionNested<A> withNewConfigVersion() {
    return new ConfigVersionNested(null);
  }
  
  public ConfigVersionNested<A> withNewConfigVersionLike(MachineConfigNodeStatusMachineConfigVersion item) {
    return new ConfigVersionNested(item);
  }
  
  public ConfigVersionNested<A> editConfigVersion() {
    return withNewConfigVersionLike(java.util.Optional.ofNullable(buildConfigVersion()).orElse(null));
  }
  
  public ConfigVersionNested<A> editOrNewConfigVersion() {
    return withNewConfigVersionLike(java.util.Optional.ofNullable(buildConfigVersion()).orElse(new MachineConfigNodeStatusMachineConfigVersionBuilder().build()));
  }
  
  public ConfigVersionNested<A> editOrNewConfigVersionLike(MachineConfigNodeStatusMachineConfigVersion item) {
    return withNewConfigVersionLike(java.util.Optional.ofNullable(buildConfigVersion()).orElse(item));
  }
  
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration = observedGeneration;
    return (A) this;
  }
  
  public boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  
  public A addToPinnedImageSets(int index,MachineConfigNodeStatusPinnedImageSet item) {
    if (this.pinnedImageSets == null) {this.pinnedImageSets = new ArrayList<MachineConfigNodeStatusPinnedImageSetBuilder>();}
    MachineConfigNodeStatusPinnedImageSetBuilder builder = new MachineConfigNodeStatusPinnedImageSetBuilder(item);
    if (index < 0 || index >= pinnedImageSets.size()) {
        _visitables.get("pinnedImageSets").add(builder);
        pinnedImageSets.add(builder);
    } else {
        _visitables.get("pinnedImageSets").add(builder);
        pinnedImageSets.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToPinnedImageSets(int index,MachineConfigNodeStatusPinnedImageSet item) {
    if (this.pinnedImageSets == null) {this.pinnedImageSets = new ArrayList<MachineConfigNodeStatusPinnedImageSetBuilder>();}
    MachineConfigNodeStatusPinnedImageSetBuilder builder = new MachineConfigNodeStatusPinnedImageSetBuilder(item);
    if (index < 0 || index >= pinnedImageSets.size()) {
        _visitables.get("pinnedImageSets").add(builder);
        pinnedImageSets.add(builder);
    } else {
        _visitables.get("pinnedImageSets").add(builder);
        pinnedImageSets.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToPinnedImageSets(io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeStatusPinnedImageSet... items) {
    if (this.pinnedImageSets == null) {this.pinnedImageSets = new ArrayList<MachineConfigNodeStatusPinnedImageSetBuilder>();}
    for (MachineConfigNodeStatusPinnedImageSet item : items) {MachineConfigNodeStatusPinnedImageSetBuilder builder = new MachineConfigNodeStatusPinnedImageSetBuilder(item);_visitables.get("pinnedImageSets").add(builder);this.pinnedImageSets.add(builder);} return (A)this;
  }
  
  public A addAllToPinnedImageSets(Collection<MachineConfigNodeStatusPinnedImageSet> items) {
    if (this.pinnedImageSets == null) {this.pinnedImageSets = new ArrayList<MachineConfigNodeStatusPinnedImageSetBuilder>();}
    for (MachineConfigNodeStatusPinnedImageSet item : items) {MachineConfigNodeStatusPinnedImageSetBuilder builder = new MachineConfigNodeStatusPinnedImageSetBuilder(item);_visitables.get("pinnedImageSets").add(builder);this.pinnedImageSets.add(builder);} return (A)this;
  }
  
  public A removeFromPinnedImageSets(io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeStatusPinnedImageSet... items) {
    if (this.pinnedImageSets == null) return (A)this;
    for (MachineConfigNodeStatusPinnedImageSet item : items) {MachineConfigNodeStatusPinnedImageSetBuilder builder = new MachineConfigNodeStatusPinnedImageSetBuilder(item);_visitables.get("pinnedImageSets").remove(builder); this.pinnedImageSets.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPinnedImageSets(Collection<MachineConfigNodeStatusPinnedImageSet> items) {
    if (this.pinnedImageSets == null) return (A)this;
    for (MachineConfigNodeStatusPinnedImageSet item : items) {MachineConfigNodeStatusPinnedImageSetBuilder builder = new MachineConfigNodeStatusPinnedImageSetBuilder(item);_visitables.get("pinnedImageSets").remove(builder); this.pinnedImageSets.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPinnedImageSets(Predicate<MachineConfigNodeStatusPinnedImageSetBuilder> predicate) {
    if (pinnedImageSets == null) return (A) this;
    final Iterator<MachineConfigNodeStatusPinnedImageSetBuilder> each = pinnedImageSets.iterator();
    final List visitables = _visitables.get("pinnedImageSets");
    while (each.hasNext()) {
      MachineConfigNodeStatusPinnedImageSetBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<MachineConfigNodeStatusPinnedImageSet> buildPinnedImageSets() {
    return this.pinnedImageSets != null ? build(pinnedImageSets) : null;
  }
  
  public MachineConfigNodeStatusPinnedImageSet buildPinnedImageSet(int index) {
    return this.pinnedImageSets.get(index).build();
  }
  
  public MachineConfigNodeStatusPinnedImageSet buildFirstPinnedImageSet() {
    return this.pinnedImageSets.get(0).build();
  }
  
  public MachineConfigNodeStatusPinnedImageSet buildLastPinnedImageSet() {
    return this.pinnedImageSets.get(pinnedImageSets.size() - 1).build();
  }
  
  public MachineConfigNodeStatusPinnedImageSet buildMatchingPinnedImageSet(Predicate<MachineConfigNodeStatusPinnedImageSetBuilder> predicate) {
      for (MachineConfigNodeStatusPinnedImageSetBuilder item : pinnedImageSets) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPinnedImageSet(Predicate<MachineConfigNodeStatusPinnedImageSetBuilder> predicate) {
      for (MachineConfigNodeStatusPinnedImageSetBuilder item : pinnedImageSets) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPinnedImageSets(List<MachineConfigNodeStatusPinnedImageSet> pinnedImageSets) {
    if (this.pinnedImageSets != null) {
      this._visitables.get("pinnedImageSets").clear();
    }
    if (pinnedImageSets != null) {
        this.pinnedImageSets = new ArrayList();
        for (MachineConfigNodeStatusPinnedImageSet item : pinnedImageSets) {
          this.addToPinnedImageSets(item);
        }
    } else {
      this.pinnedImageSets = null;
    }
    return (A) this;
  }
  
  public A withPinnedImageSets(io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeStatusPinnedImageSet... pinnedImageSets) {
    if (this.pinnedImageSets != null) {
        this.pinnedImageSets.clear();
        _visitables.remove("pinnedImageSets");
    }
    if (pinnedImageSets != null) {
      for (MachineConfigNodeStatusPinnedImageSet item : pinnedImageSets) {
        this.addToPinnedImageSets(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPinnedImageSets() {
    return this.pinnedImageSets != null && !this.pinnedImageSets.isEmpty();
  }
  
  public A addNewPinnedImageSet(Integer currentGeneration,Integer desiredGeneration,Integer lastFailedGeneration,String lastFailedGenerationError,String name) {
    return (A)addToPinnedImageSets(new MachineConfigNodeStatusPinnedImageSet(currentGeneration, desiredGeneration, lastFailedGeneration, lastFailedGenerationError, name));
  }
  
  public PinnedImageSetsNested<A> addNewPinnedImageSet() {
    return new PinnedImageSetsNested(-1, null);
  }
  
  public PinnedImageSetsNested<A> addNewPinnedImageSetLike(MachineConfigNodeStatusPinnedImageSet item) {
    return new PinnedImageSetsNested(-1, item);
  }
  
  public PinnedImageSetsNested<A> setNewPinnedImageSetLike(int index,MachineConfigNodeStatusPinnedImageSet item) {
    return new PinnedImageSetsNested(index, item);
  }
  
  public PinnedImageSetsNested<A> editPinnedImageSet(int index) {
    if (pinnedImageSets.size() <= index) throw new RuntimeException("Can't edit pinnedImageSets. Index exceeds size.");
    return setNewPinnedImageSetLike(index, buildPinnedImageSet(index));
  }
  
  public PinnedImageSetsNested<A> editFirstPinnedImageSet() {
    if (pinnedImageSets.size() == 0) throw new RuntimeException("Can't edit first pinnedImageSets. The list is empty.");
    return setNewPinnedImageSetLike(0, buildPinnedImageSet(0));
  }
  
  public PinnedImageSetsNested<A> editLastPinnedImageSet() {
    int index = pinnedImageSets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last pinnedImageSets. The list is empty.");
    return setNewPinnedImageSetLike(index, buildPinnedImageSet(index));
  }
  
  public PinnedImageSetsNested<A> editMatchingPinnedImageSet(Predicate<MachineConfigNodeStatusPinnedImageSetBuilder> predicate) {
    int index = -1;
    for (int i=0;i<pinnedImageSets.size();i++) { 
    if (predicate.test(pinnedImageSets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching pinnedImageSets. No match found.");
    return setNewPinnedImageSetLike(index, buildPinnedImageSet(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachineConfigNodeStatusFluent that = (MachineConfigNodeStatusFluent) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(configVersion, that.configVersion)) return false;
    if (!java.util.Objects.equals(observedGeneration, that.observedGeneration)) return false;
    if (!java.util.Objects.equals(pinnedImageSets, that.pinnedImageSets)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(conditions,  configVersion,  observedGeneration,  pinnedImageSets,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (configVersion != null) { sb.append("configVersion:"); sb.append(configVersion + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (pinnedImageSets != null && !pinnedImageSets.isEmpty()) { sb.append("pinnedImageSets:"); sb.append(pinnedImageSets + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ConfigVersionNested<N> extends MachineConfigNodeStatusMachineConfigVersionFluent<ConfigVersionNested<N>> implements Nested<N>{
    ConfigVersionNested(MachineConfigNodeStatusMachineConfigVersion item) {
      this.builder = new MachineConfigNodeStatusMachineConfigVersionBuilder(this, item);
    }
    MachineConfigNodeStatusMachineConfigVersionBuilder builder;
    
    public N and() {
      return (N) MachineConfigNodeStatusFluent.this.withConfigVersion(builder.build());
    }
    
    public N endConfigVersion() {
      return and();
    }
    
  
  }
  public class PinnedImageSetsNested<N> extends MachineConfigNodeStatusPinnedImageSetFluent<PinnedImageSetsNested<N>> implements Nested<N>{
    PinnedImageSetsNested(int index,MachineConfigNodeStatusPinnedImageSet item) {
      this.index = index;
      this.builder = new MachineConfigNodeStatusPinnedImageSetBuilder(this, item);
    }
    MachineConfigNodeStatusPinnedImageSetBuilder builder;
    int index;
    
    public N and() {
      return (N) MachineConfigNodeStatusFluent.this.setToPinnedImageSets(index,builder.build());
    }
    
    public N endPinnedImageSet() {
      return and();
    }
    
  
  }

}