package io.fabric8.openshift.api.model.machineconfiguration.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BuildOutputsFluent<A extends BuildOutputsFluent<A>> extends BaseFluent<A>{
  public BuildOutputsFluent() {
  }
  
  public BuildOutputsFluent(BuildOutputs instance) {
    this.copyInstance(instance);
  }
  private ImageSecretObjectReferenceBuilder currentImagePullSecret;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(BuildOutputs instance) {
    instance = (instance != null ? instance : new BuildOutputs());
    if (instance != null) {
          this.withCurrentImagePullSecret(instance.getCurrentImagePullSecret());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ImageSecretObjectReference buildCurrentImagePullSecret() {
    return this.currentImagePullSecret != null ? this.currentImagePullSecret.build() : null;
  }
  
  public A withCurrentImagePullSecret(ImageSecretObjectReference currentImagePullSecret) {
    this._visitables.remove("currentImagePullSecret");
    if (currentImagePullSecret != null) {
        this.currentImagePullSecret = new ImageSecretObjectReferenceBuilder(currentImagePullSecret);
        this._visitables.get("currentImagePullSecret").add(this.currentImagePullSecret);
    } else {
        this.currentImagePullSecret = null;
        this._visitables.get("currentImagePullSecret").remove(this.currentImagePullSecret);
    }
    return (A) this;
  }
  
  public boolean hasCurrentImagePullSecret() {
    return this.currentImagePullSecret != null;
  }
  
  public A withNewCurrentImagePullSecret(String name) {
    return (A)withCurrentImagePullSecret(new ImageSecretObjectReference(name));
  }
  
  public CurrentImagePullSecretNested<A> withNewCurrentImagePullSecret() {
    return new CurrentImagePullSecretNested(null);
  }
  
  public CurrentImagePullSecretNested<A> withNewCurrentImagePullSecretLike(ImageSecretObjectReference item) {
    return new CurrentImagePullSecretNested(item);
  }
  
  public CurrentImagePullSecretNested<A> editCurrentImagePullSecret() {
    return withNewCurrentImagePullSecretLike(java.util.Optional.ofNullable(buildCurrentImagePullSecret()).orElse(null));
  }
  
  public CurrentImagePullSecretNested<A> editOrNewCurrentImagePullSecret() {
    return withNewCurrentImagePullSecretLike(java.util.Optional.ofNullable(buildCurrentImagePullSecret()).orElse(new ImageSecretObjectReferenceBuilder().build()));
  }
  
  public CurrentImagePullSecretNested<A> editOrNewCurrentImagePullSecretLike(ImageSecretObjectReference item) {
    return withNewCurrentImagePullSecretLike(java.util.Optional.ofNullable(buildCurrentImagePullSecret()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BuildOutputsFluent that = (BuildOutputsFluent) o;
    if (!java.util.Objects.equals(currentImagePullSecret, that.currentImagePullSecret)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(currentImagePullSecret,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (currentImagePullSecret != null) { sb.append("currentImagePullSecret:"); sb.append(currentImagePullSecret + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CurrentImagePullSecretNested<N> extends ImageSecretObjectReferenceFluent<CurrentImagePullSecretNested<N>> implements Nested<N>{
    CurrentImagePullSecretNested(ImageSecretObjectReference item) {
      this.builder = new ImageSecretObjectReferenceBuilder(this, item);
    }
    ImageSecretObjectReferenceBuilder builder;
    
    public N and() {
      return (N) BuildOutputsFluent.this.withCurrentImagePullSecret(builder.build());
    }
    
    public N endCurrentImagePullSecret() {
      return and();
    }
    
  
  }

}