
package io.fabric8.openshift.api.model.machineconfiguration.v1;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import lombok.experimental.Accessors;

/**
 * MachineOSContainerfile contains all custom content the user wants built into the image
 */
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "containerfileArch",
    "content"
})
@ToString
@EqualsAndHashCode
@Accessors(prefix = {
    "_",
    ""
})
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(io.fabric8.kubernetes.api.model.ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class),
    @BuildableReference(EnvVar.class),
    @BuildableReference(ContainerPort.class),
    @BuildableReference(Volume.class),
    @BuildableReference(VolumeMount.class)
})
@Generated("io.fabric8.kubernetes.schema.generator.model.ModelGenerator")
public class MachineOSContainerfile implements Editable<MachineOSContainerfileBuilder>, KubernetesResource
{

    @JsonProperty("containerfileArch")
    private String containerfileArch;
    @JsonProperty("content")
    private String content;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     */
    public MachineOSContainerfile() {
    }

    public MachineOSContainerfile(String containerfileArch, String content) {
        super();
        this.containerfileArch = containerfileArch;
        this.content = content;
    }

    /**
     * containerfileArch describes the architecture this containerfile is to be built for. This arch is optional. If the user does not specify an architecture, it is assumed that the content can be applied to all architectures, or in a single arch cluster: the only architecture.<br><p> <br><p> Possible enum values:<br><p>  - `"AMD64"` describes the amd64 architecture<br><p>  - `"ARM64"` describes the arm64 architecture<br><p>  - `"NoArch"` describes a containerfile that can be applied to any arch<br><p>  - `"PPC64LE"` describes the ppc64le architecture<br><p>  - `"S390X"` describes the s390x architecture
     */
    @JsonProperty("containerfileArch")
    public String getContainerfileArch() {
        return containerfileArch;
    }

    /**
     * containerfileArch describes the architecture this containerfile is to be built for. This arch is optional. If the user does not specify an architecture, it is assumed that the content can be applied to all architectures, or in a single arch cluster: the only architecture.<br><p> <br><p> Possible enum values:<br><p>  - `"AMD64"` describes the amd64 architecture<br><p>  - `"ARM64"` describes the arm64 architecture<br><p>  - `"NoArch"` describes a containerfile that can be applied to any arch<br><p>  - `"PPC64LE"` describes the ppc64le architecture<br><p>  - `"S390X"` describes the s390x architecture
     */
    @JsonProperty("containerfileArch")
    public void setContainerfileArch(String containerfileArch) {
        this.containerfileArch = containerfileArch;
    }

    /**
     * content is an embedded Containerfile/Dockerfile that defines the contents to be built into your image. See https://github.com/containers/common/blob/main/docs/Containerfile.5.md for the spec reference. for example, this would add the tree package to your hosts:<br><p>   FROM configs AS final<br><p>   RUN rpm-ostree install tree &amp;&amp; \<br><p>     ostree container commit<br><p> This is a required field and can have a maximum length of &#42;&#42;4096&#42;&#42; characters.
     */
    @JsonProperty("content")
    public String getContent() {
        return content;
    }

    /**
     * content is an embedded Containerfile/Dockerfile that defines the contents to be built into your image. See https://github.com/containers/common/blob/main/docs/Containerfile.5.md for the spec reference. for example, this would add the tree package to your hosts:<br><p>   FROM configs AS final<br><p>   RUN rpm-ostree install tree &amp;&amp; \<br><p>     ostree container commit<br><p> This is a required field and can have a maximum length of &#42;&#42;4096&#42;&#42; characters.
     */
    @JsonProperty("content")
    public void setContent(String content) {
        this.content = content;
    }

    @JsonIgnore
    public MachineOSContainerfileBuilder edit() {
        return new MachineOSContainerfileBuilder(this);
    }

    @JsonIgnore
    public MachineOSContainerfileBuilder toBuilder() {
        return edit();
    }

    @JsonAnyGetter
    @JsonIgnore
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

}
