package io.fabric8.openshift.api.model.machineconfiguration.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MachineConfigNodeSpecBuilder extends MachineConfigNodeSpecFluent<MachineConfigNodeSpecBuilder> implements VisitableBuilder<MachineConfigNodeSpec,MachineConfigNodeSpecBuilder>{
  public MachineConfigNodeSpecBuilder() {
    this(new MachineConfigNodeSpec());
  }
  
  public MachineConfigNodeSpecBuilder(MachineConfigNodeSpecFluent<?> fluent) {
    this(fluent, new MachineConfigNodeSpec());
  }
  
  public MachineConfigNodeSpecBuilder(MachineConfigNodeSpecFluent<?> fluent,MachineConfigNodeSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MachineConfigNodeSpecBuilder(MachineConfigNodeSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MachineConfigNodeSpecFluent<?> fluent;
  
  public MachineConfigNodeSpec build() {
    MachineConfigNodeSpec buildable = new MachineConfigNodeSpec(fluent.buildConfigVersion(),fluent.buildNode(),fluent.buildPool());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}