package io.fabric8.openshift.api.model.machineconfig.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MachineConfigSpecFluentImpl<A extends MachineConfigSpecFluent<A>> extends BaseFluent<A> implements MachineConfigSpecFluent<A>{
  public MachineConfigSpecFluentImpl() {
  }
  public MachineConfigSpecFluentImpl(MachineConfigSpec instance) {
    this.withConfig(instance.getConfig()); 
    this.withExtensions(instance.getExtensions()); 
    this.withFips(instance.getFips()); 
    this.withKernelArguments(instance.getKernelArguments()); 
    this.withKernelType(instance.getKernelType()); 
    this.withOsImageURL(instance.getOsImageURL()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Map<String,Object> config;
  private List<String> extensions = new ArrayList<String>();
  private Boolean fips;
  private List<String> kernelArguments = new ArrayList<String>();
  private String kernelType;
  private String osImageURL;
  private Map<String,Object> additionalProperties;
  public A addToConfig(String key,Object value) {
    if(this.config == null && key != null && value != null) { this.config = new LinkedHashMap(); }
    if(key != null && value != null) {this.config.put(key, value);} return (A)this;
  }
  public A addToConfig(Map<String,Object> map) {
    if(this.config == null && map != null) { this.config = new LinkedHashMap(); }
    if(map != null) { this.config.putAll(map);} return (A)this;
  }
  public A removeFromConfig(String key) {
    if(this.config == null) { return (A) this; }
    if(key != null && this.config != null) {this.config.remove(key);} return (A)this;
  }
  public A removeFromConfig(Map<String,Object> map) {
    if(this.config == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.config != null){this.config.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getConfig() {
    return this.config;
  }
  public <K,V>A withConfig(Map<String,Object> config) {
    if (config == null) { this.config =  null;} else {this.config = new LinkedHashMap(config);} return (A) this;
  }
  public Boolean hasConfig() {
    return this.config != null;
  }
  public A addToExtensions(Integer index,String item) {
    if (this.extensions == null) {this.extensions = new ArrayList<String>();}
    this.extensions.add(index, item);
    return (A)this;
  }
  public A setToExtensions(Integer index,String item) {
    if (this.extensions == null) {this.extensions = new ArrayList<String>();}
    this.extensions.set(index, item); return (A)this;
  }
  public A addToExtensions(java.lang.String... items) {
    if (this.extensions == null) {this.extensions = new ArrayList<String>();}
    for (String item : items) {this.extensions.add(item);} return (A)this;
  }
  public A addAllToExtensions(Collection<String> items) {
    if (this.extensions == null) {this.extensions = new ArrayList<String>();}
    for (String item : items) {this.extensions.add(item);} return (A)this;
  }
  public A removeFromExtensions(java.lang.String... items) {
    for (String item : items) {if (this.extensions!= null){ this.extensions.remove(item);}} return (A)this;
  }
  public A removeAllFromExtensions(Collection<String> items) {
    for (String item : items) {if (this.extensions!= null){ this.extensions.remove(item);}} return (A)this;
  }
  public List<String> getExtensions() {
    return this.extensions;
  }
  public String getExtension(Integer index) {
    return this.extensions.get(index);
  }
  public String getFirstExtension() {
    return this.extensions.get(0);
  }
  public String getLastExtension() {
    return this.extensions.get(extensions.size() - 1);
  }
  public String getMatchingExtension(Predicate<String> predicate) {
    for (String item: extensions) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingExtension(Predicate<String> predicate) {
    for (String item: extensions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExtensions(List<String> extensions) {
    if (extensions != null) {this.extensions = new ArrayList(); for (String item : extensions){this.addToExtensions(item);}} else { this.extensions = null;} return (A) this;
  }
  public A withExtensions(java.lang.String... extensions) {
    if (this.extensions != null) {this.extensions.clear();}
    if (extensions != null) {for (String item :extensions){ this.addToExtensions(item);}} return (A) this;
  }
  public Boolean hasExtensions() {
    return extensions != null && !extensions.isEmpty();
  }
  public Boolean getFips() {
    return this.fips;
  }
  public A withFips(Boolean fips) {
    this.fips=fips; return (A) this;
  }
  public Boolean hasFips() {
    return this.fips != null;
  }
  public A addToKernelArguments(Integer index,String item) {
    if (this.kernelArguments == null) {this.kernelArguments = new ArrayList<String>();}
    this.kernelArguments.add(index, item);
    return (A)this;
  }
  public A setToKernelArguments(Integer index,String item) {
    if (this.kernelArguments == null) {this.kernelArguments = new ArrayList<String>();}
    this.kernelArguments.set(index, item); return (A)this;
  }
  public A addToKernelArguments(java.lang.String... items) {
    if (this.kernelArguments == null) {this.kernelArguments = new ArrayList<String>();}
    for (String item : items) {this.kernelArguments.add(item);} return (A)this;
  }
  public A addAllToKernelArguments(Collection<String> items) {
    if (this.kernelArguments == null) {this.kernelArguments = new ArrayList<String>();}
    for (String item : items) {this.kernelArguments.add(item);} return (A)this;
  }
  public A removeFromKernelArguments(java.lang.String... items) {
    for (String item : items) {if (this.kernelArguments!= null){ this.kernelArguments.remove(item);}} return (A)this;
  }
  public A removeAllFromKernelArguments(Collection<String> items) {
    for (String item : items) {if (this.kernelArguments!= null){ this.kernelArguments.remove(item);}} return (A)this;
  }
  public List<String> getKernelArguments() {
    return this.kernelArguments;
  }
  public String getKernelArgument(Integer index) {
    return this.kernelArguments.get(index);
  }
  public String getFirstKernelArgument() {
    return this.kernelArguments.get(0);
  }
  public String getLastKernelArgument() {
    return this.kernelArguments.get(kernelArguments.size() - 1);
  }
  public String getMatchingKernelArgument(Predicate<String> predicate) {
    for (String item: kernelArguments) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingKernelArgument(Predicate<String> predicate) {
    for (String item: kernelArguments) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withKernelArguments(List<String> kernelArguments) {
    if (kernelArguments != null) {this.kernelArguments = new ArrayList(); for (String item : kernelArguments){this.addToKernelArguments(item);}} else { this.kernelArguments = null;} return (A) this;
  }
  public A withKernelArguments(java.lang.String... kernelArguments) {
    if (this.kernelArguments != null) {this.kernelArguments.clear();}
    if (kernelArguments != null) {for (String item :kernelArguments){ this.addToKernelArguments(item);}} return (A) this;
  }
  public Boolean hasKernelArguments() {
    return kernelArguments != null && !kernelArguments.isEmpty();
  }
  public String getKernelType() {
    return this.kernelType;
  }
  public A withKernelType(String kernelType) {
    this.kernelType=kernelType; return (A) this;
  }
  public Boolean hasKernelType() {
    return this.kernelType != null;
  }
  public String getOsImageURL() {
    return this.osImageURL;
  }
  public A withOsImageURL(String osImageURL) {
    this.osImageURL=osImageURL; return (A) this;
  }
  public Boolean hasOsImageURL() {
    return this.osImageURL != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MachineConfigSpecFluentImpl that = (MachineConfigSpecFluentImpl) o;
    if (config != null ? !config.equals(that.config) :that.config != null) return false;
    if (extensions != null ? !extensions.equals(that.extensions) :that.extensions != null) return false;
    if (fips != null ? !fips.equals(that.fips) :that.fips != null) return false;
    if (kernelArguments != null ? !kernelArguments.equals(that.kernelArguments) :that.kernelArguments != null) return false;
    if (kernelType != null ? !kernelType.equals(that.kernelType) :that.kernelType != null) return false;
    if (osImageURL != null ? !osImageURL.equals(that.osImageURL) :that.osImageURL != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(config,  extensions,  fips,  kernelArguments,  kernelType,  osImageURL,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (config != null && !config.isEmpty()) { sb.append("config:"); sb.append(config + ","); }
    if (extensions != null && !extensions.isEmpty()) { sb.append("extensions:"); sb.append(extensions + ","); }
    if (fips != null) { sb.append("fips:"); sb.append(fips + ","); }
    if (kernelArguments != null && !kernelArguments.isEmpty()) { sb.append("kernelArguments:"); sb.append(kernelArguments + ","); }
    if (kernelType != null) { sb.append("kernelType:"); sb.append(kernelType + ","); }
    if (osImageURL != null) { sb.append("osImageURL:"); sb.append(osImageURL + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withFips() {
    return withFips(true);
  }
  
}