package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KubeletConfigStatusFluentImpl<A extends KubeletConfigStatusFluent<A>> extends BaseFluent<A> implements KubeletConfigStatusFluent<A>{
  public KubeletConfigStatusFluentImpl() {
  }
  public KubeletConfigStatusFluentImpl(KubeletConfigStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<KubeletConfigConditionBuilder> conditions = new ArrayList<KubeletConfigConditionBuilder>();
  private Long observedGeneration;
  private Map<String,Object> additionalProperties;
  public A addToConditions(Integer index,KubeletConfigCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<KubeletConfigConditionBuilder>();}
    KubeletConfigConditionBuilder builder = new KubeletConfigConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,KubeletConfigCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<KubeletConfigConditionBuilder>();}
    KubeletConfigConditionBuilder builder = new KubeletConfigConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<KubeletConfigConditionBuilder>();}
    for (KubeletConfigCondition item : items) {KubeletConfigConditionBuilder builder = new KubeletConfigConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<KubeletConfigCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<KubeletConfigConditionBuilder>();}
    for (KubeletConfigCondition item : items) {KubeletConfigConditionBuilder builder = new KubeletConfigConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigCondition... items) {
    for (KubeletConfigCondition item : items) {KubeletConfigConditionBuilder builder = new KubeletConfigConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<KubeletConfigCondition> items) {
    for (KubeletConfigCondition item : items) {KubeletConfigConditionBuilder builder = new KubeletConfigConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<KubeletConfigConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<KubeletConfigConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      KubeletConfigConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<KubeletConfigCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<KubeletConfigCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public KubeletConfigCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public KubeletConfigCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public KubeletConfigCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public KubeletConfigCondition buildMatchingCondition(Predicate<KubeletConfigConditionBuilder> predicate) {
    for (KubeletConfigConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<KubeletConfigConditionBuilder> predicate) {
    for (KubeletConfigConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<KubeletConfigCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (KubeletConfigCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (KubeletConfigCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new KubeletConfigCondition(lastTransitionTime, message, reason, status, type));
  }
  public KubeletConfigStatusFluent.ConditionsNested<A> addNewCondition() {
    return new KubeletConfigStatusFluentImpl.ConditionsNestedImpl();
  }
  public KubeletConfigStatusFluent.ConditionsNested<A> addNewConditionLike(KubeletConfigCondition item) {
    return new KubeletConfigStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public KubeletConfigStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,KubeletConfigCondition item) {
    return new KubeletConfigStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public KubeletConfigStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public KubeletConfigStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public KubeletConfigStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public KubeletConfigStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<KubeletConfigConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KubeletConfigStatusFluentImpl that = (KubeletConfigStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  observedGeneration,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends KubeletConfigConditionFluentImpl<KubeletConfigStatusFluent.ConditionsNested<N>> implements KubeletConfigStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,KubeletConfigCondition item) {
      this.index = index;
      this.builder = new KubeletConfigConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new KubeletConfigConditionBuilder(this);
    }
    KubeletConfigConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) KubeletConfigStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}