package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ControllerConfigBuilder extends ControllerConfigFluentImpl<ControllerConfigBuilder> implements VisitableBuilder<ControllerConfig,ControllerConfigBuilder>{
  public ControllerConfigBuilder() {
    this(false);
  }
  public ControllerConfigBuilder(Boolean validationEnabled) {
    this(new ControllerConfig(), validationEnabled);
  }
  public ControllerConfigBuilder(ControllerConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ControllerConfigBuilder(ControllerConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ControllerConfig(), validationEnabled);
  }
  public ControllerConfigBuilder(ControllerConfigFluent<?> fluent,ControllerConfig instance) {
    this(fluent, instance, false);
  }
  public ControllerConfigBuilder(ControllerConfigFluent<?> fluent,ControllerConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ControllerConfigBuilder(ControllerConfig instance) {
    this(instance,false);
  }
  public ControllerConfigBuilder(ControllerConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ControllerConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ControllerConfig build() {
    ControllerConfig buildable = new ControllerConfig(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}