package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MachineConfigPoolStatusFluentImpl<A extends MachineConfigPoolStatusFluent<A>> extends BaseFluent<A> implements MachineConfigPoolStatusFluent<A>{
  public MachineConfigPoolStatusFluentImpl() {
  }
  public MachineConfigPoolStatusFluentImpl(MachineConfigPoolStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withConfiguration(instance.getConfiguration()); 
    this.withDegradedMachineCount(instance.getDegradedMachineCount()); 
    this.withMachineCount(instance.getMachineCount()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withReadyMachineCount(instance.getReadyMachineCount()); 
    this.withUnavailableMachineCount(instance.getUnavailableMachineCount()); 
    this.withUpdatedMachineCount(instance.getUpdatedMachineCount()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<MachineConfigPoolConditionBuilder> conditions = new ArrayList<MachineConfigPoolConditionBuilder>();
  private MachineConfigPoolStatusConfigurationBuilder configuration;
  private Integer degradedMachineCount;
  private Integer machineCount;
  private Long observedGeneration;
  private Integer readyMachineCount;
  private Integer unavailableMachineCount;
  private Integer updatedMachineCount;
  private Map<String,Object> additionalProperties;
  public A addToConditions(Integer index,MachineConfigPoolCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<MachineConfigPoolConditionBuilder>();}
    MachineConfigPoolConditionBuilder builder = new MachineConfigPoolConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,MachineConfigPoolCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<MachineConfigPoolConditionBuilder>();}
    MachineConfigPoolConditionBuilder builder = new MachineConfigPoolConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<MachineConfigPoolConditionBuilder>();}
    for (MachineConfigPoolCondition item : items) {MachineConfigPoolConditionBuilder builder = new MachineConfigPoolConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<MachineConfigPoolCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<MachineConfigPoolConditionBuilder>();}
    for (MachineConfigPoolCondition item : items) {MachineConfigPoolConditionBuilder builder = new MachineConfigPoolConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolCondition... items) {
    for (MachineConfigPoolCondition item : items) {MachineConfigPoolConditionBuilder builder = new MachineConfigPoolConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<MachineConfigPoolCondition> items) {
    for (MachineConfigPoolCondition item : items) {MachineConfigPoolConditionBuilder builder = new MachineConfigPoolConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<MachineConfigPoolConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<MachineConfigPoolConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      MachineConfigPoolConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<MachineConfigPoolCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<MachineConfigPoolCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public MachineConfigPoolCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public MachineConfigPoolCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public MachineConfigPoolCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public MachineConfigPoolCondition buildMatchingCondition(Predicate<MachineConfigPoolConditionBuilder> predicate) {
    for (MachineConfigPoolConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<MachineConfigPoolConditionBuilder> predicate) {
    for (MachineConfigPoolConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<MachineConfigPoolCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (MachineConfigPoolCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (MachineConfigPoolCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new MachineConfigPoolCondition(lastTransitionTime, message, reason, status, type));
  }
  public MachineConfigPoolStatusFluent.ConditionsNested<A> addNewCondition() {
    return new MachineConfigPoolStatusFluentImpl.ConditionsNestedImpl();
  }
  public MachineConfigPoolStatusFluent.ConditionsNested<A> addNewConditionLike(MachineConfigPoolCondition item) {
    return new MachineConfigPoolStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public MachineConfigPoolStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,MachineConfigPoolCondition item) {
    return new MachineConfigPoolStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public MachineConfigPoolStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public MachineConfigPoolStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public MachineConfigPoolStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public MachineConfigPoolStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<MachineConfigPoolConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  /**
   * This method has been deprecated, please use method buildConfiguration instead.
   * @return The buildable object.
   */
  @Deprecated
  public MachineConfigPoolStatusConfiguration getConfiguration() {
    return this.configuration!=null ?this.configuration.build():null;
  }
  public MachineConfigPoolStatusConfiguration buildConfiguration() {
    return this.configuration!=null ?this.configuration.build():null;
  }
  public A withConfiguration(MachineConfigPoolStatusConfiguration configuration) {
    _visitables.get("configuration").remove(this.configuration);
    if (configuration!=null){ this.configuration= new MachineConfigPoolStatusConfigurationBuilder(configuration); _visitables.get("configuration").add(this.configuration);} else { this.configuration = null; _visitables.get("configuration").remove(this.configuration); } return (A) this;
  }
  public Boolean hasConfiguration() {
    return this.configuration != null;
  }
  public MachineConfigPoolStatusFluent.ConfigurationNested<A> withNewConfiguration() {
    return new MachineConfigPoolStatusFluentImpl.ConfigurationNestedImpl();
  }
  public MachineConfigPoolStatusFluent.ConfigurationNested<A> withNewConfigurationLike(MachineConfigPoolStatusConfiguration item) {
    return new MachineConfigPoolStatusFluentImpl.ConfigurationNestedImpl(item);
  }
  public MachineConfigPoolStatusFluent.ConfigurationNested<A> editConfiguration() {
    return withNewConfigurationLike(getConfiguration());
  }
  public MachineConfigPoolStatusFluent.ConfigurationNested<A> editOrNewConfiguration() {
    return withNewConfigurationLike(getConfiguration() != null ? getConfiguration(): new MachineConfigPoolStatusConfigurationBuilder().build());
  }
  public MachineConfigPoolStatusFluent.ConfigurationNested<A> editOrNewConfigurationLike(MachineConfigPoolStatusConfiguration item) {
    return withNewConfigurationLike(getConfiguration() != null ? getConfiguration(): item);
  }
  public Integer getDegradedMachineCount() {
    return this.degradedMachineCount;
  }
  public A withDegradedMachineCount(Integer degradedMachineCount) {
    this.degradedMachineCount=degradedMachineCount; return (A) this;
  }
  public Boolean hasDegradedMachineCount() {
    return this.degradedMachineCount != null;
  }
  public Integer getMachineCount() {
    return this.machineCount;
  }
  public A withMachineCount(Integer machineCount) {
    this.machineCount=machineCount; return (A) this;
  }
  public Boolean hasMachineCount() {
    return this.machineCount != null;
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public Integer getReadyMachineCount() {
    return this.readyMachineCount;
  }
  public A withReadyMachineCount(Integer readyMachineCount) {
    this.readyMachineCount=readyMachineCount; return (A) this;
  }
  public Boolean hasReadyMachineCount() {
    return this.readyMachineCount != null;
  }
  public Integer getUnavailableMachineCount() {
    return this.unavailableMachineCount;
  }
  public A withUnavailableMachineCount(Integer unavailableMachineCount) {
    this.unavailableMachineCount=unavailableMachineCount; return (A) this;
  }
  public Boolean hasUnavailableMachineCount() {
    return this.unavailableMachineCount != null;
  }
  public Integer getUpdatedMachineCount() {
    return this.updatedMachineCount;
  }
  public A withUpdatedMachineCount(Integer updatedMachineCount) {
    this.updatedMachineCount=updatedMachineCount; return (A) this;
  }
  public Boolean hasUpdatedMachineCount() {
    return this.updatedMachineCount != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MachineConfigPoolStatusFluentImpl that = (MachineConfigPoolStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (configuration != null ? !configuration.equals(that.configuration) :that.configuration != null) return false;
    if (degradedMachineCount != null ? !degradedMachineCount.equals(that.degradedMachineCount) :that.degradedMachineCount != null) return false;
    if (machineCount != null ? !machineCount.equals(that.machineCount) :that.machineCount != null) return false;
    if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
    if (readyMachineCount != null ? !readyMachineCount.equals(that.readyMachineCount) :that.readyMachineCount != null) return false;
    if (unavailableMachineCount != null ? !unavailableMachineCount.equals(that.unavailableMachineCount) :that.unavailableMachineCount != null) return false;
    if (updatedMachineCount != null ? !updatedMachineCount.equals(that.updatedMachineCount) :that.updatedMachineCount != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  configuration,  degradedMachineCount,  machineCount,  observedGeneration,  readyMachineCount,  unavailableMachineCount,  updatedMachineCount,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (configuration != null) { sb.append("configuration:"); sb.append(configuration + ","); }
    if (degradedMachineCount != null) { sb.append("degradedMachineCount:"); sb.append(degradedMachineCount + ","); }
    if (machineCount != null) { sb.append("machineCount:"); sb.append(machineCount + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (readyMachineCount != null) { sb.append("readyMachineCount:"); sb.append(readyMachineCount + ","); }
    if (unavailableMachineCount != null) { sb.append("unavailableMachineCount:"); sb.append(unavailableMachineCount + ","); }
    if (updatedMachineCount != null) { sb.append("updatedMachineCount:"); sb.append(updatedMachineCount + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends MachineConfigPoolConditionFluentImpl<MachineConfigPoolStatusFluent.ConditionsNested<N>> implements MachineConfigPoolStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,MachineConfigPoolCondition item) {
      this.index = index;
      this.builder = new MachineConfigPoolConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new MachineConfigPoolConditionBuilder(this);
    }
    MachineConfigPoolConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) MachineConfigPoolStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class ConfigurationNestedImpl<N> extends MachineConfigPoolStatusConfigurationFluentImpl<MachineConfigPoolStatusFluent.ConfigurationNested<N>> implements MachineConfigPoolStatusFluent.ConfigurationNested<N>,Nested<N>{
    ConfigurationNestedImpl(MachineConfigPoolStatusConfiguration item) {
      this.builder = new MachineConfigPoolStatusConfigurationBuilder(this, item);
    }
    ConfigurationNestedImpl() {
      this.builder = new MachineConfigPoolStatusConfigurationBuilder(this);
    }
    MachineConfigPoolStatusConfigurationBuilder builder;
    public N and() {
      return (N) MachineConfigPoolStatusFluentImpl.this.withConfiguration(builder.build());
    }
    public N endConfiguration() {
      return and();
    }
    
  }
  
}