package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.DNS;
import io.fabric8.openshift.api.model.config.v1.ProxyStatus;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import java.lang.Deprecated;
import io.fabric8.openshift.api.model.config.v1.Infrastructure;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ControllerConfigSpecFluent<A extends ControllerConfigSpecFluent<A>> extends Fluent<A>{
  public String getAdditionalTrustBundle();
  public A withAdditionalTrustBundle(String additionalTrustBundle);
  public Boolean hasAdditionalTrustBundle();
  public String getCloudProviderCAData();
  public A withCloudProviderCAData(String cloudProviderCAData);
  public Boolean hasCloudProviderCAData();
  public String getCloudProviderConfig();
  public A withCloudProviderConfig(String cloudProviderConfig);
  public Boolean hasCloudProviderConfig();
  public String getClusterDNSIP();
  public A withClusterDNSIP(String clusterDNSIP);
  public Boolean hasClusterDNSIP();
  public DNS getDns();
  public A withDns(DNS dns);
  public Boolean hasDns();
  public String getEtcdDiscoveryDomain();
  public A withEtcdDiscoveryDomain(String etcdDiscoveryDomain);
  public Boolean hasEtcdDiscoveryDomain();
  public A addToImages(String key,String value);
  public A addToImages(Map<String,String> map);
  public A removeFromImages(String key);
  public A removeFromImages(Map<String,String> map);
  public Map<String,String> getImages();
  public <K,V>A withImages(Map<String,String> images);
  public Boolean hasImages();
  public Infrastructure getInfra();
  public A withInfra(Infrastructure infra);
  public Boolean hasInfra();
  public String getIpFamilies();
  public A withIpFamilies(String ipFamilies);
  public Boolean hasIpFamilies();
  public String getKubeAPIServerServingCAData();
  public A withKubeAPIServerServingCAData(String kubeAPIServerServingCAData);
  public Boolean hasKubeAPIServerServingCAData();
  public String getNetworkType();
  public A withNetworkType(String networkType);
  public Boolean hasNetworkType();
  public String getOsImageURL();
  public A withOsImageURL(String osImageURL);
  public Boolean hasOsImageURL();
  public String getPlatform();
  public A withPlatform(String platform);
  public Boolean hasPlatform();
  public ProxyStatus getProxy();
  public A withProxy(ProxyStatus proxy);
  public Boolean hasProxy();
  public A withNewProxy(String httpProxy,String httpsProxy,String noProxy);
  
  /**
   * This method has been deprecated, please use method buildPullSecret instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getPullSecret();
  public ObjectReference buildPullSecret();
  public A withPullSecret(ObjectReference pullSecret);
  public Boolean hasPullSecret();
  public ControllerConfigSpecFluent.PullSecretNested<A> withNewPullSecret();
  public ControllerConfigSpecFluent.PullSecretNested<A> withNewPullSecretLike(ObjectReference item);
  public ControllerConfigSpecFluent.PullSecretNested<A> editPullSecret();
  public ControllerConfigSpecFluent.PullSecretNested<A> editOrNewPullSecret();
  public ControllerConfigSpecFluent.PullSecretNested<A> editOrNewPullSecretLike(ObjectReference item);
  public String getReleaseImage();
  public A withReleaseImage(String releaseImage);
  public Boolean hasReleaseImage();
  public String getRootCAData();
  public A withRootCAData(String rootCAData);
  public Boolean hasRootCAData();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface PullSecretNested<N> extends Nested<N>,ObjectReferenceFluent<ControllerConfigSpecFluent.PullSecretNested<N>>{
    public N and();
    public N endPullSecret();
    
  }
  
}