/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.NetworkSpec;
import io.fabric8.openshift.api.model.machine.v1beta1.NetworkSpecBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.NetworkSpecFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.VSphereDisk;
import io.fabric8.openshift.api.model.machine.v1beta1.VSphereDiskBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.VSphereDiskFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.VSphereMachineProviderSpec;
import io.fabric8.openshift.api.model.machine.v1beta1.Workspace;
import io.fabric8.openshift.api.model.machine.v1beta1.WorkspaceBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.WorkspaceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class VSphereMachineProviderSpecFluent<A extends VSphereMachineProviderSpecFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String cloneMode;
    private LocalObjectReferenceBuilder credentialsSecret;
    private ArrayList<VSphereDiskBuilder> dataDisks = new ArrayList();
    private Integer diskGiB;
    private String kind;
    private Long memoryMiB;
    private ObjectMetaBuilder metadata;
    private NetworkSpecBuilder network;
    private Integer numCPUs;
    private Integer numCoresPerSocket;
    private String snapshot;
    private List<String> tagIDs = new ArrayList<String>();
    private String template;
    private LocalObjectReferenceBuilder userDataSecret;
    private WorkspaceBuilder workspace;
    private Map<String, Object> additionalProperties;

    public VSphereMachineProviderSpecFluent() {
    }

    public VSphereMachineProviderSpecFluent(VSphereMachineProviderSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(VSphereMachineProviderSpec instance) {
        VSphereMachineProviderSpec vSphereMachineProviderSpec = instance = instance != null ? instance : new VSphereMachineProviderSpec();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withCloneMode(instance.getCloneMode());
            this.withCredentialsSecret(instance.getCredentialsSecret());
            this.withDataDisks(instance.getDataDisks());
            this.withDiskGiB(instance.getDiskGiB());
            this.withKind(instance.getKind());
            this.withMemoryMiB(instance.getMemoryMiB());
            this.withMetadata(instance.getMetadata());
            this.withNetwork(instance.getNetwork());
            this.withNumCPUs(instance.getNumCPUs());
            this.withNumCoresPerSocket(instance.getNumCoresPerSocket());
            this.withSnapshot(instance.getSnapshot());
            this.withTagIDs(instance.getTagIDs());
            this.withTemplate(instance.getTemplate());
            this.withUserDataSecret(instance.getUserDataSecret());
            this.withWorkspace(instance.getWorkspace());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getCloneMode() {
        return this.cloneMode;
    }

    public A withCloneMode(String cloneMode) {
        this.cloneMode = cloneMode;
        return (A)((Object)this);
    }

    public boolean hasCloneMode() {
        return this.cloneMode != null;
    }

    public LocalObjectReference buildCredentialsSecret() {
        return this.credentialsSecret != null ? this.credentialsSecret.build() : null;
    }

    public A withCredentialsSecret(LocalObjectReference credentialsSecret) {
        this._visitables.remove((Object)"credentialsSecret");
        if (credentialsSecret != null) {
            this.credentialsSecret = new LocalObjectReferenceBuilder(credentialsSecret);
            this._visitables.get((Object)"credentialsSecret").add(this.credentialsSecret);
        } else {
            this.credentialsSecret = null;
            this._visitables.get((Object)"credentialsSecret").remove(this.credentialsSecret);
        }
        return (A)((Object)this);
    }

    public boolean hasCredentialsSecret() {
        return this.credentialsSecret != null;
    }

    public A withNewCredentialsSecret(String name) {
        return this.withCredentialsSecret(new LocalObjectReference(name));
    }

    public CredentialsSecretNested<A> withNewCredentialsSecret() {
        return new CredentialsSecretNested(null);
    }

    public CredentialsSecretNested<A> withNewCredentialsSecretLike(LocalObjectReference item) {
        return new CredentialsSecretNested(item);
    }

    public CredentialsSecretNested<A> editCredentialsSecret() {
        return this.withNewCredentialsSecretLike(Optional.ofNullable(this.buildCredentialsSecret()).orElse(null));
    }

    public CredentialsSecretNested<A> editOrNewCredentialsSecret() {
        return this.withNewCredentialsSecretLike(Optional.ofNullable(this.buildCredentialsSecret()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public CredentialsSecretNested<A> editOrNewCredentialsSecretLike(LocalObjectReference item) {
        return this.withNewCredentialsSecretLike(Optional.ofNullable(this.buildCredentialsSecret()).orElse(item));
    }

    public A addToDataDisks(int index, VSphereDisk item) {
        if (this.dataDisks == null) {
            this.dataDisks = new ArrayList();
        }
        VSphereDiskBuilder builder = new VSphereDiskBuilder(item);
        if (index < 0 || index >= this.dataDisks.size()) {
            this._visitables.get((Object)"dataDisks").add(builder);
            this.dataDisks.add(builder);
        } else {
            this._visitables.get((Object)"dataDisks").add(builder);
            this.dataDisks.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToDataDisks(int index, VSphereDisk item) {
        if (this.dataDisks == null) {
            this.dataDisks = new ArrayList();
        }
        VSphereDiskBuilder builder = new VSphereDiskBuilder(item);
        if (index < 0 || index >= this.dataDisks.size()) {
            this._visitables.get((Object)"dataDisks").add(builder);
            this.dataDisks.add(builder);
        } else {
            this._visitables.get((Object)"dataDisks").add(builder);
            this.dataDisks.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToDataDisks(VSphereDisk ... items) {
        if (this.dataDisks == null) {
            this.dataDisks = new ArrayList();
        }
        for (VSphereDisk item : items) {
            VSphereDiskBuilder builder = new VSphereDiskBuilder(item);
            this._visitables.get((Object)"dataDisks").add(builder);
            this.dataDisks.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToDataDisks(Collection<VSphereDisk> items) {
        if (this.dataDisks == null) {
            this.dataDisks = new ArrayList();
        }
        for (VSphereDisk item : items) {
            VSphereDiskBuilder builder = new VSphereDiskBuilder(item);
            this._visitables.get((Object)"dataDisks").add(builder);
            this.dataDisks.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromDataDisks(VSphereDisk ... items) {
        if (this.dataDisks == null) {
            return (A)((Object)this);
        }
        for (VSphereDisk item : items) {
            VSphereDiskBuilder builder = new VSphereDiskBuilder(item);
            this._visitables.get((Object)"dataDisks").remove((Object)builder);
            this.dataDisks.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDataDisks(Collection<VSphereDisk> items) {
        if (this.dataDisks == null) {
            return (A)((Object)this);
        }
        for (VSphereDisk item : items) {
            VSphereDiskBuilder builder = new VSphereDiskBuilder(item);
            this._visitables.get((Object)"dataDisks").remove((Object)builder);
            this.dataDisks.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromDataDisks(Predicate<VSphereDiskBuilder> predicate) {
        if (this.dataDisks == null) {
            return (A)((Object)this);
        }
        Iterator<VSphereDiskBuilder> each = this.dataDisks.iterator();
        List visitables = this._visitables.get((Object)"dataDisks");
        while (each.hasNext()) {
            VSphereDiskBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<VSphereDisk> buildDataDisks() {
        return this.dataDisks != null ? VSphereMachineProviderSpecFluent.build(this.dataDisks) : null;
    }

    public VSphereDisk buildDataDisk(int index) {
        return this.dataDisks.get(index).build();
    }

    public VSphereDisk buildFirstDataDisk() {
        return this.dataDisks.get(0).build();
    }

    public VSphereDisk buildLastDataDisk() {
        return this.dataDisks.get(this.dataDisks.size() - 1).build();
    }

    public VSphereDisk buildMatchingDataDisk(Predicate<VSphereDiskBuilder> predicate) {
        for (VSphereDiskBuilder item : this.dataDisks) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDataDisk(Predicate<VSphereDiskBuilder> predicate) {
        for (VSphereDiskBuilder item : this.dataDisks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDataDisks(List<VSphereDisk> dataDisks) {
        if (this.dataDisks != null) {
            this._visitables.get((Object)"dataDisks").clear();
        }
        if (dataDisks != null) {
            this.dataDisks = new ArrayList();
            for (VSphereDisk item : dataDisks) {
                this.addToDataDisks(item);
            }
        } else {
            this.dataDisks = null;
        }
        return (A)((Object)this);
    }

    public A withDataDisks(VSphereDisk ... dataDisks) {
        if (this.dataDisks != null) {
            this.dataDisks.clear();
            this._visitables.remove((Object)"dataDisks");
        }
        if (dataDisks != null) {
            for (VSphereDisk item : dataDisks) {
                this.addToDataDisks(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDataDisks() {
        return this.dataDisks != null && !this.dataDisks.isEmpty();
    }

    public A addNewDataDisk(String name, String provisioningMode, Integer sizeGiB) {
        return this.addToDataDisks(new VSphereDisk(name, provisioningMode, sizeGiB));
    }

    public DataDisksNested<A> addNewDataDisk() {
        return new DataDisksNested(-1, null);
    }

    public DataDisksNested<A> addNewDataDiskLike(VSphereDisk item) {
        return new DataDisksNested(-1, item);
    }

    public DataDisksNested<A> setNewDataDiskLike(int index, VSphereDisk item) {
        return new DataDisksNested(index, item);
    }

    public DataDisksNested<A> editDataDisk(int index) {
        if (this.dataDisks.size() <= index) {
            throw new RuntimeException("Can't edit dataDisks. Index exceeds size.");
        }
        return this.setNewDataDiskLike(index, this.buildDataDisk(index));
    }

    public DataDisksNested<A> editFirstDataDisk() {
        if (this.dataDisks.size() == 0) {
            throw new RuntimeException("Can't edit first dataDisks. The list is empty.");
        }
        return this.setNewDataDiskLike(0, this.buildDataDisk(0));
    }

    public DataDisksNested<A> editLastDataDisk() {
        int index = this.dataDisks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last dataDisks. The list is empty.");
        }
        return this.setNewDataDiskLike(index, this.buildDataDisk(index));
    }

    public DataDisksNested<A> editMatchingDataDisk(Predicate<VSphereDiskBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.dataDisks.size(); ++i) {
            if (!predicate.test(this.dataDisks.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching dataDisks. No match found.");
        }
        return this.setNewDataDiskLike(index, this.buildDataDisk(index));
    }

    public Integer getDiskGiB() {
        return this.diskGiB;
    }

    public A withDiskGiB(Integer diskGiB) {
        this.diskGiB = diskGiB;
        return (A)((Object)this);
    }

    public boolean hasDiskGiB() {
        return this.diskGiB != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public Long getMemoryMiB() {
        return this.memoryMiB;
    }

    public A withMemoryMiB(Long memoryMiB) {
        this.memoryMiB = memoryMiB;
        return (A)((Object)this);
    }

    public boolean hasMemoryMiB() {
        return this.memoryMiB != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove((Object)"metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)((Object)this);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public NetworkSpec buildNetwork() {
        return this.network != null ? this.network.build() : null;
    }

    public A withNetwork(NetworkSpec network) {
        this._visitables.remove((Object)"network");
        if (network != null) {
            this.network = new NetworkSpecBuilder(network);
            this._visitables.get((Object)"network").add(this.network);
        } else {
            this.network = null;
            this._visitables.get((Object)"network").remove((Object)this.network);
        }
        return (A)((Object)this);
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public NetworkNested<A> withNewNetwork() {
        return new NetworkNested(null);
    }

    public NetworkNested<A> withNewNetworkLike(NetworkSpec item) {
        return new NetworkNested(item);
    }

    public NetworkNested<A> editNetwork() {
        return this.withNewNetworkLike(Optional.ofNullable(this.buildNetwork()).orElse(null));
    }

    public NetworkNested<A> editOrNewNetwork() {
        return this.withNewNetworkLike(Optional.ofNullable(this.buildNetwork()).orElse(new NetworkSpecBuilder().build()));
    }

    public NetworkNested<A> editOrNewNetworkLike(NetworkSpec item) {
        return this.withNewNetworkLike(Optional.ofNullable(this.buildNetwork()).orElse(item));
    }

    public Integer getNumCPUs() {
        return this.numCPUs;
    }

    public A withNumCPUs(Integer numCPUs) {
        this.numCPUs = numCPUs;
        return (A)((Object)this);
    }

    public boolean hasNumCPUs() {
        return this.numCPUs != null;
    }

    public Integer getNumCoresPerSocket() {
        return this.numCoresPerSocket;
    }

    public A withNumCoresPerSocket(Integer numCoresPerSocket) {
        this.numCoresPerSocket = numCoresPerSocket;
        return (A)((Object)this);
    }

    public boolean hasNumCoresPerSocket() {
        return this.numCoresPerSocket != null;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public A withSnapshot(String snapshot) {
        this.snapshot = snapshot;
        return (A)((Object)this);
    }

    public boolean hasSnapshot() {
        return this.snapshot != null;
    }

    public A addToTagIDs(int index, String item) {
        if (this.tagIDs == null) {
            this.tagIDs = new ArrayList<String>();
        }
        this.tagIDs.add(index, item);
        return (A)((Object)this);
    }

    public A setToTagIDs(int index, String item) {
        if (this.tagIDs == null) {
            this.tagIDs = new ArrayList<String>();
        }
        this.tagIDs.set(index, item);
        return (A)((Object)this);
    }

    public A addToTagIDs(String ... items) {
        if (this.tagIDs == null) {
            this.tagIDs = new ArrayList<String>();
        }
        for (String item : items) {
            this.tagIDs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTagIDs(Collection<String> items) {
        if (this.tagIDs == null) {
            this.tagIDs = new ArrayList<String>();
        }
        for (String item : items) {
            this.tagIDs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTagIDs(String ... items) {
        if (this.tagIDs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tagIDs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTagIDs(Collection<String> items) {
        if (this.tagIDs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tagIDs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getTagIDs() {
        return this.tagIDs;
    }

    public String getTagID(int index) {
        return this.tagIDs.get(index);
    }

    public String getFirstTagID() {
        return this.tagIDs.get(0);
    }

    public String getLastTagID() {
        return this.tagIDs.get(this.tagIDs.size() - 1);
    }

    public String getMatchingTagID(Predicate<String> predicate) {
        for (String item : this.tagIDs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTagID(Predicate<String> predicate) {
        for (String item : this.tagIDs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTagIDs(List<String> tagIDs) {
        if (tagIDs != null) {
            this.tagIDs = new ArrayList<String>();
            for (String item : tagIDs) {
                this.addToTagIDs(item);
            }
        } else {
            this.tagIDs = null;
        }
        return (A)((Object)this);
    }

    public A withTagIDs(String ... tagIDs) {
        if (this.tagIDs != null) {
            this.tagIDs.clear();
            this._visitables.remove((Object)"tagIDs");
        }
        if (tagIDs != null) {
            for (String item : tagIDs) {
                this.addToTagIDs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTagIDs() {
        return this.tagIDs != null && !this.tagIDs.isEmpty();
    }

    public String getTemplate() {
        return this.template;
    }

    public A withTemplate(String template) {
        this.template = template;
        return (A)((Object)this);
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public LocalObjectReference buildUserDataSecret() {
        return this.userDataSecret != null ? this.userDataSecret.build() : null;
    }

    public A withUserDataSecret(LocalObjectReference userDataSecret) {
        this._visitables.remove((Object)"userDataSecret");
        if (userDataSecret != null) {
            this.userDataSecret = new LocalObjectReferenceBuilder(userDataSecret);
            this._visitables.get((Object)"userDataSecret").add(this.userDataSecret);
        } else {
            this.userDataSecret = null;
            this._visitables.get((Object)"userDataSecret").remove(this.userDataSecret);
        }
        return (A)((Object)this);
    }

    public boolean hasUserDataSecret() {
        return this.userDataSecret != null;
    }

    public A withNewUserDataSecret(String name) {
        return this.withUserDataSecret(new LocalObjectReference(name));
    }

    public UserDataSecretNested<A> withNewUserDataSecret() {
        return new UserDataSecretNested(null);
    }

    public UserDataSecretNested<A> withNewUserDataSecretLike(LocalObjectReference item) {
        return new UserDataSecretNested(item);
    }

    public UserDataSecretNested<A> editUserDataSecret() {
        return this.withNewUserDataSecretLike(Optional.ofNullable(this.buildUserDataSecret()).orElse(null));
    }

    public UserDataSecretNested<A> editOrNewUserDataSecret() {
        return this.withNewUserDataSecretLike(Optional.ofNullable(this.buildUserDataSecret()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public UserDataSecretNested<A> editOrNewUserDataSecretLike(LocalObjectReference item) {
        return this.withNewUserDataSecretLike(Optional.ofNullable(this.buildUserDataSecret()).orElse(item));
    }

    public Workspace buildWorkspace() {
        return this.workspace != null ? this.workspace.build() : null;
    }

    public A withWorkspace(Workspace workspace) {
        this._visitables.remove((Object)"workspace");
        if (workspace != null) {
            this.workspace = new WorkspaceBuilder(workspace);
            this._visitables.get((Object)"workspace").add(this.workspace);
        } else {
            this.workspace = null;
            this._visitables.get((Object)"workspace").remove((Object)this.workspace);
        }
        return (A)((Object)this);
    }

    public boolean hasWorkspace() {
        return this.workspace != null;
    }

    public WorkspaceNested<A> withNewWorkspace() {
        return new WorkspaceNested(null);
    }

    public WorkspaceNested<A> withNewWorkspaceLike(Workspace item) {
        return new WorkspaceNested(item);
    }

    public WorkspaceNested<A> editWorkspace() {
        return this.withNewWorkspaceLike(Optional.ofNullable(this.buildWorkspace()).orElse(null));
    }

    public WorkspaceNested<A> editOrNewWorkspace() {
        return this.withNewWorkspaceLike(Optional.ofNullable(this.buildWorkspace()).orElse(new WorkspaceBuilder().build()));
    }

    public WorkspaceNested<A> editOrNewWorkspaceLike(Workspace item) {
        return this.withNewWorkspaceLike(Optional.ofNullable(this.buildWorkspace()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VSphereMachineProviderSpecFluent that = (VSphereMachineProviderSpecFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.cloneMode, that.cloneMode)) {
            return false;
        }
        if (!Objects.equals(this.credentialsSecret, that.credentialsSecret)) {
            return false;
        }
        if (!Objects.equals(this.dataDisks, that.dataDisks)) {
            return false;
        }
        if (!Objects.equals(this.diskGiB, that.diskGiB)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.memoryMiB, that.memoryMiB)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals((Object)this.network, (Object)that.network)) {
            return false;
        }
        if (!Objects.equals(this.numCPUs, that.numCPUs)) {
            return false;
        }
        if (!Objects.equals(this.numCoresPerSocket, that.numCoresPerSocket)) {
            return false;
        }
        if (!Objects.equals(this.snapshot, that.snapshot)) {
            return false;
        }
        if (!Objects.equals(this.tagIDs, that.tagIDs)) {
            return false;
        }
        if (!Objects.equals(this.template, that.template)) {
            return false;
        }
        if (!Objects.equals(this.userDataSecret, that.userDataSecret)) {
            return false;
        }
        if (!Objects.equals((Object)this.workspace, (Object)that.workspace)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiVersion, this.cloneMode, this.credentialsSecret, this.dataDisks, this.diskGiB, this.kind, this.memoryMiB, this.metadata, this.network, this.numCPUs, this.numCoresPerSocket, this.snapshot, this.tagIDs, this.template, this.userDataSecret, this.workspace, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.cloneMode != null) {
            sb.append("cloneMode:");
            sb.append(this.cloneMode + ",");
        }
        if (this.credentialsSecret != null) {
            sb.append("credentialsSecret:");
            sb.append(String.valueOf(this.credentialsSecret) + ",");
        }
        if (this.dataDisks != null && !this.dataDisks.isEmpty()) {
            sb.append("dataDisks:");
            sb.append(String.valueOf(this.dataDisks) + ",");
        }
        if (this.diskGiB != null) {
            sb.append("diskGiB:");
            sb.append(this.diskGiB + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.memoryMiB != null) {
            sb.append("memoryMiB:");
            sb.append(this.memoryMiB + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(String.valueOf(this.metadata) + ",");
        }
        if (this.network != null) {
            sb.append("network:");
            sb.append(String.valueOf((Object)this.network) + ",");
        }
        if (this.numCPUs != null) {
            sb.append("numCPUs:");
            sb.append(this.numCPUs + ",");
        }
        if (this.numCoresPerSocket != null) {
            sb.append("numCoresPerSocket:");
            sb.append(this.numCoresPerSocket + ",");
        }
        if (this.snapshot != null) {
            sb.append("snapshot:");
            sb.append(this.snapshot + ",");
        }
        if (this.tagIDs != null && !this.tagIDs.isEmpty()) {
            sb.append("tagIDs:");
            sb.append(String.valueOf(this.tagIDs) + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template + ",");
        }
        if (this.userDataSecret != null) {
            sb.append("userDataSecret:");
            sb.append(String.valueOf(this.userDataSecret) + ",");
        }
        if (this.workspace != null) {
            sb.append("workspace:");
            sb.append(String.valueOf((Object)this.workspace) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class WorkspaceNested<N>
    extends WorkspaceFluent<WorkspaceNested<N>>
    implements Nested<N> {
        WorkspaceBuilder builder;

        WorkspaceNested(Workspace item) {
            this.builder = new WorkspaceBuilder(this, item);
        }

        public N and() {
            return (N)VSphereMachineProviderSpecFluent.this.withWorkspace(this.builder.build());
        }

        public N endWorkspace() {
            return this.and();
        }
    }

    public class UserDataSecretNested<N>
    extends LocalObjectReferenceFluent<UserDataSecretNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        UserDataSecretNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)VSphereMachineProviderSpecFluent.this.withUserDataSecret(this.builder.build());
        }

        public N endUserDataSecret() {
            return this.and();
        }
    }

    public class NetworkNested<N>
    extends NetworkSpecFluent<NetworkNested<N>>
    implements Nested<N> {
        NetworkSpecBuilder builder;

        NetworkNested(NetworkSpec item) {
            this.builder = new NetworkSpecBuilder(this, item);
        }

        public N and() {
            return (N)VSphereMachineProviderSpecFluent.this.withNetwork(this.builder.build());
        }

        public N endNetwork() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        public N and() {
            return (N)VSphereMachineProviderSpecFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class DataDisksNested<N>
    extends VSphereDiskFluent<DataDisksNested<N>>
    implements Nested<N> {
        VSphereDiskBuilder builder;
        int index;

        DataDisksNested(int index, VSphereDisk item) {
            this.index = index;
            this.builder = new VSphereDiskBuilder(this, item);
        }

        public N and() {
            return (N)VSphereMachineProviderSpecFluent.this.setToDataDisks(this.index, this.builder.build());
        }

        public N endDataDisk() {
            return this.and();
        }
    }

    public class CredentialsSecretNested<N>
    extends LocalObjectReferenceFluent<CredentialsSecretNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        CredentialsSecretNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)VSphereMachineProviderSpecFluent.this.withCredentialsSecret(this.builder.build());
        }

        public N endCredentialsSecret() {
            return this.and();
        }
    }
}

