package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.SecretReference;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AzureMachineProviderSpecFluent<A extends AzureMachineProviderSpecFluent<A>> extends BaseFluent<A>{
  public AzureMachineProviderSpecFluent() {
  }
  
  public AzureMachineProviderSpecFluent(AzureMachineProviderSpec instance) {
    this.copyInstance(instance);
  }
  private Boolean acceleratedNetworking;
  private String apiVersion;
  private List<String> applicationSecurityGroups = new ArrayList<String>();
  private String availabilitySet;
  private String capacityReservationGroupID;
  private SecretReference credentialsSecret;
  private ArrayList<DataDiskBuilder> dataDisks = new ArrayList<DataDiskBuilder>();
  private AzureDiagnosticsBuilder diagnostics;
  private ImageBuilder image;
  private String internalLoadBalancer;
  private String kind;
  private String location;
  private String managedIdentity;
  private ObjectMetaBuilder metadata;
  private Long natRule;
  private String networkResourceGroup;
  private OSDiskBuilder osDisk;
  private Boolean publicIP;
  private String publicLoadBalancer;
  private String resourceGroup;
  private String securityGroup;
  private SecurityProfileBuilder securityProfile;
  private SpotVMOptionsBuilder spotVMOptions;
  private String sshPublicKey;
  private String subnet;
  private Map<String,String> tags;
  private String ultraSSDCapability;
  private SecretReference userDataSecret;
  private String vmSize;
  private String vnet;
  private String zone;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AzureMachineProviderSpec instance) {
    instance = (instance != null ? instance : new AzureMachineProviderSpec());
    if (instance != null) {
          this.withAcceleratedNetworking(instance.getAcceleratedNetworking());
          this.withApiVersion(instance.getApiVersion());
          this.withApplicationSecurityGroups(instance.getApplicationSecurityGroups());
          this.withAvailabilitySet(instance.getAvailabilitySet());
          this.withCapacityReservationGroupID(instance.getCapacityReservationGroupID());
          this.withCredentialsSecret(instance.getCredentialsSecret());
          this.withDataDisks(instance.getDataDisks());
          this.withDiagnostics(instance.getDiagnostics());
          this.withImage(instance.getImage());
          this.withInternalLoadBalancer(instance.getInternalLoadBalancer());
          this.withKind(instance.getKind());
          this.withLocation(instance.getLocation());
          this.withManagedIdentity(instance.getManagedIdentity());
          this.withMetadata(instance.getMetadata());
          this.withNatRule(instance.getNatRule());
          this.withNetworkResourceGroup(instance.getNetworkResourceGroup());
          this.withOsDisk(instance.getOsDisk());
          this.withPublicIP(instance.getPublicIP());
          this.withPublicLoadBalancer(instance.getPublicLoadBalancer());
          this.withResourceGroup(instance.getResourceGroup());
          this.withSecurityGroup(instance.getSecurityGroup());
          this.withSecurityProfile(instance.getSecurityProfile());
          this.withSpotVMOptions(instance.getSpotVMOptions());
          this.withSshPublicKey(instance.getSshPublicKey());
          this.withSubnet(instance.getSubnet());
          this.withTags(instance.getTags());
          this.withUltraSSDCapability(instance.getUltraSSDCapability());
          this.withUserDataSecret(instance.getUserDataSecret());
          this.withVmSize(instance.getVmSize());
          this.withVnet(instance.getVnet());
          this.withZone(instance.getZone());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Boolean getAcceleratedNetworking() {
    return this.acceleratedNetworking;
  }
  
  public A withAcceleratedNetworking(Boolean acceleratedNetworking) {
    this.acceleratedNetworking = acceleratedNetworking;
    return (A) this;
  }
  
  public boolean hasAcceleratedNetworking() {
    return this.acceleratedNetworking != null;
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public A addToApplicationSecurityGroups(int index,String item) {
    if (this.applicationSecurityGroups == null) {this.applicationSecurityGroups = new ArrayList<String>();}
    this.applicationSecurityGroups.add(index, item);
    return (A)this;
  }
  
  public A setToApplicationSecurityGroups(int index,String item) {
    if (this.applicationSecurityGroups == null) {this.applicationSecurityGroups = new ArrayList<String>();}
    this.applicationSecurityGroups.set(index, item); return (A)this;
  }
  
  public A addToApplicationSecurityGroups(java.lang.String... items) {
    if (this.applicationSecurityGroups == null) {this.applicationSecurityGroups = new ArrayList<String>();}
    for (String item : items) {this.applicationSecurityGroups.add(item);} return (A)this;
  }
  
  public A addAllToApplicationSecurityGroups(Collection<String> items) {
    if (this.applicationSecurityGroups == null) {this.applicationSecurityGroups = new ArrayList<String>();}
    for (String item : items) {this.applicationSecurityGroups.add(item);} return (A)this;
  }
  
  public A removeFromApplicationSecurityGroups(java.lang.String... items) {
    if (this.applicationSecurityGroups == null) return (A)this;
    for (String item : items) { this.applicationSecurityGroups.remove(item);} return (A)this;
  }
  
  public A removeAllFromApplicationSecurityGroups(Collection<String> items) {
    if (this.applicationSecurityGroups == null) return (A)this;
    for (String item : items) { this.applicationSecurityGroups.remove(item);} return (A)this;
  }
  
  public List<String> getApplicationSecurityGroups() {
    return this.applicationSecurityGroups;
  }
  
  public String getApplicationSecurityGroup(int index) {
    return this.applicationSecurityGroups.get(index);
  }
  
  public String getFirstApplicationSecurityGroup() {
    return this.applicationSecurityGroups.get(0);
  }
  
  public String getLastApplicationSecurityGroup() {
    return this.applicationSecurityGroups.get(applicationSecurityGroups.size() - 1);
  }
  
  public String getMatchingApplicationSecurityGroup(Predicate<String> predicate) {
      for (String item : applicationSecurityGroups) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingApplicationSecurityGroup(Predicate<String> predicate) {
      for (String item : applicationSecurityGroups) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withApplicationSecurityGroups(List<String> applicationSecurityGroups) {
    if (applicationSecurityGroups != null) {
        this.applicationSecurityGroups = new ArrayList();
        for (String item : applicationSecurityGroups) {
          this.addToApplicationSecurityGroups(item);
        }
    } else {
      this.applicationSecurityGroups = null;
    }
    return (A) this;
  }
  
  public A withApplicationSecurityGroups(java.lang.String... applicationSecurityGroups) {
    if (this.applicationSecurityGroups != null) {
        this.applicationSecurityGroups.clear();
        _visitables.remove("applicationSecurityGroups");
    }
    if (applicationSecurityGroups != null) {
      for (String item : applicationSecurityGroups) {
        this.addToApplicationSecurityGroups(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasApplicationSecurityGroups() {
    return this.applicationSecurityGroups != null && !this.applicationSecurityGroups.isEmpty();
  }
  
  public String getAvailabilitySet() {
    return this.availabilitySet;
  }
  
  public A withAvailabilitySet(String availabilitySet) {
    this.availabilitySet = availabilitySet;
    return (A) this;
  }
  
  public boolean hasAvailabilitySet() {
    return this.availabilitySet != null;
  }
  
  public String getCapacityReservationGroupID() {
    return this.capacityReservationGroupID;
  }
  
  public A withCapacityReservationGroupID(String capacityReservationGroupID) {
    this.capacityReservationGroupID = capacityReservationGroupID;
    return (A) this;
  }
  
  public boolean hasCapacityReservationGroupID() {
    return this.capacityReservationGroupID != null;
  }
  
  public SecretReference getCredentialsSecret() {
    return this.credentialsSecret;
  }
  
  public A withCredentialsSecret(SecretReference credentialsSecret) {
    this.credentialsSecret = credentialsSecret;
    return (A) this;
  }
  
  public boolean hasCredentialsSecret() {
    return this.credentialsSecret != null;
  }
  
  public A withNewCredentialsSecret(String name,String namespace) {
    return (A)withCredentialsSecret(new SecretReference(name, namespace));
  }
  
  public A addToDataDisks(int index,DataDisk item) {
    if (this.dataDisks == null) {this.dataDisks = new ArrayList<DataDiskBuilder>();}
    DataDiskBuilder builder = new DataDiskBuilder(item);
    if (index < 0 || index >= dataDisks.size()) {
        _visitables.get("dataDisks").add(builder);
        dataDisks.add(builder);
    } else {
        _visitables.get("dataDisks").add(builder);
        dataDisks.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToDataDisks(int index,DataDisk item) {
    if (this.dataDisks == null) {this.dataDisks = new ArrayList<DataDiskBuilder>();}
    DataDiskBuilder builder = new DataDiskBuilder(item);
    if (index < 0 || index >= dataDisks.size()) {
        _visitables.get("dataDisks").add(builder);
        dataDisks.add(builder);
    } else {
        _visitables.get("dataDisks").add(builder);
        dataDisks.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToDataDisks(io.fabric8.openshift.api.model.machine.v1beta1.DataDisk... items) {
    if (this.dataDisks == null) {this.dataDisks = new ArrayList<DataDiskBuilder>();}
    for (DataDisk item : items) {DataDiskBuilder builder = new DataDiskBuilder(item);_visitables.get("dataDisks").add(builder);this.dataDisks.add(builder);} return (A)this;
  }
  
  public A addAllToDataDisks(Collection<DataDisk> items) {
    if (this.dataDisks == null) {this.dataDisks = new ArrayList<DataDiskBuilder>();}
    for (DataDisk item : items) {DataDiskBuilder builder = new DataDiskBuilder(item);_visitables.get("dataDisks").add(builder);this.dataDisks.add(builder);} return (A)this;
  }
  
  public A removeFromDataDisks(io.fabric8.openshift.api.model.machine.v1beta1.DataDisk... items) {
    if (this.dataDisks == null) return (A)this;
    for (DataDisk item : items) {DataDiskBuilder builder = new DataDiskBuilder(item);_visitables.get("dataDisks").remove(builder); this.dataDisks.remove(builder);} return (A)this;
  }
  
  public A removeAllFromDataDisks(Collection<DataDisk> items) {
    if (this.dataDisks == null) return (A)this;
    for (DataDisk item : items) {DataDiskBuilder builder = new DataDiskBuilder(item);_visitables.get("dataDisks").remove(builder); this.dataDisks.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromDataDisks(Predicate<DataDiskBuilder> predicate) {
    if (dataDisks == null) return (A) this;
    final Iterator<DataDiskBuilder> each = dataDisks.iterator();
    final List visitables = _visitables.get("dataDisks");
    while (each.hasNext()) {
      DataDiskBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<DataDisk> buildDataDisks() {
    return this.dataDisks != null ? build(dataDisks) : null;
  }
  
  public DataDisk buildDataDisk(int index) {
    return this.dataDisks.get(index).build();
  }
  
  public DataDisk buildFirstDataDisk() {
    return this.dataDisks.get(0).build();
  }
  
  public DataDisk buildLastDataDisk() {
    return this.dataDisks.get(dataDisks.size() - 1).build();
  }
  
  public DataDisk buildMatchingDataDisk(Predicate<DataDiskBuilder> predicate) {
      for (DataDiskBuilder item : dataDisks) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingDataDisk(Predicate<DataDiskBuilder> predicate) {
      for (DataDiskBuilder item : dataDisks) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDataDisks(List<DataDisk> dataDisks) {
    if (this.dataDisks != null) {
      this._visitables.get("dataDisks").clear();
    }
    if (dataDisks != null) {
        this.dataDisks = new ArrayList();
        for (DataDisk item : dataDisks) {
          this.addToDataDisks(item);
        }
    } else {
      this.dataDisks = null;
    }
    return (A) this;
  }
  
  public A withDataDisks(io.fabric8.openshift.api.model.machine.v1beta1.DataDisk... dataDisks) {
    if (this.dataDisks != null) {
        this.dataDisks.clear();
        _visitables.remove("dataDisks");
    }
    if (dataDisks != null) {
      for (DataDisk item : dataDisks) {
        this.addToDataDisks(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDataDisks() {
    return this.dataDisks != null && !this.dataDisks.isEmpty();
  }
  
  public DataDisksNested<A> addNewDataDisk() {
    return new DataDisksNested(-1, null);
  }
  
  public DataDisksNested<A> addNewDataDiskLike(DataDisk item) {
    return new DataDisksNested(-1, item);
  }
  
  public DataDisksNested<A> setNewDataDiskLike(int index,DataDisk item) {
    return new DataDisksNested(index, item);
  }
  
  public DataDisksNested<A> editDataDisk(int index) {
    if (dataDisks.size() <= index) throw new RuntimeException("Can't edit dataDisks. Index exceeds size.");
    return setNewDataDiskLike(index, buildDataDisk(index));
  }
  
  public DataDisksNested<A> editFirstDataDisk() {
    if (dataDisks.size() == 0) throw new RuntimeException("Can't edit first dataDisks. The list is empty.");
    return setNewDataDiskLike(0, buildDataDisk(0));
  }
  
  public DataDisksNested<A> editLastDataDisk() {
    int index = dataDisks.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last dataDisks. The list is empty.");
    return setNewDataDiskLike(index, buildDataDisk(index));
  }
  
  public DataDisksNested<A> editMatchingDataDisk(Predicate<DataDiskBuilder> predicate) {
    int index = -1;
    for (int i=0;i<dataDisks.size();i++) { 
    if (predicate.test(dataDisks.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching dataDisks. No match found.");
    return setNewDataDiskLike(index, buildDataDisk(index));
  }
  
  public AzureDiagnostics buildDiagnostics() {
    return this.diagnostics != null ? this.diagnostics.build() : null;
  }
  
  public A withDiagnostics(AzureDiagnostics diagnostics) {
    this._visitables.remove("diagnostics");
    if (diagnostics != null) {
        this.diagnostics = new AzureDiagnosticsBuilder(diagnostics);
        this._visitables.get("diagnostics").add(this.diagnostics);
    } else {
        this.diagnostics = null;
        this._visitables.get("diagnostics").remove(this.diagnostics);
    }
    return (A) this;
  }
  
  public boolean hasDiagnostics() {
    return this.diagnostics != null;
  }
  
  public DiagnosticsNested<A> withNewDiagnostics() {
    return new DiagnosticsNested(null);
  }
  
  public DiagnosticsNested<A> withNewDiagnosticsLike(AzureDiagnostics item) {
    return new DiagnosticsNested(item);
  }
  
  public DiagnosticsNested<A> editDiagnostics() {
    return withNewDiagnosticsLike(java.util.Optional.ofNullable(buildDiagnostics()).orElse(null));
  }
  
  public DiagnosticsNested<A> editOrNewDiagnostics() {
    return withNewDiagnosticsLike(java.util.Optional.ofNullable(buildDiagnostics()).orElse(new AzureDiagnosticsBuilder().build()));
  }
  
  public DiagnosticsNested<A> editOrNewDiagnosticsLike(AzureDiagnostics item) {
    return withNewDiagnosticsLike(java.util.Optional.ofNullable(buildDiagnostics()).orElse(item));
  }
  
  public Image buildImage() {
    return this.image != null ? this.image.build() : null;
  }
  
  public A withImage(Image image) {
    this._visitables.remove("image");
    if (image != null) {
        this.image = new ImageBuilder(image);
        this._visitables.get("image").add(this.image);
    } else {
        this.image = null;
        this._visitables.get("image").remove(this.image);
    }
    return (A) this;
  }
  
  public boolean hasImage() {
    return this.image != null;
  }
  
  public ImageNested<A> withNewImage() {
    return new ImageNested(null);
  }
  
  public ImageNested<A> withNewImageLike(Image item) {
    return new ImageNested(item);
  }
  
  public ImageNested<A> editImage() {
    return withNewImageLike(java.util.Optional.ofNullable(buildImage()).orElse(null));
  }
  
  public ImageNested<A> editOrNewImage() {
    return withNewImageLike(java.util.Optional.ofNullable(buildImage()).orElse(new ImageBuilder().build()));
  }
  
  public ImageNested<A> editOrNewImageLike(Image item) {
    return withNewImageLike(java.util.Optional.ofNullable(buildImage()).orElse(item));
  }
  
  public String getInternalLoadBalancer() {
    return this.internalLoadBalancer;
  }
  
  public A withInternalLoadBalancer(String internalLoadBalancer) {
    this.internalLoadBalancer = internalLoadBalancer;
    return (A) this;
  }
  
  public boolean hasInternalLoadBalancer() {
    return this.internalLoadBalancer != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public String getLocation() {
    return this.location;
  }
  
  public A withLocation(String location) {
    this.location = location;
    return (A) this;
  }
  
  public boolean hasLocation() {
    return this.location != null;
  }
  
  public String getManagedIdentity() {
    return this.managedIdentity;
  }
  
  public A withManagedIdentity(String managedIdentity) {
    this.managedIdentity = managedIdentity;
    return (A) this;
  }
  
  public boolean hasManagedIdentity() {
    return this.managedIdentity != null;
  }
  
  public ObjectMeta buildMetadata() {
    return this.metadata != null ? this.metadata.build() : null;
  }
  
  public A withMetadata(ObjectMeta metadata) {
    this._visitables.remove("metadata");
    if (metadata != null) {
        this.metadata = new ObjectMetaBuilder(metadata);
        this._visitables.get("metadata").add(this.metadata);
    } else {
        this.metadata = null;
        this._visitables.get("metadata").remove(this.metadata);
    }
    return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  
  public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MetadataNested(item);
  }
  
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new ObjectMetaBuilder().build()));
  }
  
  public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  
  public Long getNatRule() {
    return this.natRule;
  }
  
  public A withNatRule(Long natRule) {
    this.natRule = natRule;
    return (A) this;
  }
  
  public boolean hasNatRule() {
    return this.natRule != null;
  }
  
  public String getNetworkResourceGroup() {
    return this.networkResourceGroup;
  }
  
  public A withNetworkResourceGroup(String networkResourceGroup) {
    this.networkResourceGroup = networkResourceGroup;
    return (A) this;
  }
  
  public boolean hasNetworkResourceGroup() {
    return this.networkResourceGroup != null;
  }
  
  public OSDisk buildOsDisk() {
    return this.osDisk != null ? this.osDisk.build() : null;
  }
  
  public A withOsDisk(OSDisk osDisk) {
    this._visitables.remove("osDisk");
    if (osDisk != null) {
        this.osDisk = new OSDiskBuilder(osDisk);
        this._visitables.get("osDisk").add(this.osDisk);
    } else {
        this.osDisk = null;
        this._visitables.get("osDisk").remove(this.osDisk);
    }
    return (A) this;
  }
  
  public boolean hasOsDisk() {
    return this.osDisk != null;
  }
  
  public OsDiskNested<A> withNewOsDisk() {
    return new OsDiskNested(null);
  }
  
  public OsDiskNested<A> withNewOsDiskLike(OSDisk item) {
    return new OsDiskNested(item);
  }
  
  public OsDiskNested<A> editOsDisk() {
    return withNewOsDiskLike(java.util.Optional.ofNullable(buildOsDisk()).orElse(null));
  }
  
  public OsDiskNested<A> editOrNewOsDisk() {
    return withNewOsDiskLike(java.util.Optional.ofNullable(buildOsDisk()).orElse(new OSDiskBuilder().build()));
  }
  
  public OsDiskNested<A> editOrNewOsDiskLike(OSDisk item) {
    return withNewOsDiskLike(java.util.Optional.ofNullable(buildOsDisk()).orElse(item));
  }
  
  public Boolean getPublicIP() {
    return this.publicIP;
  }
  
  public A withPublicIP(Boolean publicIP) {
    this.publicIP = publicIP;
    return (A) this;
  }
  
  public boolean hasPublicIP() {
    return this.publicIP != null;
  }
  
  public String getPublicLoadBalancer() {
    return this.publicLoadBalancer;
  }
  
  public A withPublicLoadBalancer(String publicLoadBalancer) {
    this.publicLoadBalancer = publicLoadBalancer;
    return (A) this;
  }
  
  public boolean hasPublicLoadBalancer() {
    return this.publicLoadBalancer != null;
  }
  
  public String getResourceGroup() {
    return this.resourceGroup;
  }
  
  public A withResourceGroup(String resourceGroup) {
    this.resourceGroup = resourceGroup;
    return (A) this;
  }
  
  public boolean hasResourceGroup() {
    return this.resourceGroup != null;
  }
  
  public String getSecurityGroup() {
    return this.securityGroup;
  }
  
  public A withSecurityGroup(String securityGroup) {
    this.securityGroup = securityGroup;
    return (A) this;
  }
  
  public boolean hasSecurityGroup() {
    return this.securityGroup != null;
  }
  
  public SecurityProfile buildSecurityProfile() {
    return this.securityProfile != null ? this.securityProfile.build() : null;
  }
  
  public A withSecurityProfile(SecurityProfile securityProfile) {
    this._visitables.remove("securityProfile");
    if (securityProfile != null) {
        this.securityProfile = new SecurityProfileBuilder(securityProfile);
        this._visitables.get("securityProfile").add(this.securityProfile);
    } else {
        this.securityProfile = null;
        this._visitables.get("securityProfile").remove(this.securityProfile);
    }
    return (A) this;
  }
  
  public boolean hasSecurityProfile() {
    return this.securityProfile != null;
  }
  
  public SecurityProfileNested<A> withNewSecurityProfile() {
    return new SecurityProfileNested(null);
  }
  
  public SecurityProfileNested<A> withNewSecurityProfileLike(SecurityProfile item) {
    return new SecurityProfileNested(item);
  }
  
  public SecurityProfileNested<A> editSecurityProfile() {
    return withNewSecurityProfileLike(java.util.Optional.ofNullable(buildSecurityProfile()).orElse(null));
  }
  
  public SecurityProfileNested<A> editOrNewSecurityProfile() {
    return withNewSecurityProfileLike(java.util.Optional.ofNullable(buildSecurityProfile()).orElse(new SecurityProfileBuilder().build()));
  }
  
  public SecurityProfileNested<A> editOrNewSecurityProfileLike(SecurityProfile item) {
    return withNewSecurityProfileLike(java.util.Optional.ofNullable(buildSecurityProfile()).orElse(item));
  }
  
  public SpotVMOptions buildSpotVMOptions() {
    return this.spotVMOptions != null ? this.spotVMOptions.build() : null;
  }
  
  public A withSpotVMOptions(SpotVMOptions spotVMOptions) {
    this._visitables.remove("spotVMOptions");
    if (spotVMOptions != null) {
        this.spotVMOptions = new SpotVMOptionsBuilder(spotVMOptions);
        this._visitables.get("spotVMOptions").add(this.spotVMOptions);
    } else {
        this.spotVMOptions = null;
        this._visitables.get("spotVMOptions").remove(this.spotVMOptions);
    }
    return (A) this;
  }
  
  public boolean hasSpotVMOptions() {
    return this.spotVMOptions != null;
  }
  
  public SpotVMOptionsNested<A> withNewSpotVMOptions() {
    return new SpotVMOptionsNested(null);
  }
  
  public SpotVMOptionsNested<A> withNewSpotVMOptionsLike(SpotVMOptions item) {
    return new SpotVMOptionsNested(item);
  }
  
  public SpotVMOptionsNested<A> editSpotVMOptions() {
    return withNewSpotVMOptionsLike(java.util.Optional.ofNullable(buildSpotVMOptions()).orElse(null));
  }
  
  public SpotVMOptionsNested<A> editOrNewSpotVMOptions() {
    return withNewSpotVMOptionsLike(java.util.Optional.ofNullable(buildSpotVMOptions()).orElse(new SpotVMOptionsBuilder().build()));
  }
  
  public SpotVMOptionsNested<A> editOrNewSpotVMOptionsLike(SpotVMOptions item) {
    return withNewSpotVMOptionsLike(java.util.Optional.ofNullable(buildSpotVMOptions()).orElse(item));
  }
  
  public String getSshPublicKey() {
    return this.sshPublicKey;
  }
  
  public A withSshPublicKey(String sshPublicKey) {
    this.sshPublicKey = sshPublicKey;
    return (A) this;
  }
  
  public boolean hasSshPublicKey() {
    return this.sshPublicKey != null;
  }
  
  public String getSubnet() {
    return this.subnet;
  }
  
  public A withSubnet(String subnet) {
    this.subnet = subnet;
    return (A) this;
  }
  
  public boolean hasSubnet() {
    return this.subnet != null;
  }
  
  public A addToTags(String key,String value) {
    if(this.tags == null && key != null && value != null) { this.tags = new LinkedHashMap(); }
    if(key != null && value != null) {this.tags.put(key, value);} return (A)this;
  }
  
  public A addToTags(Map<String,String> map) {
    if(this.tags == null && map != null) { this.tags = new LinkedHashMap(); }
    if(map != null) { this.tags.putAll(map);} return (A)this;
  }
  
  public A removeFromTags(String key) {
    if(this.tags == null) { return (A) this; }
    if(key != null && this.tags != null) {this.tags.remove(key);} return (A)this;
  }
  
  public A removeFromTags(Map<String,String> map) {
    if(this.tags == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.tags != null){this.tags.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getTags() {
    return this.tags;
  }
  
  public <K,V>A withTags(Map<String,String> tags) {
    if (tags == null) {
      this.tags = null;
    } else {
      this.tags = new LinkedHashMap(tags);
    }
    return (A) this;
  }
  
  public boolean hasTags() {
    return this.tags != null;
  }
  
  public String getUltraSSDCapability() {
    return this.ultraSSDCapability;
  }
  
  public A withUltraSSDCapability(String ultraSSDCapability) {
    this.ultraSSDCapability = ultraSSDCapability;
    return (A) this;
  }
  
  public boolean hasUltraSSDCapability() {
    return this.ultraSSDCapability != null;
  }
  
  public SecretReference getUserDataSecret() {
    return this.userDataSecret;
  }
  
  public A withUserDataSecret(SecretReference userDataSecret) {
    this.userDataSecret = userDataSecret;
    return (A) this;
  }
  
  public boolean hasUserDataSecret() {
    return this.userDataSecret != null;
  }
  
  public A withNewUserDataSecret(String name,String namespace) {
    return (A)withUserDataSecret(new SecretReference(name, namespace));
  }
  
  public String getVmSize() {
    return this.vmSize;
  }
  
  public A withVmSize(String vmSize) {
    this.vmSize = vmSize;
    return (A) this;
  }
  
  public boolean hasVmSize() {
    return this.vmSize != null;
  }
  
  public String getVnet() {
    return this.vnet;
  }
  
  public A withVnet(String vnet) {
    this.vnet = vnet;
    return (A) this;
  }
  
  public boolean hasVnet() {
    return this.vnet != null;
  }
  
  public String getZone() {
    return this.zone;
  }
  
  public A withZone(String zone) {
    this.zone = zone;
    return (A) this;
  }
  
  public boolean hasZone() {
    return this.zone != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AzureMachineProviderSpecFluent that = (AzureMachineProviderSpecFluent) o;
    if (!java.util.Objects.equals(acceleratedNetworking, that.acceleratedNetworking)) return false;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(applicationSecurityGroups, that.applicationSecurityGroups)) return false;
    if (!java.util.Objects.equals(availabilitySet, that.availabilitySet)) return false;
    if (!java.util.Objects.equals(capacityReservationGroupID, that.capacityReservationGroupID)) return false;
    if (!java.util.Objects.equals(credentialsSecret, that.credentialsSecret)) return false;
    if (!java.util.Objects.equals(dataDisks, that.dataDisks)) return false;
    if (!java.util.Objects.equals(diagnostics, that.diagnostics)) return false;
    if (!java.util.Objects.equals(image, that.image)) return false;
    if (!java.util.Objects.equals(internalLoadBalancer, that.internalLoadBalancer)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(location, that.location)) return false;
    if (!java.util.Objects.equals(managedIdentity, that.managedIdentity)) return false;
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
    if (!java.util.Objects.equals(natRule, that.natRule)) return false;
    if (!java.util.Objects.equals(networkResourceGroup, that.networkResourceGroup)) return false;
    if (!java.util.Objects.equals(osDisk, that.osDisk)) return false;
    if (!java.util.Objects.equals(publicIP, that.publicIP)) return false;
    if (!java.util.Objects.equals(publicLoadBalancer, that.publicLoadBalancer)) return false;
    if (!java.util.Objects.equals(resourceGroup, that.resourceGroup)) return false;
    if (!java.util.Objects.equals(securityGroup, that.securityGroup)) return false;
    if (!java.util.Objects.equals(securityProfile, that.securityProfile)) return false;
    if (!java.util.Objects.equals(spotVMOptions, that.spotVMOptions)) return false;
    if (!java.util.Objects.equals(sshPublicKey, that.sshPublicKey)) return false;
    if (!java.util.Objects.equals(subnet, that.subnet)) return false;
    if (!java.util.Objects.equals(tags, that.tags)) return false;
    if (!java.util.Objects.equals(ultraSSDCapability, that.ultraSSDCapability)) return false;
    if (!java.util.Objects.equals(userDataSecret, that.userDataSecret)) return false;
    if (!java.util.Objects.equals(vmSize, that.vmSize)) return false;
    if (!java.util.Objects.equals(vnet, that.vnet)) return false;
    if (!java.util.Objects.equals(zone, that.zone)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(acceleratedNetworking,  apiVersion,  applicationSecurityGroups,  availabilitySet,  capacityReservationGroupID,  credentialsSecret,  dataDisks,  diagnostics,  image,  internalLoadBalancer,  kind,  location,  managedIdentity,  metadata,  natRule,  networkResourceGroup,  osDisk,  publicIP,  publicLoadBalancer,  resourceGroup,  securityGroup,  securityProfile,  spotVMOptions,  sshPublicKey,  subnet,  tags,  ultraSSDCapability,  userDataSecret,  vmSize,  vnet,  zone,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (acceleratedNetworking != null) { sb.append("acceleratedNetworking:"); sb.append(acceleratedNetworking + ","); }
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (applicationSecurityGroups != null && !applicationSecurityGroups.isEmpty()) { sb.append("applicationSecurityGroups:"); sb.append(applicationSecurityGroups + ","); }
    if (availabilitySet != null) { sb.append("availabilitySet:"); sb.append(availabilitySet + ","); }
    if (capacityReservationGroupID != null) { sb.append("capacityReservationGroupID:"); sb.append(capacityReservationGroupID + ","); }
    if (credentialsSecret != null) { sb.append("credentialsSecret:"); sb.append(credentialsSecret + ","); }
    if (dataDisks != null && !dataDisks.isEmpty()) { sb.append("dataDisks:"); sb.append(dataDisks + ","); }
    if (diagnostics != null) { sb.append("diagnostics:"); sb.append(diagnostics + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (internalLoadBalancer != null) { sb.append("internalLoadBalancer:"); sb.append(internalLoadBalancer + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (location != null) { sb.append("location:"); sb.append(location + ","); }
    if (managedIdentity != null) { sb.append("managedIdentity:"); sb.append(managedIdentity + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (natRule != null) { sb.append("natRule:"); sb.append(natRule + ","); }
    if (networkResourceGroup != null) { sb.append("networkResourceGroup:"); sb.append(networkResourceGroup + ","); }
    if (osDisk != null) { sb.append("osDisk:"); sb.append(osDisk + ","); }
    if (publicIP != null) { sb.append("publicIP:"); sb.append(publicIP + ","); }
    if (publicLoadBalancer != null) { sb.append("publicLoadBalancer:"); sb.append(publicLoadBalancer + ","); }
    if (resourceGroup != null) { sb.append("resourceGroup:"); sb.append(resourceGroup + ","); }
    if (securityGroup != null) { sb.append("securityGroup:"); sb.append(securityGroup + ","); }
    if (securityProfile != null) { sb.append("securityProfile:"); sb.append(securityProfile + ","); }
    if (spotVMOptions != null) { sb.append("spotVMOptions:"); sb.append(spotVMOptions + ","); }
    if (sshPublicKey != null) { sb.append("sshPublicKey:"); sb.append(sshPublicKey + ","); }
    if (subnet != null) { sb.append("subnet:"); sb.append(subnet + ","); }
    if (tags != null && !tags.isEmpty()) { sb.append("tags:"); sb.append(tags + ","); }
    if (ultraSSDCapability != null) { sb.append("ultraSSDCapability:"); sb.append(ultraSSDCapability + ","); }
    if (userDataSecret != null) { sb.append("userDataSecret:"); sb.append(userDataSecret + ","); }
    if (vmSize != null) { sb.append("vmSize:"); sb.append(vmSize + ","); }
    if (vnet != null) { sb.append("vnet:"); sb.append(vnet + ","); }
    if (zone != null) { sb.append("zone:"); sb.append(zone + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withAcceleratedNetworking() {
    return withAcceleratedNetworking(true);
  }
  
  public A withPublicIP() {
    return withPublicIP(true);
  }
  public class DataDisksNested<N> extends DataDiskFluent<DataDisksNested<N>> implements Nested<N>{
    DataDisksNested(int index,DataDisk item) {
      this.index = index;
      this.builder = new DataDiskBuilder(this, item);
    }
    DataDiskBuilder builder;
    int index;
    
    public N and() {
      return (N) AzureMachineProviderSpecFluent.this.setToDataDisks(index,builder.build());
    }
    
    public N endDataDisk() {
      return and();
    }
    
  
  }
  public class DiagnosticsNested<N> extends AzureDiagnosticsFluent<DiagnosticsNested<N>> implements Nested<N>{
    DiagnosticsNested(AzureDiagnostics item) {
      this.builder = new AzureDiagnosticsBuilder(this, item);
    }
    AzureDiagnosticsBuilder builder;
    
    public N and() {
      return (N) AzureMachineProviderSpecFluent.this.withDiagnostics(builder.build());
    }
    
    public N endDiagnostics() {
      return and();
    }
    
  
  }
  public class ImageNested<N> extends ImageFluent<ImageNested<N>> implements Nested<N>{
    ImageNested(Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageBuilder builder;
    
    public N and() {
      return (N) AzureMachineProviderSpecFluent.this.withImage(builder.build());
    }
    
    public N endImage() {
      return and();
    }
    
  
  }
  public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    
    public N and() {
      return (N) AzureMachineProviderSpecFluent.this.withMetadata(builder.build());
    }
    
    public N endMetadata() {
      return and();
    }
    
  
  }
  public class OsDiskNested<N> extends OSDiskFluent<OsDiskNested<N>> implements Nested<N>{
    OsDiskNested(OSDisk item) {
      this.builder = new OSDiskBuilder(this, item);
    }
    OSDiskBuilder builder;
    
    public N and() {
      return (N) AzureMachineProviderSpecFluent.this.withOsDisk(builder.build());
    }
    
    public N endOsDisk() {
      return and();
    }
    
  
  }
  public class SecurityProfileNested<N> extends SecurityProfileFluent<SecurityProfileNested<N>> implements Nested<N>{
    SecurityProfileNested(SecurityProfile item) {
      this.builder = new SecurityProfileBuilder(this, item);
    }
    SecurityProfileBuilder builder;
    
    public N and() {
      return (N) AzureMachineProviderSpecFluent.this.withSecurityProfile(builder.build());
    }
    
    public N endSecurityProfile() {
      return and();
    }
    
  
  }
  public class SpotVMOptionsNested<N> extends SpotVMOptionsFluent<SpotVMOptionsNested<N>> implements Nested<N>{
    SpotVMOptionsNested(SpotVMOptions item) {
      this.builder = new SpotVMOptionsBuilder(this, item);
    }
    SpotVMOptionsBuilder builder;
    
    public N and() {
      return (N) AzureMachineProviderSpecFluent.this.withSpotVMOptions(builder.build());
    }
    
    public N endSpotVMOptions() {
      return and();
    }
    
  
  }

}