package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AzureBootDiagnosticsBuilder extends AzureBootDiagnosticsFluent<AzureBootDiagnosticsBuilder> implements VisitableBuilder<AzureBootDiagnostics,AzureBootDiagnosticsBuilder>{
  public AzureBootDiagnosticsBuilder() {
    this(new AzureBootDiagnostics());
  }
  
  public AzureBootDiagnosticsBuilder(AzureBootDiagnosticsFluent<?> fluent) {
    this(fluent, new AzureBootDiagnostics());
  }
  
  public AzureBootDiagnosticsBuilder(AzureBootDiagnosticsFluent<?> fluent,AzureBootDiagnostics instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AzureBootDiagnosticsBuilder(AzureBootDiagnostics instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AzureBootDiagnosticsFluent<?> fluent;
  
  public AzureBootDiagnostics build() {
    AzureBootDiagnostics buildable = new AzureBootDiagnostics(fluent.buildCustomerManaged(),fluent.getStorageAccountType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}