/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.GCPDisk;
import io.fabric8.openshift.api.model.machine.v1beta1.GCPDiskBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.GCPDiskFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.GCPGPUConfig;
import io.fabric8.openshift.api.model.machine.v1beta1.GCPGPUConfigBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.GCPGPUConfigFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.GCPMachineProviderSpec;
import io.fabric8.openshift.api.model.machine.v1beta1.GCPMetadata;
import io.fabric8.openshift.api.model.machine.v1beta1.GCPMetadataBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.GCPMetadataFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.GCPNetworkInterface;
import io.fabric8.openshift.api.model.machine.v1beta1.GCPNetworkInterfaceBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.GCPNetworkInterfaceFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.GCPServiceAccount;
import io.fabric8.openshift.api.model.machine.v1beta1.GCPServiceAccountBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.GCPServiceAccountFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.GCPShieldedInstanceConfig;
import io.fabric8.openshift.api.model.machine.v1beta1.GCPShieldedInstanceConfigBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.GCPShieldedInstanceConfigFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.ResourceManagerTag;
import io.fabric8.openshift.api.model.machine.v1beta1.ResourceManagerTagBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.ResourceManagerTagFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class GCPMachineProviderSpecFluent<A extends GCPMachineProviderSpecFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private Boolean canIPForward;
    private String confidentialCompute;
    private LocalObjectReferenceBuilder credentialsSecret;
    private Boolean deletionProtection;
    private ArrayList<GCPDiskBuilder> disks = new ArrayList();
    private ArrayList<GCPMetadataBuilder> gcpMetadata = new ArrayList();
    private ArrayList<GCPGPUConfigBuilder> gpus = new ArrayList();
    private String kind;
    private Map<String, String> labels;
    private String machineType;
    private ObjectMetaBuilder metadata;
    private ArrayList<GCPNetworkInterfaceBuilder> networkInterfaces = new ArrayList();
    private String onHostMaintenance;
    private Boolean preemptible;
    private String projectID;
    private String region;
    private ArrayList<ResourceManagerTagBuilder> resourceManagerTags = new ArrayList();
    private String restartPolicy;
    private ArrayList<GCPServiceAccountBuilder> serviceAccounts = new ArrayList();
    private GCPShieldedInstanceConfigBuilder shieldedInstanceConfig;
    private List<String> tags = new ArrayList<String>();
    private List<String> targetPools = new ArrayList<String>();
    private LocalObjectReferenceBuilder userDataSecret;
    private String zone;
    private Map<String, Object> additionalProperties;

    public GCPMachineProviderSpecFluent() {
    }

    public GCPMachineProviderSpecFluent(GCPMachineProviderSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GCPMachineProviderSpec instance) {
        GCPMachineProviderSpec gCPMachineProviderSpec = instance = instance != null ? instance : new GCPMachineProviderSpec();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withCanIPForward(instance.getCanIPForward());
            this.withConfidentialCompute(instance.getConfidentialCompute());
            this.withCredentialsSecret(instance.getCredentialsSecret());
            this.withDeletionProtection(instance.getDeletionProtection());
            this.withDisks(instance.getDisks());
            this.withGcpMetadata(instance.getGcpMetadata());
            this.withGpus(instance.getGpus());
            this.withKind(instance.getKind());
            this.withLabels(instance.getLabels());
            this.withMachineType(instance.getMachineType());
            this.withMetadata(instance.getMetadata());
            this.withNetworkInterfaces(instance.getNetworkInterfaces());
            this.withOnHostMaintenance(instance.getOnHostMaintenance());
            this.withPreemptible(instance.getPreemptible());
            this.withProjectID(instance.getProjectID());
            this.withRegion(instance.getRegion());
            this.withResourceManagerTags(instance.getResourceManagerTags());
            this.withRestartPolicy(instance.getRestartPolicy());
            this.withServiceAccounts(instance.getServiceAccounts());
            this.withShieldedInstanceConfig(instance.getShieldedInstanceConfig());
            this.withTags(instance.getTags());
            this.withTargetPools(instance.getTargetPools());
            this.withUserDataSecret(instance.getUserDataSecret());
            this.withZone(instance.getZone());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public Boolean getCanIPForward() {
        return this.canIPForward;
    }

    public A withCanIPForward(Boolean canIPForward) {
        this.canIPForward = canIPForward;
        return (A)((Object)this);
    }

    public boolean hasCanIPForward() {
        return this.canIPForward != null;
    }

    public String getConfidentialCompute() {
        return this.confidentialCompute;
    }

    public A withConfidentialCompute(String confidentialCompute) {
        this.confidentialCompute = confidentialCompute;
        return (A)((Object)this);
    }

    public boolean hasConfidentialCompute() {
        return this.confidentialCompute != null;
    }

    public LocalObjectReference buildCredentialsSecret() {
        return this.credentialsSecret != null ? this.credentialsSecret.build() : null;
    }

    public A withCredentialsSecret(LocalObjectReference credentialsSecret) {
        this._visitables.remove((Object)"credentialsSecret");
        if (credentialsSecret != null) {
            this.credentialsSecret = new LocalObjectReferenceBuilder(credentialsSecret);
            this._visitables.get((Object)"credentialsSecret").add(this.credentialsSecret);
        } else {
            this.credentialsSecret = null;
            this._visitables.get((Object)"credentialsSecret").remove(this.credentialsSecret);
        }
        return (A)((Object)this);
    }

    public boolean hasCredentialsSecret() {
        return this.credentialsSecret != null;
    }

    public A withNewCredentialsSecret(String name) {
        return this.withCredentialsSecret(new LocalObjectReference(name));
    }

    public CredentialsSecretNested<A> withNewCredentialsSecret() {
        return new CredentialsSecretNested(null);
    }

    public CredentialsSecretNested<A> withNewCredentialsSecretLike(LocalObjectReference item) {
        return new CredentialsSecretNested(item);
    }

    public CredentialsSecretNested<A> editCredentialsSecret() {
        return this.withNewCredentialsSecretLike(Optional.ofNullable(this.buildCredentialsSecret()).orElse(null));
    }

    public CredentialsSecretNested<A> editOrNewCredentialsSecret() {
        return this.withNewCredentialsSecretLike(Optional.ofNullable(this.buildCredentialsSecret()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public CredentialsSecretNested<A> editOrNewCredentialsSecretLike(LocalObjectReference item) {
        return this.withNewCredentialsSecretLike(Optional.ofNullable(this.buildCredentialsSecret()).orElse(item));
    }

    public Boolean getDeletionProtection() {
        return this.deletionProtection;
    }

    public A withDeletionProtection(Boolean deletionProtection) {
        this.deletionProtection = deletionProtection;
        return (A)((Object)this);
    }

    public boolean hasDeletionProtection() {
        return this.deletionProtection != null;
    }

    public A addToDisks(int index, GCPDisk item) {
        if (this.disks == null) {
            this.disks = new ArrayList();
        }
        GCPDiskBuilder builder = new GCPDiskBuilder(item);
        if (index < 0 || index >= this.disks.size()) {
            this._visitables.get((Object)"disks").add(builder);
            this.disks.add(builder);
        } else {
            this._visitables.get((Object)"disks").add(index, builder);
            this.disks.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToDisks(int index, GCPDisk item) {
        if (this.disks == null) {
            this.disks = new ArrayList();
        }
        GCPDiskBuilder builder = new GCPDiskBuilder(item);
        if (index < 0 || index >= this.disks.size()) {
            this._visitables.get((Object)"disks").add(builder);
            this.disks.add(builder);
        } else {
            this._visitables.get((Object)"disks").set(index, builder);
            this.disks.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToDisks(GCPDisk ... items) {
        if (this.disks == null) {
            this.disks = new ArrayList();
        }
        for (GCPDisk item : items) {
            GCPDiskBuilder builder = new GCPDiskBuilder(item);
            this._visitables.get((Object)"disks").add(builder);
            this.disks.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToDisks(Collection<GCPDisk> items) {
        if (this.disks == null) {
            this.disks = new ArrayList();
        }
        for (GCPDisk item : items) {
            GCPDiskBuilder builder = new GCPDiskBuilder(item);
            this._visitables.get((Object)"disks").add(builder);
            this.disks.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromDisks(GCPDisk ... items) {
        if (this.disks == null) {
            return (A)((Object)this);
        }
        for (GCPDisk item : items) {
            GCPDiskBuilder builder = new GCPDiskBuilder(item);
            this._visitables.get((Object)"disks").remove((Object)builder);
            this.disks.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDisks(Collection<GCPDisk> items) {
        if (this.disks == null) {
            return (A)((Object)this);
        }
        for (GCPDisk item : items) {
            GCPDiskBuilder builder = new GCPDiskBuilder(item);
            this._visitables.get((Object)"disks").remove((Object)builder);
            this.disks.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromDisks(Predicate<GCPDiskBuilder> predicate) {
        if (this.disks == null) {
            return (A)((Object)this);
        }
        Iterator<GCPDiskBuilder> each = this.disks.iterator();
        List visitables = this._visitables.get((Object)"disks");
        while (each.hasNext()) {
            GCPDiskBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<GCPDisk> buildDisks() {
        return this.disks != null ? GCPMachineProviderSpecFluent.build(this.disks) : null;
    }

    public GCPDisk buildDisk(int index) {
        return this.disks.get(index).build();
    }

    public GCPDisk buildFirstDisk() {
        return this.disks.get(0).build();
    }

    public GCPDisk buildLastDisk() {
        return this.disks.get(this.disks.size() - 1).build();
    }

    public GCPDisk buildMatchingDisk(Predicate<GCPDiskBuilder> predicate) {
        for (GCPDiskBuilder item : this.disks) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDisk(Predicate<GCPDiskBuilder> predicate) {
        for (GCPDiskBuilder item : this.disks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDisks(List<GCPDisk> disks) {
        if (this.disks != null) {
            this._visitables.get((Object)"disks").clear();
        }
        if (disks != null) {
            this.disks = new ArrayList();
            for (GCPDisk item : disks) {
                this.addToDisks(item);
            }
        } else {
            this.disks = null;
        }
        return (A)((Object)this);
    }

    public A withDisks(GCPDisk ... disks) {
        if (this.disks != null) {
            this.disks.clear();
            this._visitables.remove((Object)"disks");
        }
        if (disks != null) {
            for (GCPDisk item : disks) {
                this.addToDisks(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDisks() {
        return this.disks != null && !this.disks.isEmpty();
    }

    public DisksNested<A> addNewDisk() {
        return new DisksNested(-1, null);
    }

    public DisksNested<A> addNewDiskLike(GCPDisk item) {
        return new DisksNested(-1, item);
    }

    public DisksNested<A> setNewDiskLike(int index, GCPDisk item) {
        return new DisksNested(index, item);
    }

    public DisksNested<A> editDisk(int index) {
        if (this.disks.size() <= index) {
            throw new RuntimeException("Can't edit disks. Index exceeds size.");
        }
        return this.setNewDiskLike(index, this.buildDisk(index));
    }

    public DisksNested<A> editFirstDisk() {
        if (this.disks.size() == 0) {
            throw new RuntimeException("Can't edit first disks. The list is empty.");
        }
        return this.setNewDiskLike(0, this.buildDisk(0));
    }

    public DisksNested<A> editLastDisk() {
        int index = this.disks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last disks. The list is empty.");
        }
        return this.setNewDiskLike(index, this.buildDisk(index));
    }

    public DisksNested<A> editMatchingDisk(Predicate<GCPDiskBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.disks.size(); ++i) {
            if (!predicate.test(this.disks.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching disks. No match found.");
        }
        return this.setNewDiskLike(index, this.buildDisk(index));
    }

    public A addToGcpMetadata(int index, GCPMetadata item) {
        if (this.gcpMetadata == null) {
            this.gcpMetadata = new ArrayList();
        }
        GCPMetadataBuilder builder = new GCPMetadataBuilder(item);
        if (index < 0 || index >= this.gcpMetadata.size()) {
            this._visitables.get((Object)"gcpMetadata").add(builder);
            this.gcpMetadata.add(builder);
        } else {
            this._visitables.get((Object)"gcpMetadata").add(index, builder);
            this.gcpMetadata.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToGcpMetadata(int index, GCPMetadata item) {
        if (this.gcpMetadata == null) {
            this.gcpMetadata = new ArrayList();
        }
        GCPMetadataBuilder builder = new GCPMetadataBuilder(item);
        if (index < 0 || index >= this.gcpMetadata.size()) {
            this._visitables.get((Object)"gcpMetadata").add(builder);
            this.gcpMetadata.add(builder);
        } else {
            this._visitables.get((Object)"gcpMetadata").set(index, builder);
            this.gcpMetadata.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToGcpMetadata(GCPMetadata ... items) {
        if (this.gcpMetadata == null) {
            this.gcpMetadata = new ArrayList();
        }
        for (GCPMetadata item : items) {
            GCPMetadataBuilder builder = new GCPMetadataBuilder(item);
            this._visitables.get((Object)"gcpMetadata").add(builder);
            this.gcpMetadata.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToGcpMetadata(Collection<GCPMetadata> items) {
        if (this.gcpMetadata == null) {
            this.gcpMetadata = new ArrayList();
        }
        for (GCPMetadata item : items) {
            GCPMetadataBuilder builder = new GCPMetadataBuilder(item);
            this._visitables.get((Object)"gcpMetadata").add(builder);
            this.gcpMetadata.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromGcpMetadata(GCPMetadata ... items) {
        if (this.gcpMetadata == null) {
            return (A)((Object)this);
        }
        for (GCPMetadata item : items) {
            GCPMetadataBuilder builder = new GCPMetadataBuilder(item);
            this._visitables.get((Object)"gcpMetadata").remove((Object)builder);
            this.gcpMetadata.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromGcpMetadata(Collection<GCPMetadata> items) {
        if (this.gcpMetadata == null) {
            return (A)((Object)this);
        }
        for (GCPMetadata item : items) {
            GCPMetadataBuilder builder = new GCPMetadataBuilder(item);
            this._visitables.get((Object)"gcpMetadata").remove((Object)builder);
            this.gcpMetadata.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromGcpMetadata(Predicate<GCPMetadataBuilder> predicate) {
        if (this.gcpMetadata == null) {
            return (A)((Object)this);
        }
        Iterator<GCPMetadataBuilder> each = this.gcpMetadata.iterator();
        List visitables = this._visitables.get((Object)"gcpMetadata");
        while (each.hasNext()) {
            GCPMetadataBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<GCPMetadata> buildGcpMetadata() {
        return this.gcpMetadata != null ? GCPMachineProviderSpecFluent.build(this.gcpMetadata) : null;
    }

    public GCPMetadata buildGcpMetadatum(int index) {
        return this.gcpMetadata.get(index).build();
    }

    public GCPMetadata buildFirstGcpMetadatum() {
        return this.gcpMetadata.get(0).build();
    }

    public GCPMetadata buildLastGcpMetadatum() {
        return this.gcpMetadata.get(this.gcpMetadata.size() - 1).build();
    }

    public GCPMetadata buildMatchingGcpMetadatum(Predicate<GCPMetadataBuilder> predicate) {
        for (GCPMetadataBuilder item : this.gcpMetadata) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingGcpMetadatum(Predicate<GCPMetadataBuilder> predicate) {
        for (GCPMetadataBuilder item : this.gcpMetadata) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withGcpMetadata(List<GCPMetadata> gcpMetadata) {
        if (this.gcpMetadata != null) {
            this._visitables.get((Object)"gcpMetadata").clear();
        }
        if (gcpMetadata != null) {
            this.gcpMetadata = new ArrayList();
            for (GCPMetadata item : gcpMetadata) {
                this.addToGcpMetadata(item);
            }
        } else {
            this.gcpMetadata = null;
        }
        return (A)((Object)this);
    }

    public A withGcpMetadata(GCPMetadata ... gcpMetadata) {
        if (this.gcpMetadata != null) {
            this.gcpMetadata.clear();
            this._visitables.remove((Object)"gcpMetadata");
        }
        if (gcpMetadata != null) {
            for (GCPMetadata item : gcpMetadata) {
                this.addToGcpMetadata(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasGcpMetadata() {
        return this.gcpMetadata != null && !this.gcpMetadata.isEmpty();
    }

    public A addNewGcpMetadatum(String key, String value) {
        return this.addToGcpMetadata(new GCPMetadata(key, value));
    }

    public GcpMetadataNested<A> addNewGcpMetadatum() {
        return new GcpMetadataNested(-1, null);
    }

    public GcpMetadataNested<A> addNewGcpMetadatumLike(GCPMetadata item) {
        return new GcpMetadataNested(-1, item);
    }

    public GcpMetadataNested<A> setNewGcpMetadatumLike(int index, GCPMetadata item) {
        return new GcpMetadataNested(index, item);
    }

    public GcpMetadataNested<A> editGcpMetadatum(int index) {
        if (this.gcpMetadata.size() <= index) {
            throw new RuntimeException("Can't edit gcpMetadata. Index exceeds size.");
        }
        return this.setNewGcpMetadatumLike(index, this.buildGcpMetadatum(index));
    }

    public GcpMetadataNested<A> editFirstGcpMetadatum() {
        if (this.gcpMetadata.size() == 0) {
            throw new RuntimeException("Can't edit first gcpMetadata. The list is empty.");
        }
        return this.setNewGcpMetadatumLike(0, this.buildGcpMetadatum(0));
    }

    public GcpMetadataNested<A> editLastGcpMetadatum() {
        int index = this.gcpMetadata.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last gcpMetadata. The list is empty.");
        }
        return this.setNewGcpMetadatumLike(index, this.buildGcpMetadatum(index));
    }

    public GcpMetadataNested<A> editMatchingGcpMetadatum(Predicate<GCPMetadataBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.gcpMetadata.size(); ++i) {
            if (!predicate.test(this.gcpMetadata.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching gcpMetadata. No match found.");
        }
        return this.setNewGcpMetadatumLike(index, this.buildGcpMetadatum(index));
    }

    public A addToGpus(int index, GCPGPUConfig item) {
        if (this.gpus == null) {
            this.gpus = new ArrayList();
        }
        GCPGPUConfigBuilder builder = new GCPGPUConfigBuilder(item);
        if (index < 0 || index >= this.gpus.size()) {
            this._visitables.get((Object)"gpus").add(builder);
            this.gpus.add(builder);
        } else {
            this._visitables.get((Object)"gpus").add(index, builder);
            this.gpus.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToGpus(int index, GCPGPUConfig item) {
        if (this.gpus == null) {
            this.gpus = new ArrayList();
        }
        GCPGPUConfigBuilder builder = new GCPGPUConfigBuilder(item);
        if (index < 0 || index >= this.gpus.size()) {
            this._visitables.get((Object)"gpus").add(builder);
            this.gpus.add(builder);
        } else {
            this._visitables.get((Object)"gpus").set(index, builder);
            this.gpus.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToGpus(GCPGPUConfig ... items) {
        if (this.gpus == null) {
            this.gpus = new ArrayList();
        }
        for (GCPGPUConfig item : items) {
            GCPGPUConfigBuilder builder = new GCPGPUConfigBuilder(item);
            this._visitables.get((Object)"gpus").add(builder);
            this.gpus.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToGpus(Collection<GCPGPUConfig> items) {
        if (this.gpus == null) {
            this.gpus = new ArrayList();
        }
        for (GCPGPUConfig item : items) {
            GCPGPUConfigBuilder builder = new GCPGPUConfigBuilder(item);
            this._visitables.get((Object)"gpus").add(builder);
            this.gpus.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromGpus(GCPGPUConfig ... items) {
        if (this.gpus == null) {
            return (A)((Object)this);
        }
        for (GCPGPUConfig item : items) {
            GCPGPUConfigBuilder builder = new GCPGPUConfigBuilder(item);
            this._visitables.get((Object)"gpus").remove((Object)builder);
            this.gpus.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromGpus(Collection<GCPGPUConfig> items) {
        if (this.gpus == null) {
            return (A)((Object)this);
        }
        for (GCPGPUConfig item : items) {
            GCPGPUConfigBuilder builder = new GCPGPUConfigBuilder(item);
            this._visitables.get((Object)"gpus").remove((Object)builder);
            this.gpus.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromGpus(Predicate<GCPGPUConfigBuilder> predicate) {
        if (this.gpus == null) {
            return (A)((Object)this);
        }
        Iterator<GCPGPUConfigBuilder> each = this.gpus.iterator();
        List visitables = this._visitables.get((Object)"gpus");
        while (each.hasNext()) {
            GCPGPUConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<GCPGPUConfig> buildGpus() {
        return this.gpus != null ? GCPMachineProviderSpecFluent.build(this.gpus) : null;
    }

    public GCPGPUConfig buildGpus(int index) {
        return this.gpus.get(index).build();
    }

    public GCPGPUConfig buildFirstGpus() {
        return this.gpus.get(0).build();
    }

    public GCPGPUConfig buildLastGpus() {
        return this.gpus.get(this.gpus.size() - 1).build();
    }

    public GCPGPUConfig buildMatchingGpus(Predicate<GCPGPUConfigBuilder> predicate) {
        for (GCPGPUConfigBuilder item : this.gpus) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingGpus(Predicate<GCPGPUConfigBuilder> predicate) {
        for (GCPGPUConfigBuilder item : this.gpus) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withGpus(List<GCPGPUConfig> gpus) {
        if (this.gpus != null) {
            this._visitables.get((Object)"gpus").clear();
        }
        if (gpus != null) {
            this.gpus = new ArrayList();
            for (GCPGPUConfig item : gpus) {
                this.addToGpus(item);
            }
        } else {
            this.gpus = null;
        }
        return (A)((Object)this);
    }

    public A withGpus(GCPGPUConfig ... gpus) {
        if (this.gpus != null) {
            this.gpus.clear();
            this._visitables.remove((Object)"gpus");
        }
        if (gpus != null) {
            for (GCPGPUConfig item : gpus) {
                this.addToGpus(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasGpus() {
        return this.gpus != null && !this.gpus.isEmpty();
    }

    public A addNewGpus(Integer count, String type) {
        return this.addToGpus(new GCPGPUConfig(count, type));
    }

    public GpusNested<A> addNewGpus() {
        return new GpusNested(-1, null);
    }

    public GpusNested<A> addNewGpusLike(GCPGPUConfig item) {
        return new GpusNested(-1, item);
    }

    public GpusNested<A> setNewGpusLike(int index, GCPGPUConfig item) {
        return new GpusNested(index, item);
    }

    public GpusNested<A> editGpus(int index) {
        if (this.gpus.size() <= index) {
            throw new RuntimeException("Can't edit gpus. Index exceeds size.");
        }
        return this.setNewGpusLike(index, this.buildGpus(index));
    }

    public GpusNested<A> editFirstGpus() {
        if (this.gpus.size() == 0) {
            throw new RuntimeException("Can't edit first gpus. The list is empty.");
        }
        return this.setNewGpusLike(0, this.buildGpus(0));
    }

    public GpusNested<A> editLastGpus() {
        int index = this.gpus.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last gpus. The list is empty.");
        }
        return this.setNewGpusLike(index, this.buildGpus(index));
    }

    public GpusNested<A> editMatchingGpus(Predicate<GCPGPUConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.gpus.size(); ++i) {
            if (!predicate.test(this.gpus.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching gpus. No match found.");
        }
        return this.setNewGpusLike(index, this.buildGpus(index));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)((Object)this);
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public <K, V> A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)((Object)this);
    }

    public boolean hasLabels() {
        return this.labels != null;
    }

    public String getMachineType() {
        return this.machineType;
    }

    public A withMachineType(String machineType) {
        this.machineType = machineType;
        return (A)((Object)this);
    }

    public boolean hasMachineType() {
        return this.machineType != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove((Object)"metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)((Object)this);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public A addToNetworkInterfaces(int index, GCPNetworkInterface item) {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new ArrayList();
        }
        GCPNetworkInterfaceBuilder builder = new GCPNetworkInterfaceBuilder(item);
        if (index < 0 || index >= this.networkInterfaces.size()) {
            this._visitables.get((Object)"networkInterfaces").add(builder);
            this.networkInterfaces.add(builder);
        } else {
            this._visitables.get((Object)"networkInterfaces").add(index, builder);
            this.networkInterfaces.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToNetworkInterfaces(int index, GCPNetworkInterface item) {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new ArrayList();
        }
        GCPNetworkInterfaceBuilder builder = new GCPNetworkInterfaceBuilder(item);
        if (index < 0 || index >= this.networkInterfaces.size()) {
            this._visitables.get((Object)"networkInterfaces").add(builder);
            this.networkInterfaces.add(builder);
        } else {
            this._visitables.get((Object)"networkInterfaces").set(index, builder);
            this.networkInterfaces.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToNetworkInterfaces(GCPNetworkInterface ... items) {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new ArrayList();
        }
        for (GCPNetworkInterface item : items) {
            GCPNetworkInterfaceBuilder builder = new GCPNetworkInterfaceBuilder(item);
            this._visitables.get((Object)"networkInterfaces").add(builder);
            this.networkInterfaces.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToNetworkInterfaces(Collection<GCPNetworkInterface> items) {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new ArrayList();
        }
        for (GCPNetworkInterface item : items) {
            GCPNetworkInterfaceBuilder builder = new GCPNetworkInterfaceBuilder(item);
            this._visitables.get((Object)"networkInterfaces").add(builder);
            this.networkInterfaces.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromNetworkInterfaces(GCPNetworkInterface ... items) {
        if (this.networkInterfaces == null) {
            return (A)((Object)this);
        }
        for (GCPNetworkInterface item : items) {
            GCPNetworkInterfaceBuilder builder = new GCPNetworkInterfaceBuilder(item);
            this._visitables.get((Object)"networkInterfaces").remove((Object)builder);
            this.networkInterfaces.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromNetworkInterfaces(Collection<GCPNetworkInterface> items) {
        if (this.networkInterfaces == null) {
            return (A)((Object)this);
        }
        for (GCPNetworkInterface item : items) {
            GCPNetworkInterfaceBuilder builder = new GCPNetworkInterfaceBuilder(item);
            this._visitables.get((Object)"networkInterfaces").remove((Object)builder);
            this.networkInterfaces.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromNetworkInterfaces(Predicate<GCPNetworkInterfaceBuilder> predicate) {
        if (this.networkInterfaces == null) {
            return (A)((Object)this);
        }
        Iterator<GCPNetworkInterfaceBuilder> each = this.networkInterfaces.iterator();
        List visitables = this._visitables.get((Object)"networkInterfaces");
        while (each.hasNext()) {
            GCPNetworkInterfaceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<GCPNetworkInterface> buildNetworkInterfaces() {
        return this.networkInterfaces != null ? GCPMachineProviderSpecFluent.build(this.networkInterfaces) : null;
    }

    public GCPNetworkInterface buildNetworkInterface(int index) {
        return this.networkInterfaces.get(index).build();
    }

    public GCPNetworkInterface buildFirstNetworkInterface() {
        return this.networkInterfaces.get(0).build();
    }

    public GCPNetworkInterface buildLastNetworkInterface() {
        return this.networkInterfaces.get(this.networkInterfaces.size() - 1).build();
    }

    public GCPNetworkInterface buildMatchingNetworkInterface(Predicate<GCPNetworkInterfaceBuilder> predicate) {
        for (GCPNetworkInterfaceBuilder item : this.networkInterfaces) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingNetworkInterface(Predicate<GCPNetworkInterfaceBuilder> predicate) {
        for (GCPNetworkInterfaceBuilder item : this.networkInterfaces) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNetworkInterfaces(List<GCPNetworkInterface> networkInterfaces) {
        if (this.networkInterfaces != null) {
            this._visitables.get((Object)"networkInterfaces").clear();
        }
        if (networkInterfaces != null) {
            this.networkInterfaces = new ArrayList();
            for (GCPNetworkInterface item : networkInterfaces) {
                this.addToNetworkInterfaces(item);
            }
        } else {
            this.networkInterfaces = null;
        }
        return (A)((Object)this);
    }

    public A withNetworkInterfaces(GCPNetworkInterface ... networkInterfaces) {
        if (this.networkInterfaces != null) {
            this.networkInterfaces.clear();
            this._visitables.remove((Object)"networkInterfaces");
        }
        if (networkInterfaces != null) {
            for (GCPNetworkInterface item : networkInterfaces) {
                this.addToNetworkInterfaces(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasNetworkInterfaces() {
        return this.networkInterfaces != null && !this.networkInterfaces.isEmpty();
    }

    public A addNewNetworkInterface(String network, String projectID, Boolean publicIP, String subnetwork) {
        return this.addToNetworkInterfaces(new GCPNetworkInterface(network, projectID, publicIP, subnetwork));
    }

    public NetworkInterfacesNested<A> addNewNetworkInterface() {
        return new NetworkInterfacesNested(-1, null);
    }

    public NetworkInterfacesNested<A> addNewNetworkInterfaceLike(GCPNetworkInterface item) {
        return new NetworkInterfacesNested(-1, item);
    }

    public NetworkInterfacesNested<A> setNewNetworkInterfaceLike(int index, GCPNetworkInterface item) {
        return new NetworkInterfacesNested(index, item);
    }

    public NetworkInterfacesNested<A> editNetworkInterface(int index) {
        if (this.networkInterfaces.size() <= index) {
            throw new RuntimeException("Can't edit networkInterfaces. Index exceeds size.");
        }
        return this.setNewNetworkInterfaceLike(index, this.buildNetworkInterface(index));
    }

    public NetworkInterfacesNested<A> editFirstNetworkInterface() {
        if (this.networkInterfaces.size() == 0) {
            throw new RuntimeException("Can't edit first networkInterfaces. The list is empty.");
        }
        return this.setNewNetworkInterfaceLike(0, this.buildNetworkInterface(0));
    }

    public NetworkInterfacesNested<A> editLastNetworkInterface() {
        int index = this.networkInterfaces.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last networkInterfaces. The list is empty.");
        }
        return this.setNewNetworkInterfaceLike(index, this.buildNetworkInterface(index));
    }

    public NetworkInterfacesNested<A> editMatchingNetworkInterface(Predicate<GCPNetworkInterfaceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.networkInterfaces.size(); ++i) {
            if (!predicate.test(this.networkInterfaces.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching networkInterfaces. No match found.");
        }
        return this.setNewNetworkInterfaceLike(index, this.buildNetworkInterface(index));
    }

    public String getOnHostMaintenance() {
        return this.onHostMaintenance;
    }

    public A withOnHostMaintenance(String onHostMaintenance) {
        this.onHostMaintenance = onHostMaintenance;
        return (A)((Object)this);
    }

    public boolean hasOnHostMaintenance() {
        return this.onHostMaintenance != null;
    }

    public Boolean getPreemptible() {
        return this.preemptible;
    }

    public A withPreemptible(Boolean preemptible) {
        this.preemptible = preemptible;
        return (A)((Object)this);
    }

    public boolean hasPreemptible() {
        return this.preemptible != null;
    }

    public String getProjectID() {
        return this.projectID;
    }

    public A withProjectID(String projectID) {
        this.projectID = projectID;
        return (A)((Object)this);
    }

    public boolean hasProjectID() {
        return this.projectID != null;
    }

    public String getRegion() {
        return this.region;
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)((Object)this);
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public A addToResourceManagerTags(int index, ResourceManagerTag item) {
        if (this.resourceManagerTags == null) {
            this.resourceManagerTags = new ArrayList();
        }
        ResourceManagerTagBuilder builder = new ResourceManagerTagBuilder(item);
        if (index < 0 || index >= this.resourceManagerTags.size()) {
            this._visitables.get((Object)"resourceManagerTags").add(builder);
            this.resourceManagerTags.add(builder);
        } else {
            this._visitables.get((Object)"resourceManagerTags").add(index, builder);
            this.resourceManagerTags.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToResourceManagerTags(int index, ResourceManagerTag item) {
        if (this.resourceManagerTags == null) {
            this.resourceManagerTags = new ArrayList();
        }
        ResourceManagerTagBuilder builder = new ResourceManagerTagBuilder(item);
        if (index < 0 || index >= this.resourceManagerTags.size()) {
            this._visitables.get((Object)"resourceManagerTags").add(builder);
            this.resourceManagerTags.add(builder);
        } else {
            this._visitables.get((Object)"resourceManagerTags").set(index, builder);
            this.resourceManagerTags.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToResourceManagerTags(ResourceManagerTag ... items) {
        if (this.resourceManagerTags == null) {
            this.resourceManagerTags = new ArrayList();
        }
        for (ResourceManagerTag item : items) {
            ResourceManagerTagBuilder builder = new ResourceManagerTagBuilder(item);
            this._visitables.get((Object)"resourceManagerTags").add(builder);
            this.resourceManagerTags.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToResourceManagerTags(Collection<ResourceManagerTag> items) {
        if (this.resourceManagerTags == null) {
            this.resourceManagerTags = new ArrayList();
        }
        for (ResourceManagerTag item : items) {
            ResourceManagerTagBuilder builder = new ResourceManagerTagBuilder(item);
            this._visitables.get((Object)"resourceManagerTags").add(builder);
            this.resourceManagerTags.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromResourceManagerTags(ResourceManagerTag ... items) {
        if (this.resourceManagerTags == null) {
            return (A)((Object)this);
        }
        for (ResourceManagerTag item : items) {
            ResourceManagerTagBuilder builder = new ResourceManagerTagBuilder(item);
            this._visitables.get((Object)"resourceManagerTags").remove((Object)builder);
            this.resourceManagerTags.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromResourceManagerTags(Collection<ResourceManagerTag> items) {
        if (this.resourceManagerTags == null) {
            return (A)((Object)this);
        }
        for (ResourceManagerTag item : items) {
            ResourceManagerTagBuilder builder = new ResourceManagerTagBuilder(item);
            this._visitables.get((Object)"resourceManagerTags").remove((Object)builder);
            this.resourceManagerTags.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromResourceManagerTags(Predicate<ResourceManagerTagBuilder> predicate) {
        if (this.resourceManagerTags == null) {
            return (A)((Object)this);
        }
        Iterator<ResourceManagerTagBuilder> each = this.resourceManagerTags.iterator();
        List visitables = this._visitables.get((Object)"resourceManagerTags");
        while (each.hasNext()) {
            ResourceManagerTagBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ResourceManagerTag> buildResourceManagerTags() {
        return this.resourceManagerTags != null ? GCPMachineProviderSpecFluent.build(this.resourceManagerTags) : null;
    }

    public ResourceManagerTag buildResourceManagerTag(int index) {
        return this.resourceManagerTags.get(index).build();
    }

    public ResourceManagerTag buildFirstResourceManagerTag() {
        return this.resourceManagerTags.get(0).build();
    }

    public ResourceManagerTag buildLastResourceManagerTag() {
        return this.resourceManagerTags.get(this.resourceManagerTags.size() - 1).build();
    }

    public ResourceManagerTag buildMatchingResourceManagerTag(Predicate<ResourceManagerTagBuilder> predicate) {
        for (ResourceManagerTagBuilder item : this.resourceManagerTags) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResourceManagerTag(Predicate<ResourceManagerTagBuilder> predicate) {
        for (ResourceManagerTagBuilder item : this.resourceManagerTags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResourceManagerTags(List<ResourceManagerTag> resourceManagerTags) {
        if (this.resourceManagerTags != null) {
            this._visitables.get((Object)"resourceManagerTags").clear();
        }
        if (resourceManagerTags != null) {
            this.resourceManagerTags = new ArrayList();
            for (ResourceManagerTag item : resourceManagerTags) {
                this.addToResourceManagerTags(item);
            }
        } else {
            this.resourceManagerTags = null;
        }
        return (A)((Object)this);
    }

    public A withResourceManagerTags(ResourceManagerTag ... resourceManagerTags) {
        if (this.resourceManagerTags != null) {
            this.resourceManagerTags.clear();
            this._visitables.remove((Object)"resourceManagerTags");
        }
        if (resourceManagerTags != null) {
            for (ResourceManagerTag item : resourceManagerTags) {
                this.addToResourceManagerTags(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasResourceManagerTags() {
        return this.resourceManagerTags != null && !this.resourceManagerTags.isEmpty();
    }

    public A addNewResourceManagerTag(String key, String parentID, String value) {
        return this.addToResourceManagerTags(new ResourceManagerTag(key, parentID, value));
    }

    public ResourceManagerTagsNested<A> addNewResourceManagerTag() {
        return new ResourceManagerTagsNested(-1, null);
    }

    public ResourceManagerTagsNested<A> addNewResourceManagerTagLike(ResourceManagerTag item) {
        return new ResourceManagerTagsNested(-1, item);
    }

    public ResourceManagerTagsNested<A> setNewResourceManagerTagLike(int index, ResourceManagerTag item) {
        return new ResourceManagerTagsNested(index, item);
    }

    public ResourceManagerTagsNested<A> editResourceManagerTag(int index) {
        if (this.resourceManagerTags.size() <= index) {
            throw new RuntimeException("Can't edit resourceManagerTags. Index exceeds size.");
        }
        return this.setNewResourceManagerTagLike(index, this.buildResourceManagerTag(index));
    }

    public ResourceManagerTagsNested<A> editFirstResourceManagerTag() {
        if (this.resourceManagerTags.size() == 0) {
            throw new RuntimeException("Can't edit first resourceManagerTags. The list is empty.");
        }
        return this.setNewResourceManagerTagLike(0, this.buildResourceManagerTag(0));
    }

    public ResourceManagerTagsNested<A> editLastResourceManagerTag() {
        int index = this.resourceManagerTags.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resourceManagerTags. The list is empty.");
        }
        return this.setNewResourceManagerTagLike(index, this.buildResourceManagerTag(index));
    }

    public ResourceManagerTagsNested<A> editMatchingResourceManagerTag(Predicate<ResourceManagerTagBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resourceManagerTags.size(); ++i) {
            if (!predicate.test(this.resourceManagerTags.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resourceManagerTags. No match found.");
        }
        return this.setNewResourceManagerTagLike(index, this.buildResourceManagerTag(index));
    }

    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public A withRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return (A)((Object)this);
    }

    public boolean hasRestartPolicy() {
        return this.restartPolicy != null;
    }

    public A addToServiceAccounts(int index, GCPServiceAccount item) {
        if (this.serviceAccounts == null) {
            this.serviceAccounts = new ArrayList();
        }
        GCPServiceAccountBuilder builder = new GCPServiceAccountBuilder(item);
        if (index < 0 || index >= this.serviceAccounts.size()) {
            this._visitables.get((Object)"serviceAccounts").add(builder);
            this.serviceAccounts.add(builder);
        } else {
            this._visitables.get((Object)"serviceAccounts").add(index, builder);
            this.serviceAccounts.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToServiceAccounts(int index, GCPServiceAccount item) {
        if (this.serviceAccounts == null) {
            this.serviceAccounts = new ArrayList();
        }
        GCPServiceAccountBuilder builder = new GCPServiceAccountBuilder(item);
        if (index < 0 || index >= this.serviceAccounts.size()) {
            this._visitables.get((Object)"serviceAccounts").add(builder);
            this.serviceAccounts.add(builder);
        } else {
            this._visitables.get((Object)"serviceAccounts").set(index, builder);
            this.serviceAccounts.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToServiceAccounts(GCPServiceAccount ... items) {
        if (this.serviceAccounts == null) {
            this.serviceAccounts = new ArrayList();
        }
        for (GCPServiceAccount item : items) {
            GCPServiceAccountBuilder builder = new GCPServiceAccountBuilder(item);
            this._visitables.get((Object)"serviceAccounts").add(builder);
            this.serviceAccounts.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToServiceAccounts(Collection<GCPServiceAccount> items) {
        if (this.serviceAccounts == null) {
            this.serviceAccounts = new ArrayList();
        }
        for (GCPServiceAccount item : items) {
            GCPServiceAccountBuilder builder = new GCPServiceAccountBuilder(item);
            this._visitables.get((Object)"serviceAccounts").add(builder);
            this.serviceAccounts.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromServiceAccounts(GCPServiceAccount ... items) {
        if (this.serviceAccounts == null) {
            return (A)((Object)this);
        }
        for (GCPServiceAccount item : items) {
            GCPServiceAccountBuilder builder = new GCPServiceAccountBuilder(item);
            this._visitables.get((Object)"serviceAccounts").remove((Object)builder);
            this.serviceAccounts.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromServiceAccounts(Collection<GCPServiceAccount> items) {
        if (this.serviceAccounts == null) {
            return (A)((Object)this);
        }
        for (GCPServiceAccount item : items) {
            GCPServiceAccountBuilder builder = new GCPServiceAccountBuilder(item);
            this._visitables.get((Object)"serviceAccounts").remove((Object)builder);
            this.serviceAccounts.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromServiceAccounts(Predicate<GCPServiceAccountBuilder> predicate) {
        if (this.serviceAccounts == null) {
            return (A)((Object)this);
        }
        Iterator<GCPServiceAccountBuilder> each = this.serviceAccounts.iterator();
        List visitables = this._visitables.get((Object)"serviceAccounts");
        while (each.hasNext()) {
            GCPServiceAccountBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<GCPServiceAccount> buildServiceAccounts() {
        return this.serviceAccounts != null ? GCPMachineProviderSpecFluent.build(this.serviceAccounts) : null;
    }

    public GCPServiceAccount buildServiceAccount(int index) {
        return this.serviceAccounts.get(index).build();
    }

    public GCPServiceAccount buildFirstServiceAccount() {
        return this.serviceAccounts.get(0).build();
    }

    public GCPServiceAccount buildLastServiceAccount() {
        return this.serviceAccounts.get(this.serviceAccounts.size() - 1).build();
    }

    public GCPServiceAccount buildMatchingServiceAccount(Predicate<GCPServiceAccountBuilder> predicate) {
        for (GCPServiceAccountBuilder item : this.serviceAccounts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingServiceAccount(Predicate<GCPServiceAccountBuilder> predicate) {
        for (GCPServiceAccountBuilder item : this.serviceAccounts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withServiceAccounts(List<GCPServiceAccount> serviceAccounts) {
        if (this.serviceAccounts != null) {
            this._visitables.get((Object)"serviceAccounts").clear();
        }
        if (serviceAccounts != null) {
            this.serviceAccounts = new ArrayList();
            for (GCPServiceAccount item : serviceAccounts) {
                this.addToServiceAccounts(item);
            }
        } else {
            this.serviceAccounts = null;
        }
        return (A)((Object)this);
    }

    public A withServiceAccounts(GCPServiceAccount ... serviceAccounts) {
        if (this.serviceAccounts != null) {
            this.serviceAccounts.clear();
            this._visitables.remove((Object)"serviceAccounts");
        }
        if (serviceAccounts != null) {
            for (GCPServiceAccount item : serviceAccounts) {
                this.addToServiceAccounts(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasServiceAccounts() {
        return this.serviceAccounts != null && !this.serviceAccounts.isEmpty();
    }

    public ServiceAccountsNested<A> addNewServiceAccount() {
        return new ServiceAccountsNested(-1, null);
    }

    public ServiceAccountsNested<A> addNewServiceAccountLike(GCPServiceAccount item) {
        return new ServiceAccountsNested(-1, item);
    }

    public ServiceAccountsNested<A> setNewServiceAccountLike(int index, GCPServiceAccount item) {
        return new ServiceAccountsNested(index, item);
    }

    public ServiceAccountsNested<A> editServiceAccount(int index) {
        if (this.serviceAccounts.size() <= index) {
            throw new RuntimeException("Can't edit serviceAccounts. Index exceeds size.");
        }
        return this.setNewServiceAccountLike(index, this.buildServiceAccount(index));
    }

    public ServiceAccountsNested<A> editFirstServiceAccount() {
        if (this.serviceAccounts.size() == 0) {
            throw new RuntimeException("Can't edit first serviceAccounts. The list is empty.");
        }
        return this.setNewServiceAccountLike(0, this.buildServiceAccount(0));
    }

    public ServiceAccountsNested<A> editLastServiceAccount() {
        int index = this.serviceAccounts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last serviceAccounts. The list is empty.");
        }
        return this.setNewServiceAccountLike(index, this.buildServiceAccount(index));
    }

    public ServiceAccountsNested<A> editMatchingServiceAccount(Predicate<GCPServiceAccountBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.serviceAccounts.size(); ++i) {
            if (!predicate.test(this.serviceAccounts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching serviceAccounts. No match found.");
        }
        return this.setNewServiceAccountLike(index, this.buildServiceAccount(index));
    }

    public GCPShieldedInstanceConfig buildShieldedInstanceConfig() {
        return this.shieldedInstanceConfig != null ? this.shieldedInstanceConfig.build() : null;
    }

    public A withShieldedInstanceConfig(GCPShieldedInstanceConfig shieldedInstanceConfig) {
        this._visitables.remove((Object)"shieldedInstanceConfig");
        if (shieldedInstanceConfig != null) {
            this.shieldedInstanceConfig = new GCPShieldedInstanceConfigBuilder(shieldedInstanceConfig);
            this._visitables.get((Object)"shieldedInstanceConfig").add(this.shieldedInstanceConfig);
        } else {
            this.shieldedInstanceConfig = null;
            this._visitables.get((Object)"shieldedInstanceConfig").remove((Object)this.shieldedInstanceConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasShieldedInstanceConfig() {
        return this.shieldedInstanceConfig != null;
    }

    public A withNewShieldedInstanceConfig(String integrityMonitoring, String secureBoot, String virtualizedTrustedPlatformModule) {
        return this.withShieldedInstanceConfig(new GCPShieldedInstanceConfig(integrityMonitoring, secureBoot, virtualizedTrustedPlatformModule));
    }

    public ShieldedInstanceConfigNested<A> withNewShieldedInstanceConfig() {
        return new ShieldedInstanceConfigNested(null);
    }

    public ShieldedInstanceConfigNested<A> withNewShieldedInstanceConfigLike(GCPShieldedInstanceConfig item) {
        return new ShieldedInstanceConfigNested(item);
    }

    public ShieldedInstanceConfigNested<A> editShieldedInstanceConfig() {
        return this.withNewShieldedInstanceConfigLike(Optional.ofNullable(this.buildShieldedInstanceConfig()).orElse(null));
    }

    public ShieldedInstanceConfigNested<A> editOrNewShieldedInstanceConfig() {
        return this.withNewShieldedInstanceConfigLike(Optional.ofNullable(this.buildShieldedInstanceConfig()).orElse(new GCPShieldedInstanceConfigBuilder().build()));
    }

    public ShieldedInstanceConfigNested<A> editOrNewShieldedInstanceConfigLike(GCPShieldedInstanceConfig item) {
        return this.withNewShieldedInstanceConfigLike(Optional.ofNullable(this.buildShieldedInstanceConfig()).orElse(item));
    }

    public A addToTags(int index, String item) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(index, item);
        return (A)((Object)this);
    }

    public A setToTags(int index, String item) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.set(index, item);
        return (A)((Object)this);
    }

    public A addToTags(String ... items) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        for (String item : items) {
            this.tags.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTags(Collection<String> items) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        for (String item : items) {
            this.tags.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTags(String ... items) {
        if (this.tags == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tags.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTags(Collection<String> items) {
        if (this.tags == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tags.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getTag(int index) {
        return this.tags.get(index);
    }

    public String getFirstTag() {
        return this.tags.get(0);
    }

    public String getLastTag() {
        return this.tags.get(this.tags.size() - 1);
    }

    public String getMatchingTag(Predicate<String> predicate) {
        for (String item : this.tags) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTag(Predicate<String> predicate) {
        for (String item : this.tags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTags(List<String> tags) {
        if (tags != null) {
            this.tags = new ArrayList<String>();
            for (String item : tags) {
                this.addToTags(item);
            }
        } else {
            this.tags = null;
        }
        return (A)((Object)this);
    }

    public A withTags(String ... tags) {
        if (this.tags != null) {
            this.tags.clear();
            this._visitables.remove((Object)"tags");
        }
        if (tags != null) {
            for (String item : tags) {
                this.addToTags(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    public A addToTargetPools(int index, String item) {
        if (this.targetPools == null) {
            this.targetPools = new ArrayList<String>();
        }
        this.targetPools.add(index, item);
        return (A)((Object)this);
    }

    public A setToTargetPools(int index, String item) {
        if (this.targetPools == null) {
            this.targetPools = new ArrayList<String>();
        }
        this.targetPools.set(index, item);
        return (A)((Object)this);
    }

    public A addToTargetPools(String ... items) {
        if (this.targetPools == null) {
            this.targetPools = new ArrayList<String>();
        }
        for (String item : items) {
            this.targetPools.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTargetPools(Collection<String> items) {
        if (this.targetPools == null) {
            this.targetPools = new ArrayList<String>();
        }
        for (String item : items) {
            this.targetPools.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTargetPools(String ... items) {
        if (this.targetPools == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.targetPools.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTargetPools(Collection<String> items) {
        if (this.targetPools == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.targetPools.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getTargetPools() {
        return this.targetPools;
    }

    public String getTargetPool(int index) {
        return this.targetPools.get(index);
    }

    public String getFirstTargetPool() {
        return this.targetPools.get(0);
    }

    public String getLastTargetPool() {
        return this.targetPools.get(this.targetPools.size() - 1);
    }

    public String getMatchingTargetPool(Predicate<String> predicate) {
        for (String item : this.targetPools) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTargetPool(Predicate<String> predicate) {
        for (String item : this.targetPools) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTargetPools(List<String> targetPools) {
        if (targetPools != null) {
            this.targetPools = new ArrayList<String>();
            for (String item : targetPools) {
                this.addToTargetPools(item);
            }
        } else {
            this.targetPools = null;
        }
        return (A)((Object)this);
    }

    public A withTargetPools(String ... targetPools) {
        if (this.targetPools != null) {
            this.targetPools.clear();
            this._visitables.remove((Object)"targetPools");
        }
        if (targetPools != null) {
            for (String item : targetPools) {
                this.addToTargetPools(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTargetPools() {
        return this.targetPools != null && !this.targetPools.isEmpty();
    }

    public LocalObjectReference buildUserDataSecret() {
        return this.userDataSecret != null ? this.userDataSecret.build() : null;
    }

    public A withUserDataSecret(LocalObjectReference userDataSecret) {
        this._visitables.remove((Object)"userDataSecret");
        if (userDataSecret != null) {
            this.userDataSecret = new LocalObjectReferenceBuilder(userDataSecret);
            this._visitables.get((Object)"userDataSecret").add(this.userDataSecret);
        } else {
            this.userDataSecret = null;
            this._visitables.get((Object)"userDataSecret").remove(this.userDataSecret);
        }
        return (A)((Object)this);
    }

    public boolean hasUserDataSecret() {
        return this.userDataSecret != null;
    }

    public A withNewUserDataSecret(String name) {
        return this.withUserDataSecret(new LocalObjectReference(name));
    }

    public UserDataSecretNested<A> withNewUserDataSecret() {
        return new UserDataSecretNested(null);
    }

    public UserDataSecretNested<A> withNewUserDataSecretLike(LocalObjectReference item) {
        return new UserDataSecretNested(item);
    }

    public UserDataSecretNested<A> editUserDataSecret() {
        return this.withNewUserDataSecretLike(Optional.ofNullable(this.buildUserDataSecret()).orElse(null));
    }

    public UserDataSecretNested<A> editOrNewUserDataSecret() {
        return this.withNewUserDataSecretLike(Optional.ofNullable(this.buildUserDataSecret()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public UserDataSecretNested<A> editOrNewUserDataSecretLike(LocalObjectReference item) {
        return this.withNewUserDataSecretLike(Optional.ofNullable(this.buildUserDataSecret()).orElse(item));
    }

    public String getZone() {
        return this.zone;
    }

    public A withZone(String zone) {
        this.zone = zone;
        return (A)((Object)this);
    }

    public boolean hasZone() {
        return this.zone != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GCPMachineProviderSpecFluent that = (GCPMachineProviderSpecFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.canIPForward, that.canIPForward)) {
            return false;
        }
        if (!Objects.equals(this.confidentialCompute, that.confidentialCompute)) {
            return false;
        }
        if (!Objects.equals(this.credentialsSecret, that.credentialsSecret)) {
            return false;
        }
        if (!Objects.equals(this.deletionProtection, that.deletionProtection)) {
            return false;
        }
        if (!Objects.equals(this.disks, that.disks)) {
            return false;
        }
        if (!Objects.equals(this.gcpMetadata, that.gcpMetadata)) {
            return false;
        }
        if (!Objects.equals(this.gpus, that.gpus)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.labels, that.labels)) {
            return false;
        }
        if (!Objects.equals(this.machineType, that.machineType)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.networkInterfaces, that.networkInterfaces)) {
            return false;
        }
        if (!Objects.equals(this.onHostMaintenance, that.onHostMaintenance)) {
            return false;
        }
        if (!Objects.equals(this.preemptible, that.preemptible)) {
            return false;
        }
        if (!Objects.equals(this.projectID, that.projectID)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.resourceManagerTags, that.resourceManagerTags)) {
            return false;
        }
        if (!Objects.equals(this.restartPolicy, that.restartPolicy)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccounts, that.serviceAccounts)) {
            return false;
        }
        if (!Objects.equals((Object)this.shieldedInstanceConfig, (Object)that.shieldedInstanceConfig)) {
            return false;
        }
        if (!Objects.equals(this.tags, that.tags)) {
            return false;
        }
        if (!Objects.equals(this.targetPools, that.targetPools)) {
            return false;
        }
        if (!Objects.equals(this.userDataSecret, that.userDataSecret)) {
            return false;
        }
        if (!Objects.equals(this.zone, that.zone)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiVersion, this.canIPForward, this.confidentialCompute, this.credentialsSecret, this.deletionProtection, this.disks, this.gcpMetadata, this.gpus, this.kind, this.labels, this.machineType, this.metadata, this.networkInterfaces, this.onHostMaintenance, this.preemptible, this.projectID, this.region, this.resourceManagerTags, this.restartPolicy, this.serviceAccounts, this.shieldedInstanceConfig, this.tags, this.targetPools, this.userDataSecret, this.zone, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.canIPForward != null) {
            sb.append("canIPForward:");
            sb.append(this.canIPForward + ",");
        }
        if (this.confidentialCompute != null) {
            sb.append("confidentialCompute:");
            sb.append(this.confidentialCompute + ",");
        }
        if (this.credentialsSecret != null) {
            sb.append("credentialsSecret:");
            sb.append(this.credentialsSecret + ",");
        }
        if (this.deletionProtection != null) {
            sb.append("deletionProtection:");
            sb.append(this.deletionProtection + ",");
        }
        if (this.disks != null && !this.disks.isEmpty()) {
            sb.append("disks:");
            sb.append(this.disks + ",");
        }
        if (this.gcpMetadata != null && !this.gcpMetadata.isEmpty()) {
            sb.append("gcpMetadata:");
            sb.append(this.gcpMetadata + ",");
        }
        if (this.gpus != null && !this.gpus.isEmpty()) {
            sb.append("gpus:");
            sb.append(this.gpus + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            sb.append("labels:");
            sb.append(this.labels + ",");
        }
        if (this.machineType != null) {
            sb.append("machineType:");
            sb.append(this.machineType + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.networkInterfaces != null && !this.networkInterfaces.isEmpty()) {
            sb.append("networkInterfaces:");
            sb.append(this.networkInterfaces + ",");
        }
        if (this.onHostMaintenance != null) {
            sb.append("onHostMaintenance:");
            sb.append(this.onHostMaintenance + ",");
        }
        if (this.preemptible != null) {
            sb.append("preemptible:");
            sb.append(this.preemptible + ",");
        }
        if (this.projectID != null) {
            sb.append("projectID:");
            sb.append(this.projectID + ",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.resourceManagerTags != null && !this.resourceManagerTags.isEmpty()) {
            sb.append("resourceManagerTags:");
            sb.append(this.resourceManagerTags + ",");
        }
        if (this.restartPolicy != null) {
            sb.append("restartPolicy:");
            sb.append(this.restartPolicy + ",");
        }
        if (this.serviceAccounts != null && !this.serviceAccounts.isEmpty()) {
            sb.append("serviceAccounts:");
            sb.append(this.serviceAccounts + ",");
        }
        if (this.shieldedInstanceConfig != null) {
            sb.append("shieldedInstanceConfig:");
            sb.append(this.shieldedInstanceConfig + ",");
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            sb.append("tags:");
            sb.append(this.tags + ",");
        }
        if (this.targetPools != null && !this.targetPools.isEmpty()) {
            sb.append("targetPools:");
            sb.append(this.targetPools + ",");
        }
        if (this.userDataSecret != null) {
            sb.append("userDataSecret:");
            sb.append(this.userDataSecret + ",");
        }
        if (this.zone != null) {
            sb.append("zone:");
            sb.append(this.zone + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withCanIPForward() {
        return this.withCanIPForward(true);
    }

    public A withDeletionProtection() {
        return this.withDeletionProtection(true);
    }

    public A withPreemptible() {
        return this.withPreemptible(true);
    }

    public class UserDataSecretNested<N>
    extends LocalObjectReferenceFluent<UserDataSecretNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        UserDataSecretNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)GCPMachineProviderSpecFluent.this.withUserDataSecret(this.builder.build());
        }

        public N endUserDataSecret() {
            return this.and();
        }
    }

    public class ShieldedInstanceConfigNested<N>
    extends GCPShieldedInstanceConfigFluent<ShieldedInstanceConfigNested<N>>
    implements Nested<N> {
        GCPShieldedInstanceConfigBuilder builder;

        ShieldedInstanceConfigNested(GCPShieldedInstanceConfig item) {
            this.builder = new GCPShieldedInstanceConfigBuilder(this, item);
        }

        public N and() {
            return (N)GCPMachineProviderSpecFluent.this.withShieldedInstanceConfig(this.builder.build());
        }

        public N endShieldedInstanceConfig() {
            return this.and();
        }
    }

    public class ServiceAccountsNested<N>
    extends GCPServiceAccountFluent<ServiceAccountsNested<N>>
    implements Nested<N> {
        GCPServiceAccountBuilder builder;
        int index;

        ServiceAccountsNested(int index, GCPServiceAccount item) {
            this.index = index;
            this.builder = new GCPServiceAccountBuilder(this, item);
        }

        public N and() {
            return (N)GCPMachineProviderSpecFluent.this.setToServiceAccounts(this.index, this.builder.build());
        }

        public N endServiceAccount() {
            return this.and();
        }
    }

    public class ResourceManagerTagsNested<N>
    extends ResourceManagerTagFluent<ResourceManagerTagsNested<N>>
    implements Nested<N> {
        ResourceManagerTagBuilder builder;
        int index;

        ResourceManagerTagsNested(int index, ResourceManagerTag item) {
            this.index = index;
            this.builder = new ResourceManagerTagBuilder(this, item);
        }

        public N and() {
            return (N)GCPMachineProviderSpecFluent.this.setToResourceManagerTags(this.index, this.builder.build());
        }

        public N endResourceManagerTag() {
            return this.and();
        }
    }

    public class NetworkInterfacesNested<N>
    extends GCPNetworkInterfaceFluent<NetworkInterfacesNested<N>>
    implements Nested<N> {
        GCPNetworkInterfaceBuilder builder;
        int index;

        NetworkInterfacesNested(int index, GCPNetworkInterface item) {
            this.index = index;
            this.builder = new GCPNetworkInterfaceBuilder(this, item);
        }

        public N and() {
            return (N)GCPMachineProviderSpecFluent.this.setToNetworkInterfaces(this.index, this.builder.build());
        }

        public N endNetworkInterface() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        public N and() {
            return (N)GCPMachineProviderSpecFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class GpusNested<N>
    extends GCPGPUConfigFluent<GpusNested<N>>
    implements Nested<N> {
        GCPGPUConfigBuilder builder;
        int index;

        GpusNested(int index, GCPGPUConfig item) {
            this.index = index;
            this.builder = new GCPGPUConfigBuilder(this, item);
        }

        public N and() {
            return (N)GCPMachineProviderSpecFluent.this.setToGpus(this.index, this.builder.build());
        }

        public N endGpus() {
            return this.and();
        }
    }

    public class GcpMetadataNested<N>
    extends GCPMetadataFluent<GcpMetadataNested<N>>
    implements Nested<N> {
        GCPMetadataBuilder builder;
        int index;

        GcpMetadataNested(int index, GCPMetadata item) {
            this.index = index;
            this.builder = new GCPMetadataBuilder(this, item);
        }

        public N and() {
            return (N)GCPMachineProviderSpecFluent.this.setToGcpMetadata(this.index, this.builder.build());
        }

        public N endGcpMetadatum() {
            return this.and();
        }
    }

    public class DisksNested<N>
    extends GCPDiskFluent<DisksNested<N>>
    implements Nested<N> {
        GCPDiskBuilder builder;
        int index;

        DisksNested(int index, GCPDisk item) {
            this.index = index;
            this.builder = new GCPDiskBuilder(this, item);
        }

        public N and() {
            return (N)GCPMachineProviderSpecFluent.this.setToDisks(this.index, this.builder.build());
        }

        public N endDisk() {
            return this.and();
        }
    }

    public class CredentialsSecretNested<N>
    extends LocalObjectReferenceFluent<CredentialsSecretNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        CredentialsSecretNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)GCPMachineProviderSpecFluent.this.withCredentialsSecret(this.builder.build());
        }

        public N endCredentialsSecret() {
            return this.and();
        }
    }
}

