package io.fabric8.openshift.api.model.machine.v1;

import io.fabric8.openshift.api.model.machine.v1beta1.MachineSpecBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineSpecFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineSpec;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OpenShiftMachineV1Beta1MachineTemplateFluent<A extends OpenShiftMachineV1Beta1MachineTemplateFluent<A>> extends BaseFluent<A>{
  public OpenShiftMachineV1Beta1MachineTemplateFluent() {
  }
  
  public OpenShiftMachineV1Beta1MachineTemplateFluent(OpenShiftMachineV1Beta1MachineTemplate instance) {
    this.copyInstance(instance);
  }
  private FailureDomainsBuilder failureDomains;
  private ControlPlaneMachineSetTemplateObjectMetaBuilder metadata;
  private MachineSpecBuilder spec;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(OpenShiftMachineV1Beta1MachineTemplate instance) {
    instance = (instance != null ? instance : new OpenShiftMachineV1Beta1MachineTemplate());
    if (instance != null) {
          this.withFailureDomains(instance.getFailureDomains());
          this.withMetadata(instance.getMetadata());
          this.withSpec(instance.getSpec());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public FailureDomains buildFailureDomains() {
    return this.failureDomains != null ? this.failureDomains.build() : null;
  }
  
  public A withFailureDomains(FailureDomains failureDomains) {
    this._visitables.remove("failureDomains");
    if (failureDomains != null) {
        this.failureDomains = new FailureDomainsBuilder(failureDomains);
        this._visitables.get("failureDomains").add(this.failureDomains);
    } else {
        this.failureDomains = null;
        this._visitables.get("failureDomains").remove(this.failureDomains);
    }
    return (A) this;
  }
  
  public boolean hasFailureDomains() {
    return this.failureDomains != null;
  }
  
  public FailureDomainsNested<A> withNewFailureDomains() {
    return new FailureDomainsNested(null);
  }
  
  public FailureDomainsNested<A> withNewFailureDomainsLike(FailureDomains item) {
    return new FailureDomainsNested(item);
  }
  
  public FailureDomainsNested<A> editFailureDomains() {
    return withNewFailureDomainsLike(java.util.Optional.ofNullable(buildFailureDomains()).orElse(null));
  }
  
  public FailureDomainsNested<A> editOrNewFailureDomains() {
    return withNewFailureDomainsLike(java.util.Optional.ofNullable(buildFailureDomains()).orElse(new FailureDomainsBuilder().build()));
  }
  
  public FailureDomainsNested<A> editOrNewFailureDomainsLike(FailureDomains item) {
    return withNewFailureDomainsLike(java.util.Optional.ofNullable(buildFailureDomains()).orElse(item));
  }
  
  public ControlPlaneMachineSetTemplateObjectMeta buildMetadata() {
    return this.metadata != null ? this.metadata.build() : null;
  }
  
  public A withMetadata(ControlPlaneMachineSetTemplateObjectMeta metadata) {
    this._visitables.remove("metadata");
    if (metadata != null) {
        this.metadata = new ControlPlaneMachineSetTemplateObjectMetaBuilder(metadata);
        this._visitables.get("metadata").add(this.metadata);
    } else {
        this.metadata = null;
        this._visitables.get("metadata").remove(this.metadata);
    }
    return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  
  public MetadataNested<A> withNewMetadataLike(ControlPlaneMachineSetTemplateObjectMeta item) {
    return new MetadataNested(item);
  }
  
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new ControlPlaneMachineSetTemplateObjectMetaBuilder().build()));
  }
  
  public MetadataNested<A> editOrNewMetadataLike(ControlPlaneMachineSetTemplateObjectMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  
  public MachineSpec buildSpec() {
    return this.spec != null ? this.spec.build() : null;
  }
  
  public A withSpec(MachineSpec spec) {
    this._visitables.remove("spec");
    if (spec != null) {
        this.spec = new MachineSpecBuilder(spec);
        this._visitables.get("spec").add(this.spec);
    } else {
        this.spec = null;
        this._visitables.get("spec").remove(this.spec);
    }
    return (A) this;
  }
  
  public boolean hasSpec() {
    return this.spec != null;
  }
  
  public SpecNested<A> withNewSpec() {
    return new SpecNested(null);
  }
  
  public SpecNested<A> withNewSpecLike(MachineSpec item) {
    return new SpecNested(item);
  }
  
  public SpecNested<A> editSpec() {
    return withNewSpecLike(java.util.Optional.ofNullable(buildSpec()).orElse(null));
  }
  
  public SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(java.util.Optional.ofNullable(buildSpec()).orElse(new MachineSpecBuilder().build()));
  }
  
  public SpecNested<A> editOrNewSpecLike(MachineSpec item) {
    return withNewSpecLike(java.util.Optional.ofNullable(buildSpec()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OpenShiftMachineV1Beta1MachineTemplateFluent that = (OpenShiftMachineV1Beta1MachineTemplateFluent) o;
    if (!java.util.Objects.equals(failureDomains, that.failureDomains)) return false;
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
    if (!java.util.Objects.equals(spec, that.spec)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(failureDomains,  metadata,  spec,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (failureDomains != null) { sb.append("failureDomains:"); sb.append(failureDomains + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class FailureDomainsNested<N> extends FailureDomainsFluent<FailureDomainsNested<N>> implements Nested<N>{
    FailureDomainsNested(FailureDomains item) {
      this.builder = new FailureDomainsBuilder(this, item);
    }
    FailureDomainsBuilder builder;
    
    public N and() {
      return (N) OpenShiftMachineV1Beta1MachineTemplateFluent.this.withFailureDomains(builder.build());
    }
    
    public N endFailureDomains() {
      return and();
    }
    
  
  }
  public class MetadataNested<N> extends ControlPlaneMachineSetTemplateObjectMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(ControlPlaneMachineSetTemplateObjectMeta item) {
      this.builder = new ControlPlaneMachineSetTemplateObjectMetaBuilder(this, item);
    }
    ControlPlaneMachineSetTemplateObjectMetaBuilder builder;
    
    public N and() {
      return (N) OpenShiftMachineV1Beta1MachineTemplateFluent.this.withMetadata(builder.build());
    }
    
    public N endMetadata() {
      return and();
    }
    
  
  }
  public class SpecNested<N> extends MachineSpecFluent<SpecNested<N>> implements Nested<N>{
    SpecNested(MachineSpec item) {
      this.builder = new MachineSpecBuilder(this, item);
    }
    MachineSpecBuilder builder;
    
    public N and() {
      return (N) OpenShiftMachineV1Beta1MachineTemplateFluent.this.withSpec(builder.build());
    }
    
    public N endSpec() {
      return and();
    }
    
  
  }

}