/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.openshift.api.model.machine.v1beta1.ObjectMeta;
import io.fabric8.openshift.api.model.machine.v1beta1.ObjectMetaFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ObjectMetaFluentImpl<A extends ObjectMetaFluent<A>>
extends BaseFluent<A>
implements ObjectMetaFluent<A> {
    private Map<String, String> annotations;
    private String generateName;
    private Map<String, String> labels;
    private String name;
    private String namespace;
    private List<OwnerReference> ownerReferences = new ArrayList<OwnerReference>();

    public ObjectMetaFluentImpl() {
    }

    public ObjectMetaFluentImpl(ObjectMeta instance) {
        this.withAnnotations(instance.getAnnotations());
        this.withGenerateName(instance.getGenerateName());
        this.withLabels(instance.getLabels());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withOwnerReferences(instance.getOwnerReferences());
    }

    @Override
    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @Override
    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)this;
    }

    @Override
    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    @Override
    public String getGenerateName() {
        return this.generateName;
    }

    @Override
    public A withGenerateName(String generateName) {
        this.generateName = generateName;
        return (A)this;
    }

    @Override
    public Boolean hasGenerateName() {
        return this.generateName != null;
    }

    @Override
    @Deprecated
    public A withNewGenerateName(String arg0) {
        return this.withGenerateName(new String(arg0));
    }

    @Override
    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)this;
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public <K, V> A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)this;
    }

    @Override
    public Boolean hasLabels() {
        return this.labels != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public A withNewName(String arg0) {
        return this.withName(new String(arg0));
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    @Override
    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    @Override
    @Deprecated
    public A withNewNamespace(String arg0) {
        return this.withNamespace(new String(arg0));
    }

    @Override
    public A addToOwnerReferences(int index, OwnerReference item) {
        if (this.ownerReferences == null) {
            this.ownerReferences = new ArrayList<OwnerReference>();
        }
        this.ownerReferences.add(index, item);
        return (A)this;
    }

    @Override
    public A setToOwnerReferences(int index, OwnerReference item) {
        if (this.ownerReferences == null) {
            this.ownerReferences = new ArrayList<OwnerReference>();
        }
        this.ownerReferences.set(index, item);
        return (A)this;
    }

    @Override
    public A addToOwnerReferences(OwnerReference ... items) {
        if (this.ownerReferences == null) {
            this.ownerReferences = new ArrayList<OwnerReference>();
        }
        for (OwnerReference item : items) {
            this.ownerReferences.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToOwnerReferences(Collection<OwnerReference> items) {
        if (this.ownerReferences == null) {
            this.ownerReferences = new ArrayList<OwnerReference>();
        }
        for (OwnerReference item : items) {
            this.ownerReferences.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromOwnerReferences(OwnerReference ... items) {
        for (OwnerReference item : items) {
            if (this.ownerReferences == null) continue;
            this.ownerReferences.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromOwnerReferences(Collection<OwnerReference> items) {
        for (OwnerReference item : items) {
            if (this.ownerReferences == null) continue;
            this.ownerReferences.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<OwnerReference> getOwnerReferences() {
        return this.ownerReferences;
    }

    @Override
    public OwnerReference getOwnerReference(int index) {
        return this.ownerReferences.get(index);
    }

    @Override
    public OwnerReference getFirstOwnerReference() {
        return this.ownerReferences.get(0);
    }

    @Override
    public OwnerReference getLastOwnerReference() {
        return this.ownerReferences.get(this.ownerReferences.size() - 1);
    }

    @Override
    public OwnerReference getMatchingOwnerReference(Predicate<OwnerReference> predicate) {
        for (OwnerReference item : this.ownerReferences) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingOwnerReference(Predicate<OwnerReference> predicate) {
        for (OwnerReference item : this.ownerReferences) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withOwnerReferences(List<OwnerReference> ownerReferences) {
        if (this.ownerReferences != null) {
            this._visitables.get((Object)"ownerReferences").removeAll(this.ownerReferences);
        }
        if (ownerReferences != null) {
            this.ownerReferences = new ArrayList<OwnerReference>();
            for (OwnerReference item : ownerReferences) {
                this.addToOwnerReferences(item);
            }
        } else {
            this.ownerReferences = null;
        }
        return (A)this;
    }

    @Override
    public A withOwnerReferences(OwnerReference ... ownerReferences) {
        if (this.ownerReferences != null) {
            this.ownerReferences.clear();
        }
        if (ownerReferences != null) {
            for (OwnerReference item : ownerReferences) {
                this.addToOwnerReferences(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasOwnerReferences() {
        return this.ownerReferences != null && !this.ownerReferences.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectMetaFluentImpl that = (ObjectMetaFluentImpl)o;
        if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) {
            return false;
        }
        if (this.generateName != null ? !this.generateName.equals(that.generateName) : that.generateName != null) {
            return false;
        }
        if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        return !(this.ownerReferences != null ? !this.ownerReferences.equals(that.ownerReferences) : that.ownerReferences != null);
    }

    public int hashCode() {
        return Objects.hash(this.annotations, this.generateName, this.labels, this.name, this.namespace, this.ownerReferences, super.hashCode());
    }
}

