/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineSet;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineSetFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineSetSpec;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineSetSpecBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineSetSpecFluentImpl;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineSetStatus;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineSetStatusBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineSetStatusFluentImpl;
import java.util.Objects;

public class MachineSetFluentImpl<A extends MachineSetFluent<A>>
extends BaseFluent<A>
implements MachineSetFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private MachineSetSpecBuilder spec;
    private MachineSetStatusBuilder status;

    public MachineSetFluentImpl() {
    }

    public MachineSetFluentImpl(MachineSet instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public MachineSetFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public MachineSetFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public MachineSetFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public MachineSetFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public MachineSetFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public MachineSetSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public MachineSetSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(MachineSetSpec spec) {
        this._visitables.get((Object)"spec").remove(this.spec);
        if (spec != null) {
            this.spec = new MachineSetSpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public MachineSetFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public MachineSetFluent.SpecNested<A> withNewSpecLike(MachineSetSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public MachineSetFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public MachineSetFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new MachineSetSpecBuilder().build());
    }

    @Override
    public MachineSetFluent.SpecNested<A> editOrNewSpecLike(MachineSetSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public MachineSetStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public MachineSetStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(MachineSetStatus status) {
        this._visitables.get((Object)"status").remove(this.status);
        if (status != null) {
            this.status = new MachineSetStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public MachineSetFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public MachineSetFluent.StatusNested<A> withNewStatusLike(MachineSetStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public MachineSetFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public MachineSetFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new MachineSetStatusBuilder().build());
    }

    @Override
    public MachineSetFluent.StatusNested<A> editOrNewStatusLike(MachineSetStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachineSetFluentImpl that = (MachineSetFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public class StatusNestedImpl<N>
    extends MachineSetStatusFluentImpl<MachineSetFluent.StatusNested<N>>
    implements MachineSetFluent.StatusNested<N>,
    Nested<N> {
        private final MachineSetStatusBuilder builder;

        StatusNestedImpl(MachineSetStatus item) {
            this.builder = new MachineSetStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new MachineSetStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)MachineSetFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends MachineSetSpecFluentImpl<MachineSetFluent.SpecNested<N>>
    implements MachineSetFluent.SpecNested<N>,
    Nested<N> {
        private final MachineSetSpecBuilder builder;

        SpecNestedImpl(MachineSetSpec item) {
            this.builder = new MachineSetSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new MachineSetSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)MachineSetFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<MachineSetFluent.MetadataNested<N>>
    implements MachineSetFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)MachineSetFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

