/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.vsphere.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.vsphere.v1.Host;
import io.fabric8.openshift.api.model.installer.vsphere.v1.NetworkDeviceSpec;
import io.fabric8.openshift.api.model.installer.vsphere.v1.NetworkDeviceSpecBuilder;
import io.fabric8.openshift.api.model.installer.vsphere.v1.NetworkDeviceSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HostFluent<A extends HostFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String failureDomain;
    private NetworkDeviceSpecBuilder networkDevice;
    private String role;

    public HostFluent() {
    }

    public HostFluent(Host instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public NetworkDeviceSpec buildNetworkDevice() {
        return this.networkDevice != null ? this.networkDevice.build() : null;
    }

    protected void copyInstance(Host instance) {
        Host host = instance = instance != null ? instance : new Host();
        if (instance != null) {
            this.withFailureDomain(instance.getFailureDomain());
            this.withNetworkDevice(instance.getNetworkDevice());
            this.withRole(instance.getRole());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public NetworkDeviceNested<A> editNetworkDevice() {
        return this.withNewNetworkDeviceLike(Optional.ofNullable(this.buildNetworkDevice()).orElse(null));
    }

    public NetworkDeviceNested<A> editOrNewNetworkDevice() {
        return this.withNewNetworkDeviceLike(Optional.ofNullable(this.buildNetworkDevice()).orElse(new NetworkDeviceSpecBuilder().build()));
    }

    public NetworkDeviceNested<A> editOrNewNetworkDeviceLike(NetworkDeviceSpec item) {
        return this.withNewNetworkDeviceLike(Optional.ofNullable(this.buildNetworkDevice()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HostFluent that = (HostFluent)((Object)o);
        if (!Objects.equals(this.failureDomain, that.failureDomain)) {
            return false;
        }
        if (!Objects.equals((Object)this.networkDevice, (Object)that.networkDevice)) {
            return false;
        }
        if (!Objects.equals(this.role, that.role)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getFailureDomain() {
        return this.failureDomain;
    }

    public String getRole() {
        return this.role;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasFailureDomain() {
        return this.failureDomain != null;
    }

    public boolean hasNetworkDevice() {
        return this.networkDevice != null;
    }

    public boolean hasRole() {
        return this.role != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.failureDomain, this.networkDevice, this.role, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.failureDomain != null) {
            sb.append("failureDomain:");
            sb.append(this.failureDomain);
            sb.append(",");
        }
        if (this.networkDevice != null) {
            sb.append("networkDevice:");
            sb.append((Object)this.networkDevice);
            sb.append(",");
        }
        if (this.role != null) {
            sb.append("role:");
            sb.append(this.role);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withFailureDomain(String failureDomain) {
        this.failureDomain = failureDomain;
        return (A)((Object)this);
    }

    public A withNetworkDevice(NetworkDeviceSpec networkDevice) {
        this._visitables.remove((Object)"networkDevice");
        if (networkDevice != null) {
            this.networkDevice = new NetworkDeviceSpecBuilder(networkDevice);
            this._visitables.get((Object)"networkDevice").add(this.networkDevice);
        } else {
            this.networkDevice = null;
            this._visitables.get((Object)"networkDevice").remove((Object)this.networkDevice);
        }
        return (A)((Object)this);
    }

    public NetworkDeviceNested<A> withNewNetworkDevice() {
        return new NetworkDeviceNested(null);
    }

    public NetworkDeviceNested<A> withNewNetworkDeviceLike(NetworkDeviceSpec item) {
        return new NetworkDeviceNested(item);
    }

    public A withRole(String role) {
        this.role = role;
        return (A)((Object)this);
    }

    public class NetworkDeviceNested<N>
    extends NetworkDeviceSpecFluent<NetworkDeviceNested<N>>
    implements Nested<N> {
        NetworkDeviceSpecBuilder builder;

        NetworkDeviceNested(NetworkDeviceSpec item) {
            this.builder = new NetworkDeviceSpecBuilder(this, item);
        }

        public N and() {
            return (N)HostFluent.this.withNetworkDevice(this.builder.build());
        }

        public N endNetworkDevice() {
            return this.and();
        }
    }
}

