/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.installer.v1.BootstrapInPlace;
import io.fabric8.openshift.api.model.installer.v1.BootstrapInPlaceBuilder;
import io.fabric8.openshift.api.model.installer.v1.BootstrapInPlaceFluent;
import io.fabric8.openshift.api.model.installer.v1.Capabilities;
import io.fabric8.openshift.api.model.installer.v1.CapabilitiesBuilder;
import io.fabric8.openshift.api.model.installer.v1.CapabilitiesFluent;
import io.fabric8.openshift.api.model.installer.v1.ImageContentSource;
import io.fabric8.openshift.api.model.installer.v1.ImageContentSourceBuilder;
import io.fabric8.openshift.api.model.installer.v1.ImageContentSourceFluent;
import io.fabric8.openshift.api.model.installer.v1.ImageDigestSource;
import io.fabric8.openshift.api.model.installer.v1.ImageDigestSourceBuilder;
import io.fabric8.openshift.api.model.installer.v1.ImageDigestSourceFluent;
import io.fabric8.openshift.api.model.installer.v1.InstallConfig;
import io.fabric8.openshift.api.model.installer.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.installer.v1.MachinePoolFluent;
import io.fabric8.openshift.api.model.installer.v1.Networking;
import io.fabric8.openshift.api.model.installer.v1.NetworkingBuilder;
import io.fabric8.openshift.api.model.installer.v1.NetworkingFluent;
import io.fabric8.openshift.api.model.installer.v1.OperatorPublishingStrategy;
import io.fabric8.openshift.api.model.installer.v1.OperatorPublishingStrategyBuilder;
import io.fabric8.openshift.api.model.installer.v1.OperatorPublishingStrategyFluent;
import io.fabric8.openshift.api.model.installer.v1.Platform;
import io.fabric8.openshift.api.model.installer.v1.PlatformBuilder;
import io.fabric8.openshift.api.model.installer.v1.PlatformFluent;
import io.fabric8.openshift.api.model.installer.v1.Proxy;
import io.fabric8.openshift.api.model.installer.v1.ProxyBuilder;
import io.fabric8.openshift.api.model.installer.v1.ProxyFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class InstallConfigFluent<A extends InstallConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String additionalTrustBundle;
    private String additionalTrustBundlePolicy;
    private String apiVersion;
    private MachinePoolBuilder arbiter;
    private String baseDomain;
    private BootstrapInPlaceBuilder bootstrapInPlace;
    private CapabilitiesBuilder capabilities;
    private ArrayList<MachinePoolBuilder> compute = new ArrayList();
    private MachinePoolBuilder controlPlane;
    private String cpuPartitioningMode;
    private String credentialsMode;
    private List<String> featureGates = new ArrayList<String>();
    private String featureSet;
    private Boolean fips;
    private ArrayList<ImageContentSourceBuilder> imageContentSources = new ArrayList();
    private ArrayList<ImageDigestSourceBuilder> imageDigestSources = new ArrayList();
    private String kind;
    private ObjectMetaBuilder metadata;
    private NetworkingBuilder networking;
    private OperatorPublishingStrategyBuilder operatorPublishingStrategy;
    private PlatformBuilder platform;
    private ProxyBuilder proxy;
    private String publish;
    private String pullSecret;
    private String sshKey;

    public InstallConfigFluent() {
    }

    public InstallConfigFluent(InstallConfig instance) {
        this.copyInstance(instance);
    }

    public A addAllToCompute(Collection<MachinePool> items) {
        if (this.compute == null) {
            this.compute = new ArrayList();
        }
        for (MachinePool item : items) {
            MachinePoolBuilder builder = new MachinePoolBuilder(item);
            this._visitables.get((Object)"compute").add(builder);
            this.compute.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToFeatureGates(Collection<String> items) {
        if (this.featureGates == null) {
            this.featureGates = new ArrayList<String>();
        }
        for (String item : items) {
            this.featureGates.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToImageContentSources(Collection<ImageContentSource> items) {
        if (this.imageContentSources == null) {
            this.imageContentSources = new ArrayList();
        }
        for (ImageContentSource item : items) {
            ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);
            this._visitables.get((Object)"imageContentSources").add(builder);
            this.imageContentSources.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToImageDigestSources(Collection<ImageDigestSource> items) {
        if (this.imageDigestSources == null) {
            this.imageDigestSources = new ArrayList();
        }
        for (ImageDigestSource item : items) {
            ImageDigestSourceBuilder builder = new ImageDigestSourceBuilder(item);
            this._visitables.get((Object)"imageDigestSources").add(builder);
            this.imageDigestSources.add(builder);
        }
        return (A)((Object)this);
    }

    public ComputeNested<A> addNewCompute() {
        return new ComputeNested(-1, null);
    }

    public ComputeNested<A> addNewComputeLike(MachinePool item) {
        return new ComputeNested(-1, item);
    }

    public ImageContentSourcesNested<A> addNewImageContentSource() {
        return new ImageContentSourcesNested(-1, null);
    }

    public ImageContentSourcesNested<A> addNewImageContentSourceLike(ImageContentSource item) {
        return new ImageContentSourcesNested(-1, item);
    }

    public ImageDigestSourcesNested<A> addNewImageDigestSource() {
        return new ImageDigestSourcesNested(-1, null);
    }

    public ImageDigestSourcesNested<A> addNewImageDigestSourceLike(ImageDigestSource item) {
        return new ImageDigestSourcesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToCompute(MachinePool ... items) {
        if (this.compute == null) {
            this.compute = new ArrayList();
        }
        for (MachinePool item : items) {
            MachinePoolBuilder builder = new MachinePoolBuilder(item);
            this._visitables.get((Object)"compute").add(builder);
            this.compute.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToCompute(int index, MachinePool item) {
        if (this.compute == null) {
            this.compute = new ArrayList();
        }
        MachinePoolBuilder builder = new MachinePoolBuilder(item);
        if (index < 0 || index >= this.compute.size()) {
            this._visitables.get((Object)"compute").add(builder);
            this.compute.add(builder);
        } else {
            this._visitables.get((Object)"compute").add(builder);
            this.compute.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToFeatureGates(String ... items) {
        if (this.featureGates == null) {
            this.featureGates = new ArrayList<String>();
        }
        for (String item : items) {
            this.featureGates.add(item);
        }
        return (A)((Object)this);
    }

    public A addToFeatureGates(int index, String item) {
        if (this.featureGates == null) {
            this.featureGates = new ArrayList<String>();
        }
        this.featureGates.add(index, item);
        return (A)((Object)this);
    }

    public A addToImageContentSources(ImageContentSource ... items) {
        if (this.imageContentSources == null) {
            this.imageContentSources = new ArrayList();
        }
        for (ImageContentSource item : items) {
            ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);
            this._visitables.get((Object)"imageContentSources").add(builder);
            this.imageContentSources.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToImageContentSources(int index, ImageContentSource item) {
        if (this.imageContentSources == null) {
            this.imageContentSources = new ArrayList();
        }
        ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);
        if (index < 0 || index >= this.imageContentSources.size()) {
            this._visitables.get((Object)"imageContentSources").add(builder);
            this.imageContentSources.add(builder);
        } else {
            this._visitables.get((Object)"imageContentSources").add(builder);
            this.imageContentSources.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToImageDigestSources(ImageDigestSource ... items) {
        if (this.imageDigestSources == null) {
            this.imageDigestSources = new ArrayList();
        }
        for (ImageDigestSource item : items) {
            ImageDigestSourceBuilder builder = new ImageDigestSourceBuilder(item);
            this._visitables.get((Object)"imageDigestSources").add(builder);
            this.imageDigestSources.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToImageDigestSources(int index, ImageDigestSource item) {
        if (this.imageDigestSources == null) {
            this.imageDigestSources = new ArrayList();
        }
        ImageDigestSourceBuilder builder = new ImageDigestSourceBuilder(item);
        if (index < 0 || index >= this.imageDigestSources.size()) {
            this._visitables.get((Object)"imageDigestSources").add(builder);
            this.imageDigestSources.add(builder);
        } else {
            this._visitables.get((Object)"imageDigestSources").add(builder);
            this.imageDigestSources.add(index, builder);
        }
        return (A)((Object)this);
    }

    public MachinePool buildArbiter() {
        return this.arbiter != null ? this.arbiter.build() : null;
    }

    public BootstrapInPlace buildBootstrapInPlace() {
        return this.bootstrapInPlace != null ? this.bootstrapInPlace.build() : null;
    }

    public Capabilities buildCapabilities() {
        return this.capabilities != null ? this.capabilities.build() : null;
    }

    public List<MachinePool> buildCompute() {
        return this.compute != null ? InstallConfigFluent.build(this.compute) : null;
    }

    public MachinePool buildCompute(int index) {
        return this.compute.get(index).build();
    }

    public MachinePool buildControlPlane() {
        return this.controlPlane != null ? this.controlPlane.build() : null;
    }

    public MachinePool buildFirstCompute() {
        return this.compute.get(0).build();
    }

    public ImageContentSource buildFirstImageContentSource() {
        return this.imageContentSources.get(0).build();
    }

    public ImageDigestSource buildFirstImageDigestSource() {
        return this.imageDigestSources.get(0).build();
    }

    public ImageContentSource buildImageContentSource(int index) {
        return this.imageContentSources.get(index).build();
    }

    public List<ImageContentSource> buildImageContentSources() {
        return this.imageContentSources != null ? InstallConfigFluent.build(this.imageContentSources) : null;
    }

    public ImageDigestSource buildImageDigestSource(int index) {
        return this.imageDigestSources.get(index).build();
    }

    public List<ImageDigestSource> buildImageDigestSources() {
        return this.imageDigestSources != null ? InstallConfigFluent.build(this.imageDigestSources) : null;
    }

    public MachinePool buildLastCompute() {
        return this.compute.get(this.compute.size() - 1).build();
    }

    public ImageContentSource buildLastImageContentSource() {
        return this.imageContentSources.get(this.imageContentSources.size() - 1).build();
    }

    public ImageDigestSource buildLastImageDigestSource() {
        return this.imageDigestSources.get(this.imageDigestSources.size() - 1).build();
    }

    public MachinePool buildMatchingCompute(Predicate<MachinePoolBuilder> predicate) {
        for (MachinePoolBuilder item : this.compute) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public ImageContentSource buildMatchingImageContentSource(Predicate<ImageContentSourceBuilder> predicate) {
        for (ImageContentSourceBuilder item : this.imageContentSources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public ImageDigestSource buildMatchingImageDigestSource(Predicate<ImageDigestSourceBuilder> predicate) {
        for (ImageDigestSourceBuilder item : this.imageDigestSources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public Networking buildNetworking() {
        return this.networking != null ? this.networking.build() : null;
    }

    public OperatorPublishingStrategy buildOperatorPublishingStrategy() {
        return this.operatorPublishingStrategy != null ? this.operatorPublishingStrategy.build() : null;
    }

    public Platform buildPlatform() {
        return this.platform != null ? this.platform.build() : null;
    }

    public Proxy buildProxy() {
        return this.proxy != null ? this.proxy.build() : null;
    }

    protected void copyInstance(InstallConfig instance) {
        InstallConfig installConfig = instance = instance != null ? instance : new InstallConfig();
        if (instance != null) {
            this.withAdditionalTrustBundle(instance.getAdditionalTrustBundle());
            this.withAdditionalTrustBundlePolicy(instance.getAdditionalTrustBundlePolicy());
            this.withApiVersion(instance.getApiVersion());
            this.withArbiter(instance.getArbiter());
            this.withBaseDomain(instance.getBaseDomain());
            this.withBootstrapInPlace(instance.getBootstrapInPlace());
            this.withCapabilities(instance.getCapabilities());
            this.withCompute(instance.getCompute());
            this.withControlPlane(instance.getControlPlane());
            this.withCpuPartitioningMode(instance.getCpuPartitioningMode());
            this.withCredentialsMode(instance.getCredentialsMode());
            this.withFeatureGates(instance.getFeatureGates());
            this.withFeatureSet(instance.getFeatureSet());
            this.withFips(instance.getFips());
            this.withImageContentSources(instance.getImageContentSources());
            this.withImageDigestSources(instance.getImageDigestSources());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withNetworking(instance.getNetworking());
            this.withOperatorPublishingStrategy(instance.getOperatorPublishingStrategy());
            this.withPlatform(instance.getPlatform());
            this.withProxy(instance.getProxy());
            this.withPublish(instance.getPublish());
            this.withPullSecret(instance.getPullSecret());
            this.withSshKey(instance.getSshKey());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ArbiterNested<A> editArbiter() {
        return this.withNewArbiterLike(Optional.ofNullable(this.buildArbiter()).orElse(null));
    }

    public BootstrapInPlaceNested<A> editBootstrapInPlace() {
        return this.withNewBootstrapInPlaceLike(Optional.ofNullable(this.buildBootstrapInPlace()).orElse(null));
    }

    public CapabilitiesNested<A> editCapabilities() {
        return this.withNewCapabilitiesLike(Optional.ofNullable(this.buildCapabilities()).orElse(null));
    }

    public ComputeNested<A> editCompute(int index) {
        if (this.compute.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "compute"));
        }
        return this.setNewComputeLike(index, this.buildCompute(index));
    }

    public ControlPlaneNested<A> editControlPlane() {
        return this.withNewControlPlaneLike(Optional.ofNullable(this.buildControlPlane()).orElse(null));
    }

    public ComputeNested<A> editFirstCompute() {
        if (this.compute.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "compute"));
        }
        return this.setNewComputeLike(0, this.buildCompute(0));
    }

    public ImageContentSourcesNested<A> editFirstImageContentSource() {
        if (this.imageContentSources.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "imageContentSources"));
        }
        return this.setNewImageContentSourceLike(0, this.buildImageContentSource(0));
    }

    public ImageDigestSourcesNested<A> editFirstImageDigestSource() {
        if (this.imageDigestSources.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "imageDigestSources"));
        }
        return this.setNewImageDigestSourceLike(0, this.buildImageDigestSource(0));
    }

    public ImageContentSourcesNested<A> editImageContentSource(int index) {
        if (this.imageContentSources.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "imageContentSources"));
        }
        return this.setNewImageContentSourceLike(index, this.buildImageContentSource(index));
    }

    public ImageDigestSourcesNested<A> editImageDigestSource(int index) {
        if (this.imageDigestSources.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "imageDigestSources"));
        }
        return this.setNewImageDigestSourceLike(index, this.buildImageDigestSource(index));
    }

    public ComputeNested<A> editLastCompute() {
        int index = this.compute.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "compute"));
        }
        return this.setNewComputeLike(index, this.buildCompute(index));
    }

    public ImageContentSourcesNested<A> editLastImageContentSource() {
        int index = this.imageContentSources.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "imageContentSources"));
        }
        return this.setNewImageContentSourceLike(index, this.buildImageContentSource(index));
    }

    public ImageDigestSourcesNested<A> editLastImageDigestSource() {
        int index = this.imageDigestSources.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "imageDigestSources"));
        }
        return this.setNewImageDigestSourceLike(index, this.buildImageDigestSource(index));
    }

    public ComputeNested<A> editMatchingCompute(Predicate<MachinePoolBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.compute.size(); ++i) {
            if (!predicate.test(this.compute.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "compute"));
        }
        return this.setNewComputeLike(index, this.buildCompute(index));
    }

    public ImageContentSourcesNested<A> editMatchingImageContentSource(Predicate<ImageContentSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imageContentSources.size(); ++i) {
            if (!predicate.test(this.imageContentSources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "imageContentSources"));
        }
        return this.setNewImageContentSourceLike(index, this.buildImageContentSource(index));
    }

    public ImageDigestSourcesNested<A> editMatchingImageDigestSource(Predicate<ImageDigestSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imageDigestSources.size(); ++i) {
            if (!predicate.test(this.imageDigestSources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "imageDigestSources"));
        }
        return this.setNewImageDigestSourceLike(index, this.buildImageDigestSource(index));
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public NetworkingNested<A> editNetworking() {
        return this.withNewNetworkingLike(Optional.ofNullable(this.buildNetworking()).orElse(null));
    }

    public OperatorPublishingStrategyNested<A> editOperatorPublishingStrategy() {
        return this.withNewOperatorPublishingStrategyLike(Optional.ofNullable(this.buildOperatorPublishingStrategy()).orElse(null));
    }

    public ArbiterNested<A> editOrNewArbiter() {
        return this.withNewArbiterLike(Optional.ofNullable(this.buildArbiter()).orElse(new MachinePoolBuilder().build()));
    }

    public ArbiterNested<A> editOrNewArbiterLike(MachinePool item) {
        return this.withNewArbiterLike(Optional.ofNullable(this.buildArbiter()).orElse(item));
    }

    public BootstrapInPlaceNested<A> editOrNewBootstrapInPlace() {
        return this.withNewBootstrapInPlaceLike(Optional.ofNullable(this.buildBootstrapInPlace()).orElse(new BootstrapInPlaceBuilder().build()));
    }

    public BootstrapInPlaceNested<A> editOrNewBootstrapInPlaceLike(BootstrapInPlace item) {
        return this.withNewBootstrapInPlaceLike(Optional.ofNullable(this.buildBootstrapInPlace()).orElse(item));
    }

    public CapabilitiesNested<A> editOrNewCapabilities() {
        return this.withNewCapabilitiesLike(Optional.ofNullable(this.buildCapabilities()).orElse(new CapabilitiesBuilder().build()));
    }

    public CapabilitiesNested<A> editOrNewCapabilitiesLike(Capabilities item) {
        return this.withNewCapabilitiesLike(Optional.ofNullable(this.buildCapabilities()).orElse(item));
    }

    public ControlPlaneNested<A> editOrNewControlPlane() {
        return this.withNewControlPlaneLike(Optional.ofNullable(this.buildControlPlane()).orElse(new MachinePoolBuilder().build()));
    }

    public ControlPlaneNested<A> editOrNewControlPlaneLike(MachinePool item) {
        return this.withNewControlPlaneLike(Optional.ofNullable(this.buildControlPlane()).orElse(item));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public NetworkingNested<A> editOrNewNetworking() {
        return this.withNewNetworkingLike(Optional.ofNullable(this.buildNetworking()).orElse(new NetworkingBuilder().build()));
    }

    public NetworkingNested<A> editOrNewNetworkingLike(Networking item) {
        return this.withNewNetworkingLike(Optional.ofNullable(this.buildNetworking()).orElse(item));
    }

    public OperatorPublishingStrategyNested<A> editOrNewOperatorPublishingStrategy() {
        return this.withNewOperatorPublishingStrategyLike(Optional.ofNullable(this.buildOperatorPublishingStrategy()).orElse(new OperatorPublishingStrategyBuilder().build()));
    }

    public OperatorPublishingStrategyNested<A> editOrNewOperatorPublishingStrategyLike(OperatorPublishingStrategy item) {
        return this.withNewOperatorPublishingStrategyLike(Optional.ofNullable(this.buildOperatorPublishingStrategy()).orElse(item));
    }

    public PlatformNested<A> editOrNewPlatform() {
        return this.withNewPlatformLike(Optional.ofNullable(this.buildPlatform()).orElse(new PlatformBuilder().build()));
    }

    public PlatformNested<A> editOrNewPlatformLike(Platform item) {
        return this.withNewPlatformLike(Optional.ofNullable(this.buildPlatform()).orElse(item));
    }

    public ProxyNested<A> editOrNewProxy() {
        return this.withNewProxyLike(Optional.ofNullable(this.buildProxy()).orElse(new ProxyBuilder().build()));
    }

    public ProxyNested<A> editOrNewProxyLike(Proxy item) {
        return this.withNewProxyLike(Optional.ofNullable(this.buildProxy()).orElse(item));
    }

    public PlatformNested<A> editPlatform() {
        return this.withNewPlatformLike(Optional.ofNullable(this.buildPlatform()).orElse(null));
    }

    public ProxyNested<A> editProxy() {
        return this.withNewProxyLike(Optional.ofNullable(this.buildProxy()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InstallConfigFluent that = (InstallConfigFluent)((Object)o);
        if (!Objects.equals(this.additionalTrustBundle, that.additionalTrustBundle)) {
            return false;
        }
        if (!Objects.equals(this.additionalTrustBundlePolicy, that.additionalTrustBundlePolicy)) {
            return false;
        }
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals((Object)this.arbiter, (Object)that.arbiter)) {
            return false;
        }
        if (!Objects.equals(this.baseDomain, that.baseDomain)) {
            return false;
        }
        if (!Objects.equals((Object)this.bootstrapInPlace, (Object)that.bootstrapInPlace)) {
            return false;
        }
        if (!Objects.equals((Object)this.capabilities, (Object)that.capabilities)) {
            return false;
        }
        if (!Objects.equals(this.compute, that.compute)) {
            return false;
        }
        if (!Objects.equals((Object)this.controlPlane, (Object)that.controlPlane)) {
            return false;
        }
        if (!Objects.equals(this.cpuPartitioningMode, that.cpuPartitioningMode)) {
            return false;
        }
        if (!Objects.equals(this.credentialsMode, that.credentialsMode)) {
            return false;
        }
        if (!Objects.equals(this.featureGates, that.featureGates)) {
            return false;
        }
        if (!Objects.equals(this.featureSet, that.featureSet)) {
            return false;
        }
        if (!Objects.equals(this.fips, that.fips)) {
            return false;
        }
        if (!Objects.equals(this.imageContentSources, that.imageContentSources)) {
            return false;
        }
        if (!Objects.equals(this.imageDigestSources, that.imageDigestSources)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals((Object)this.networking, (Object)that.networking)) {
            return false;
        }
        if (!Objects.equals((Object)this.operatorPublishingStrategy, (Object)that.operatorPublishingStrategy)) {
            return false;
        }
        if (!Objects.equals((Object)this.platform, (Object)that.platform)) {
            return false;
        }
        if (!Objects.equals((Object)this.proxy, (Object)that.proxy)) {
            return false;
        }
        if (!Objects.equals(this.publish, that.publish)) {
            return false;
        }
        if (!Objects.equals(this.pullSecret, that.pullSecret)) {
            return false;
        }
        if (!Objects.equals(this.sshKey, that.sshKey)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getAdditionalTrustBundle() {
        return this.additionalTrustBundle;
    }

    public String getAdditionalTrustBundlePolicy() {
        return this.additionalTrustBundlePolicy;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getBaseDomain() {
        return this.baseDomain;
    }

    public String getCpuPartitioningMode() {
        return this.cpuPartitioningMode;
    }

    public String getCredentialsMode() {
        return this.credentialsMode;
    }

    public String getFeatureGate(int index) {
        return this.featureGates.get(index);
    }

    public List<String> getFeatureGates() {
        return this.featureGates;
    }

    public String getFeatureSet() {
        return this.featureSet;
    }

    public Boolean getFips() {
        return this.fips;
    }

    public String getFirstFeatureGate() {
        return this.featureGates.get(0);
    }

    public String getKind() {
        return this.kind;
    }

    public String getLastFeatureGate() {
        return this.featureGates.get(this.featureGates.size() - 1);
    }

    public String getMatchingFeatureGate(Predicate<String> predicate) {
        for (String item : this.featureGates) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getPublish() {
        return this.publish;
    }

    public String getPullSecret() {
        return this.pullSecret;
    }

    public String getSshKey() {
        return this.sshKey;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAdditionalTrustBundle() {
        return this.additionalTrustBundle != null;
    }

    public boolean hasAdditionalTrustBundlePolicy() {
        return this.additionalTrustBundlePolicy != null;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public boolean hasArbiter() {
        return this.arbiter != null;
    }

    public boolean hasBaseDomain() {
        return this.baseDomain != null;
    }

    public boolean hasBootstrapInPlace() {
        return this.bootstrapInPlace != null;
    }

    public boolean hasCapabilities() {
        return this.capabilities != null;
    }

    public boolean hasCompute() {
        return this.compute != null && !this.compute.isEmpty();
    }

    public boolean hasControlPlane() {
        return this.controlPlane != null;
    }

    public boolean hasCpuPartitioningMode() {
        return this.cpuPartitioningMode != null;
    }

    public boolean hasCredentialsMode() {
        return this.credentialsMode != null;
    }

    public boolean hasFeatureGates() {
        return this.featureGates != null && !this.featureGates.isEmpty();
    }

    public boolean hasFeatureSet() {
        return this.featureSet != null;
    }

    public boolean hasFips() {
        return this.fips != null;
    }

    public boolean hasImageContentSources() {
        return this.imageContentSources != null && !this.imageContentSources.isEmpty();
    }

    public boolean hasImageDigestSources() {
        return this.imageDigestSources != null && !this.imageDigestSources.isEmpty();
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public boolean hasMatchingCompute(Predicate<MachinePoolBuilder> predicate) {
        for (MachinePoolBuilder item : this.compute) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingFeatureGate(Predicate<String> predicate) {
        for (String item : this.featureGates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingImageContentSource(Predicate<ImageContentSourceBuilder> predicate) {
        for (ImageContentSourceBuilder item : this.imageContentSources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingImageDigestSource(Predicate<ImageDigestSourceBuilder> predicate) {
        for (ImageDigestSourceBuilder item : this.imageDigestSources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public boolean hasNetworking() {
        return this.networking != null;
    }

    public boolean hasOperatorPublishingStrategy() {
        return this.operatorPublishingStrategy != null;
    }

    public boolean hasPlatform() {
        return this.platform != null;
    }

    public boolean hasProxy() {
        return this.proxy != null;
    }

    public boolean hasPublish() {
        return this.publish != null;
    }

    public boolean hasPullSecret() {
        return this.pullSecret != null;
    }

    public boolean hasSshKey() {
        return this.sshKey != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalTrustBundle, this.additionalTrustBundlePolicy, this.apiVersion, this.arbiter, this.baseDomain, this.bootstrapInPlace, this.capabilities, this.compute, this.controlPlane, this.cpuPartitioningMode, this.credentialsMode, this.featureGates, this.featureSet, this.fips, this.imageContentSources, this.imageDigestSources, this.kind, this.metadata, this.networking, this.operatorPublishingStrategy, this.platform, this.proxy, this.publish, this.pullSecret, this.sshKey, this.additionalProperties});
    }

    public A removeAllFromCompute(Collection<MachinePool> items) {
        if (this.compute == null) {
            return (A)((Object)this);
        }
        for (MachinePool item : items) {
            MachinePoolBuilder builder = new MachinePoolBuilder(item);
            this._visitables.get((Object)"compute").remove((Object)builder);
            this.compute.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromFeatureGates(Collection<String> items) {
        if (this.featureGates == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.featureGates.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromImageContentSources(Collection<ImageContentSource> items) {
        if (this.imageContentSources == null) {
            return (A)((Object)this);
        }
        for (ImageContentSource item : items) {
            ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);
            this._visitables.get((Object)"imageContentSources").remove((Object)builder);
            this.imageContentSources.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromImageDigestSources(Collection<ImageDigestSource> items) {
        if (this.imageDigestSources == null) {
            return (A)((Object)this);
        }
        for (ImageDigestSource item : items) {
            ImageDigestSourceBuilder builder = new ImageDigestSourceBuilder(item);
            this._visitables.get((Object)"imageDigestSources").remove((Object)builder);
            this.imageDigestSources.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromCompute(MachinePool ... items) {
        if (this.compute == null) {
            return (A)((Object)this);
        }
        for (MachinePool item : items) {
            MachinePoolBuilder builder = new MachinePoolBuilder(item);
            this._visitables.get((Object)"compute").remove((Object)builder);
            this.compute.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromFeatureGates(String ... items) {
        if (this.featureGates == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.featureGates.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromImageContentSources(ImageContentSource ... items) {
        if (this.imageContentSources == null) {
            return (A)((Object)this);
        }
        for (ImageContentSource item : items) {
            ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);
            this._visitables.get((Object)"imageContentSources").remove((Object)builder);
            this.imageContentSources.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromImageDigestSources(ImageDigestSource ... items) {
        if (this.imageDigestSources == null) {
            return (A)((Object)this);
        }
        for (ImageDigestSource item : items) {
            ImageDigestSourceBuilder builder = new ImageDigestSourceBuilder(item);
            this._visitables.get((Object)"imageDigestSources").remove((Object)builder);
            this.imageDigestSources.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromCompute(Predicate<MachinePoolBuilder> predicate) {
        if (this.compute == null) {
            return (A)((Object)this);
        }
        Iterator<MachinePoolBuilder> each = this.compute.iterator();
        List visitables = this._visitables.get((Object)"compute");
        while (each.hasNext()) {
            MachinePoolBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromImageContentSources(Predicate<ImageContentSourceBuilder> predicate) {
        if (this.imageContentSources == null) {
            return (A)((Object)this);
        }
        Iterator<ImageContentSourceBuilder> each = this.imageContentSources.iterator();
        List visitables = this._visitables.get((Object)"imageContentSources");
        while (each.hasNext()) {
            ImageContentSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromImageDigestSources(Predicate<ImageDigestSourceBuilder> predicate) {
        if (this.imageDigestSources == null) {
            return (A)((Object)this);
        }
        Iterator<ImageDigestSourceBuilder> each = this.imageDigestSources.iterator();
        List visitables = this._visitables.get((Object)"imageDigestSources");
        while (each.hasNext()) {
            ImageDigestSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ComputeNested<A> setNewComputeLike(int index, MachinePool item) {
        return new ComputeNested(index, item);
    }

    public ImageContentSourcesNested<A> setNewImageContentSourceLike(int index, ImageContentSource item) {
        return new ImageContentSourcesNested(index, item);
    }

    public ImageDigestSourcesNested<A> setNewImageDigestSourceLike(int index, ImageDigestSource item) {
        return new ImageDigestSourcesNested(index, item);
    }

    public A setToCompute(int index, MachinePool item) {
        if (this.compute == null) {
            this.compute = new ArrayList();
        }
        MachinePoolBuilder builder = new MachinePoolBuilder(item);
        if (index < 0 || index >= this.compute.size()) {
            this._visitables.get((Object)"compute").add(builder);
            this.compute.add(builder);
        } else {
            this._visitables.get((Object)"compute").add(builder);
            this.compute.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToFeatureGates(int index, String item) {
        if (this.featureGates == null) {
            this.featureGates = new ArrayList<String>();
        }
        this.featureGates.set(index, item);
        return (A)((Object)this);
    }

    public A setToImageContentSources(int index, ImageContentSource item) {
        if (this.imageContentSources == null) {
            this.imageContentSources = new ArrayList();
        }
        ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);
        if (index < 0 || index >= this.imageContentSources.size()) {
            this._visitables.get((Object)"imageContentSources").add(builder);
            this.imageContentSources.add(builder);
        } else {
            this._visitables.get((Object)"imageContentSources").add(builder);
            this.imageContentSources.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToImageDigestSources(int index, ImageDigestSource item) {
        if (this.imageDigestSources == null) {
            this.imageDigestSources = new ArrayList();
        }
        ImageDigestSourceBuilder builder = new ImageDigestSourceBuilder(item);
        if (index < 0 || index >= this.imageDigestSources.size()) {
            this._visitables.get((Object)"imageDigestSources").add(builder);
            this.imageDigestSources.add(builder);
        } else {
            this._visitables.get((Object)"imageDigestSources").add(builder);
            this.imageDigestSources.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.additionalTrustBundle != null) {
            sb.append("additionalTrustBundle:");
            sb.append(this.additionalTrustBundle);
            sb.append(",");
        }
        if (this.additionalTrustBundlePolicy != null) {
            sb.append("additionalTrustBundlePolicy:");
            sb.append(this.additionalTrustBundlePolicy);
            sb.append(",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion);
            sb.append(",");
        }
        if (this.arbiter != null) {
            sb.append("arbiter:");
            sb.append((Object)this.arbiter);
            sb.append(",");
        }
        if (this.baseDomain != null) {
            sb.append("baseDomain:");
            sb.append(this.baseDomain);
            sb.append(",");
        }
        if (this.bootstrapInPlace != null) {
            sb.append("bootstrapInPlace:");
            sb.append((Object)this.bootstrapInPlace);
            sb.append(",");
        }
        if (this.capabilities != null) {
            sb.append("capabilities:");
            sb.append((Object)this.capabilities);
            sb.append(",");
        }
        if (this.compute != null && !this.compute.isEmpty()) {
            sb.append("compute:");
            sb.append(this.compute);
            sb.append(",");
        }
        if (this.controlPlane != null) {
            sb.append("controlPlane:");
            sb.append((Object)this.controlPlane);
            sb.append(",");
        }
        if (this.cpuPartitioningMode != null) {
            sb.append("cpuPartitioningMode:");
            sb.append(this.cpuPartitioningMode);
            sb.append(",");
        }
        if (this.credentialsMode != null) {
            sb.append("credentialsMode:");
            sb.append(this.credentialsMode);
            sb.append(",");
        }
        if (this.featureGates != null && !this.featureGates.isEmpty()) {
            sb.append("featureGates:");
            sb.append(this.featureGates);
            sb.append(",");
        }
        if (this.featureSet != null) {
            sb.append("featureSet:");
            sb.append(this.featureSet);
            sb.append(",");
        }
        if (this.fips != null) {
            sb.append("fips:");
            sb.append(this.fips);
            sb.append(",");
        }
        if (this.imageContentSources != null && !this.imageContentSources.isEmpty()) {
            sb.append("imageContentSources:");
            sb.append(this.imageContentSources);
            sb.append(",");
        }
        if (this.imageDigestSources != null && !this.imageDigestSources.isEmpty()) {
            sb.append("imageDigestSources:");
            sb.append(this.imageDigestSources);
            sb.append(",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
            sb.append(",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
            sb.append(",");
        }
        if (this.networking != null) {
            sb.append("networking:");
            sb.append((Object)this.networking);
            sb.append(",");
        }
        if (this.operatorPublishingStrategy != null) {
            sb.append("operatorPublishingStrategy:");
            sb.append((Object)this.operatorPublishingStrategy);
            sb.append(",");
        }
        if (this.platform != null) {
            sb.append("platform:");
            sb.append((Object)this.platform);
            sb.append(",");
        }
        if (this.proxy != null) {
            sb.append("proxy:");
            sb.append((Object)this.proxy);
            sb.append(",");
        }
        if (this.publish != null) {
            sb.append("publish:");
            sb.append(this.publish);
            sb.append(",");
        }
        if (this.pullSecret != null) {
            sb.append("pullSecret:");
            sb.append(this.pullSecret);
            sb.append(",");
        }
        if (this.sshKey != null) {
            sb.append("sshKey:");
            sb.append(this.sshKey);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAdditionalTrustBundle(String additionalTrustBundle) {
        this.additionalTrustBundle = additionalTrustBundle;
        return (A)((Object)this);
    }

    public A withAdditionalTrustBundlePolicy(String additionalTrustBundlePolicy) {
        this.additionalTrustBundlePolicy = additionalTrustBundlePolicy;
        return (A)((Object)this);
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public A withArbiter(MachinePool arbiter) {
        this._visitables.remove((Object)"arbiter");
        if (arbiter != null) {
            this.arbiter = new MachinePoolBuilder(arbiter);
            this._visitables.get((Object)"arbiter").add(this.arbiter);
        } else {
            this.arbiter = null;
            this._visitables.get((Object)"arbiter").remove((Object)this.arbiter);
        }
        return (A)((Object)this);
    }

    public A withBaseDomain(String baseDomain) {
        this.baseDomain = baseDomain;
        return (A)((Object)this);
    }

    public A withBootstrapInPlace(BootstrapInPlace bootstrapInPlace) {
        this._visitables.remove((Object)"bootstrapInPlace");
        if (bootstrapInPlace != null) {
            this.bootstrapInPlace = new BootstrapInPlaceBuilder(bootstrapInPlace);
            this._visitables.get((Object)"bootstrapInPlace").add(this.bootstrapInPlace);
        } else {
            this.bootstrapInPlace = null;
            this._visitables.get((Object)"bootstrapInPlace").remove((Object)this.bootstrapInPlace);
        }
        return (A)((Object)this);
    }

    public A withCapabilities(Capabilities capabilities) {
        this._visitables.remove((Object)"capabilities");
        if (capabilities != null) {
            this.capabilities = new CapabilitiesBuilder(capabilities);
            this._visitables.get((Object)"capabilities").add(this.capabilities);
        } else {
            this.capabilities = null;
            this._visitables.get((Object)"capabilities").remove((Object)this.capabilities);
        }
        return (A)((Object)this);
    }

    public A withCompute(List<MachinePool> compute) {
        if (this.compute != null) {
            this._visitables.get((Object)"compute").clear();
        }
        if (compute != null) {
            this.compute = new ArrayList();
            for (MachinePool item : compute) {
                this.addToCompute(item);
            }
        } else {
            this.compute = null;
        }
        return (A)((Object)this);
    }

    public A withCompute(MachinePool ... compute) {
        if (this.compute != null) {
            this.compute.clear();
            this._visitables.remove((Object)"compute");
        }
        if (compute != null) {
            for (MachinePool item : compute) {
                this.addToCompute(item);
            }
        }
        return (A)((Object)this);
    }

    public A withControlPlane(MachinePool controlPlane) {
        this._visitables.remove((Object)"controlPlane");
        if (controlPlane != null) {
            this.controlPlane = new MachinePoolBuilder(controlPlane);
            this._visitables.get((Object)"controlPlane").add(this.controlPlane);
        } else {
            this.controlPlane = null;
            this._visitables.get((Object)"controlPlane").remove((Object)this.controlPlane);
        }
        return (A)((Object)this);
    }

    public A withCpuPartitioningMode(String cpuPartitioningMode) {
        this.cpuPartitioningMode = cpuPartitioningMode;
        return (A)((Object)this);
    }

    public A withCredentialsMode(String credentialsMode) {
        this.credentialsMode = credentialsMode;
        return (A)((Object)this);
    }

    public A withFeatureGates(List<String> featureGates) {
        if (featureGates != null) {
            this.featureGates = new ArrayList<String>();
            for (String item : featureGates) {
                this.addToFeatureGates(item);
            }
        } else {
            this.featureGates = null;
        }
        return (A)((Object)this);
    }

    public A withFeatureGates(String ... featureGates) {
        if (this.featureGates != null) {
            this.featureGates.clear();
            this._visitables.remove((Object)"featureGates");
        }
        if (featureGates != null) {
            for (String item : featureGates) {
                this.addToFeatureGates(item);
            }
        }
        return (A)((Object)this);
    }

    public A withFeatureSet(String featureSet) {
        this.featureSet = featureSet;
        return (A)((Object)this);
    }

    public A withFips() {
        return this.withFips(true);
    }

    public A withFips(Boolean fips) {
        this.fips = fips;
        return (A)((Object)this);
    }

    public A withImageContentSources(List<ImageContentSource> imageContentSources) {
        if (this.imageContentSources != null) {
            this._visitables.get((Object)"imageContentSources").clear();
        }
        if (imageContentSources != null) {
            this.imageContentSources = new ArrayList();
            for (ImageContentSource item : imageContentSources) {
                this.addToImageContentSources(item);
            }
        } else {
            this.imageContentSources = null;
        }
        return (A)((Object)this);
    }

    public A withImageContentSources(ImageContentSource ... imageContentSources) {
        if (this.imageContentSources != null) {
            this.imageContentSources.clear();
            this._visitables.remove((Object)"imageContentSources");
        }
        if (imageContentSources != null) {
            for (ImageContentSource item : imageContentSources) {
                this.addToImageContentSources(item);
            }
        }
        return (A)((Object)this);
    }

    public A withImageDigestSources(List<ImageDigestSource> imageDigestSources) {
        if (this.imageDigestSources != null) {
            this._visitables.get((Object)"imageDigestSources").clear();
        }
        if (imageDigestSources != null) {
            this.imageDigestSources = new ArrayList();
            for (ImageDigestSource item : imageDigestSources) {
                this.addToImageDigestSources(item);
            }
        } else {
            this.imageDigestSources = null;
        }
        return (A)((Object)this);
    }

    public A withImageDigestSources(ImageDigestSource ... imageDigestSources) {
        if (this.imageDigestSources != null) {
            this.imageDigestSources.clear();
            this._visitables.remove((Object)"imageDigestSources");
        }
        if (imageDigestSources != null) {
            for (ImageDigestSource item : imageDigestSources) {
                this.addToImageDigestSources(item);
            }
        }
        return (A)((Object)this);
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove((Object)"metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)((Object)this);
    }

    public A withNetworking(Networking networking) {
        this._visitables.remove((Object)"networking");
        if (networking != null) {
            this.networking = new NetworkingBuilder(networking);
            this._visitables.get((Object)"networking").add(this.networking);
        } else {
            this.networking = null;
            this._visitables.get((Object)"networking").remove((Object)this.networking);
        }
        return (A)((Object)this);
    }

    public ArbiterNested<A> withNewArbiter() {
        return new ArbiterNested(null);
    }

    public ArbiterNested<A> withNewArbiterLike(MachinePool item) {
        return new ArbiterNested(item);
    }

    public BootstrapInPlaceNested<A> withNewBootstrapInPlace() {
        return new BootstrapInPlaceNested(null);
    }

    public A withNewBootstrapInPlace(String installationDisk) {
        return this.withBootstrapInPlace(new BootstrapInPlace(installationDisk));
    }

    public BootstrapInPlaceNested<A> withNewBootstrapInPlaceLike(BootstrapInPlace item) {
        return new BootstrapInPlaceNested(item);
    }

    public CapabilitiesNested<A> withNewCapabilities() {
        return new CapabilitiesNested(null);
    }

    public CapabilitiesNested<A> withNewCapabilitiesLike(Capabilities item) {
        return new CapabilitiesNested(item);
    }

    public ControlPlaneNested<A> withNewControlPlane() {
        return new ControlPlaneNested(null);
    }

    public ControlPlaneNested<A> withNewControlPlaneLike(MachinePool item) {
        return new ControlPlaneNested(item);
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public NetworkingNested<A> withNewNetworking() {
        return new NetworkingNested(null);
    }

    public NetworkingNested<A> withNewNetworkingLike(Networking item) {
        return new NetworkingNested(item);
    }

    public OperatorPublishingStrategyNested<A> withNewOperatorPublishingStrategy() {
        return new OperatorPublishingStrategyNested(null);
    }

    public A withNewOperatorPublishingStrategy(String apiserver, String ingress) {
        return this.withOperatorPublishingStrategy(new OperatorPublishingStrategy(apiserver, ingress));
    }

    public OperatorPublishingStrategyNested<A> withNewOperatorPublishingStrategyLike(OperatorPublishingStrategy item) {
        return new OperatorPublishingStrategyNested(item);
    }

    public PlatformNested<A> withNewPlatform() {
        return new PlatformNested(null);
    }

    public PlatformNested<A> withNewPlatformLike(Platform item) {
        return new PlatformNested(item);
    }

    public ProxyNested<A> withNewProxy() {
        return new ProxyNested(null);
    }

    public A withNewProxy(String httpProxy, String httpsProxy, String noProxy) {
        return this.withProxy(new Proxy(httpProxy, httpsProxy, noProxy));
    }

    public ProxyNested<A> withNewProxyLike(Proxy item) {
        return new ProxyNested(item);
    }

    public A withOperatorPublishingStrategy(OperatorPublishingStrategy operatorPublishingStrategy) {
        this._visitables.remove((Object)"operatorPublishingStrategy");
        if (operatorPublishingStrategy != null) {
            this.operatorPublishingStrategy = new OperatorPublishingStrategyBuilder(operatorPublishingStrategy);
            this._visitables.get((Object)"operatorPublishingStrategy").add(this.operatorPublishingStrategy);
        } else {
            this.operatorPublishingStrategy = null;
            this._visitables.get((Object)"operatorPublishingStrategy").remove((Object)this.operatorPublishingStrategy);
        }
        return (A)((Object)this);
    }

    public A withPlatform(Platform platform) {
        this._visitables.remove((Object)"platform");
        if (platform != null) {
            this.platform = new PlatformBuilder(platform);
            this._visitables.get((Object)"platform").add(this.platform);
        } else {
            this.platform = null;
            this._visitables.get((Object)"platform").remove((Object)this.platform);
        }
        return (A)((Object)this);
    }

    public A withProxy(Proxy proxy) {
        this._visitables.remove((Object)"proxy");
        if (proxy != null) {
            this.proxy = new ProxyBuilder(proxy);
            this._visitables.get((Object)"proxy").add(this.proxy);
        } else {
            this.proxy = null;
            this._visitables.get((Object)"proxy").remove((Object)this.proxy);
        }
        return (A)((Object)this);
    }

    public A withPublish(String publish) {
        this.publish = publish;
        return (A)((Object)this);
    }

    public A withPullSecret(String pullSecret) {
        this.pullSecret = pullSecret;
        return (A)((Object)this);
    }

    public A withSshKey(String sshKey) {
        this.sshKey = sshKey;
        return (A)((Object)this);
    }

    public class ProxyNested<N>
    extends ProxyFluent<ProxyNested<N>>
    implements Nested<N> {
        ProxyBuilder builder;

        ProxyNested(Proxy item) {
            this.builder = new ProxyBuilder(this, item);
        }

        public N and() {
            return (N)InstallConfigFluent.this.withProxy(this.builder.build());
        }

        public N endProxy() {
            return this.and();
        }
    }

    public class PlatformNested<N>
    extends PlatformFluent<PlatformNested<N>>
    implements Nested<N> {
        PlatformBuilder builder;

        PlatformNested(Platform item) {
            this.builder = new PlatformBuilder(this, item);
        }

        public N and() {
            return (N)InstallConfigFluent.this.withPlatform(this.builder.build());
        }

        public N endPlatform() {
            return this.and();
        }
    }

    public class OperatorPublishingStrategyNested<N>
    extends OperatorPublishingStrategyFluent<OperatorPublishingStrategyNested<N>>
    implements Nested<N> {
        OperatorPublishingStrategyBuilder builder;

        OperatorPublishingStrategyNested(OperatorPublishingStrategy item) {
            this.builder = new OperatorPublishingStrategyBuilder(this, item);
        }

        public N and() {
            return (N)InstallConfigFluent.this.withOperatorPublishingStrategy(this.builder.build());
        }

        public N endOperatorPublishingStrategy() {
            return this.and();
        }
    }

    public class NetworkingNested<N>
    extends NetworkingFluent<NetworkingNested<N>>
    implements Nested<N> {
        NetworkingBuilder builder;

        NetworkingNested(Networking item) {
            this.builder = new NetworkingBuilder(this, item);
        }

        public N and() {
            return (N)InstallConfigFluent.this.withNetworking(this.builder.build());
        }

        public N endNetworking() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        public N and() {
            return (N)InstallConfigFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class ImageDigestSourcesNested<N>
    extends ImageDigestSourceFluent<ImageDigestSourcesNested<N>>
    implements Nested<N> {
        ImageDigestSourceBuilder builder;
        int index;

        ImageDigestSourcesNested(int index, ImageDigestSource item) {
            this.index = index;
            this.builder = new ImageDigestSourceBuilder(this, item);
        }

        public N and() {
            return (N)InstallConfigFluent.this.setToImageDigestSources(this.index, this.builder.build());
        }

        public N endImageDigestSource() {
            return this.and();
        }
    }

    public class ImageContentSourcesNested<N>
    extends ImageContentSourceFluent<ImageContentSourcesNested<N>>
    implements Nested<N> {
        ImageContentSourceBuilder builder;
        int index;

        ImageContentSourcesNested(int index, ImageContentSource item) {
            this.index = index;
            this.builder = new ImageContentSourceBuilder(this, item);
        }

        public N and() {
            return (N)InstallConfigFluent.this.setToImageContentSources(this.index, this.builder.build());
        }

        public N endImageContentSource() {
            return this.and();
        }
    }

    public class ControlPlaneNested<N>
    extends MachinePoolFluent<ControlPlaneNested<N>>
    implements Nested<N> {
        MachinePoolBuilder builder;

        ControlPlaneNested(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        public N and() {
            return (N)InstallConfigFluent.this.withControlPlane(this.builder.build());
        }

        public N endControlPlane() {
            return this.and();
        }
    }

    public class ComputeNested<N>
    extends MachinePoolFluent<ComputeNested<N>>
    implements Nested<N> {
        MachinePoolBuilder builder;
        int index;

        ComputeNested(int index, MachinePool item) {
            this.index = index;
            this.builder = new MachinePoolBuilder(this, item);
        }

        public N and() {
            return (N)InstallConfigFluent.this.setToCompute(this.index, this.builder.build());
        }

        public N endCompute() {
            return this.and();
        }
    }

    public class CapabilitiesNested<N>
    extends CapabilitiesFluent<CapabilitiesNested<N>>
    implements Nested<N> {
        CapabilitiesBuilder builder;

        CapabilitiesNested(Capabilities item) {
            this.builder = new CapabilitiesBuilder(this, item);
        }

        public N and() {
            return (N)InstallConfigFluent.this.withCapabilities(this.builder.build());
        }

        public N endCapabilities() {
            return this.and();
        }
    }

    public class BootstrapInPlaceNested<N>
    extends BootstrapInPlaceFluent<BootstrapInPlaceNested<N>>
    implements Nested<N> {
        BootstrapInPlaceBuilder builder;

        BootstrapInPlaceNested(BootstrapInPlace item) {
            this.builder = new BootstrapInPlaceBuilder(this, item);
        }

        public N and() {
            return (N)InstallConfigFluent.this.withBootstrapInPlace(this.builder.build());
        }

        public N endBootstrapInPlace() {
            return this.and();
        }
    }

    public class ArbiterNested<N>
    extends MachinePoolFluent<ArbiterNested<N>>
    implements Nested<N> {
        MachinePoolBuilder builder;

        ArbiterNested(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        public N and() {
            return (N)InstallConfigFluent.this.withArbiter(this.builder.build());
        }

        public N endArbiter() {
            return this.and();
        }
    }
}

