/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.aws.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.aws.v1.Subnet;
import io.fabric8.openshift.api.model.installer.aws.v1.SubnetRole;
import io.fabric8.openshift.api.model.installer.aws.v1.SubnetRoleBuilder;
import io.fabric8.openshift.api.model.installer.aws.v1.SubnetRoleFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class SubnetFluent<A extends SubnetFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String id;
    private ArrayList<SubnetRoleBuilder> roles = new ArrayList();

    public SubnetFluent() {
    }

    public SubnetFluent(Subnet instance) {
        this.copyInstance(instance);
    }

    public A addAllToRoles(Collection<SubnetRole> items) {
        if (this.roles == null) {
            this.roles = new ArrayList();
        }
        for (SubnetRole item : items) {
            SubnetRoleBuilder builder = new SubnetRoleBuilder(item);
            this._visitables.get((Object)"roles").add(builder);
            this.roles.add(builder);
        }
        return (A)((Object)this);
    }

    public RolesNested<A> addNewRole() {
        return new RolesNested(-1, null);
    }

    public A addNewRole(String type) {
        return this.addToRoles(new SubnetRole(type));
    }

    public RolesNested<A> addNewRoleLike(SubnetRole item) {
        return new RolesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToRoles(SubnetRole ... items) {
        if (this.roles == null) {
            this.roles = new ArrayList();
        }
        for (SubnetRole item : items) {
            SubnetRoleBuilder builder = new SubnetRoleBuilder(item);
            this._visitables.get((Object)"roles").add(builder);
            this.roles.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToRoles(int index, SubnetRole item) {
        if (this.roles == null) {
            this.roles = new ArrayList();
        }
        SubnetRoleBuilder builder = new SubnetRoleBuilder(item);
        if (index < 0 || index >= this.roles.size()) {
            this._visitables.get((Object)"roles").add(builder);
            this.roles.add(builder);
        } else {
            this._visitables.get((Object)"roles").add(builder);
            this.roles.add(index, builder);
        }
        return (A)((Object)this);
    }

    public SubnetRole buildFirstRole() {
        return this.roles.get(0).build();
    }

    public SubnetRole buildLastRole() {
        return this.roles.get(this.roles.size() - 1).build();
    }

    public SubnetRole buildMatchingRole(Predicate<SubnetRoleBuilder> predicate) {
        for (SubnetRoleBuilder item : this.roles) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public SubnetRole buildRole(int index) {
        return this.roles.get(index).build();
    }

    public List<SubnetRole> buildRoles() {
        return this.roles != null ? SubnetFluent.build(this.roles) : null;
    }

    protected void copyInstance(Subnet instance) {
        Subnet subnet = instance = instance != null ? instance : new Subnet();
        if (instance != null) {
            this.withId(instance.getId());
            this.withRoles(instance.getRoles());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public RolesNested<A> editFirstRole() {
        if (this.roles.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "roles"));
        }
        return this.setNewRoleLike(0, this.buildRole(0));
    }

    public RolesNested<A> editLastRole() {
        int index = this.roles.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "roles"));
        }
        return this.setNewRoleLike(index, this.buildRole(index));
    }

    public RolesNested<A> editMatchingRole(Predicate<SubnetRoleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.roles.size(); ++i) {
            if (!predicate.test(this.roles.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "roles"));
        }
        return this.setNewRoleLike(index, this.buildRole(index));
    }

    public RolesNested<A> editRole(int index) {
        if (this.roles.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "roles"));
        }
        return this.setNewRoleLike(index, this.buildRole(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubnetFluent that = (SubnetFluent)((Object)o);
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.roles, that.roles)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getId() {
        return this.id;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasId() {
        return this.id != null;
    }

    public boolean hasMatchingRole(Predicate<SubnetRoleBuilder> predicate) {
        for (SubnetRoleBuilder item : this.roles) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRoles() {
        return this.roles != null && !this.roles.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.roles, this.additionalProperties);
    }

    public A removeAllFromRoles(Collection<SubnetRole> items) {
        if (this.roles == null) {
            return (A)((Object)this);
        }
        for (SubnetRole item : items) {
            SubnetRoleBuilder builder = new SubnetRoleBuilder(item);
            this._visitables.get((Object)"roles").remove((Object)builder);
            this.roles.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromRoles(SubnetRole ... items) {
        if (this.roles == null) {
            return (A)((Object)this);
        }
        for (SubnetRole item : items) {
            SubnetRoleBuilder builder = new SubnetRoleBuilder(item);
            this._visitables.get((Object)"roles").remove((Object)builder);
            this.roles.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRoles(Predicate<SubnetRoleBuilder> predicate) {
        if (this.roles == null) {
            return (A)((Object)this);
        }
        Iterator<SubnetRoleBuilder> each = this.roles.iterator();
        List visitables = this._visitables.get((Object)"roles");
        while (each.hasNext()) {
            SubnetRoleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public RolesNested<A> setNewRoleLike(int index, SubnetRole item) {
        return new RolesNested(index, item);
    }

    public A setToRoles(int index, SubnetRole item) {
        if (this.roles == null) {
            this.roles = new ArrayList();
        }
        SubnetRoleBuilder builder = new SubnetRoleBuilder(item);
        if (index < 0 || index >= this.roles.size()) {
            this._visitables.get((Object)"roles").add(builder);
            this.roles.add(builder);
        } else {
            this._visitables.get((Object)"roles").add(builder);
            this.roles.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id != null) {
            sb.append("id:");
            sb.append(this.id);
            sb.append(",");
        }
        if (this.roles != null && !this.roles.isEmpty()) {
            sb.append("roles:");
            sb.append(this.roles);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withId(String id) {
        this.id = id;
        return (A)((Object)this);
    }

    public A withRoles(List<SubnetRole> roles) {
        if (this.roles != null) {
            this._visitables.get((Object)"roles").clear();
        }
        if (roles != null) {
            this.roles = new ArrayList();
            for (SubnetRole item : roles) {
                this.addToRoles(item);
            }
        } else {
            this.roles = null;
        }
        return (A)((Object)this);
    }

    public A withRoles(SubnetRole ... roles) {
        if (this.roles != null) {
            this.roles.clear();
            this._visitables.remove((Object)"roles");
        }
        if (roles != null) {
            for (SubnetRole item : roles) {
                this.addToRoles(item);
            }
        }
        return (A)((Object)this);
    }

    public class RolesNested<N>
    extends SubnetRoleFluent<RolesNested<N>>
    implements Nested<N> {
        SubnetRoleBuilder builder;
        int index;

        RolesNested(int index, SubnetRole item) {
            this.index = index;
            this.builder = new SubnetRoleBuilder(this, item);
        }

        public N and() {
            return (N)SubnetFluent.this.setToRoles(this.index, this.builder.build());
        }

        public N endRole() {
            return this.and();
        }
    }
}

