/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.aws.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.aws.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.aws.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.installer.aws.v1.MachinePoolFluent;
import io.fabric8.openshift.api.model.installer.aws.v1.Platform;
import io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint;
import io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder;
import io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointFluent;
import io.fabric8.openshift.api.model.installer.aws.v1.VPC;
import io.fabric8.openshift.api.model.installer.aws.v1.VPCBuilder;
import io.fabric8.openshift.api.model.installer.aws.v1.VPCFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PlatformFluent<A extends PlatformFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String amiID;
    private Boolean bestEffortDeleteIgnition;
    private MachinePoolBuilder defaultMachinePlatform;
    private String hostedZone;
    private String hostedZoneRole;
    private String lbType;
    private Boolean preserveBootstrapIgnition;
    private Boolean propagateUserTags;
    private String publicIpv4Pool;
    private String region;
    private ArrayList<ServiceEndpointBuilder> serviceEndpoints = new ArrayList();
    private List<String> subnets = new ArrayList<String>();
    private String userProvisionedDNS;
    private Map<String, String> userTags;
    private VPCBuilder vpc;

    public PlatformFluent() {
    }

    public PlatformFluent(Platform instance) {
        this.copyInstance(instance);
    }

    public A addAllToServiceEndpoints(Collection<ServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        for (ServiceEndpoint item : items) {
            ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
            this._visitables.get((Object)"serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSubnets(Collection<String> items) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        for (String item : items) {
            this.subnets.add(item);
        }
        return (A)((Object)this);
    }

    public ServiceEndpointsNested<A> addNewServiceEndpoint() {
        return new ServiceEndpointsNested(-1, null);
    }

    public A addNewServiceEndpoint(String name, String url) {
        return this.addToServiceEndpoints(new ServiceEndpoint(name, url));
    }

    public ServiceEndpointsNested<A> addNewServiceEndpointLike(ServiceEndpoint item) {
        return new ServiceEndpointsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToServiceEndpoints(ServiceEndpoint ... items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        for (ServiceEndpoint item : items) {
            ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
            this._visitables.get((Object)"serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToServiceEndpoints(int index, ServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
        if (index < 0 || index >= this.serviceEndpoints.size()) {
            this._visitables.get((Object)"serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        } else {
            this._visitables.get((Object)"serviceEndpoints").add(builder);
            this.serviceEndpoints.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSubnets(String ... items) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        for (String item : items) {
            this.subnets.add(item);
        }
        return (A)((Object)this);
    }

    public A addToSubnets(int index, String item) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        this.subnets.add(index, item);
        return (A)((Object)this);
    }

    public A addToUserTags(Map<String, String> map) {
        if (this.userTags == null && map != null) {
            this.userTags = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.userTags.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToUserTags(String key, String value) {
        if (this.userTags == null && key != null && value != null) {
            this.userTags = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.userTags.put(key, value);
        }
        return (A)((Object)this);
    }

    public MachinePool buildDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    public ServiceEndpoint buildFirstServiceEndpoint() {
        return this.serviceEndpoints.get(0).build();
    }

    public ServiceEndpoint buildLastServiceEndpoint() {
        return this.serviceEndpoints.get(this.serviceEndpoints.size() - 1).build();
    }

    public ServiceEndpoint buildMatchingServiceEndpoint(Predicate<ServiceEndpointBuilder> predicate) {
        for (ServiceEndpointBuilder item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public ServiceEndpoint buildServiceEndpoint(int index) {
        return this.serviceEndpoints.get(index).build();
    }

    public List<ServiceEndpoint> buildServiceEndpoints() {
        return this.serviceEndpoints != null ? PlatformFluent.build(this.serviceEndpoints) : null;
    }

    public VPC buildVpc() {
        return this.vpc != null ? this.vpc.build() : null;
    }

    protected void copyInstance(Platform instance) {
        Platform platform = instance = instance != null ? instance : new Platform();
        if (instance != null) {
            this.withAmiID(instance.getAmiID());
            this.withBestEffortDeleteIgnition(instance.getBestEffortDeleteIgnition());
            this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
            this.withHostedZone(instance.getHostedZone());
            this.withHostedZoneRole(instance.getHostedZoneRole());
            this.withLbType(instance.getLbType());
            this.withPreserveBootstrapIgnition(instance.getPreserveBootstrapIgnition());
            this.withPropagateUserTags(instance.getPropagateUserTags());
            this.withPublicIpv4Pool(instance.getPublicIpv4Pool());
            this.withRegion(instance.getRegion());
            this.withServiceEndpoints(instance.getServiceEndpoints());
            this.withSubnets(instance.getSubnets());
            this.withUserProvisionedDNS(instance.getUserProvisionedDNS());
            this.withUserTags(instance.getUserTags());
            this.withVpc(instance.getVpc());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(null));
    }

    public ServiceEndpointsNested<A> editFirstServiceEndpoint() {
        if (this.serviceEndpoints.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "serviceEndpoints"));
        }
        return this.setNewServiceEndpointLike(0, this.buildServiceEndpoint(0));
    }

    public ServiceEndpointsNested<A> editLastServiceEndpoint() {
        int index = this.serviceEndpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "serviceEndpoints"));
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    public ServiceEndpointsNested<A> editMatchingServiceEndpoint(Predicate<ServiceEndpointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.serviceEndpoints.size(); ++i) {
            if (!predicate.test(this.serviceEndpoints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "serviceEndpoints"));
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(new MachinePoolBuilder().build()));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(item));
    }

    public VpcNested<A> editOrNewVpc() {
        return this.withNewVpcLike(Optional.ofNullable(this.buildVpc()).orElse(new VPCBuilder().build()));
    }

    public VpcNested<A> editOrNewVpcLike(VPC item) {
        return this.withNewVpcLike(Optional.ofNullable(this.buildVpc()).orElse(item));
    }

    public ServiceEndpointsNested<A> editServiceEndpoint(int index) {
        if (this.serviceEndpoints.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "serviceEndpoints"));
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    public VpcNested<A> editVpc() {
        return this.withNewVpcLike(Optional.ofNullable(this.buildVpc()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlatformFluent that = (PlatformFluent)((Object)o);
        if (!Objects.equals(this.amiID, that.amiID)) {
            return false;
        }
        if (!Objects.equals(this.bestEffortDeleteIgnition, that.bestEffortDeleteIgnition)) {
            return false;
        }
        if (!Objects.equals((Object)this.defaultMachinePlatform, (Object)that.defaultMachinePlatform)) {
            return false;
        }
        if (!Objects.equals(this.hostedZone, that.hostedZone)) {
            return false;
        }
        if (!Objects.equals(this.hostedZoneRole, that.hostedZoneRole)) {
            return false;
        }
        if (!Objects.equals(this.lbType, that.lbType)) {
            return false;
        }
        if (!Objects.equals(this.preserveBootstrapIgnition, that.preserveBootstrapIgnition)) {
            return false;
        }
        if (!Objects.equals(this.propagateUserTags, that.propagateUserTags)) {
            return false;
        }
        if (!Objects.equals(this.publicIpv4Pool, that.publicIpv4Pool)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.serviceEndpoints, that.serviceEndpoints)) {
            return false;
        }
        if (!Objects.equals(this.subnets, that.subnets)) {
            return false;
        }
        if (!Objects.equals(this.userProvisionedDNS, that.userProvisionedDNS)) {
            return false;
        }
        if (!Objects.equals(this.userTags, that.userTags)) {
            return false;
        }
        if (!Objects.equals((Object)this.vpc, (Object)that.vpc)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getAmiID() {
        return this.amiID;
    }

    public Boolean getBestEffortDeleteIgnition() {
        return this.bestEffortDeleteIgnition;
    }

    public String getFirstSubnet() {
        return this.subnets.get(0);
    }

    public String getHostedZone() {
        return this.hostedZone;
    }

    public String getHostedZoneRole() {
        return this.hostedZoneRole;
    }

    public String getLastSubnet() {
        return this.subnets.get(this.subnets.size() - 1);
    }

    public String getLbType() {
        return this.lbType;
    }

    public String getMatchingSubnet(Predicate<String> predicate) {
        for (String item : this.subnets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public Boolean getPreserveBootstrapIgnition() {
        return this.preserveBootstrapIgnition;
    }

    public Boolean getPropagateUserTags() {
        return this.propagateUserTags;
    }

    public String getPublicIpv4Pool() {
        return this.publicIpv4Pool;
    }

    public String getRegion() {
        return this.region;
    }

    public String getSubnet(int index) {
        return this.subnets.get(index);
    }

    public List<String> getSubnets() {
        return this.subnets;
    }

    public String getUserProvisionedDNS() {
        return this.userProvisionedDNS;
    }

    public Map<String, String> getUserTags() {
        return this.userTags;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAmiID() {
        return this.amiID != null;
    }

    public boolean hasBestEffortDeleteIgnition() {
        return this.bestEffortDeleteIgnition != null;
    }

    public boolean hasDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null;
    }

    public boolean hasHostedZone() {
        return this.hostedZone != null;
    }

    public boolean hasHostedZoneRole() {
        return this.hostedZoneRole != null;
    }

    public boolean hasLbType() {
        return this.lbType != null;
    }

    public boolean hasMatchingServiceEndpoint(Predicate<ServiceEndpointBuilder> predicate) {
        for (ServiceEndpointBuilder item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingSubnet(Predicate<String> predicate) {
        for (String item : this.subnets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPreserveBootstrapIgnition() {
        return this.preserveBootstrapIgnition != null;
    }

    public boolean hasPropagateUserTags() {
        return this.propagateUserTags != null;
    }

    public boolean hasPublicIpv4Pool() {
        return this.publicIpv4Pool != null;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public boolean hasServiceEndpoints() {
        return this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty();
    }

    public boolean hasSubnets() {
        return this.subnets != null && !this.subnets.isEmpty();
    }

    public boolean hasUserProvisionedDNS() {
        return this.userProvisionedDNS != null;
    }

    public boolean hasUserTags() {
        return this.userTags != null;
    }

    public boolean hasVpc() {
        return this.vpc != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amiID, this.bestEffortDeleteIgnition, this.defaultMachinePlatform, this.hostedZone, this.hostedZoneRole, this.lbType, this.preserveBootstrapIgnition, this.propagateUserTags, this.publicIpv4Pool, this.region, this.serviceEndpoints, this.subnets, this.userProvisionedDNS, this.userTags, this.vpc, this.additionalProperties});
    }

    public A removeAllFromServiceEndpoints(Collection<ServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {
            return (A)((Object)this);
        }
        for (ServiceEndpoint item : items) {
            ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
            this._visitables.get((Object)"serviceEndpoints").remove((Object)builder);
            this.serviceEndpoints.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSubnets(Collection<String> items) {
        if (this.subnets == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.subnets.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromServiceEndpoints(ServiceEndpoint ... items) {
        if (this.serviceEndpoints == null) {
            return (A)((Object)this);
        }
        for (ServiceEndpoint item : items) {
            ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
            this._visitables.get((Object)"serviceEndpoints").remove((Object)builder);
            this.serviceEndpoints.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSubnets(String ... items) {
        if (this.subnets == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.subnets.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromUserTags(String key) {
        if (this.userTags == null) {
            return (A)((Object)this);
        }
        if (key != null && this.userTags != null) {
            this.userTags.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromUserTags(Map<String, String> map) {
        if (this.userTags == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.userTags == null) continue;
                this.userTags.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromServiceEndpoints(Predicate<ServiceEndpointBuilder> predicate) {
        if (this.serviceEndpoints == null) {
            return (A)((Object)this);
        }
        Iterator<ServiceEndpointBuilder> each = this.serviceEndpoints.iterator();
        List visitables = this._visitables.get((Object)"serviceEndpoints");
        while (each.hasNext()) {
            ServiceEndpointBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ServiceEndpointsNested<A> setNewServiceEndpointLike(int index, ServiceEndpoint item) {
        return new ServiceEndpointsNested(index, item);
    }

    public A setToServiceEndpoints(int index, ServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
        if (index < 0 || index >= this.serviceEndpoints.size()) {
            this._visitables.get((Object)"serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        } else {
            this._visitables.get((Object)"serviceEndpoints").add(builder);
            this.serviceEndpoints.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSubnets(int index, String item) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        this.subnets.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.amiID != null) {
            sb.append("amiID:");
            sb.append(this.amiID);
            sb.append(",");
        }
        if (this.bestEffortDeleteIgnition != null) {
            sb.append("bestEffortDeleteIgnition:");
            sb.append(this.bestEffortDeleteIgnition);
            sb.append(",");
        }
        if (this.defaultMachinePlatform != null) {
            sb.append("defaultMachinePlatform:");
            sb.append((Object)this.defaultMachinePlatform);
            sb.append(",");
        }
        if (this.hostedZone != null) {
            sb.append("hostedZone:");
            sb.append(this.hostedZone);
            sb.append(",");
        }
        if (this.hostedZoneRole != null) {
            sb.append("hostedZoneRole:");
            sb.append(this.hostedZoneRole);
            sb.append(",");
        }
        if (this.lbType != null) {
            sb.append("lbType:");
            sb.append(this.lbType);
            sb.append(",");
        }
        if (this.preserveBootstrapIgnition != null) {
            sb.append("preserveBootstrapIgnition:");
            sb.append(this.preserveBootstrapIgnition);
            sb.append(",");
        }
        if (this.propagateUserTags != null) {
            sb.append("propagateUserTags:");
            sb.append(this.propagateUserTags);
            sb.append(",");
        }
        if (this.publicIpv4Pool != null) {
            sb.append("publicIpv4Pool:");
            sb.append(this.publicIpv4Pool);
            sb.append(",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region);
            sb.append(",");
        }
        if (this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty()) {
            sb.append("serviceEndpoints:");
            sb.append(this.serviceEndpoints);
            sb.append(",");
        }
        if (this.subnets != null && !this.subnets.isEmpty()) {
            sb.append("subnets:");
            sb.append(this.subnets);
            sb.append(",");
        }
        if (this.userProvisionedDNS != null) {
            sb.append("userProvisionedDNS:");
            sb.append(this.userProvisionedDNS);
            sb.append(",");
        }
        if (this.userTags != null && !this.userTags.isEmpty()) {
            sb.append("userTags:");
            sb.append(this.userTags);
            sb.append(",");
        }
        if (this.vpc != null) {
            sb.append("vpc:");
            sb.append((Object)this.vpc);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAmiID(String amiID) {
        this.amiID = amiID;
        return (A)((Object)this);
    }

    public A withBestEffortDeleteIgnition() {
        return this.withBestEffortDeleteIgnition(true);
    }

    public A withBestEffortDeleteIgnition(Boolean bestEffortDeleteIgnition) {
        this.bestEffortDeleteIgnition = bestEffortDeleteIgnition;
        return (A)((Object)this);
    }

    public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
        this._visitables.remove((Object)"defaultMachinePlatform");
        if (defaultMachinePlatform != null) {
            this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
            this._visitables.get((Object)"defaultMachinePlatform").add(this.defaultMachinePlatform);
        } else {
            this.defaultMachinePlatform = null;
            this._visitables.get((Object)"defaultMachinePlatform").remove((Object)this.defaultMachinePlatform);
        }
        return (A)((Object)this);
    }

    public A withHostedZone(String hostedZone) {
        this.hostedZone = hostedZone;
        return (A)((Object)this);
    }

    public A withHostedZoneRole(String hostedZoneRole) {
        this.hostedZoneRole = hostedZoneRole;
        return (A)((Object)this);
    }

    public A withLbType(String lbType) {
        this.lbType = lbType;
        return (A)((Object)this);
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
        return new DefaultMachinePlatformNested(null);
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
        return new DefaultMachinePlatformNested(item);
    }

    public VpcNested<A> withNewVpc() {
        return new VpcNested(null);
    }

    public VpcNested<A> withNewVpcLike(VPC item) {
        return new VpcNested(item);
    }

    public A withPreserveBootstrapIgnition() {
        return this.withPreserveBootstrapIgnition(true);
    }

    public A withPreserveBootstrapIgnition(Boolean preserveBootstrapIgnition) {
        this.preserveBootstrapIgnition = preserveBootstrapIgnition;
        return (A)((Object)this);
    }

    public A withPropagateUserTags() {
        return this.withPropagateUserTags(true);
    }

    public A withPropagateUserTags(Boolean propagateUserTags) {
        this.propagateUserTags = propagateUserTags;
        return (A)((Object)this);
    }

    public A withPublicIpv4Pool(String publicIpv4Pool) {
        this.publicIpv4Pool = publicIpv4Pool;
        return (A)((Object)this);
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)((Object)this);
    }

    public A withServiceEndpoints(List<ServiceEndpoint> serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this._visitables.get((Object)"serviceEndpoints").clear();
        }
        if (serviceEndpoints != null) {
            this.serviceEndpoints = new ArrayList();
            for (ServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        } else {
            this.serviceEndpoints = null;
        }
        return (A)((Object)this);
    }

    public A withServiceEndpoints(ServiceEndpoint ... serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this.serviceEndpoints.clear();
            this._visitables.remove((Object)"serviceEndpoints");
        }
        if (serviceEndpoints != null) {
            for (ServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        }
        return (A)((Object)this);
    }

    public A withSubnets(List<String> subnets) {
        if (subnets != null) {
            this.subnets = new ArrayList<String>();
            for (String item : subnets) {
                this.addToSubnets(item);
            }
        } else {
            this.subnets = null;
        }
        return (A)((Object)this);
    }

    public A withSubnets(String ... subnets) {
        if (this.subnets != null) {
            this.subnets.clear();
            this._visitables.remove((Object)"subnets");
        }
        if (subnets != null) {
            for (String item : subnets) {
                this.addToSubnets(item);
            }
        }
        return (A)((Object)this);
    }

    public A withUserProvisionedDNS(String userProvisionedDNS) {
        this.userProvisionedDNS = userProvisionedDNS;
        return (A)((Object)this);
    }

    public <K, V> A withUserTags(Map<String, String> userTags) {
        this.userTags = userTags == null ? null : new LinkedHashMap<String, String>(userTags);
        return (A)((Object)this);
    }

    public A withVpc(VPC vpc) {
        this._visitables.remove((Object)"vpc");
        if (vpc != null) {
            this.vpc = new VPCBuilder(vpc);
            this._visitables.get((Object)"vpc").add(this.vpc);
        } else {
            this.vpc = null;
            this._visitables.get((Object)"vpc").remove((Object)this.vpc);
        }
        return (A)((Object)this);
    }

    public class VpcNested<N>
    extends VPCFluent<VpcNested<N>>
    implements Nested<N> {
        VPCBuilder builder;

        VpcNested(VPC item) {
            this.builder = new VPCBuilder(this, item);
        }

        public N and() {
            return (N)PlatformFluent.this.withVpc(this.builder.build());
        }

        public N endVpc() {
            return this.and();
        }
    }

    public class ServiceEndpointsNested<N>
    extends ServiceEndpointFluent<ServiceEndpointsNested<N>>
    implements Nested<N> {
        ServiceEndpointBuilder builder;
        int index;

        ServiceEndpointsNested(int index, ServiceEndpoint item) {
            this.index = index;
            this.builder = new ServiceEndpointBuilder(this, item);
        }

        public N and() {
            return (N)PlatformFluent.this.setToServiceEndpoints(this.index, this.builder.build());
        }

        public N endServiceEndpoint() {
            return this.and();
        }
    }

    public class DefaultMachinePlatformNested<N>
    extends MachinePoolFluent<DefaultMachinePlatformNested<N>>
    implements Nested<N> {
        MachinePoolBuilder builder;

        DefaultMachinePlatformNested(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        public N and() {
            return (N)PlatformFluent.this.withDefaultMachinePlatform(this.builder.build());
        }

        public N endDefaultMachinePlatform() {
            return this.and();
        }
    }
}

