/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry;
import io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder;
import io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryFluent;
import io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry;
import io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder;
import io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryFluent;
import io.fabric8.openshift.api.model.installer.v1.Networking;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NetworkingFluent<A extends NetworkingFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ClusterNetworkEntryBuilder> clusterNetwork = new ArrayList();
    private ArrayList<ClusterNetworkEntryBuilder> deprecatedClusterNetworks = new ArrayList();
    private String machineCIDR;
    private ArrayList<MachineNetworkEntryBuilder> machineNetwork = new ArrayList();
    private String networkType;
    private String serviceCIDR;
    private List<String> serviceNetwork = new ArrayList<String>();
    private String type;
    private Map<String, Object> additionalProperties;

    public NetworkingFluent() {
    }

    public NetworkingFluent(Networking instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Networking instance) {
        Networking networking = instance = instance != null ? instance : new Networking();
        if (instance != null) {
            this.withClusterNetwork(instance.getClusterNetwork());
            this.withDeprecatedClusterNetworks(instance.getDeprecatedClusterNetworks());
            this.withMachineCIDR(instance.getMachineCIDR());
            this.withMachineNetwork(instance.getMachineNetwork());
            this.withNetworkType(instance.getNetworkType());
            this.withServiceCIDR(instance.getServiceCIDR());
            this.withServiceNetwork(instance.getServiceNetwork());
            this.withType(instance.getType());
            this.withClusterNetwork(instance.getClusterNetwork());
            this.withDeprecatedClusterNetworks(instance.getDeprecatedClusterNetworks());
            this.withMachineCIDR(instance.getMachineCIDR());
            this.withMachineNetwork(instance.getMachineNetwork());
            this.withNetworkType(instance.getNetworkType());
            this.withServiceCIDR(instance.getServiceCIDR());
            this.withServiceNetwork(instance.getServiceNetwork());
            this.withType(instance.getType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToClusterNetwork(int index, ClusterNetworkEntry item) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= this.clusterNetwork.size()) {
            this._visitables.get((Object)"clusterNetwork").add(builder);
            this.clusterNetwork.add(builder);
        } else {
            this._visitables.get((Object)"clusterNetwork").add(index, builder);
            this.clusterNetwork.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToClusterNetwork(int index, ClusterNetworkEntry item) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= this.clusterNetwork.size()) {
            this._visitables.get((Object)"clusterNetwork").add(builder);
            this.clusterNetwork.add(builder);
        } else {
            this._visitables.get((Object)"clusterNetwork").set(index, builder);
            this.clusterNetwork.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToClusterNetwork(ClusterNetworkEntry ... items) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"clusterNetwork").add(builder);
            this.clusterNetwork.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToClusterNetwork(Collection<ClusterNetworkEntry> items) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"clusterNetwork").add(builder);
            this.clusterNetwork.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromClusterNetwork(ClusterNetworkEntry ... items) {
        if (this.clusterNetwork == null) {
            return (A)((Object)this);
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"clusterNetwork").remove((Object)builder);
            this.clusterNetwork.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromClusterNetwork(Collection<ClusterNetworkEntry> items) {
        if (this.clusterNetwork == null) {
            return (A)((Object)this);
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"clusterNetwork").remove((Object)builder);
            this.clusterNetwork.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        if (this.clusterNetwork == null) {
            return (A)((Object)this);
        }
        Iterator<ClusterNetworkEntryBuilder> each = this.clusterNetwork.iterator();
        List visitables = this._visitables.get((Object)"clusterNetwork");
        while (each.hasNext()) {
            ClusterNetworkEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ClusterNetworkEntry> buildClusterNetwork() {
        return this.clusterNetwork != null ? NetworkingFluent.build(this.clusterNetwork) : null;
    }

    public ClusterNetworkEntry buildClusterNetwork(int index) {
        return this.clusterNetwork.get(index).build();
    }

    public ClusterNetworkEntry buildFirstClusterNetwork() {
        return this.clusterNetwork.get(0).build();
    }

    public ClusterNetworkEntry buildLastClusterNetwork() {
        return this.clusterNetwork.get(this.clusterNetwork.size() - 1).build();
    }

    public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.clusterNetwork) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.clusterNetwork) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withClusterNetwork(List<ClusterNetworkEntry> clusterNetwork) {
        if (this.clusterNetwork != null) {
            this._visitables.get((Object)"clusterNetwork").clear();
        }
        if (clusterNetwork != null) {
            this.clusterNetwork = new ArrayList();
            for (ClusterNetworkEntry item : clusterNetwork) {
                this.addToClusterNetwork(item);
            }
        } else {
            this.clusterNetwork = null;
        }
        return (A)((Object)this);
    }

    public A withClusterNetwork(ClusterNetworkEntry ... clusterNetwork) {
        if (this.clusterNetwork != null) {
            this.clusterNetwork.clear();
            this._visitables.remove((Object)"clusterNetwork");
        }
        if (clusterNetwork != null) {
            for (ClusterNetworkEntry item : clusterNetwork) {
                this.addToClusterNetwork(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasClusterNetwork() {
        return this.clusterNetwork != null && !this.clusterNetwork.isEmpty();
    }

    public A addNewClusterNetwork(String cidr, Integer hostPrefix, Integer hostSubnetLength) {
        return this.addToClusterNetwork(new ClusterNetworkEntry(cidr, hostPrefix, hostSubnetLength));
    }

    public ClusterNetworkNested<A> addNewClusterNetwork() {
        return new ClusterNetworkNested(-1, null);
    }

    public ClusterNetworkNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item) {
        return new ClusterNetworkNested(-1, item);
    }

    public ClusterNetworkNested<A> setNewClusterNetworkLike(int index, ClusterNetworkEntry item) {
        return new ClusterNetworkNested(index, item);
    }

    public ClusterNetworkNested<A> editClusterNetwork(int index) {
        if (this.clusterNetwork.size() <= index) {
            throw new RuntimeException("Can't edit clusterNetwork. Index exceeds size.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    public ClusterNetworkNested<A> editFirstClusterNetwork() {
        if (this.clusterNetwork.size() == 0) {
            throw new RuntimeException("Can't edit first clusterNetwork. The list is empty.");
        }
        return this.setNewClusterNetworkLike(0, this.buildClusterNetwork(0));
    }

    public ClusterNetworkNested<A> editLastClusterNetwork() {
        int index = this.clusterNetwork.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last clusterNetwork. The list is empty.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    public ClusterNetworkNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusterNetwork.size(); ++i) {
            if (!predicate.test(this.clusterNetwork.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching clusterNetwork. No match found.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    public A addToDeprecatedClusterNetworks(int index, ClusterNetworkEntry item) {
        if (this.deprecatedClusterNetworks == null) {
            this.deprecatedClusterNetworks = new ArrayList();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= this.deprecatedClusterNetworks.size()) {
            this._visitables.get((Object)"deprecatedClusterNetworks").add(builder);
            this.deprecatedClusterNetworks.add(builder);
        } else {
            this._visitables.get((Object)"deprecatedClusterNetworks").add(index, builder);
            this.deprecatedClusterNetworks.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToDeprecatedClusterNetworks(int index, ClusterNetworkEntry item) {
        if (this.deprecatedClusterNetworks == null) {
            this.deprecatedClusterNetworks = new ArrayList();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= this.deprecatedClusterNetworks.size()) {
            this._visitables.get((Object)"deprecatedClusterNetworks").add(builder);
            this.deprecatedClusterNetworks.add(builder);
        } else {
            this._visitables.get((Object)"deprecatedClusterNetworks").set(index, builder);
            this.deprecatedClusterNetworks.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToDeprecatedClusterNetworks(ClusterNetworkEntry ... items) {
        if (this.deprecatedClusterNetworks == null) {
            this.deprecatedClusterNetworks = new ArrayList();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"deprecatedClusterNetworks").add(builder);
            this.deprecatedClusterNetworks.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToDeprecatedClusterNetworks(Collection<ClusterNetworkEntry> items) {
        if (this.deprecatedClusterNetworks == null) {
            this.deprecatedClusterNetworks = new ArrayList();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"deprecatedClusterNetworks").add(builder);
            this.deprecatedClusterNetworks.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromDeprecatedClusterNetworks(ClusterNetworkEntry ... items) {
        if (this.deprecatedClusterNetworks == null) {
            return (A)((Object)this);
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"deprecatedClusterNetworks").remove((Object)builder);
            this.deprecatedClusterNetworks.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDeprecatedClusterNetworks(Collection<ClusterNetworkEntry> items) {
        if (this.deprecatedClusterNetworks == null) {
            return (A)((Object)this);
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"deprecatedClusterNetworks").remove((Object)builder);
            this.deprecatedClusterNetworks.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromDeprecatedClusterNetworks(Predicate<ClusterNetworkEntryBuilder> predicate) {
        if (this.deprecatedClusterNetworks == null) {
            return (A)((Object)this);
        }
        Iterator<ClusterNetworkEntryBuilder> each = this.deprecatedClusterNetworks.iterator();
        List visitables = this._visitables.get((Object)"deprecatedClusterNetworks");
        while (each.hasNext()) {
            ClusterNetworkEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ClusterNetworkEntry> buildDeprecatedClusterNetworks() {
        return this.deprecatedClusterNetworks != null ? NetworkingFluent.build(this.deprecatedClusterNetworks) : null;
    }

    public ClusterNetworkEntry buildDeprecatedClusterNetwork(int index) {
        return this.deprecatedClusterNetworks.get(index).build();
    }

    public ClusterNetworkEntry buildFirstDeprecatedClusterNetwork() {
        return this.deprecatedClusterNetworks.get(0).build();
    }

    public ClusterNetworkEntry buildLastDeprecatedClusterNetwork() {
        return this.deprecatedClusterNetworks.get(this.deprecatedClusterNetworks.size() - 1).build();
    }

    public ClusterNetworkEntry buildMatchingDeprecatedClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.deprecatedClusterNetworks) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDeprecatedClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.deprecatedClusterNetworks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDeprecatedClusterNetworks(List<ClusterNetworkEntry> deprecatedClusterNetworks) {
        if (this.deprecatedClusterNetworks != null) {
            this._visitables.get((Object)"deprecatedClusterNetworks").clear();
        }
        if (deprecatedClusterNetworks != null) {
            this.deprecatedClusterNetworks = new ArrayList();
            for (ClusterNetworkEntry item : deprecatedClusterNetworks) {
                this.addToDeprecatedClusterNetworks(item);
            }
        } else {
            this.deprecatedClusterNetworks = null;
        }
        return (A)((Object)this);
    }

    public A withDeprecatedClusterNetworks(ClusterNetworkEntry ... deprecatedClusterNetworks) {
        if (this.deprecatedClusterNetworks != null) {
            this.deprecatedClusterNetworks.clear();
            this._visitables.remove((Object)"deprecatedClusterNetworks");
        }
        if (deprecatedClusterNetworks != null) {
            for (ClusterNetworkEntry item : deprecatedClusterNetworks) {
                this.addToDeprecatedClusterNetworks(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDeprecatedClusterNetworks() {
        return this.deprecatedClusterNetworks != null && !this.deprecatedClusterNetworks.isEmpty();
    }

    public A addNewDeprecatedClusterNetwork(String cidr, Integer hostPrefix, Integer hostSubnetLength) {
        return this.addToDeprecatedClusterNetworks(new ClusterNetworkEntry(cidr, hostPrefix, hostSubnetLength));
    }

    public DeprecatedClusterNetworksNested<A> addNewDeprecatedClusterNetwork() {
        return new DeprecatedClusterNetworksNested(-1, null);
    }

    public DeprecatedClusterNetworksNested<A> addNewDeprecatedClusterNetworkLike(ClusterNetworkEntry item) {
        return new DeprecatedClusterNetworksNested(-1, item);
    }

    public DeprecatedClusterNetworksNested<A> setNewDeprecatedClusterNetworkLike(int index, ClusterNetworkEntry item) {
        return new DeprecatedClusterNetworksNested(index, item);
    }

    public DeprecatedClusterNetworksNested<A> editDeprecatedClusterNetwork(int index) {
        if (this.deprecatedClusterNetworks.size() <= index) {
            throw new RuntimeException("Can't edit deprecatedClusterNetworks. Index exceeds size.");
        }
        return this.setNewDeprecatedClusterNetworkLike(index, this.buildDeprecatedClusterNetwork(index));
    }

    public DeprecatedClusterNetworksNested<A> editFirstDeprecatedClusterNetwork() {
        if (this.deprecatedClusterNetworks.size() == 0) {
            throw new RuntimeException("Can't edit first deprecatedClusterNetworks. The list is empty.");
        }
        return this.setNewDeprecatedClusterNetworkLike(0, this.buildDeprecatedClusterNetwork(0));
    }

    public DeprecatedClusterNetworksNested<A> editLastDeprecatedClusterNetwork() {
        int index = this.deprecatedClusterNetworks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last deprecatedClusterNetworks. The list is empty.");
        }
        return this.setNewDeprecatedClusterNetworkLike(index, this.buildDeprecatedClusterNetwork(index));
    }

    public DeprecatedClusterNetworksNested<A> editMatchingDeprecatedClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.deprecatedClusterNetworks.size(); ++i) {
            if (!predicate.test(this.deprecatedClusterNetworks.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching deprecatedClusterNetworks. No match found.");
        }
        return this.setNewDeprecatedClusterNetworkLike(index, this.buildDeprecatedClusterNetwork(index));
    }

    public String getMachineCIDR() {
        return this.machineCIDR;
    }

    public A withMachineCIDR(String machineCIDR) {
        this.machineCIDR = machineCIDR;
        return (A)((Object)this);
    }

    public boolean hasMachineCIDR() {
        return this.machineCIDR != null;
    }

    public A addToMachineNetwork(int index, MachineNetworkEntry item) {
        if (this.machineNetwork == null) {
            this.machineNetwork = new ArrayList();
        }
        MachineNetworkEntryBuilder builder = new MachineNetworkEntryBuilder(item);
        if (index < 0 || index >= this.machineNetwork.size()) {
            this._visitables.get((Object)"machineNetwork").add(builder);
            this.machineNetwork.add(builder);
        } else {
            this._visitables.get((Object)"machineNetwork").add(index, builder);
            this.machineNetwork.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToMachineNetwork(int index, MachineNetworkEntry item) {
        if (this.machineNetwork == null) {
            this.machineNetwork = new ArrayList();
        }
        MachineNetworkEntryBuilder builder = new MachineNetworkEntryBuilder(item);
        if (index < 0 || index >= this.machineNetwork.size()) {
            this._visitables.get((Object)"machineNetwork").add(builder);
            this.machineNetwork.add(builder);
        } else {
            this._visitables.get((Object)"machineNetwork").set(index, builder);
            this.machineNetwork.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToMachineNetwork(MachineNetworkEntry ... items) {
        if (this.machineNetwork == null) {
            this.machineNetwork = new ArrayList();
        }
        for (MachineNetworkEntry item : items) {
            MachineNetworkEntryBuilder builder = new MachineNetworkEntryBuilder(item);
            this._visitables.get((Object)"machineNetwork").add(builder);
            this.machineNetwork.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToMachineNetwork(Collection<MachineNetworkEntry> items) {
        if (this.machineNetwork == null) {
            this.machineNetwork = new ArrayList();
        }
        for (MachineNetworkEntry item : items) {
            MachineNetworkEntryBuilder builder = new MachineNetworkEntryBuilder(item);
            this._visitables.get((Object)"machineNetwork").add(builder);
            this.machineNetwork.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromMachineNetwork(MachineNetworkEntry ... items) {
        if (this.machineNetwork == null) {
            return (A)((Object)this);
        }
        for (MachineNetworkEntry item : items) {
            MachineNetworkEntryBuilder builder = new MachineNetworkEntryBuilder(item);
            this._visitables.get((Object)"machineNetwork").remove((Object)builder);
            this.machineNetwork.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMachineNetwork(Collection<MachineNetworkEntry> items) {
        if (this.machineNetwork == null) {
            return (A)((Object)this);
        }
        for (MachineNetworkEntry item : items) {
            MachineNetworkEntryBuilder builder = new MachineNetworkEntryBuilder(item);
            this._visitables.get((Object)"machineNetwork").remove((Object)builder);
            this.machineNetwork.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromMachineNetwork(Predicate<MachineNetworkEntryBuilder> predicate) {
        if (this.machineNetwork == null) {
            return (A)((Object)this);
        }
        Iterator<MachineNetworkEntryBuilder> each = this.machineNetwork.iterator();
        List visitables = this._visitables.get((Object)"machineNetwork");
        while (each.hasNext()) {
            MachineNetworkEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<MachineNetworkEntry> buildMachineNetwork() {
        return this.machineNetwork != null ? NetworkingFluent.build(this.machineNetwork) : null;
    }

    public MachineNetworkEntry buildMachineNetwork(int index) {
        return this.machineNetwork.get(index).build();
    }

    public MachineNetworkEntry buildFirstMachineNetwork() {
        return this.machineNetwork.get(0).build();
    }

    public MachineNetworkEntry buildLastMachineNetwork() {
        return this.machineNetwork.get(this.machineNetwork.size() - 1).build();
    }

    public MachineNetworkEntry buildMatchingMachineNetwork(Predicate<MachineNetworkEntryBuilder> predicate) {
        for (MachineNetworkEntryBuilder item : this.machineNetwork) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMachineNetwork(Predicate<MachineNetworkEntryBuilder> predicate) {
        for (MachineNetworkEntryBuilder item : this.machineNetwork) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMachineNetwork(List<MachineNetworkEntry> machineNetwork) {
        if (this.machineNetwork != null) {
            this._visitables.get((Object)"machineNetwork").clear();
        }
        if (machineNetwork != null) {
            this.machineNetwork = new ArrayList();
            for (MachineNetworkEntry item : machineNetwork) {
                this.addToMachineNetwork(item);
            }
        } else {
            this.machineNetwork = null;
        }
        return (A)((Object)this);
    }

    public A withMachineNetwork(MachineNetworkEntry ... machineNetwork) {
        if (this.machineNetwork != null) {
            this.machineNetwork.clear();
            this._visitables.remove((Object)"machineNetwork");
        }
        if (machineNetwork != null) {
            for (MachineNetworkEntry item : machineNetwork) {
                this.addToMachineNetwork(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasMachineNetwork() {
        return this.machineNetwork != null && !this.machineNetwork.isEmpty();
    }

    public A addNewMachineNetwork(String cidr) {
        return this.addToMachineNetwork(new MachineNetworkEntry(cidr));
    }

    public MachineNetworkNested<A> addNewMachineNetwork() {
        return new MachineNetworkNested(-1, null);
    }

    public MachineNetworkNested<A> addNewMachineNetworkLike(MachineNetworkEntry item) {
        return new MachineNetworkNested(-1, item);
    }

    public MachineNetworkNested<A> setNewMachineNetworkLike(int index, MachineNetworkEntry item) {
        return new MachineNetworkNested(index, item);
    }

    public MachineNetworkNested<A> editMachineNetwork(int index) {
        if (this.machineNetwork.size() <= index) {
            throw new RuntimeException("Can't edit machineNetwork. Index exceeds size.");
        }
        return this.setNewMachineNetworkLike(index, this.buildMachineNetwork(index));
    }

    public MachineNetworkNested<A> editFirstMachineNetwork() {
        if (this.machineNetwork.size() == 0) {
            throw new RuntimeException("Can't edit first machineNetwork. The list is empty.");
        }
        return this.setNewMachineNetworkLike(0, this.buildMachineNetwork(0));
    }

    public MachineNetworkNested<A> editLastMachineNetwork() {
        int index = this.machineNetwork.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last machineNetwork. The list is empty.");
        }
        return this.setNewMachineNetworkLike(index, this.buildMachineNetwork(index));
    }

    public MachineNetworkNested<A> editMatchingMachineNetwork(Predicate<MachineNetworkEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.machineNetwork.size(); ++i) {
            if (!predicate.test(this.machineNetwork.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching machineNetwork. No match found.");
        }
        return this.setNewMachineNetworkLike(index, this.buildMachineNetwork(index));
    }

    public String getNetworkType() {
        return this.networkType;
    }

    public A withNetworkType(String networkType) {
        this.networkType = networkType;
        return (A)((Object)this);
    }

    public boolean hasNetworkType() {
        return this.networkType != null;
    }

    public String getServiceCIDR() {
        return this.serviceCIDR;
    }

    public A withServiceCIDR(String serviceCIDR) {
        this.serviceCIDR = serviceCIDR;
        return (A)((Object)this);
    }

    public boolean hasServiceCIDR() {
        return this.serviceCIDR != null;
    }

    public A addToServiceNetwork(int index, String item) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        this.serviceNetwork.add(index, item);
        return (A)((Object)this);
    }

    public A setToServiceNetwork(int index, String item) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        this.serviceNetwork.set(index, item);
        return (A)((Object)this);
    }

    public A addToServiceNetwork(String ... items) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceNetwork.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToServiceNetwork(Collection<String> items) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceNetwork.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromServiceNetwork(String ... items) {
        if (this.serviceNetwork == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.serviceNetwork.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromServiceNetwork(Collection<String> items) {
        if (this.serviceNetwork == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.serviceNetwork.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getServiceNetwork() {
        return this.serviceNetwork;
    }

    public String getServiceNetwork(int index) {
        return this.serviceNetwork.get(index);
    }

    public String getFirstServiceNetwork() {
        return this.serviceNetwork.get(0);
    }

    public String getLastServiceNetwork() {
        return this.serviceNetwork.get(this.serviceNetwork.size() - 1);
    }

    public String getMatchingServiceNetwork(Predicate<String> predicate) {
        for (String item : this.serviceNetwork) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingServiceNetwork(Predicate<String> predicate) {
        for (String item : this.serviceNetwork) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withServiceNetwork(List<String> serviceNetwork) {
        if (serviceNetwork != null) {
            this.serviceNetwork = new ArrayList<String>();
            for (String item : serviceNetwork) {
                this.addToServiceNetwork(item);
            }
        } else {
            this.serviceNetwork = null;
        }
        return (A)((Object)this);
    }

    public A withServiceNetwork(String ... serviceNetwork) {
        if (this.serviceNetwork != null) {
            this.serviceNetwork.clear();
            this._visitables.remove((Object)"serviceNetwork");
        }
        if (serviceNetwork != null) {
            for (String item : serviceNetwork) {
                this.addToServiceNetwork(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasServiceNetwork() {
        return this.serviceNetwork != null && !this.serviceNetwork.isEmpty();
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkingFluent that = (NetworkingFluent)((Object)o);
        if (!Objects.equals(this.clusterNetwork, that.clusterNetwork)) {
            return false;
        }
        if (!Objects.equals(this.deprecatedClusterNetworks, that.deprecatedClusterNetworks)) {
            return false;
        }
        if (!Objects.equals(this.machineCIDR, that.machineCIDR)) {
            return false;
        }
        if (!Objects.equals(this.machineNetwork, that.machineNetwork)) {
            return false;
        }
        if (!Objects.equals(this.networkType, that.networkType)) {
            return false;
        }
        if (!Objects.equals(this.serviceCIDR, that.serviceCIDR)) {
            return false;
        }
        if (!Objects.equals(this.serviceNetwork, that.serviceNetwork)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.clusterNetwork, this.deprecatedClusterNetworks, this.machineCIDR, this.machineNetwork, this.networkType, this.serviceCIDR, this.serviceNetwork, this.type, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterNetwork != null && !this.clusterNetwork.isEmpty()) {
            sb.append("clusterNetwork:");
            sb.append(this.clusterNetwork + ",");
        }
        if (this.deprecatedClusterNetworks != null && !this.deprecatedClusterNetworks.isEmpty()) {
            sb.append("deprecatedClusterNetworks:");
            sb.append(this.deprecatedClusterNetworks + ",");
        }
        if (this.machineCIDR != null) {
            sb.append("machineCIDR:");
            sb.append(this.machineCIDR + ",");
        }
        if (this.machineNetwork != null && !this.machineNetwork.isEmpty()) {
            sb.append("machineNetwork:");
            sb.append(this.machineNetwork + ",");
        }
        if (this.networkType != null) {
            sb.append("networkType:");
            sb.append(this.networkType + ",");
        }
        if (this.serviceCIDR != null) {
            sb.append("serviceCIDR:");
            sb.append(this.serviceCIDR + ",");
        }
        if (this.serviceNetwork != null && !this.serviceNetwork.isEmpty()) {
            sb.append("serviceNetwork:");
            sb.append(this.serviceNetwork + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MachineNetworkNested<N>
    extends MachineNetworkEntryFluent<MachineNetworkNested<N>>
    implements Nested<N> {
        MachineNetworkEntryBuilder builder;
        int index;

        MachineNetworkNested(int index, MachineNetworkEntry item) {
            this.index = index;
            this.builder = new MachineNetworkEntryBuilder(this, item);
        }

        public N and() {
            return (N)NetworkingFluent.this.setToMachineNetwork(this.index, this.builder.build());
        }

        public N endMachineNetwork() {
            return this.and();
        }
    }

    public class DeprecatedClusterNetworksNested<N>
    extends ClusterNetworkEntryFluent<DeprecatedClusterNetworksNested<N>>
    implements Nested<N> {
        ClusterNetworkEntryBuilder builder;
        int index;

        DeprecatedClusterNetworksNested(int index, ClusterNetworkEntry item) {
            this.index = index;
            this.builder = new ClusterNetworkEntryBuilder(this, item);
        }

        public N and() {
            return (N)NetworkingFluent.this.setToDeprecatedClusterNetworks(this.index, this.builder.build());
        }

        public N endDeprecatedClusterNetwork() {
            return this.and();
        }
    }

    public class ClusterNetworkNested<N>
    extends ClusterNetworkEntryFluent<ClusterNetworkNested<N>>
    implements Nested<N> {
        ClusterNetworkEntryBuilder builder;
        int index;

        ClusterNetworkNested(int index, ClusterNetworkEntry item) {
            this.index = index;
            this.builder = new ClusterNetworkEntryBuilder(this, item);
        }

        public N and() {
            return (N)NetworkingFluent.this.setToClusterNetwork(this.index, this.builder.build());
        }

        public N endClusterNetwork() {
            return this.and();
        }
    }
}

