/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.openstack.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.OpenStackPlatformLoadBalancer;
import io.fabric8.openshift.api.model.installer.openstack.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.openstack.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.installer.openstack.v1.MachinePoolFluent;
import io.fabric8.openshift.api.model.installer.openstack.v1.Platform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PlatformFluent<A extends PlatformFluent<A>>
extends BaseFluent<A> {
    private String apiFloatingIP;
    private String apiVIP;
    private List<String> apiVIPs = new ArrayList<String>();
    private String cloud;
    private String clusterOSImage;
    private Map<String, String> clusterOSImageProperties;
    private String computeFlavor;
    private MachinePoolBuilder defaultMachinePlatform;
    private List<String> externalDNS = new ArrayList<String>();
    private String externalNetwork;
    private String ingressFloatingIP;
    private String ingressVIP;
    private List<String> ingressVIPs = new ArrayList<String>();
    private String lbFloatingIP;
    private OpenStackPlatformLoadBalancer loadBalancer;
    private String machinesSubnet;
    private String octaviaSupport;
    private String region;
    private String trunkSupport;
    private Map<String, Object> additionalProperties;

    public PlatformFluent() {
    }

    public PlatformFluent(Platform instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Platform instance) {
        Platform platform = instance = instance != null ? instance : new Platform();
        if (instance != null) {
            this.withApiFloatingIP(instance.getApiFloatingIP());
            this.withApiVIP(instance.getApiVIP());
            this.withApiVIPs(instance.getApiVIPs());
            this.withCloud(instance.getCloud());
            this.withClusterOSImage(instance.getClusterOSImage());
            this.withClusterOSImageProperties(instance.getClusterOSImageProperties());
            this.withComputeFlavor(instance.getComputeFlavor());
            this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
            this.withExternalDNS(instance.getExternalDNS());
            this.withExternalNetwork(instance.getExternalNetwork());
            this.withIngressFloatingIP(instance.getIngressFloatingIP());
            this.withIngressVIP(instance.getIngressVIP());
            this.withIngressVIPs(instance.getIngressVIPs());
            this.withLbFloatingIP(instance.getLbFloatingIP());
            this.withLoadBalancer(instance.getLoadBalancer());
            this.withMachinesSubnet(instance.getMachinesSubnet());
            this.withOctaviaSupport(instance.getOctaviaSupport());
            this.withRegion(instance.getRegion());
            this.withTrunkSupport(instance.getTrunkSupport());
            this.withApiFloatingIP(instance.getApiFloatingIP());
            this.withApiVIP(instance.getApiVIP());
            this.withApiVIPs(instance.getApiVIPs());
            this.withCloud(instance.getCloud());
            this.withClusterOSImage(instance.getClusterOSImage());
            this.withClusterOSImageProperties(instance.getClusterOSImageProperties());
            this.withComputeFlavor(instance.getComputeFlavor());
            this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
            this.withExternalDNS(instance.getExternalDNS());
            this.withExternalNetwork(instance.getExternalNetwork());
            this.withIngressFloatingIP(instance.getIngressFloatingIP());
            this.withIngressVIP(instance.getIngressVIP());
            this.withIngressVIPs(instance.getIngressVIPs());
            this.withLbFloatingIP(instance.getLbFloatingIP());
            this.withLoadBalancer(instance.getLoadBalancer());
            this.withMachinesSubnet(instance.getMachinesSubnet());
            this.withOctaviaSupport(instance.getOctaviaSupport());
            this.withRegion(instance.getRegion());
            this.withTrunkSupport(instance.getTrunkSupport());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiFloatingIP() {
        return this.apiFloatingIP;
    }

    public A withApiFloatingIP(String apiFloatingIP) {
        this.apiFloatingIP = apiFloatingIP;
        return (A)((Object)this);
    }

    public boolean hasApiFloatingIP() {
        return this.apiFloatingIP != null;
    }

    public String getApiVIP() {
        return this.apiVIP;
    }

    public A withApiVIP(String apiVIP) {
        this.apiVIP = apiVIP;
        return (A)((Object)this);
    }

    public boolean hasApiVIP() {
        return this.apiVIP != null;
    }

    public A addToApiVIPs(int index, String item) {
        if (this.apiVIPs == null) {
            this.apiVIPs = new ArrayList<String>();
        }
        this.apiVIPs.add(index, item);
        return (A)((Object)this);
    }

    public A setToApiVIPs(int index, String item) {
        if (this.apiVIPs == null) {
            this.apiVIPs = new ArrayList<String>();
        }
        this.apiVIPs.set(index, item);
        return (A)((Object)this);
    }

    public A addToApiVIPs(String ... items) {
        if (this.apiVIPs == null) {
            this.apiVIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiVIPs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToApiVIPs(Collection<String> items) {
        if (this.apiVIPs == null) {
            this.apiVIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiVIPs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromApiVIPs(String ... items) {
        if (this.apiVIPs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.apiVIPs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromApiVIPs(Collection<String> items) {
        if (this.apiVIPs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.apiVIPs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getApiVIPs() {
        return this.apiVIPs;
    }

    public String getApiVIP(int index) {
        return this.apiVIPs.get(index);
    }

    public String getFirstApiVIP() {
        return this.apiVIPs.get(0);
    }

    public String getLastApiVIP() {
        return this.apiVIPs.get(this.apiVIPs.size() - 1);
    }

    public String getMatchingApiVIP(Predicate<String> predicate) {
        for (String item : this.apiVIPs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingApiVIP(Predicate<String> predicate) {
        for (String item : this.apiVIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withApiVIPs(List<String> apiVIPs) {
        if (apiVIPs != null) {
            this.apiVIPs = new ArrayList<String>();
            for (String item : apiVIPs) {
                this.addToApiVIPs(item);
            }
        } else {
            this.apiVIPs = null;
        }
        return (A)((Object)this);
    }

    public A withApiVIPs(String ... apiVIPs) {
        if (this.apiVIPs != null) {
            this.apiVIPs.clear();
            this._visitables.remove((Object)"apiVIPs");
        }
        if (apiVIPs != null) {
            for (String item : apiVIPs) {
                this.addToApiVIPs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasApiVIPs() {
        return this.apiVIPs != null && !this.apiVIPs.isEmpty();
    }

    public String getCloud() {
        return this.cloud;
    }

    public A withCloud(String cloud) {
        this.cloud = cloud;
        return (A)((Object)this);
    }

    public boolean hasCloud() {
        return this.cloud != null;
    }

    public String getClusterOSImage() {
        return this.clusterOSImage;
    }

    public A withClusterOSImage(String clusterOSImage) {
        this.clusterOSImage = clusterOSImage;
        return (A)((Object)this);
    }

    public boolean hasClusterOSImage() {
        return this.clusterOSImage != null;
    }

    public A addToClusterOSImageProperties(String key, String value) {
        if (this.clusterOSImageProperties == null && key != null && value != null) {
            this.clusterOSImageProperties = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.clusterOSImageProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToClusterOSImageProperties(Map<String, String> map) {
        if (this.clusterOSImageProperties == null && map != null) {
            this.clusterOSImageProperties = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.clusterOSImageProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromClusterOSImageProperties(String key) {
        if (this.clusterOSImageProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.clusterOSImageProperties != null) {
            this.clusterOSImageProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromClusterOSImageProperties(Map<String, String> map) {
        if (this.clusterOSImageProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.clusterOSImageProperties == null) continue;
                this.clusterOSImageProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getClusterOSImageProperties() {
        return this.clusterOSImageProperties;
    }

    public <K, V> A withClusterOSImageProperties(Map<String, String> clusterOSImageProperties) {
        this.clusterOSImageProperties = clusterOSImageProperties == null ? null : new LinkedHashMap<String, String>(clusterOSImageProperties);
        return (A)((Object)this);
    }

    public boolean hasClusterOSImageProperties() {
        return this.clusterOSImageProperties != null;
    }

    public String getComputeFlavor() {
        return this.computeFlavor;
    }

    public A withComputeFlavor(String computeFlavor) {
        this.computeFlavor = computeFlavor;
        return (A)((Object)this);
    }

    public boolean hasComputeFlavor() {
        return this.computeFlavor != null;
    }

    public MachinePool buildDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
        this._visitables.get((Object)"defaultMachinePlatform").remove((Object)this.defaultMachinePlatform);
        if (defaultMachinePlatform != null) {
            this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
            this._visitables.get((Object)"defaultMachinePlatform").add(this.defaultMachinePlatform);
        } else {
            this.defaultMachinePlatform = null;
            this._visitables.get((Object)"defaultMachinePlatform").remove((Object)this.defaultMachinePlatform);
        }
        return (A)((Object)this);
    }

    public boolean hasDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null;
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
        return new DefaultMachinePlatformNested(null);
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
        return new DefaultMachinePlatformNested(item);
    }

    public DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(null));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(new MachinePoolBuilder().build()));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(item));
    }

    public A addToExternalDNS(int index, String item) {
        if (this.externalDNS == null) {
            this.externalDNS = new ArrayList<String>();
        }
        this.externalDNS.add(index, item);
        return (A)((Object)this);
    }

    public A setToExternalDNS(int index, String item) {
        if (this.externalDNS == null) {
            this.externalDNS = new ArrayList<String>();
        }
        this.externalDNS.set(index, item);
        return (A)((Object)this);
    }

    public A addToExternalDNS(String ... items) {
        if (this.externalDNS == null) {
            this.externalDNS = new ArrayList<String>();
        }
        for (String item : items) {
            this.externalDNS.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToExternalDNS(Collection<String> items) {
        if (this.externalDNS == null) {
            this.externalDNS = new ArrayList<String>();
        }
        for (String item : items) {
            this.externalDNS.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromExternalDNS(String ... items) {
        if (this.externalDNS == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.externalDNS.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromExternalDNS(Collection<String> items) {
        if (this.externalDNS == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.externalDNS.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getExternalDNS() {
        return this.externalDNS;
    }

    public String getExternalDN(int index) {
        return this.externalDNS.get(index);
    }

    public String getFirstExternalDN() {
        return this.externalDNS.get(0);
    }

    public String getLastExternalDN() {
        return this.externalDNS.get(this.externalDNS.size() - 1);
    }

    public String getMatchingExternalDN(Predicate<String> predicate) {
        for (String item : this.externalDNS) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingExternalDN(Predicate<String> predicate) {
        for (String item : this.externalDNS) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExternalDNS(List<String> externalDNS) {
        if (externalDNS != null) {
            this.externalDNS = new ArrayList<String>();
            for (String item : externalDNS) {
                this.addToExternalDNS(item);
            }
        } else {
            this.externalDNS = null;
        }
        return (A)((Object)this);
    }

    public A withExternalDNS(String ... externalDNS) {
        if (this.externalDNS != null) {
            this.externalDNS.clear();
            this._visitables.remove((Object)"externalDNS");
        }
        if (externalDNS != null) {
            for (String item : externalDNS) {
                this.addToExternalDNS(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasExternalDNS() {
        return this.externalDNS != null && !this.externalDNS.isEmpty();
    }

    public String getExternalNetwork() {
        return this.externalNetwork;
    }

    public A withExternalNetwork(String externalNetwork) {
        this.externalNetwork = externalNetwork;
        return (A)((Object)this);
    }

    public boolean hasExternalNetwork() {
        return this.externalNetwork != null;
    }

    public String getIngressFloatingIP() {
        return this.ingressFloatingIP;
    }

    public A withIngressFloatingIP(String ingressFloatingIP) {
        this.ingressFloatingIP = ingressFloatingIP;
        return (A)((Object)this);
    }

    public boolean hasIngressFloatingIP() {
        return this.ingressFloatingIP != null;
    }

    public String getIngressVIP() {
        return this.ingressVIP;
    }

    public A withIngressVIP(String ingressVIP) {
        this.ingressVIP = ingressVIP;
        return (A)((Object)this);
    }

    public boolean hasIngressVIP() {
        return this.ingressVIP != null;
    }

    public A addToIngressVIPs(int index, String item) {
        if (this.ingressVIPs == null) {
            this.ingressVIPs = new ArrayList<String>();
        }
        this.ingressVIPs.add(index, item);
        return (A)((Object)this);
    }

    public A setToIngressVIPs(int index, String item) {
        if (this.ingressVIPs == null) {
            this.ingressVIPs = new ArrayList<String>();
        }
        this.ingressVIPs.set(index, item);
        return (A)((Object)this);
    }

    public A addToIngressVIPs(String ... items) {
        if (this.ingressVIPs == null) {
            this.ingressVIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.ingressVIPs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToIngressVIPs(Collection<String> items) {
        if (this.ingressVIPs == null) {
            this.ingressVIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.ingressVIPs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromIngressVIPs(String ... items) {
        if (this.ingressVIPs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ingressVIPs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIngressVIPs(Collection<String> items) {
        if (this.ingressVIPs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ingressVIPs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getIngressVIPs() {
        return this.ingressVIPs;
    }

    public String getIngressVIP(int index) {
        return this.ingressVIPs.get(index);
    }

    public String getFirstIngressVIP() {
        return this.ingressVIPs.get(0);
    }

    public String getLastIngressVIP() {
        return this.ingressVIPs.get(this.ingressVIPs.size() - 1);
    }

    public String getMatchingIngressVIP(Predicate<String> predicate) {
        for (String item : this.ingressVIPs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingIngressVIP(Predicate<String> predicate) {
        for (String item : this.ingressVIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIngressVIPs(List<String> ingressVIPs) {
        if (ingressVIPs != null) {
            this.ingressVIPs = new ArrayList<String>();
            for (String item : ingressVIPs) {
                this.addToIngressVIPs(item);
            }
        } else {
            this.ingressVIPs = null;
        }
        return (A)((Object)this);
    }

    public A withIngressVIPs(String ... ingressVIPs) {
        if (this.ingressVIPs != null) {
            this.ingressVIPs.clear();
            this._visitables.remove((Object)"ingressVIPs");
        }
        if (ingressVIPs != null) {
            for (String item : ingressVIPs) {
                this.addToIngressVIPs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasIngressVIPs() {
        return this.ingressVIPs != null && !this.ingressVIPs.isEmpty();
    }

    public String getLbFloatingIP() {
        return this.lbFloatingIP;
    }

    public A withLbFloatingIP(String lbFloatingIP) {
        this.lbFloatingIP = lbFloatingIP;
        return (A)((Object)this);
    }

    public boolean hasLbFloatingIP() {
        return this.lbFloatingIP != null;
    }

    public OpenStackPlatformLoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public A withLoadBalancer(OpenStackPlatformLoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
        return (A)((Object)this);
    }

    public boolean hasLoadBalancer() {
        return this.loadBalancer != null;
    }

    public A withNewLoadBalancer(String type) {
        return this.withLoadBalancer(new OpenStackPlatformLoadBalancer(type));
    }

    public String getMachinesSubnet() {
        return this.machinesSubnet;
    }

    public A withMachinesSubnet(String machinesSubnet) {
        this.machinesSubnet = machinesSubnet;
        return (A)((Object)this);
    }

    public boolean hasMachinesSubnet() {
        return this.machinesSubnet != null;
    }

    public String getOctaviaSupport() {
        return this.octaviaSupport;
    }

    public A withOctaviaSupport(String octaviaSupport) {
        this.octaviaSupport = octaviaSupport;
        return (A)((Object)this);
    }

    public boolean hasOctaviaSupport() {
        return this.octaviaSupport != null;
    }

    public String getRegion() {
        return this.region;
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)((Object)this);
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public String getTrunkSupport() {
        return this.trunkSupport;
    }

    public A withTrunkSupport(String trunkSupport) {
        this.trunkSupport = trunkSupport;
        return (A)((Object)this);
    }

    public boolean hasTrunkSupport() {
        return this.trunkSupport != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlatformFluent that = (PlatformFluent)((Object)o);
        if (!Objects.equals(this.apiFloatingIP, that.apiFloatingIP)) {
            return false;
        }
        if (!Objects.equals(this.apiVIP, that.apiVIP)) {
            return false;
        }
        if (!Objects.equals(this.apiVIPs, that.apiVIPs)) {
            return false;
        }
        if (!Objects.equals(this.cloud, that.cloud)) {
            return false;
        }
        if (!Objects.equals(this.clusterOSImage, that.clusterOSImage)) {
            return false;
        }
        if (!Objects.equals(this.clusterOSImageProperties, that.clusterOSImageProperties)) {
            return false;
        }
        if (!Objects.equals(this.computeFlavor, that.computeFlavor)) {
            return false;
        }
        if (!Objects.equals((Object)this.defaultMachinePlatform, (Object)that.defaultMachinePlatform)) {
            return false;
        }
        if (!Objects.equals(this.externalDNS, that.externalDNS)) {
            return false;
        }
        if (!Objects.equals(this.externalNetwork, that.externalNetwork)) {
            return false;
        }
        if (!Objects.equals(this.ingressFloatingIP, that.ingressFloatingIP)) {
            return false;
        }
        if (!Objects.equals(this.ingressVIP, that.ingressVIP)) {
            return false;
        }
        if (!Objects.equals(this.ingressVIPs, that.ingressVIPs)) {
            return false;
        }
        if (!Objects.equals(this.lbFloatingIP, that.lbFloatingIP)) {
            return false;
        }
        if (!Objects.equals(this.loadBalancer, that.loadBalancer)) {
            return false;
        }
        if (!Objects.equals(this.machinesSubnet, that.machinesSubnet)) {
            return false;
        }
        if (!Objects.equals(this.octaviaSupport, that.octaviaSupport)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.trunkSupport, that.trunkSupport)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiFloatingIP, this.apiVIP, this.apiVIPs, this.cloud, this.clusterOSImage, this.clusterOSImageProperties, this.computeFlavor, this.defaultMachinePlatform, this.externalDNS, this.externalNetwork, this.ingressFloatingIP, this.ingressVIP, this.ingressVIPs, this.lbFloatingIP, this.loadBalancer, this.machinesSubnet, this.octaviaSupport, this.region, this.trunkSupport, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiFloatingIP != null) {
            sb.append("apiFloatingIP:");
            sb.append(this.apiFloatingIP + ",");
        }
        if (this.apiVIP != null) {
            sb.append("apiVIP:");
            sb.append(this.apiVIP + ",");
        }
        if (this.apiVIPs != null && !this.apiVIPs.isEmpty()) {
            sb.append("apiVIPs:");
            sb.append(this.apiVIPs + ",");
        }
        if (this.cloud != null) {
            sb.append("cloud:");
            sb.append(this.cloud + ",");
        }
        if (this.clusterOSImage != null) {
            sb.append("clusterOSImage:");
            sb.append(this.clusterOSImage + ",");
        }
        if (this.clusterOSImageProperties != null && !this.clusterOSImageProperties.isEmpty()) {
            sb.append("clusterOSImageProperties:");
            sb.append(this.clusterOSImageProperties + ",");
        }
        if (this.computeFlavor != null) {
            sb.append("computeFlavor:");
            sb.append(this.computeFlavor + ",");
        }
        if (this.defaultMachinePlatform != null) {
            sb.append("defaultMachinePlatform:");
            sb.append((Object)((Object)this.defaultMachinePlatform) + ",");
        }
        if (this.externalDNS != null && !this.externalDNS.isEmpty()) {
            sb.append("externalDNS:");
            sb.append(this.externalDNS + ",");
        }
        if (this.externalNetwork != null) {
            sb.append("externalNetwork:");
            sb.append(this.externalNetwork + ",");
        }
        if (this.ingressFloatingIP != null) {
            sb.append("ingressFloatingIP:");
            sb.append(this.ingressFloatingIP + ",");
        }
        if (this.ingressVIP != null) {
            sb.append("ingressVIP:");
            sb.append(this.ingressVIP + ",");
        }
        if (this.ingressVIPs != null && !this.ingressVIPs.isEmpty()) {
            sb.append("ingressVIPs:");
            sb.append(this.ingressVIPs + ",");
        }
        if (this.lbFloatingIP != null) {
            sb.append("lbFloatingIP:");
            sb.append(this.lbFloatingIP + ",");
        }
        if (this.loadBalancer != null) {
            sb.append("loadBalancer:");
            sb.append(this.loadBalancer + ",");
        }
        if (this.machinesSubnet != null) {
            sb.append("machinesSubnet:");
            sb.append(this.machinesSubnet + ",");
        }
        if (this.octaviaSupport != null) {
            sb.append("octaviaSupport:");
            sb.append(this.octaviaSupport + ",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.trunkSupport != null) {
            sb.append("trunkSupport:");
            sb.append(this.trunkSupport + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DefaultMachinePlatformNested<N>
    extends MachinePoolFluent<DefaultMachinePlatformNested<N>>
    implements Nested<N> {
        MachinePoolBuilder builder;

        DefaultMachinePlatformNested(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        public N and() {
            return (N)PlatformFluent.this.withDefaultMachinePlatform(this.builder.build());
        }

        public N endDefaultMachinePlatform() {
            return this.and();
        }
    }
}

