/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.ovirt.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.ovirt.v1.AffinityGroup;
import io.fabric8.openshift.api.model.installer.ovirt.v1.AffinityGroupBuilder;
import io.fabric8.openshift.api.model.installer.ovirt.v1.AffinityGroupFluentImpl;
import io.fabric8.openshift.api.model.installer.ovirt.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.ovirt.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.installer.ovirt.v1.MachinePoolFluentImpl;
import io.fabric8.openshift.api.model.installer.ovirt.v1.Platform;
import io.fabric8.openshift.api.model.installer.ovirt.v1.PlatformFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PlatformFluentImpl<A extends PlatformFluent<A>>
extends BaseFluent<A>
implements PlatformFluent<A> {
    private ArrayList<AffinityGroupBuilder> affinityGroups = new ArrayList();
    private String apiVip;
    private MachinePoolBuilder defaultMachinePlatform;
    private String ingressVip;
    private String ovirtClusterId;
    private String ovirtNetworkName;
    private String ovirtStorageDomainId;
    private String vnicProfileID;
    private Map<String, Object> additionalProperties;

    public PlatformFluentImpl() {
    }

    public PlatformFluentImpl(Platform instance) {
        this.withAffinityGroups(instance.getAffinityGroups());
        this.withApiVip(instance.getApiVip());
        this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
        this.withIngressVip(instance.getIngressVip());
        this.withOvirtClusterId(instance.getOvirtClusterId());
        this.withOvirtNetworkName(instance.getOvirtNetworkName());
        this.withOvirtStorageDomainId(instance.getOvirtStorageDomainId());
        this.withVnicProfileID(instance.getVnicProfileID());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToAffinityGroups(Integer index, AffinityGroup item) {
        if (this.affinityGroups == null) {
            this.affinityGroups = new ArrayList();
        }
        AffinityGroupBuilder builder = new AffinityGroupBuilder(item);
        this._visitables.get((Object)"affinityGroups").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"affinityGroups").size(), builder);
        this.affinityGroups.add(index >= 0 ? index.intValue() : this.affinityGroups.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAffinityGroups(Integer index, AffinityGroup item) {
        if (this.affinityGroups == null) {
            this.affinityGroups = new ArrayList();
        }
        AffinityGroupBuilder builder = new AffinityGroupBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"affinityGroups").size()) {
            this._visitables.get((Object)"affinityGroups").add(builder);
        } else {
            this._visitables.get((Object)"affinityGroups").set(index, builder);
        }
        if (index < 0 || index >= this.affinityGroups.size()) {
            this.affinityGroups.add(builder);
        } else {
            this.affinityGroups.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAffinityGroups(AffinityGroup ... items) {
        if (this.affinityGroups == null) {
            this.affinityGroups = new ArrayList();
        }
        for (AffinityGroup item : items) {
            AffinityGroupBuilder builder = new AffinityGroupBuilder(item);
            this._visitables.get((Object)"affinityGroups").add(builder);
            this.affinityGroups.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAffinityGroups(Collection<AffinityGroup> items) {
        if (this.affinityGroups == null) {
            this.affinityGroups = new ArrayList();
        }
        for (AffinityGroup item : items) {
            AffinityGroupBuilder builder = new AffinityGroupBuilder(item);
            this._visitables.get((Object)"affinityGroups").add(builder);
            this.affinityGroups.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAffinityGroups(AffinityGroup ... items) {
        for (AffinityGroup item : items) {
            AffinityGroupBuilder builder = new AffinityGroupBuilder(item);
            this._visitables.get((Object)"affinityGroups").remove(builder);
            if (this.affinityGroups == null) continue;
            this.affinityGroups.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAffinityGroups(Collection<AffinityGroup> items) {
        for (AffinityGroup item : items) {
            AffinityGroupBuilder builder = new AffinityGroupBuilder(item);
            this._visitables.get((Object)"affinityGroups").remove(builder);
            if (this.affinityGroups == null) continue;
            this.affinityGroups.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAffinityGroups(Predicate<AffinityGroupBuilder> predicate) {
        if (this.affinityGroups == null) {
            return (A)this;
        }
        Iterator<AffinityGroupBuilder> each = this.affinityGroups.iterator();
        List visitables = this._visitables.get((Object)"affinityGroups");
        while (each.hasNext()) {
            AffinityGroupBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<AffinityGroup> getAffinityGroups() {
        return this.affinityGroups != null ? PlatformFluentImpl.build(this.affinityGroups) : null;
    }

    @Override
    public List<AffinityGroup> buildAffinityGroups() {
        return this.affinityGroups != null ? PlatformFluentImpl.build(this.affinityGroups) : null;
    }

    @Override
    public AffinityGroup buildAffinityGroup(Integer index) {
        return this.affinityGroups.get(index).build();
    }

    @Override
    public AffinityGroup buildFirstAffinityGroup() {
        return this.affinityGroups.get(0).build();
    }

    @Override
    public AffinityGroup buildLastAffinityGroup() {
        return this.affinityGroups.get(this.affinityGroups.size() - 1).build();
    }

    @Override
    public AffinityGroup buildMatchingAffinityGroup(Predicate<AffinityGroupBuilder> predicate) {
        for (AffinityGroupBuilder item : this.affinityGroups) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAffinityGroup(Predicate<AffinityGroupBuilder> predicate) {
        for (AffinityGroupBuilder item : this.affinityGroups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAffinityGroups(List<AffinityGroup> affinityGroups) {
        if (this.affinityGroups != null) {
            this._visitables.get((Object)"affinityGroups").removeAll(this.affinityGroups);
        }
        if (affinityGroups != null) {
            this.affinityGroups = new ArrayList();
            for (AffinityGroup item : affinityGroups) {
                this.addToAffinityGroups(item);
            }
        } else {
            this.affinityGroups = null;
        }
        return (A)this;
    }

    @Override
    public A withAffinityGroups(AffinityGroup ... affinityGroups) {
        if (this.affinityGroups != null) {
            this.affinityGroups.clear();
        }
        if (affinityGroups != null) {
            for (AffinityGroup item : affinityGroups) {
                this.addToAffinityGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAffinityGroups() {
        return this.affinityGroups != null && !this.affinityGroups.isEmpty();
    }

    @Override
    public A addNewAffinityGroup(String description, Boolean enforcing, String name, Integer priority) {
        return this.addToAffinityGroups(new AffinityGroup(description, enforcing, name, priority));
    }

    @Override
    public PlatformFluent.AffinityGroupsNested<A> addNewAffinityGroup() {
        return new AffinityGroupsNestedImpl();
    }

    @Override
    public PlatformFluent.AffinityGroupsNested<A> addNewAffinityGroupLike(AffinityGroup item) {
        return new AffinityGroupsNestedImpl(-1, item);
    }

    @Override
    public PlatformFluent.AffinityGroupsNested<A> setNewAffinityGroupLike(Integer index, AffinityGroup item) {
        return new AffinityGroupsNestedImpl(index, item);
    }

    @Override
    public PlatformFluent.AffinityGroupsNested<A> editAffinityGroup(Integer index) {
        if (this.affinityGroups.size() <= index) {
            throw new RuntimeException("Can't edit affinityGroups. Index exceeds size.");
        }
        return this.setNewAffinityGroupLike(index, this.buildAffinityGroup(index));
    }

    @Override
    public PlatformFluent.AffinityGroupsNested<A> editFirstAffinityGroup() {
        if (this.affinityGroups.size() == 0) {
            throw new RuntimeException("Can't edit first affinityGroups. The list is empty.");
        }
        return this.setNewAffinityGroupLike(0, this.buildAffinityGroup(0));
    }

    @Override
    public PlatformFluent.AffinityGroupsNested<A> editLastAffinityGroup() {
        int index = this.affinityGroups.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last affinityGroups. The list is empty.");
        }
        return this.setNewAffinityGroupLike(index, this.buildAffinityGroup(index));
    }

    @Override
    public PlatformFluent.AffinityGroupsNested<A> editMatchingAffinityGroup(Predicate<AffinityGroupBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.affinityGroups.size(); ++i) {
            if (!predicate.test(this.affinityGroups.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching affinityGroups. No match found.");
        }
        return this.setNewAffinityGroupLike(index, this.buildAffinityGroup(index));
    }

    @Override
    public String getApiVip() {
        return this.apiVip;
    }

    @Override
    public A withApiVip(String apiVip) {
        this.apiVip = apiVip;
        return (A)this;
    }

    @Override
    public Boolean hasApiVip() {
        return this.apiVip != null;
    }

    @Override
    @Deprecated
    public MachinePool getDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    @Override
    public MachinePool buildDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    @Override
    public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
        this._visitables.get((Object)"defaultMachinePlatform").remove(this.defaultMachinePlatform);
        if (defaultMachinePlatform != null) {
            this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
            this._visitables.get((Object)"defaultMachinePlatform").add(this.defaultMachinePlatform);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null;
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
        return new DefaultMachinePlatformNestedImpl();
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
        return new DefaultMachinePlatformNestedImpl(item);
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform());
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform() != null ? this.getDefaultMachinePlatform() : new MachinePoolBuilder().build());
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform() != null ? this.getDefaultMachinePlatform() : item);
    }

    @Override
    public String getIngressVip() {
        return this.ingressVip;
    }

    @Override
    public A withIngressVip(String ingressVip) {
        this.ingressVip = ingressVip;
        return (A)this;
    }

    @Override
    public Boolean hasIngressVip() {
        return this.ingressVip != null;
    }

    @Override
    public String getOvirtClusterId() {
        return this.ovirtClusterId;
    }

    @Override
    public A withOvirtClusterId(String ovirtClusterId) {
        this.ovirtClusterId = ovirtClusterId;
        return (A)this;
    }

    @Override
    public Boolean hasOvirtClusterId() {
        return this.ovirtClusterId != null;
    }

    @Override
    public String getOvirtNetworkName() {
        return this.ovirtNetworkName;
    }

    @Override
    public A withOvirtNetworkName(String ovirtNetworkName) {
        this.ovirtNetworkName = ovirtNetworkName;
        return (A)this;
    }

    @Override
    public Boolean hasOvirtNetworkName() {
        return this.ovirtNetworkName != null;
    }

    @Override
    public String getOvirtStorageDomainId() {
        return this.ovirtStorageDomainId;
    }

    @Override
    public A withOvirtStorageDomainId(String ovirtStorageDomainId) {
        this.ovirtStorageDomainId = ovirtStorageDomainId;
        return (A)this;
    }

    @Override
    public Boolean hasOvirtStorageDomainId() {
        return this.ovirtStorageDomainId != null;
    }

    @Override
    public String getVnicProfileID() {
        return this.vnicProfileID;
    }

    @Override
    public A withVnicProfileID(String vnicProfileID) {
        this.vnicProfileID = vnicProfileID;
        return (A)this;
    }

    @Override
    public Boolean hasVnicProfileID() {
        return this.vnicProfileID != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlatformFluentImpl that = (PlatformFluentImpl)o;
        if (this.affinityGroups != null ? !this.affinityGroups.equals(that.affinityGroups) : that.affinityGroups != null) {
            return false;
        }
        if (this.apiVip != null ? !this.apiVip.equals(that.apiVip) : that.apiVip != null) {
            return false;
        }
        if (this.defaultMachinePlatform != null ? !this.defaultMachinePlatform.equals(that.defaultMachinePlatform) : that.defaultMachinePlatform != null) {
            return false;
        }
        if (this.ingressVip != null ? !this.ingressVip.equals(that.ingressVip) : that.ingressVip != null) {
            return false;
        }
        if (this.ovirtClusterId != null ? !this.ovirtClusterId.equals(that.ovirtClusterId) : that.ovirtClusterId != null) {
            return false;
        }
        if (this.ovirtNetworkName != null ? !this.ovirtNetworkName.equals(that.ovirtNetworkName) : that.ovirtNetworkName != null) {
            return false;
        }
        if (this.ovirtStorageDomainId != null ? !this.ovirtStorageDomainId.equals(that.ovirtStorageDomainId) : that.ovirtStorageDomainId != null) {
            return false;
        }
        if (this.vnicProfileID != null ? !this.vnicProfileID.equals(that.vnicProfileID) : that.vnicProfileID != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.affinityGroups, this.apiVip, this.defaultMachinePlatform, this.ingressVip, this.ovirtClusterId, this.ovirtNetworkName, this.ovirtStorageDomainId, this.vnicProfileID, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.affinityGroups != null && !this.affinityGroups.isEmpty()) {
            sb.append("affinityGroups:");
            sb.append(this.affinityGroups + ",");
        }
        if (this.apiVip != null) {
            sb.append("apiVip:");
            sb.append(this.apiVip + ",");
        }
        if (this.defaultMachinePlatform != null) {
            sb.append("defaultMachinePlatform:");
            sb.append(this.defaultMachinePlatform + ",");
        }
        if (this.ingressVip != null) {
            sb.append("ingressVip:");
            sb.append(this.ingressVip + ",");
        }
        if (this.ovirtClusterId != null) {
            sb.append("ovirtClusterId:");
            sb.append(this.ovirtClusterId + ",");
        }
        if (this.ovirtNetworkName != null) {
            sb.append("ovirtNetworkName:");
            sb.append(this.ovirtNetworkName + ",");
        }
        if (this.ovirtStorageDomainId != null) {
            sb.append("ovirtStorageDomainId:");
            sb.append(this.ovirtStorageDomainId + ",");
        }
        if (this.vnicProfileID != null) {
            sb.append("vnicProfileID:");
            sb.append(this.vnicProfileID + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class DefaultMachinePlatformNestedImpl<N>
    extends MachinePoolFluentImpl<PlatformFluent.DefaultMachinePlatformNested<N>>
    implements PlatformFluent.DefaultMachinePlatformNested<N>,
    Nested<N> {
        MachinePoolBuilder builder;

        DefaultMachinePlatformNestedImpl(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        DefaultMachinePlatformNestedImpl() {
            this.builder = new MachinePoolBuilder(this);
        }

        @Override
        public N and() {
            return (N)PlatformFluentImpl.this.withDefaultMachinePlatform(this.builder.build());
        }

        @Override
        public N endDefaultMachinePlatform() {
            return this.and();
        }
    }

    class AffinityGroupsNestedImpl<N>
    extends AffinityGroupFluentImpl<PlatformFluent.AffinityGroupsNested<N>>
    implements PlatformFluent.AffinityGroupsNested<N>,
    Nested<N> {
        AffinityGroupBuilder builder;
        Integer index;

        AffinityGroupsNestedImpl(Integer index, AffinityGroup item) {
            this.index = index;
            this.builder = new AffinityGroupBuilder(this, item);
        }

        AffinityGroupsNestedImpl() {
            this.index = -1;
            this.builder = new AffinityGroupBuilder(this);
        }

        @Override
        public N and() {
            return (N)PlatformFluentImpl.this.setToAffinityGroups(this.index, this.builder.build());
        }

        @Override
        public N endAffinityGroup() {
            return this.and();
        }
    }
}

