/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.gcp.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.gcp.v1.EncryptionKeyReference;
import io.fabric8.openshift.api.model.installer.gcp.v1.EncryptionKeyReferenceBuilder;
import io.fabric8.openshift.api.model.installer.gcp.v1.EncryptionKeyReferenceFluentImpl;
import io.fabric8.openshift.api.model.installer.gcp.v1.OSDisk;
import io.fabric8.openshift.api.model.installer.gcp.v1.OSDiskFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class OSDiskFluentImpl<A extends OSDiskFluent<A>>
extends BaseFluent<A>
implements OSDiskFluent<A> {
    private Long diskSizeGB;
    private String diskType;
    private EncryptionKeyReferenceBuilder encryptionKey;
    private Map<String, Object> additionalProperties;

    public OSDiskFluentImpl() {
    }

    public OSDiskFluentImpl(OSDisk instance) {
        this.withDiskSizeGB(instance.getDiskSizeGB());
        this.withDiskType(instance.getDiskType());
        this.withEncryptionKey(instance.getEncryptionKey());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Long getDiskSizeGB() {
        return this.diskSizeGB;
    }

    @Override
    public A withDiskSizeGB(Long diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return (A)this;
    }

    @Override
    public Boolean hasDiskSizeGB() {
        return this.diskSizeGB != null;
    }

    @Override
    public String getDiskType() {
        return this.diskType;
    }

    @Override
    public A withDiskType(String diskType) {
        this.diskType = diskType;
        return (A)this;
    }

    @Override
    public Boolean hasDiskType() {
        return this.diskType != null;
    }

    @Override
    @Deprecated
    public EncryptionKeyReference getEncryptionKey() {
        return this.encryptionKey != null ? this.encryptionKey.build() : null;
    }

    @Override
    public EncryptionKeyReference buildEncryptionKey() {
        return this.encryptionKey != null ? this.encryptionKey.build() : null;
    }

    @Override
    public A withEncryptionKey(EncryptionKeyReference encryptionKey) {
        this._visitables.get((Object)"encryptionKey").remove(this.encryptionKey);
        if (encryptionKey != null) {
            this.encryptionKey = new EncryptionKeyReferenceBuilder(encryptionKey);
            this._visitables.get((Object)"encryptionKey").add(this.encryptionKey);
        }
        return (A)this;
    }

    @Override
    public Boolean hasEncryptionKey() {
        return this.encryptionKey != null;
    }

    @Override
    public OSDiskFluent.EncryptionKeyNested<A> withNewEncryptionKey() {
        return new EncryptionKeyNestedImpl();
    }

    @Override
    public OSDiskFluent.EncryptionKeyNested<A> withNewEncryptionKeyLike(EncryptionKeyReference item) {
        return new EncryptionKeyNestedImpl(item);
    }

    @Override
    public OSDiskFluent.EncryptionKeyNested<A> editEncryptionKey() {
        return this.withNewEncryptionKeyLike(this.getEncryptionKey());
    }

    @Override
    public OSDiskFluent.EncryptionKeyNested<A> editOrNewEncryptionKey() {
        return this.withNewEncryptionKeyLike(this.getEncryptionKey() != null ? this.getEncryptionKey() : new EncryptionKeyReferenceBuilder().build());
    }

    @Override
    public OSDiskFluent.EncryptionKeyNested<A> editOrNewEncryptionKeyLike(EncryptionKeyReference item) {
        return this.withNewEncryptionKeyLike(this.getEncryptionKey() != null ? this.getEncryptionKey() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OSDiskFluentImpl that = (OSDiskFluentImpl)o;
        if (this.diskSizeGB != null ? !this.diskSizeGB.equals(that.diskSizeGB) : that.diskSizeGB != null) {
            return false;
        }
        if (this.diskType != null ? !this.diskType.equals(that.diskType) : that.diskType != null) {
            return false;
        }
        if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.diskSizeGB, this.diskType, this.encryptionKey, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.diskSizeGB != null) {
            sb.append("diskSizeGB:");
            sb.append(this.diskSizeGB + ",");
        }
        if (this.diskType != null) {
            sb.append("diskType:");
            sb.append(this.diskType + ",");
        }
        if (this.encryptionKey != null) {
            sb.append("encryptionKey:");
            sb.append(this.encryptionKey + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class EncryptionKeyNestedImpl<N>
    extends EncryptionKeyReferenceFluentImpl<OSDiskFluent.EncryptionKeyNested<N>>
    implements OSDiskFluent.EncryptionKeyNested<N>,
    Nested<N> {
        EncryptionKeyReferenceBuilder builder;

        EncryptionKeyNestedImpl(EncryptionKeyReference item) {
            this.builder = new EncryptionKeyReferenceBuilder(this, item);
        }

        EncryptionKeyNestedImpl() {
            this.builder = new EncryptionKeyReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)OSDiskFluentImpl.this.withEncryptionKey(this.builder.build());
        }

        @Override
        public N endEncryptionKey() {
            return this.and();
        }
    }
}

