/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.aws.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.openshift.api.model.hive.aws.v1.AssumeRole;
import io.fabric8.openshift.api.model.hive.aws.v1.AssumeRoleBuilder;
import io.fabric8.openshift.api.model.hive.aws.v1.AssumeRoleFluent;
import io.fabric8.openshift.api.model.hive.aws.v1.Platform;
import io.fabric8.openshift.api.model.hive.aws.v1.PrivateLinkAccess;
import io.fabric8.openshift.api.model.hive.aws.v1.PrivateLinkAccessBuilder;
import io.fabric8.openshift.api.model.hive.aws.v1.PrivateLinkAccessFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PlatformFluent<A extends PlatformFluent<A>>
extends BaseFluent<A> {
    private AssumeRoleBuilder credentialsAssumeRole;
    private LocalObjectReferenceBuilder credentialsSecretRef;
    private PrivateLinkAccessBuilder privateLink;
    private String region;
    private Map<String, String> userTags;
    private Map<String, Object> additionalProperties;

    public PlatformFluent() {
    }

    public PlatformFluent(Platform instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Platform instance) {
        Platform platform = instance = instance != null ? instance : new Platform();
        if (instance != null) {
            this.withCredentialsAssumeRole(instance.getCredentialsAssumeRole());
            this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
            this.withPrivateLink(instance.getPrivateLink());
            this.withRegion(instance.getRegion());
            this.withUserTags(instance.getUserTags());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AssumeRole buildCredentialsAssumeRole() {
        return this.credentialsAssumeRole != null ? this.credentialsAssumeRole.build() : null;
    }

    public A withCredentialsAssumeRole(AssumeRole credentialsAssumeRole) {
        this._visitables.remove((Object)"credentialsAssumeRole");
        if (credentialsAssumeRole != null) {
            this.credentialsAssumeRole = new AssumeRoleBuilder(credentialsAssumeRole);
            this._visitables.get((Object)"credentialsAssumeRole").add(this.credentialsAssumeRole);
        } else {
            this.credentialsAssumeRole = null;
            this._visitables.get((Object)"credentialsAssumeRole").remove((Object)this.credentialsAssumeRole);
        }
        return (A)((Object)this);
    }

    public boolean hasCredentialsAssumeRole() {
        return this.credentialsAssumeRole != null;
    }

    public A withNewCredentialsAssumeRole(String externalID, String roleARN) {
        return this.withCredentialsAssumeRole(new AssumeRole(externalID, roleARN));
    }

    public CredentialsAssumeRoleNested<A> withNewCredentialsAssumeRole() {
        return new CredentialsAssumeRoleNested(null);
    }

    public CredentialsAssumeRoleNested<A> withNewCredentialsAssumeRoleLike(AssumeRole item) {
        return new CredentialsAssumeRoleNested(item);
    }

    public CredentialsAssumeRoleNested<A> editCredentialsAssumeRole() {
        return this.withNewCredentialsAssumeRoleLike(Optional.ofNullable(this.buildCredentialsAssumeRole()).orElse(null));
    }

    public CredentialsAssumeRoleNested<A> editOrNewCredentialsAssumeRole() {
        return this.withNewCredentialsAssumeRoleLike(Optional.ofNullable(this.buildCredentialsAssumeRole()).orElse(new AssumeRoleBuilder().build()));
    }

    public CredentialsAssumeRoleNested<A> editOrNewCredentialsAssumeRoleLike(AssumeRole item) {
        return this.withNewCredentialsAssumeRoleLike(Optional.ofNullable(this.buildCredentialsAssumeRole()).orElse(item));
    }

    public LocalObjectReference buildCredentialsSecretRef() {
        return this.credentialsSecretRef != null ? this.credentialsSecretRef.build() : null;
    }

    public A withCredentialsSecretRef(LocalObjectReference credentialsSecretRef) {
        this._visitables.remove((Object)"credentialsSecretRef");
        if (credentialsSecretRef != null) {
            this.credentialsSecretRef = new LocalObjectReferenceBuilder(credentialsSecretRef);
            this._visitables.get((Object)"credentialsSecretRef").add(this.credentialsSecretRef);
        } else {
            this.credentialsSecretRef = null;
            this._visitables.get((Object)"credentialsSecretRef").remove(this.credentialsSecretRef);
        }
        return (A)((Object)this);
    }

    public boolean hasCredentialsSecretRef() {
        return this.credentialsSecretRef != null;
    }

    public A withNewCredentialsSecretRef(String name) {
        return this.withCredentialsSecretRef(new LocalObjectReference(name));
    }

    public CredentialsSecretRefNested<A> withNewCredentialsSecretRef() {
        return new CredentialsSecretRefNested(null);
    }

    public CredentialsSecretRefNested<A> withNewCredentialsSecretRefLike(LocalObjectReference item) {
        return new CredentialsSecretRefNested(item);
    }

    public CredentialsSecretRefNested<A> editCredentialsSecretRef() {
        return this.withNewCredentialsSecretRefLike(Optional.ofNullable(this.buildCredentialsSecretRef()).orElse(null));
    }

    public CredentialsSecretRefNested<A> editOrNewCredentialsSecretRef() {
        return this.withNewCredentialsSecretRefLike(Optional.ofNullable(this.buildCredentialsSecretRef()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public CredentialsSecretRefNested<A> editOrNewCredentialsSecretRefLike(LocalObjectReference item) {
        return this.withNewCredentialsSecretRefLike(Optional.ofNullable(this.buildCredentialsSecretRef()).orElse(item));
    }

    public PrivateLinkAccess buildPrivateLink() {
        return this.privateLink != null ? this.privateLink.build() : null;
    }

    public A withPrivateLink(PrivateLinkAccess privateLink) {
        this._visitables.remove((Object)"privateLink");
        if (privateLink != null) {
            this.privateLink = new PrivateLinkAccessBuilder(privateLink);
            this._visitables.get((Object)"privateLink").add(this.privateLink);
        } else {
            this.privateLink = null;
            this._visitables.get((Object)"privateLink").remove((Object)this.privateLink);
        }
        return (A)((Object)this);
    }

    public boolean hasPrivateLink() {
        return this.privateLink != null;
    }

    public PrivateLinkNested<A> withNewPrivateLink() {
        return new PrivateLinkNested(null);
    }

    public PrivateLinkNested<A> withNewPrivateLinkLike(PrivateLinkAccess item) {
        return new PrivateLinkNested(item);
    }

    public PrivateLinkNested<A> editPrivateLink() {
        return this.withNewPrivateLinkLike(Optional.ofNullable(this.buildPrivateLink()).orElse(null));
    }

    public PrivateLinkNested<A> editOrNewPrivateLink() {
        return this.withNewPrivateLinkLike(Optional.ofNullable(this.buildPrivateLink()).orElse(new PrivateLinkAccessBuilder().build()));
    }

    public PrivateLinkNested<A> editOrNewPrivateLinkLike(PrivateLinkAccess item) {
        return this.withNewPrivateLinkLike(Optional.ofNullable(this.buildPrivateLink()).orElse(item));
    }

    public String getRegion() {
        return this.region;
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)((Object)this);
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public A addToUserTags(String key, String value) {
        if (this.userTags == null && key != null && value != null) {
            this.userTags = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.userTags.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToUserTags(Map<String, String> map) {
        if (this.userTags == null && map != null) {
            this.userTags = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.userTags.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromUserTags(String key) {
        if (this.userTags == null) {
            return (A)((Object)this);
        }
        if (key != null && this.userTags != null) {
            this.userTags.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromUserTags(Map<String, String> map) {
        if (this.userTags == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.userTags == null) continue;
                this.userTags.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getUserTags() {
        return this.userTags;
    }

    public <K, V> A withUserTags(Map<String, String> userTags) {
        this.userTags = userTags == null ? null : new LinkedHashMap<String, String>(userTags);
        return (A)((Object)this);
    }

    public boolean hasUserTags() {
        return this.userTags != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlatformFluent that = (PlatformFluent)((Object)o);
        if (!Objects.equals((Object)this.credentialsAssumeRole, (Object)that.credentialsAssumeRole)) {
            return false;
        }
        if (!Objects.equals(this.credentialsSecretRef, that.credentialsSecretRef)) {
            return false;
        }
        if (!Objects.equals((Object)this.privateLink, (Object)that.privateLink)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.userTags, that.userTags)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.credentialsAssumeRole, this.credentialsSecretRef, this.privateLink, this.region, this.userTags, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.credentialsAssumeRole != null) {
            sb.append("credentialsAssumeRole:");
            sb.append(this.credentialsAssumeRole + ",");
        }
        if (this.credentialsSecretRef != null) {
            sb.append("credentialsSecretRef:");
            sb.append(this.credentialsSecretRef + ",");
        }
        if (this.privateLink != null) {
            sb.append("privateLink:");
            sb.append(this.privateLink + ",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.userTags != null && !this.userTags.isEmpty()) {
            sb.append("userTags:");
            sb.append(this.userTags + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PrivateLinkNested<N>
    extends PrivateLinkAccessFluent<PrivateLinkNested<N>>
    implements Nested<N> {
        PrivateLinkAccessBuilder builder;

        PrivateLinkNested(PrivateLinkAccess item) {
            this.builder = new PrivateLinkAccessBuilder(this, item);
        }

        public N and() {
            return (N)PlatformFluent.this.withPrivateLink(this.builder.build());
        }

        public N endPrivateLink() {
            return this.and();
        }
    }

    public class CredentialsSecretRefNested<N>
    extends LocalObjectReferenceFluent<CredentialsSecretRefNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        CredentialsSecretRefNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)PlatformFluent.this.withCredentialsSecretRef(this.builder.build());
        }

        public N endCredentialsSecretRef() {
            return this.and();
        }
    }

    public class CredentialsAssumeRoleNested<N>
    extends AssumeRoleFluent<CredentialsAssumeRoleNested<N>>
    implements Nested<N> {
        AssumeRoleBuilder builder;

        CredentialsAssumeRoleNested(AssumeRole item) {
            this.builder = new AssumeRoleBuilder(this, item);
        }

        public N and() {
            return (N)PlatformFluent.this.withCredentialsAssumeRole(this.builder.build());
        }

        public N endCredentialsAssumeRole() {
            return this.and();
        }
    }
}

