/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.openshift.api.model.hive.aws.v1.AssumeRole;
import io.fabric8.openshift.api.model.hive.aws.v1.AssumeRoleBuilder;
import io.fabric8.openshift.api.model.hive.aws.v1.AssumeRoleFluent;
import io.fabric8.openshift.api.model.hive.v1.AWSDNSZoneSpec;
import io.fabric8.openshift.api.model.hive.v1.AWSResourceTag;
import io.fabric8.openshift.api.model.hive.v1.AWSResourceTagBuilder;
import io.fabric8.openshift.api.model.hive.v1.AWSResourceTagFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class AWSDNSZoneSpecFluent<A extends AWSDNSZoneSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<AWSResourceTagBuilder> additionalTags = new ArrayList();
    private AssumeRoleBuilder credentialsAssumeRole;
    private LocalObjectReferenceBuilder credentialsSecretRef;
    private String region;
    private Map<String, Object> additionalProperties;

    public AWSDNSZoneSpecFluent() {
    }

    public AWSDNSZoneSpecFluent(AWSDNSZoneSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AWSDNSZoneSpec instance) {
        AWSDNSZoneSpec aWSDNSZoneSpec = instance = instance != null ? instance : new AWSDNSZoneSpec();
        if (instance != null) {
            this.withAdditionalTags(instance.getAdditionalTags());
            this.withCredentialsAssumeRole(instance.getCredentialsAssumeRole());
            this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
            this.withRegion(instance.getRegion());
            this.withAdditionalTags(instance.getAdditionalTags());
            this.withCredentialsAssumeRole(instance.getCredentialsAssumeRole());
            this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
            this.withRegion(instance.getRegion());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAdditionalTags(int index, AWSResourceTag item) {
        if (this.additionalTags == null) {
            this.additionalTags = new ArrayList();
        }
        AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);
        if (index < 0 || index >= this.additionalTags.size()) {
            this._visitables.get((Object)"additionalTags").add(builder);
            this.additionalTags.add(builder);
        } else {
            this._visitables.get((Object)"additionalTags").add(index, builder);
            this.additionalTags.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAdditionalTags(int index, AWSResourceTag item) {
        if (this.additionalTags == null) {
            this.additionalTags = new ArrayList();
        }
        AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);
        if (index < 0 || index >= this.additionalTags.size()) {
            this._visitables.get((Object)"additionalTags").add(builder);
            this.additionalTags.add(builder);
        } else {
            this._visitables.get((Object)"additionalTags").set(index, builder);
            this.additionalTags.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalTags(AWSResourceTag ... items) {
        if (this.additionalTags == null) {
            this.additionalTags = new ArrayList();
        }
        for (AWSResourceTag item : items) {
            AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);
            this._visitables.get((Object)"additionalTags").add(builder);
            this.additionalTags.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAdditionalTags(Collection<AWSResourceTag> items) {
        if (this.additionalTags == null) {
            this.additionalTags = new ArrayList();
        }
        for (AWSResourceTag item : items) {
            AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);
            this._visitables.get((Object)"additionalTags").add(builder);
            this.additionalTags.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalTags(AWSResourceTag ... items) {
        if (this.additionalTags == null) {
            return (A)((Object)this);
        }
        for (AWSResourceTag item : items) {
            AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);
            this._visitables.get((Object)"additionalTags").remove((Object)builder);
            this.additionalTags.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAdditionalTags(Collection<AWSResourceTag> items) {
        if (this.additionalTags == null) {
            return (A)((Object)this);
        }
        for (AWSResourceTag item : items) {
            AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);
            this._visitables.get((Object)"additionalTags").remove((Object)builder);
            this.additionalTags.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAdditionalTags(Predicate<AWSResourceTagBuilder> predicate) {
        if (this.additionalTags == null) {
            return (A)((Object)this);
        }
        Iterator<AWSResourceTagBuilder> each = this.additionalTags.iterator();
        List visitables = this._visitables.get((Object)"additionalTags");
        while (each.hasNext()) {
            AWSResourceTagBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<AWSResourceTag> buildAdditionalTags() {
        return this.additionalTags != null ? AWSDNSZoneSpecFluent.build(this.additionalTags) : null;
    }

    public AWSResourceTag buildAdditionalTag(int index) {
        return this.additionalTags.get(index).build();
    }

    public AWSResourceTag buildFirstAdditionalTag() {
        return this.additionalTags.get(0).build();
    }

    public AWSResourceTag buildLastAdditionalTag() {
        return this.additionalTags.get(this.additionalTags.size() - 1).build();
    }

    public AWSResourceTag buildMatchingAdditionalTag(Predicate<AWSResourceTagBuilder> predicate) {
        for (AWSResourceTagBuilder item : this.additionalTags) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAdditionalTag(Predicate<AWSResourceTagBuilder> predicate) {
        for (AWSResourceTagBuilder item : this.additionalTags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAdditionalTags(List<AWSResourceTag> additionalTags) {
        if (this.additionalTags != null) {
            this._visitables.get((Object)"additionalTags").clear();
        }
        if (additionalTags != null) {
            this.additionalTags = new ArrayList();
            for (AWSResourceTag item : additionalTags) {
                this.addToAdditionalTags(item);
            }
        } else {
            this.additionalTags = null;
        }
        return (A)((Object)this);
    }

    public A withAdditionalTags(AWSResourceTag ... additionalTags) {
        if (this.additionalTags != null) {
            this.additionalTags.clear();
            this._visitables.remove((Object)"additionalTags");
        }
        if (additionalTags != null) {
            for (AWSResourceTag item : additionalTags) {
                this.addToAdditionalTags(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAdditionalTags() {
        return this.additionalTags != null && !this.additionalTags.isEmpty();
    }

    public A addNewAdditionalTag(String key, String value) {
        return this.addToAdditionalTags(new AWSResourceTag(key, value));
    }

    public AdditionalTagsNested<A> addNewAdditionalTag() {
        return new AdditionalTagsNested(-1, null);
    }

    public AdditionalTagsNested<A> addNewAdditionalTagLike(AWSResourceTag item) {
        return new AdditionalTagsNested(-1, item);
    }

    public AdditionalTagsNested<A> setNewAdditionalTagLike(int index, AWSResourceTag item) {
        return new AdditionalTagsNested(index, item);
    }

    public AdditionalTagsNested<A> editAdditionalTag(int index) {
        if (this.additionalTags.size() <= index) {
            throw new RuntimeException("Can't edit additionalTags. Index exceeds size.");
        }
        return this.setNewAdditionalTagLike(index, this.buildAdditionalTag(index));
    }

    public AdditionalTagsNested<A> editFirstAdditionalTag() {
        if (this.additionalTags.size() == 0) {
            throw new RuntimeException("Can't edit first additionalTags. The list is empty.");
        }
        return this.setNewAdditionalTagLike(0, this.buildAdditionalTag(0));
    }

    public AdditionalTagsNested<A> editLastAdditionalTag() {
        int index = this.additionalTags.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last additionalTags. The list is empty.");
        }
        return this.setNewAdditionalTagLike(index, this.buildAdditionalTag(index));
    }

    public AdditionalTagsNested<A> editMatchingAdditionalTag(Predicate<AWSResourceTagBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.additionalTags.size(); ++i) {
            if (!predicate.test(this.additionalTags.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching additionalTags. No match found.");
        }
        return this.setNewAdditionalTagLike(index, this.buildAdditionalTag(index));
    }

    public AssumeRole buildCredentialsAssumeRole() {
        return this.credentialsAssumeRole != null ? this.credentialsAssumeRole.build() : null;
    }

    public A withCredentialsAssumeRole(AssumeRole credentialsAssumeRole) {
        this._visitables.get((Object)"credentialsAssumeRole").remove((Object)this.credentialsAssumeRole);
        if (credentialsAssumeRole != null) {
            this.credentialsAssumeRole = new AssumeRoleBuilder(credentialsAssumeRole);
            this._visitables.get((Object)"credentialsAssumeRole").add(this.credentialsAssumeRole);
        } else {
            this.credentialsAssumeRole = null;
            this._visitables.get((Object)"credentialsAssumeRole").remove((Object)this.credentialsAssumeRole);
        }
        return (A)((Object)this);
    }

    public boolean hasCredentialsAssumeRole() {
        return this.credentialsAssumeRole != null;
    }

    public A withNewCredentialsAssumeRole(String externalID, String roleARN) {
        return this.withCredentialsAssumeRole(new AssumeRole(externalID, roleARN));
    }

    public CredentialsAssumeRoleNested<A> withNewCredentialsAssumeRole() {
        return new CredentialsAssumeRoleNested(null);
    }

    public CredentialsAssumeRoleNested<A> withNewCredentialsAssumeRoleLike(AssumeRole item) {
        return new CredentialsAssumeRoleNested(item);
    }

    public CredentialsAssumeRoleNested<A> editCredentialsAssumeRole() {
        return this.withNewCredentialsAssumeRoleLike(Optional.ofNullable(this.buildCredentialsAssumeRole()).orElse(null));
    }

    public CredentialsAssumeRoleNested<A> editOrNewCredentialsAssumeRole() {
        return this.withNewCredentialsAssumeRoleLike(Optional.ofNullable(this.buildCredentialsAssumeRole()).orElse(new AssumeRoleBuilder().build()));
    }

    public CredentialsAssumeRoleNested<A> editOrNewCredentialsAssumeRoleLike(AssumeRole item) {
        return this.withNewCredentialsAssumeRoleLike(Optional.ofNullable(this.buildCredentialsAssumeRole()).orElse(item));
    }

    public LocalObjectReference buildCredentialsSecretRef() {
        return this.credentialsSecretRef != null ? this.credentialsSecretRef.build() : null;
    }

    public A withCredentialsSecretRef(LocalObjectReference credentialsSecretRef) {
        this._visitables.get((Object)"credentialsSecretRef").remove(this.credentialsSecretRef);
        if (credentialsSecretRef != null) {
            this.credentialsSecretRef = new LocalObjectReferenceBuilder(credentialsSecretRef);
            this._visitables.get((Object)"credentialsSecretRef").add(this.credentialsSecretRef);
        } else {
            this.credentialsSecretRef = null;
            this._visitables.get((Object)"credentialsSecretRef").remove(this.credentialsSecretRef);
        }
        return (A)((Object)this);
    }

    public boolean hasCredentialsSecretRef() {
        return this.credentialsSecretRef != null;
    }

    public A withNewCredentialsSecretRef(String name) {
        return this.withCredentialsSecretRef(new LocalObjectReference(name));
    }

    public CredentialsSecretRefNested<A> withNewCredentialsSecretRef() {
        return new CredentialsSecretRefNested(null);
    }

    public CredentialsSecretRefNested<A> withNewCredentialsSecretRefLike(LocalObjectReference item) {
        return new CredentialsSecretRefNested(item);
    }

    public CredentialsSecretRefNested<A> editCredentialsSecretRef() {
        return this.withNewCredentialsSecretRefLike(Optional.ofNullable(this.buildCredentialsSecretRef()).orElse(null));
    }

    public CredentialsSecretRefNested<A> editOrNewCredentialsSecretRef() {
        return this.withNewCredentialsSecretRefLike(Optional.ofNullable(this.buildCredentialsSecretRef()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public CredentialsSecretRefNested<A> editOrNewCredentialsSecretRefLike(LocalObjectReference item) {
        return this.withNewCredentialsSecretRefLike(Optional.ofNullable(this.buildCredentialsSecretRef()).orElse(item));
    }

    public String getRegion() {
        return this.region;
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)((Object)this);
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AWSDNSZoneSpecFluent that = (AWSDNSZoneSpecFluent)((Object)o);
        if (!Objects.equals(this.additionalTags, that.additionalTags)) {
            return false;
        }
        if (!Objects.equals((Object)this.credentialsAssumeRole, (Object)that.credentialsAssumeRole)) {
            return false;
        }
        if (!Objects.equals(this.credentialsSecretRef, that.credentialsSecretRef)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalTags, this.credentialsAssumeRole, this.credentialsSecretRef, this.region, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.additionalTags != null && !this.additionalTags.isEmpty()) {
            sb.append("additionalTags:");
            sb.append(this.additionalTags + ",");
        }
        if (this.credentialsAssumeRole != null) {
            sb.append("credentialsAssumeRole:");
            sb.append((Object)((Object)this.credentialsAssumeRole) + ",");
        }
        if (this.credentialsSecretRef != null) {
            sb.append("credentialsSecretRef:");
            sb.append(this.credentialsSecretRef + ",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class CredentialsSecretRefNested<N>
    extends LocalObjectReferenceFluent<CredentialsSecretRefNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        CredentialsSecretRefNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)AWSDNSZoneSpecFluent.this.withCredentialsSecretRef(this.builder.build());
        }

        public N endCredentialsSecretRef() {
            return this.and();
        }
    }

    public class CredentialsAssumeRoleNested<N>
    extends AssumeRoleFluent<CredentialsAssumeRoleNested<N>>
    implements Nested<N> {
        AssumeRoleBuilder builder;

        CredentialsAssumeRoleNested(AssumeRole item) {
            this.builder = new AssumeRoleBuilder(this, item);
        }

        public N and() {
            return (N)AWSDNSZoneSpecFluent.this.withCredentialsAssumeRole(this.builder.build());
        }

        public N endCredentialsAssumeRole() {
            return this.and();
        }
    }

    public class AdditionalTagsNested<N>
    extends AWSResourceTagFluent<AdditionalTagsNested<N>>
    implements Nested<N> {
        AWSResourceTagBuilder builder;
        int index;

        AdditionalTagsNested(int index, AWSResourceTag item) {
            this.index = index;
            this.builder = new AWSResourceTagBuilder(this, item);
        }

        public N and() {
            return (N)AWSDNSZoneSpecFluent.this.setToAdditionalTags(this.index, this.builder.build());
        }

        public N endAdditionalTag() {
            return this.and();
        }
    }
}

