package io.fabric8.openshift.api.model.hive.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SpotMarketOptionsBuilder extends SpotMarketOptionsFluent<SpotMarketOptionsBuilder> implements VisitableBuilder<SpotMarketOptions,SpotMarketOptionsBuilder>{
  public SpotMarketOptionsBuilder() {
    this(new SpotMarketOptions());
  }
  
  public SpotMarketOptionsBuilder(SpotMarketOptionsFluent<?> fluent) {
    this(fluent, new SpotMarketOptions());
  }
  
  public SpotMarketOptionsBuilder(SpotMarketOptionsFluent<?> fluent,SpotMarketOptions instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SpotMarketOptionsBuilder(SpotMarketOptions instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SpotMarketOptionsFluent<?> fluent;
  
  public SpotMarketOptions build() {
    SpotMarketOptions buildable = new SpotMarketOptions(fluent.getMaxPrice());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}