/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.hive.v1.AWSAssociatedVPC;
import io.fabric8.openshift.api.model.hive.v1.AWSAssociatedVPCBuilder;
import io.fabric8.openshift.api.model.hive.v1.AWSAssociatedVPCFluentImpl;
import io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkConfig;
import io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkConfigFluent;
import io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkInventory;
import io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkInventoryBuilder;
import io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkInventoryFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AWSPrivateLinkConfigFluentImpl<A extends AWSPrivateLinkConfigFluent<A>>
extends BaseFluent<A>
implements AWSPrivateLinkConfigFluent<A> {
    private ArrayList<AWSAssociatedVPCBuilder> associatedVPCs = new ArrayList();
    private LocalObjectReferenceBuilder credentialsSecretRef;
    private String dnsRecordType;
    private ArrayList<AWSPrivateLinkInventoryBuilder> endpointVPCInventory = new ArrayList();
    private Map<String, Object> additionalProperties;

    public AWSPrivateLinkConfigFluentImpl() {
    }

    public AWSPrivateLinkConfigFluentImpl(AWSPrivateLinkConfig instance) {
        this.withAssociatedVPCs(instance.getAssociatedVPCs());
        this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
        this.withDnsRecordType(instance.getDnsRecordType());
        this.withEndpointVPCInventory(instance.getEndpointVPCInventory());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToAssociatedVPCs(Integer index, AWSAssociatedVPC item) {
        if (this.associatedVPCs == null) {
            this.associatedVPCs = new ArrayList();
        }
        AWSAssociatedVPCBuilder builder = new AWSAssociatedVPCBuilder(item);
        this._visitables.get((Object)"associatedVPCs").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"associatedVPCs").size(), builder);
        this.associatedVPCs.add(index >= 0 ? index.intValue() : this.associatedVPCs.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAssociatedVPCs(Integer index, AWSAssociatedVPC item) {
        if (this.associatedVPCs == null) {
            this.associatedVPCs = new ArrayList();
        }
        AWSAssociatedVPCBuilder builder = new AWSAssociatedVPCBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"associatedVPCs").size()) {
            this._visitables.get((Object)"associatedVPCs").add(builder);
        } else {
            this._visitables.get((Object)"associatedVPCs").set(index, builder);
        }
        if (index < 0 || index >= this.associatedVPCs.size()) {
            this.associatedVPCs.add(builder);
        } else {
            this.associatedVPCs.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAssociatedVPCs(AWSAssociatedVPC ... items) {
        if (this.associatedVPCs == null) {
            this.associatedVPCs = new ArrayList();
        }
        for (AWSAssociatedVPC item : items) {
            AWSAssociatedVPCBuilder builder = new AWSAssociatedVPCBuilder(item);
            this._visitables.get((Object)"associatedVPCs").add(builder);
            this.associatedVPCs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAssociatedVPCs(Collection<AWSAssociatedVPC> items) {
        if (this.associatedVPCs == null) {
            this.associatedVPCs = new ArrayList();
        }
        for (AWSAssociatedVPC item : items) {
            AWSAssociatedVPCBuilder builder = new AWSAssociatedVPCBuilder(item);
            this._visitables.get((Object)"associatedVPCs").add(builder);
            this.associatedVPCs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAssociatedVPCs(AWSAssociatedVPC ... items) {
        for (AWSAssociatedVPC item : items) {
            AWSAssociatedVPCBuilder builder = new AWSAssociatedVPCBuilder(item);
            this._visitables.get((Object)"associatedVPCs").remove(builder);
            if (this.associatedVPCs == null) continue;
            this.associatedVPCs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAssociatedVPCs(Collection<AWSAssociatedVPC> items) {
        for (AWSAssociatedVPC item : items) {
            AWSAssociatedVPCBuilder builder = new AWSAssociatedVPCBuilder(item);
            this._visitables.get((Object)"associatedVPCs").remove(builder);
            if (this.associatedVPCs == null) continue;
            this.associatedVPCs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAssociatedVPCs(Predicate<AWSAssociatedVPCBuilder> predicate) {
        if (this.associatedVPCs == null) {
            return (A)this;
        }
        Iterator<AWSAssociatedVPCBuilder> each = this.associatedVPCs.iterator();
        List visitables = this._visitables.get((Object)"associatedVPCs");
        while (each.hasNext()) {
            AWSAssociatedVPCBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<AWSAssociatedVPC> getAssociatedVPCs() {
        return this.associatedVPCs != null ? AWSPrivateLinkConfigFluentImpl.build(this.associatedVPCs) : null;
    }

    @Override
    public List<AWSAssociatedVPC> buildAssociatedVPCs() {
        return this.associatedVPCs != null ? AWSPrivateLinkConfigFluentImpl.build(this.associatedVPCs) : null;
    }

    @Override
    public AWSAssociatedVPC buildAssociatedVPC(Integer index) {
        return this.associatedVPCs.get(index).build();
    }

    @Override
    public AWSAssociatedVPC buildFirstAssociatedVPC() {
        return this.associatedVPCs.get(0).build();
    }

    @Override
    public AWSAssociatedVPC buildLastAssociatedVPC() {
        return this.associatedVPCs.get(this.associatedVPCs.size() - 1).build();
    }

    @Override
    public AWSAssociatedVPC buildMatchingAssociatedVPC(Predicate<AWSAssociatedVPCBuilder> predicate) {
        for (AWSAssociatedVPCBuilder item : this.associatedVPCs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAssociatedVPC(Predicate<AWSAssociatedVPCBuilder> predicate) {
        for (AWSAssociatedVPCBuilder item : this.associatedVPCs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAssociatedVPCs(List<AWSAssociatedVPC> associatedVPCs) {
        if (this.associatedVPCs != null) {
            this._visitables.get((Object)"associatedVPCs").removeAll(this.associatedVPCs);
        }
        if (associatedVPCs != null) {
            this.associatedVPCs = new ArrayList();
            for (AWSAssociatedVPC item : associatedVPCs) {
                this.addToAssociatedVPCs(item);
            }
        } else {
            this.associatedVPCs = null;
        }
        return (A)this;
    }

    @Override
    public A withAssociatedVPCs(AWSAssociatedVPC ... associatedVPCs) {
        if (this.associatedVPCs != null) {
            this.associatedVPCs.clear();
        }
        if (associatedVPCs != null) {
            for (AWSAssociatedVPC item : associatedVPCs) {
                this.addToAssociatedVPCs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAssociatedVPCs() {
        return this.associatedVPCs != null && !this.associatedVPCs.isEmpty();
    }

    @Override
    public AWSPrivateLinkConfigFluent.AssociatedVPCsNested<A> addNewAssociatedVPC() {
        return new AssociatedVPCsNestedImpl();
    }

    @Override
    public AWSPrivateLinkConfigFluent.AssociatedVPCsNested<A> addNewAssociatedVPCLike(AWSAssociatedVPC item) {
        return new AssociatedVPCsNestedImpl(-1, item);
    }

    @Override
    public AWSPrivateLinkConfigFluent.AssociatedVPCsNested<A> setNewAssociatedVPCLike(Integer index, AWSAssociatedVPC item) {
        return new AssociatedVPCsNestedImpl(index, item);
    }

    @Override
    public AWSPrivateLinkConfigFluent.AssociatedVPCsNested<A> editAssociatedVPC(Integer index) {
        if (this.associatedVPCs.size() <= index) {
            throw new RuntimeException("Can't edit associatedVPCs. Index exceeds size.");
        }
        return this.setNewAssociatedVPCLike(index, this.buildAssociatedVPC(index));
    }

    @Override
    public AWSPrivateLinkConfigFluent.AssociatedVPCsNested<A> editFirstAssociatedVPC() {
        if (this.associatedVPCs.size() == 0) {
            throw new RuntimeException("Can't edit first associatedVPCs. The list is empty.");
        }
        return this.setNewAssociatedVPCLike(0, this.buildAssociatedVPC(0));
    }

    @Override
    public AWSPrivateLinkConfigFluent.AssociatedVPCsNested<A> editLastAssociatedVPC() {
        int index = this.associatedVPCs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last associatedVPCs. The list is empty.");
        }
        return this.setNewAssociatedVPCLike(index, this.buildAssociatedVPC(index));
    }

    @Override
    public AWSPrivateLinkConfigFluent.AssociatedVPCsNested<A> editMatchingAssociatedVPC(Predicate<AWSAssociatedVPCBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.associatedVPCs.size(); ++i) {
            if (!predicate.test(this.associatedVPCs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching associatedVPCs. No match found.");
        }
        return this.setNewAssociatedVPCLike(index, this.buildAssociatedVPC(index));
    }

    @Override
    @Deprecated
    public LocalObjectReference getCredentialsSecretRef() {
        return this.credentialsSecretRef != null ? this.credentialsSecretRef.build() : null;
    }

    @Override
    public LocalObjectReference buildCredentialsSecretRef() {
        return this.credentialsSecretRef != null ? this.credentialsSecretRef.build() : null;
    }

    @Override
    public A withCredentialsSecretRef(LocalObjectReference credentialsSecretRef) {
        this._visitables.get((Object)"credentialsSecretRef").remove(this.credentialsSecretRef);
        if (credentialsSecretRef != null) {
            this.credentialsSecretRef = new LocalObjectReferenceBuilder(credentialsSecretRef);
            this._visitables.get((Object)"credentialsSecretRef").add(this.credentialsSecretRef);
        } else {
            this.credentialsSecretRef = null;
            this._visitables.get((Object)"credentialsSecretRef").remove(this.credentialsSecretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCredentialsSecretRef() {
        return this.credentialsSecretRef != null;
    }

    @Override
    public A withNewCredentialsSecretRef(String name) {
        return this.withCredentialsSecretRef(new LocalObjectReference(name));
    }

    @Override
    public AWSPrivateLinkConfigFluent.CredentialsSecretRefNested<A> withNewCredentialsSecretRef() {
        return new CredentialsSecretRefNestedImpl();
    }

    @Override
    public AWSPrivateLinkConfigFluent.CredentialsSecretRefNested<A> withNewCredentialsSecretRefLike(LocalObjectReference item) {
        return new CredentialsSecretRefNestedImpl(item);
    }

    @Override
    public AWSPrivateLinkConfigFluent.CredentialsSecretRefNested<A> editCredentialsSecretRef() {
        return this.withNewCredentialsSecretRefLike(this.getCredentialsSecretRef());
    }

    @Override
    public AWSPrivateLinkConfigFluent.CredentialsSecretRefNested<A> editOrNewCredentialsSecretRef() {
        return this.withNewCredentialsSecretRefLike(this.getCredentialsSecretRef() != null ? this.getCredentialsSecretRef() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public AWSPrivateLinkConfigFluent.CredentialsSecretRefNested<A> editOrNewCredentialsSecretRefLike(LocalObjectReference item) {
        return this.withNewCredentialsSecretRefLike(this.getCredentialsSecretRef() != null ? this.getCredentialsSecretRef() : item);
    }

    @Override
    public String getDnsRecordType() {
        return this.dnsRecordType;
    }

    @Override
    public A withDnsRecordType(String dnsRecordType) {
        this.dnsRecordType = dnsRecordType;
        return (A)this;
    }

    @Override
    public Boolean hasDnsRecordType() {
        return this.dnsRecordType != null;
    }

    @Override
    public A addToEndpointVPCInventory(Integer index, AWSPrivateLinkInventory item) {
        if (this.endpointVPCInventory == null) {
            this.endpointVPCInventory = new ArrayList();
        }
        AWSPrivateLinkInventoryBuilder builder = new AWSPrivateLinkInventoryBuilder(item);
        this._visitables.get((Object)"endpointVPCInventory").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"endpointVPCInventory").size(), builder);
        this.endpointVPCInventory.add(index >= 0 ? index.intValue() : this.endpointVPCInventory.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEndpointVPCInventory(Integer index, AWSPrivateLinkInventory item) {
        if (this.endpointVPCInventory == null) {
            this.endpointVPCInventory = new ArrayList();
        }
        AWSPrivateLinkInventoryBuilder builder = new AWSPrivateLinkInventoryBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"endpointVPCInventory").size()) {
            this._visitables.get((Object)"endpointVPCInventory").add(builder);
        } else {
            this._visitables.get((Object)"endpointVPCInventory").set(index, builder);
        }
        if (index < 0 || index >= this.endpointVPCInventory.size()) {
            this.endpointVPCInventory.add(builder);
        } else {
            this.endpointVPCInventory.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEndpointVPCInventory(AWSPrivateLinkInventory ... items) {
        if (this.endpointVPCInventory == null) {
            this.endpointVPCInventory = new ArrayList();
        }
        for (AWSPrivateLinkInventory item : items) {
            AWSPrivateLinkInventoryBuilder builder = new AWSPrivateLinkInventoryBuilder(item);
            this._visitables.get((Object)"endpointVPCInventory").add(builder);
            this.endpointVPCInventory.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEndpointVPCInventory(Collection<AWSPrivateLinkInventory> items) {
        if (this.endpointVPCInventory == null) {
            this.endpointVPCInventory = new ArrayList();
        }
        for (AWSPrivateLinkInventory item : items) {
            AWSPrivateLinkInventoryBuilder builder = new AWSPrivateLinkInventoryBuilder(item);
            this._visitables.get((Object)"endpointVPCInventory").add(builder);
            this.endpointVPCInventory.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEndpointVPCInventory(AWSPrivateLinkInventory ... items) {
        for (AWSPrivateLinkInventory item : items) {
            AWSPrivateLinkInventoryBuilder builder = new AWSPrivateLinkInventoryBuilder(item);
            this._visitables.get((Object)"endpointVPCInventory").remove(builder);
            if (this.endpointVPCInventory == null) continue;
            this.endpointVPCInventory.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEndpointVPCInventory(Collection<AWSPrivateLinkInventory> items) {
        for (AWSPrivateLinkInventory item : items) {
            AWSPrivateLinkInventoryBuilder builder = new AWSPrivateLinkInventoryBuilder(item);
            this._visitables.get((Object)"endpointVPCInventory").remove(builder);
            if (this.endpointVPCInventory == null) continue;
            this.endpointVPCInventory.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEndpointVPCInventory(Predicate<AWSPrivateLinkInventoryBuilder> predicate) {
        if (this.endpointVPCInventory == null) {
            return (A)this;
        }
        Iterator<AWSPrivateLinkInventoryBuilder> each = this.endpointVPCInventory.iterator();
        List visitables = this._visitables.get((Object)"endpointVPCInventory");
        while (each.hasNext()) {
            AWSPrivateLinkInventoryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<AWSPrivateLinkInventory> getEndpointVPCInventory() {
        return this.endpointVPCInventory != null ? AWSPrivateLinkConfigFluentImpl.build(this.endpointVPCInventory) : null;
    }

    @Override
    public List<AWSPrivateLinkInventory> buildEndpointVPCInventory() {
        return this.endpointVPCInventory != null ? AWSPrivateLinkConfigFluentImpl.build(this.endpointVPCInventory) : null;
    }

    @Override
    public AWSPrivateLinkInventory buildEndpointVPCInventory(Integer index) {
        return this.endpointVPCInventory.get(index).build();
    }

    @Override
    public AWSPrivateLinkInventory buildFirstEndpointVPCInventory() {
        return this.endpointVPCInventory.get(0).build();
    }

    @Override
    public AWSPrivateLinkInventory buildLastEndpointVPCInventory() {
        return this.endpointVPCInventory.get(this.endpointVPCInventory.size() - 1).build();
    }

    @Override
    public AWSPrivateLinkInventory buildMatchingEndpointVPCInventory(Predicate<AWSPrivateLinkInventoryBuilder> predicate) {
        for (AWSPrivateLinkInventoryBuilder item : this.endpointVPCInventory) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEndpointVPCInventory(Predicate<AWSPrivateLinkInventoryBuilder> predicate) {
        for (AWSPrivateLinkInventoryBuilder item : this.endpointVPCInventory) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEndpointVPCInventory(List<AWSPrivateLinkInventory> endpointVPCInventory) {
        if (this.endpointVPCInventory != null) {
            this._visitables.get((Object)"endpointVPCInventory").removeAll(this.endpointVPCInventory);
        }
        if (endpointVPCInventory != null) {
            this.endpointVPCInventory = new ArrayList();
            for (AWSPrivateLinkInventory item : endpointVPCInventory) {
                this.addToEndpointVPCInventory(item);
            }
        } else {
            this.endpointVPCInventory = null;
        }
        return (A)this;
    }

    @Override
    public A withEndpointVPCInventory(AWSPrivateLinkInventory ... endpointVPCInventory) {
        if (this.endpointVPCInventory != null) {
            this.endpointVPCInventory.clear();
        }
        if (endpointVPCInventory != null) {
            for (AWSPrivateLinkInventory item : endpointVPCInventory) {
                this.addToEndpointVPCInventory(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEndpointVPCInventory() {
        return this.endpointVPCInventory != null && !this.endpointVPCInventory.isEmpty();
    }

    @Override
    public AWSPrivateLinkConfigFluent.EndpointVPCInventoryNested<A> addNewEndpointVPCInventory() {
        return new EndpointVPCInventoryNestedImpl();
    }

    @Override
    public AWSPrivateLinkConfigFluent.EndpointVPCInventoryNested<A> addNewEndpointVPCInventoryLike(AWSPrivateLinkInventory item) {
        return new EndpointVPCInventoryNestedImpl(-1, item);
    }

    @Override
    public AWSPrivateLinkConfigFluent.EndpointVPCInventoryNested<A> setNewEndpointVPCInventoryLike(Integer index, AWSPrivateLinkInventory item) {
        return new EndpointVPCInventoryNestedImpl(index, item);
    }

    @Override
    public AWSPrivateLinkConfigFluent.EndpointVPCInventoryNested<A> editEndpointVPCInventory(Integer index) {
        if (this.endpointVPCInventory.size() <= index) {
            throw new RuntimeException("Can't edit endpointVPCInventory. Index exceeds size.");
        }
        return this.setNewEndpointVPCInventoryLike(index, this.buildEndpointVPCInventory(index));
    }

    @Override
    public AWSPrivateLinkConfigFluent.EndpointVPCInventoryNested<A> editFirstEndpointVPCInventory() {
        if (this.endpointVPCInventory.size() == 0) {
            throw new RuntimeException("Can't edit first endpointVPCInventory. The list is empty.");
        }
        return this.setNewEndpointVPCInventoryLike(0, this.buildEndpointVPCInventory(0));
    }

    @Override
    public AWSPrivateLinkConfigFluent.EndpointVPCInventoryNested<A> editLastEndpointVPCInventory() {
        int index = this.endpointVPCInventory.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last endpointVPCInventory. The list is empty.");
        }
        return this.setNewEndpointVPCInventoryLike(index, this.buildEndpointVPCInventory(index));
    }

    @Override
    public AWSPrivateLinkConfigFluent.EndpointVPCInventoryNested<A> editMatchingEndpointVPCInventory(Predicate<AWSPrivateLinkInventoryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.endpointVPCInventory.size(); ++i) {
            if (!predicate.test(this.endpointVPCInventory.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching endpointVPCInventory. No match found.");
        }
        return this.setNewEndpointVPCInventoryLike(index, this.buildEndpointVPCInventory(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSPrivateLinkConfigFluentImpl that = (AWSPrivateLinkConfigFluentImpl)o;
        if (this.associatedVPCs != null ? !this.associatedVPCs.equals(that.associatedVPCs) : that.associatedVPCs != null) {
            return false;
        }
        if (this.credentialsSecretRef != null ? !this.credentialsSecretRef.equals((Object)that.credentialsSecretRef) : that.credentialsSecretRef != null) {
            return false;
        }
        if (this.dnsRecordType != null ? !this.dnsRecordType.equals(that.dnsRecordType) : that.dnsRecordType != null) {
            return false;
        }
        if (this.endpointVPCInventory != null ? !this.endpointVPCInventory.equals(that.endpointVPCInventory) : that.endpointVPCInventory != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.associatedVPCs, this.credentialsSecretRef, this.dnsRecordType, this.endpointVPCInventory, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.associatedVPCs != null && !this.associatedVPCs.isEmpty()) {
            sb.append("associatedVPCs:");
            sb.append(this.associatedVPCs + ",");
        }
        if (this.credentialsSecretRef != null) {
            sb.append("credentialsSecretRef:");
            sb.append(this.credentialsSecretRef + ",");
        }
        if (this.dnsRecordType != null) {
            sb.append("dnsRecordType:");
            sb.append(this.dnsRecordType + ",");
        }
        if (this.endpointVPCInventory != null && !this.endpointVPCInventory.isEmpty()) {
            sb.append("endpointVPCInventory:");
            sb.append(this.endpointVPCInventory + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class EndpointVPCInventoryNestedImpl<N>
    extends AWSPrivateLinkInventoryFluentImpl<AWSPrivateLinkConfigFluent.EndpointVPCInventoryNested<N>>
    implements AWSPrivateLinkConfigFluent.EndpointVPCInventoryNested<N>,
    Nested<N> {
        AWSPrivateLinkInventoryBuilder builder;
        Integer index;

        EndpointVPCInventoryNestedImpl(Integer index, AWSPrivateLinkInventory item) {
            this.index = index;
            this.builder = new AWSPrivateLinkInventoryBuilder(this, item);
        }

        EndpointVPCInventoryNestedImpl() {
            this.index = -1;
            this.builder = new AWSPrivateLinkInventoryBuilder(this);
        }

        @Override
        public N and() {
            return (N)AWSPrivateLinkConfigFluentImpl.this.setToEndpointVPCInventory(this.index, this.builder.build());
        }

        @Override
        public N endEndpointVPCInventory() {
            return this.and();
        }
    }

    class CredentialsSecretRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<AWSPrivateLinkConfigFluent.CredentialsSecretRefNested<N>>
    implements AWSPrivateLinkConfigFluent.CredentialsSecretRefNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        CredentialsSecretRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        CredentialsSecretRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this);
        }

        @Override
        public N and() {
            return (N)AWSPrivateLinkConfigFluentImpl.this.withCredentialsSecretRef(this.builder.build());
        }

        @Override
        public N endCredentialsSecretRef() {
            return this.and();
        }
    }

    class AssociatedVPCsNestedImpl<N>
    extends AWSAssociatedVPCFluentImpl<AWSPrivateLinkConfigFluent.AssociatedVPCsNested<N>>
    implements AWSPrivateLinkConfigFluent.AssociatedVPCsNested<N>,
    Nested<N> {
        AWSAssociatedVPCBuilder builder;
        Integer index;

        AssociatedVPCsNestedImpl(Integer index, AWSAssociatedVPC item) {
            this.index = index;
            this.builder = new AWSAssociatedVPCBuilder(this, item);
        }

        AssociatedVPCsNestedImpl() {
            this.index = -1;
            this.builder = new AWSAssociatedVPCBuilder(this);
        }

        @Override
        public N and() {
            return (N)AWSPrivateLinkConfigFluentImpl.this.setToAssociatedVPCs(this.index, this.builder.build());
        }

        @Override
        public N endAssociatedVPC() {
            return this.and();
        }
    }
}

