/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.azure.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.hive.azure.v1.Platform;
import io.fabric8.openshift.api.model.hive.azure.v1.PlatformFluent;
import io.fabric8.openshift.api.model.hive.azure.v1.PlatformFluentImpl;
import java.util.Objects;

public class PlatformBuilder
extends PlatformFluentImpl<PlatformBuilder>
implements VisitableBuilder<Platform, PlatformBuilder> {
    PlatformFluent<?> fluent;
    Boolean validationEnabled;

    public PlatformBuilder() {
        this(false);
    }

    public PlatformBuilder(Boolean validationEnabled) {
        this(new Platform(), validationEnabled);
    }

    public PlatformBuilder(PlatformFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public PlatformBuilder(PlatformFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Platform(), validationEnabled);
    }

    public PlatformBuilder(PlatformFluent<?> fluent, Platform instance) {
        this(fluent, instance, false);
    }

    public PlatformBuilder(PlatformFluent<?> fluent, Platform instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withBaseDomainResourceGroupName(instance.getBaseDomainResourceGroupName());
        fluent.withCloudName(instance.getCloudName());
        fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef());
        fluent.withRegion(instance.getRegion());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public PlatformBuilder(Platform instance) {
        this(instance, (Boolean)false);
    }

    public PlatformBuilder(Platform instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withBaseDomainResourceGroupName(instance.getBaseDomainResourceGroupName());
        this.withCloudName(instance.getCloudName());
        this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
        this.withRegion(instance.getRegion());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public Platform build() {
        Platform buildable = new Platform(this.fluent.getBaseDomainResourceGroupName(), this.fluent.getCloudName(), this.fluent.getCredentialsSecretRef(), this.fluent.getRegion());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlatformBuilder that = (PlatformBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

