/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.ovirt.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.hive.ovirt.v1.Disk;
import io.fabric8.openshift.api.model.hive.ovirt.v1.DiskFluent;
import io.fabric8.openshift.api.model.hive.ovirt.v1.DiskFluentImpl;
import java.util.Objects;

public class DiskBuilder
extends DiskFluentImpl<DiskBuilder>
implements VisitableBuilder<Disk, DiskBuilder> {
    DiskFluent<?> fluent;
    Boolean validationEnabled;

    public DiskBuilder() {
        this(false);
    }

    public DiskBuilder(Boolean validationEnabled) {
        this(new Disk(), validationEnabled);
    }

    public DiskBuilder(DiskFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public DiskBuilder(DiskFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Disk(), validationEnabled);
    }

    public DiskBuilder(DiskFluent<?> fluent, Disk instance) {
        this(fluent, instance, false);
    }

    public DiskBuilder(DiskFluent<?> fluent, Disk instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withSizeGB(instance.getSizeGB());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public DiskBuilder(Disk instance) {
        this(instance, (Boolean)false);
    }

    public DiskBuilder(Disk instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withSizeGB(instance.getSizeGB());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public Disk build() {
        Disk buildable = new Disk(this.fluent.getSizeGB());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DiskBuilder that = (DiskBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

