package io.fabric8.openshift.api.model.console.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ConsoleSampleContainerImportSourceFluent<A extends ConsoleSampleContainerImportSourceFluent<A>> extends BaseFluent<A>{
  public ConsoleSampleContainerImportSourceFluent() {
  }
  
  public ConsoleSampleContainerImportSourceFluent(ConsoleSampleContainerImportSource instance) {
    this.copyInstance(instance);
  }
  private String image;
  private ConsoleSampleContainerImportSourceServiceBuilder service;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ConsoleSampleContainerImportSource instance) {
    instance = (instance != null ? instance : new ConsoleSampleContainerImportSource());
    if (instance != null) {
          this.withImage(instance.getImage());
          this.withService(instance.getService());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getImage() {
    return this.image;
  }
  
  public A withImage(String image) {
    this.image = image;
    return (A) this;
  }
  
  public boolean hasImage() {
    return this.image != null;
  }
  
  public ConsoleSampleContainerImportSourceService buildService() {
    return this.service != null ? this.service.build() : null;
  }
  
  public A withService(ConsoleSampleContainerImportSourceService service) {
    this._visitables.remove("service");
    if (service != null) {
        this.service = new ConsoleSampleContainerImportSourceServiceBuilder(service);
        this._visitables.get("service").add(this.service);
    } else {
        this.service = null;
        this._visitables.get("service").remove(this.service);
    }
    return (A) this;
  }
  
  public boolean hasService() {
    return this.service != null;
  }
  
  public A withNewService(Integer targetPort) {
    return (A)withService(new ConsoleSampleContainerImportSourceService(targetPort));
  }
  
  public ServiceNested<A> withNewService() {
    return new ServiceNested(null);
  }
  
  public ServiceNested<A> withNewServiceLike(ConsoleSampleContainerImportSourceService item) {
    return new ServiceNested(item);
  }
  
  public ServiceNested<A> editService() {
    return withNewServiceLike(java.util.Optional.ofNullable(buildService()).orElse(null));
  }
  
  public ServiceNested<A> editOrNewService() {
    return withNewServiceLike(java.util.Optional.ofNullable(buildService()).orElse(new ConsoleSampleContainerImportSourceServiceBuilder().build()));
  }
  
  public ServiceNested<A> editOrNewServiceLike(ConsoleSampleContainerImportSourceService item) {
    return withNewServiceLike(java.util.Optional.ofNullable(buildService()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConsoleSampleContainerImportSourceFluent that = (ConsoleSampleContainerImportSourceFluent) o;
    if (!java.util.Objects.equals(image, that.image)) return false;
    if (!java.util.Objects.equals(service, that.service)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(image,  service,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (service != null) { sb.append("service:"); sb.append(service + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ServiceNested<N> extends ConsoleSampleContainerImportSourceServiceFluent<ServiceNested<N>> implements Nested<N>{
    ServiceNested(ConsoleSampleContainerImportSourceService item) {
      this.builder = new ConsoleSampleContainerImportSourceServiceBuilder(this, item);
    }
    ConsoleSampleContainerImportSourceServiceBuilder builder;
    
    public N and() {
      return (N) ConsoleSampleContainerImportSourceFluent.this.withService(builder.build());
    }
    
    public N endService() {
      return and();
    }
    
  
  }

}