package io.fabric8.openshift.api.model.console.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ConsolePluginProxyFluent<A extends ConsolePluginProxyFluent<A>> extends BaseFluent<A>{
  public ConsolePluginProxyFluent() {
  }
  
  public ConsolePluginProxyFluent(ConsolePluginProxy instance) {
    this.copyInstance(instance);
  }
  private String alias;
  private String authorization;
  private String caCertificate;
  private ConsolePluginProxyEndpointBuilder endpoint;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ConsolePluginProxy instance) {
    instance = (instance != null ? instance : new ConsolePluginProxy());
    if (instance != null) {
          this.withAlias(instance.getAlias());
          this.withAuthorization(instance.getAuthorization());
          this.withCaCertificate(instance.getCaCertificate());
          this.withEndpoint(instance.getEndpoint());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getAlias() {
    return this.alias;
  }
  
  public A withAlias(String alias) {
    this.alias = alias;
    return (A) this;
  }
  
  public boolean hasAlias() {
    return this.alias != null;
  }
  
  public String getAuthorization() {
    return this.authorization;
  }
  
  public A withAuthorization(String authorization) {
    this.authorization = authorization;
    return (A) this;
  }
  
  public boolean hasAuthorization() {
    return this.authorization != null;
  }
  
  public String getCaCertificate() {
    return this.caCertificate;
  }
  
  public A withCaCertificate(String caCertificate) {
    this.caCertificate = caCertificate;
    return (A) this;
  }
  
  public boolean hasCaCertificate() {
    return this.caCertificate != null;
  }
  
  public ConsolePluginProxyEndpoint buildEndpoint() {
    return this.endpoint != null ? this.endpoint.build() : null;
  }
  
  public A withEndpoint(ConsolePluginProxyEndpoint endpoint) {
    this._visitables.remove("endpoint");
    if (endpoint != null) {
        this.endpoint = new ConsolePluginProxyEndpointBuilder(endpoint);
        this._visitables.get("endpoint").add(this.endpoint);
    } else {
        this.endpoint = null;
        this._visitables.get("endpoint").remove(this.endpoint);
    }
    return (A) this;
  }
  
  public boolean hasEndpoint() {
    return this.endpoint != null;
  }
  
  public EndpointNested<A> withNewEndpoint() {
    return new EndpointNested(null);
  }
  
  public EndpointNested<A> withNewEndpointLike(ConsolePluginProxyEndpoint item) {
    return new EndpointNested(item);
  }
  
  public EndpointNested<A> editEndpoint() {
    return withNewEndpointLike(java.util.Optional.ofNullable(buildEndpoint()).orElse(null));
  }
  
  public EndpointNested<A> editOrNewEndpoint() {
    return withNewEndpointLike(java.util.Optional.ofNullable(buildEndpoint()).orElse(new ConsolePluginProxyEndpointBuilder().build()));
  }
  
  public EndpointNested<A> editOrNewEndpointLike(ConsolePluginProxyEndpoint item) {
    return withNewEndpointLike(java.util.Optional.ofNullable(buildEndpoint()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConsolePluginProxyFluent that = (ConsolePluginProxyFluent) o;
    if (!java.util.Objects.equals(alias, that.alias)) return false;
    if (!java.util.Objects.equals(authorization, that.authorization)) return false;
    if (!java.util.Objects.equals(caCertificate, that.caCertificate)) return false;
    if (!java.util.Objects.equals(endpoint, that.endpoint)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(alias,  authorization,  caCertificate,  endpoint,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (alias != null) { sb.append("alias:"); sb.append(alias + ","); }
    if (authorization != null) { sb.append("authorization:"); sb.append(authorization + ","); }
    if (caCertificate != null) { sb.append("caCertificate:"); sb.append(caCertificate + ","); }
    if (endpoint != null) { sb.append("endpoint:"); sb.append(endpoint + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class EndpointNested<N> extends ConsolePluginProxyEndpointFluent<EndpointNested<N>> implements Nested<N>{
    EndpointNested(ConsolePluginProxyEndpoint item) {
      this.builder = new ConsolePluginProxyEndpointBuilder(this, item);
    }
    ConsolePluginProxyEndpointBuilder builder;
    
    public N and() {
      return (N) ConsolePluginProxyFluent.this.withEndpoint(builder.build());
    }
    
    public N endEndpoint() {
      return and();
    }
    
  
  }

}