package io.fabric8.openshift.api.model.console.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ConsolePluginBackendFluent<A extends ConsolePluginBackendFluent<A>> extends BaseFluent<A>{
  public ConsolePluginBackendFluent() {
  }
  
  public ConsolePluginBackendFluent(ConsolePluginBackend instance) {
    this.copyInstance(instance);
  }
  private ConsolePluginServiceBuilder service;
  private String type;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ConsolePluginBackend instance) {
    instance = (instance != null ? instance : new ConsolePluginBackend());
    if (instance != null) {
          this.withService(instance.getService());
          this.withType(instance.getType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ConsolePluginService buildService() {
    return this.service != null ? this.service.build() : null;
  }
  
  public A withService(ConsolePluginService service) {
    this._visitables.remove("service");
    if (service != null) {
        this.service = new ConsolePluginServiceBuilder(service);
        this._visitables.get("service").add(this.service);
    } else {
        this.service = null;
        this._visitables.get("service").remove(this.service);
    }
    return (A) this;
  }
  
  public boolean hasService() {
    return this.service != null;
  }
  
  public A withNewService(String basePath,String name,String namespace,Integer port) {
    return (A)withService(new ConsolePluginService(basePath, name, namespace, port));
  }
  
  public ServiceNested<A> withNewService() {
    return new ServiceNested(null);
  }
  
  public ServiceNested<A> withNewServiceLike(ConsolePluginService item) {
    return new ServiceNested(item);
  }
  
  public ServiceNested<A> editService() {
    return withNewServiceLike(java.util.Optional.ofNullable(buildService()).orElse(null));
  }
  
  public ServiceNested<A> editOrNewService() {
    return withNewServiceLike(java.util.Optional.ofNullable(buildService()).orElse(new ConsolePluginServiceBuilder().build()));
  }
  
  public ServiceNested<A> editOrNewServiceLike(ConsolePluginService item) {
    return withNewServiceLike(java.util.Optional.ofNullable(buildService()).orElse(item));
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConsolePluginBackendFluent that = (ConsolePluginBackendFluent) o;
    if (!java.util.Objects.equals(service, that.service)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(service,  type,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (service != null) { sb.append("service:"); sb.append(service + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ServiceNested<N> extends ConsolePluginServiceFluent<ServiceNested<N>> implements Nested<N>{
    ServiceNested(ConsolePluginService item) {
      this.builder = new ConsolePluginServiceBuilder(this, item);
    }
    ConsolePluginServiceBuilder builder;
    
    public N and() {
      return (N) ConsolePluginBackendFluent.this.withService(builder.build());
    }
    
    public N endService() {
      return and();
    }
    
  
  }

}