package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ApplicationMenuSpecBuilder extends ApplicationMenuSpecFluent<ApplicationMenuSpecBuilder> implements VisitableBuilder<ApplicationMenuSpec,ApplicationMenuSpecBuilder>{
  public ApplicationMenuSpecBuilder() {
    this(new ApplicationMenuSpec());
  }
  
  public ApplicationMenuSpecBuilder(ApplicationMenuSpecFluent<?> fluent) {
    this(fluent, new ApplicationMenuSpec());
  }
  
  public ApplicationMenuSpecBuilder(ApplicationMenuSpecFluent<?> fluent,ApplicationMenuSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ApplicationMenuSpecBuilder(ApplicationMenuSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ApplicationMenuSpecFluent<?> fluent;
  
  public ApplicationMenuSpec build() {
    ApplicationMenuSpec buildable = new ApplicationMenuSpec(fluent.getImageURL(),fluent.getSection());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}