/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.AWSPlatformStatus;
import io.fabric8.openshift.api.model.config.v1.AWSResourceTag;
import io.fabric8.openshift.api.model.config.v1.AWSResourceTagBuilder;
import io.fabric8.openshift.api.model.config.v1.AWSResourceTagFluent;
import io.fabric8.openshift.api.model.config.v1.AWSServiceEndpoint;
import io.fabric8.openshift.api.model.config.v1.AWSServiceEndpointBuilder;
import io.fabric8.openshift.api.model.config.v1.AWSServiceEndpointFluent;
import io.fabric8.openshift.api.model.config.v1.CloudLoadBalancerConfig;
import io.fabric8.openshift.api.model.config.v1.CloudLoadBalancerConfigBuilder;
import io.fabric8.openshift.api.model.config.v1.CloudLoadBalancerConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class AWSPlatformStatusFluent<A extends AWSPlatformStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private CloudLoadBalancerConfigBuilder cloudLoadBalancerConfig;
    private String region;
    private ArrayList<AWSResourceTagBuilder> resourceTags = new ArrayList();
    private ArrayList<AWSServiceEndpointBuilder> serviceEndpoints = new ArrayList();

    public AWSPlatformStatusFluent() {
    }

    public AWSPlatformStatusFluent(AWSPlatformStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToResourceTags(Collection<AWSResourceTag> items) {
        if (this.resourceTags == null) {
            this.resourceTags = new ArrayList();
        }
        for (AWSResourceTag item : items) {
            AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);
            this._visitables.get((Object)"resourceTags").add(builder);
            this.resourceTags.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToServiceEndpoints(Collection<AWSServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        for (AWSServiceEndpoint item : items) {
            AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
            this._visitables.get((Object)"serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        }
        return (A)((Object)this);
    }

    public ResourceTagsNested<A> addNewResourceTag() {
        return new ResourceTagsNested(-1, null);
    }

    public A addNewResourceTag(String key, String value) {
        return this.addToResourceTags(new AWSResourceTag(key, value));
    }

    public ResourceTagsNested<A> addNewResourceTagLike(AWSResourceTag item) {
        return new ResourceTagsNested(-1, item);
    }

    public ServiceEndpointsNested<A> addNewServiceEndpoint() {
        return new ServiceEndpointsNested(-1, null);
    }

    public A addNewServiceEndpoint(String name, String url) {
        return this.addToServiceEndpoints(new AWSServiceEndpoint(name, url));
    }

    public ServiceEndpointsNested<A> addNewServiceEndpointLike(AWSServiceEndpoint item) {
        return new ServiceEndpointsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToResourceTags(AWSResourceTag ... items) {
        if (this.resourceTags == null) {
            this.resourceTags = new ArrayList();
        }
        for (AWSResourceTag item : items) {
            AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);
            this._visitables.get((Object)"resourceTags").add(builder);
            this.resourceTags.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToResourceTags(int index, AWSResourceTag item) {
        if (this.resourceTags == null) {
            this.resourceTags = new ArrayList();
        }
        AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);
        if (index < 0 || index >= this.resourceTags.size()) {
            this._visitables.get((Object)"resourceTags").add(builder);
            this.resourceTags.add(builder);
        } else {
            this._visitables.get((Object)"resourceTags").add(builder);
            this.resourceTags.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToServiceEndpoints(AWSServiceEndpoint ... items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        for (AWSServiceEndpoint item : items) {
            AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
            this._visitables.get((Object)"serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToServiceEndpoints(int index, AWSServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
        if (index < 0 || index >= this.serviceEndpoints.size()) {
            this._visitables.get((Object)"serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        } else {
            this._visitables.get((Object)"serviceEndpoints").add(builder);
            this.serviceEndpoints.add(index, builder);
        }
        return (A)((Object)this);
    }

    public CloudLoadBalancerConfig buildCloudLoadBalancerConfig() {
        return this.cloudLoadBalancerConfig != null ? this.cloudLoadBalancerConfig.build() : null;
    }

    public AWSResourceTag buildFirstResourceTag() {
        return this.resourceTags.get(0).build();
    }

    public AWSServiceEndpoint buildFirstServiceEndpoint() {
        return this.serviceEndpoints.get(0).build();
    }

    public AWSResourceTag buildLastResourceTag() {
        return this.resourceTags.get(this.resourceTags.size() - 1).build();
    }

    public AWSServiceEndpoint buildLastServiceEndpoint() {
        return this.serviceEndpoints.get(this.serviceEndpoints.size() - 1).build();
    }

    public AWSResourceTag buildMatchingResourceTag(Predicate<AWSResourceTagBuilder> predicate) {
        for (AWSResourceTagBuilder item : this.resourceTags) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public AWSServiceEndpoint buildMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate) {
        for (AWSServiceEndpointBuilder item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public AWSResourceTag buildResourceTag(int index) {
        return this.resourceTags.get(index).build();
    }

    public List<AWSResourceTag> buildResourceTags() {
        return this.resourceTags != null ? AWSPlatformStatusFluent.build(this.resourceTags) : null;
    }

    public AWSServiceEndpoint buildServiceEndpoint(int index) {
        return this.serviceEndpoints.get(index).build();
    }

    public List<AWSServiceEndpoint> buildServiceEndpoints() {
        return this.serviceEndpoints != null ? AWSPlatformStatusFluent.build(this.serviceEndpoints) : null;
    }

    protected void copyInstance(AWSPlatformStatus instance) {
        AWSPlatformStatus aWSPlatformStatus = instance = instance != null ? instance : new AWSPlatformStatus();
        if (instance != null) {
            this.withCloudLoadBalancerConfig(instance.getCloudLoadBalancerConfig());
            this.withRegion(instance.getRegion());
            this.withResourceTags(instance.getResourceTags());
            this.withServiceEndpoints(instance.getServiceEndpoints());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public CloudLoadBalancerConfigNested<A> editCloudLoadBalancerConfig() {
        return this.withNewCloudLoadBalancerConfigLike(Optional.ofNullable(this.buildCloudLoadBalancerConfig()).orElse(null));
    }

    public ResourceTagsNested<A> editFirstResourceTag() {
        if (this.resourceTags.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "resourceTags"));
        }
        return this.setNewResourceTagLike(0, this.buildResourceTag(0));
    }

    public ServiceEndpointsNested<A> editFirstServiceEndpoint() {
        if (this.serviceEndpoints.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "serviceEndpoints"));
        }
        return this.setNewServiceEndpointLike(0, this.buildServiceEndpoint(0));
    }

    public ResourceTagsNested<A> editLastResourceTag() {
        int index = this.resourceTags.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "resourceTags"));
        }
        return this.setNewResourceTagLike(index, this.buildResourceTag(index));
    }

    public ServiceEndpointsNested<A> editLastServiceEndpoint() {
        int index = this.serviceEndpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "serviceEndpoints"));
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    public ResourceTagsNested<A> editMatchingResourceTag(Predicate<AWSResourceTagBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resourceTags.size(); ++i) {
            if (!predicate.test(this.resourceTags.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "resourceTags"));
        }
        return this.setNewResourceTagLike(index, this.buildResourceTag(index));
    }

    public ServiceEndpointsNested<A> editMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.serviceEndpoints.size(); ++i) {
            if (!predicate.test(this.serviceEndpoints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "serviceEndpoints"));
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    public CloudLoadBalancerConfigNested<A> editOrNewCloudLoadBalancerConfig() {
        return this.withNewCloudLoadBalancerConfigLike(Optional.ofNullable(this.buildCloudLoadBalancerConfig()).orElse(new CloudLoadBalancerConfigBuilder().build()));
    }

    public CloudLoadBalancerConfigNested<A> editOrNewCloudLoadBalancerConfigLike(CloudLoadBalancerConfig item) {
        return this.withNewCloudLoadBalancerConfigLike(Optional.ofNullable(this.buildCloudLoadBalancerConfig()).orElse(item));
    }

    public ResourceTagsNested<A> editResourceTag(int index) {
        if (this.resourceTags.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "resourceTags"));
        }
        return this.setNewResourceTagLike(index, this.buildResourceTag(index));
    }

    public ServiceEndpointsNested<A> editServiceEndpoint(int index) {
        if (this.serviceEndpoints.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "serviceEndpoints"));
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AWSPlatformStatusFluent that = (AWSPlatformStatusFluent)((Object)o);
        if (!Objects.equals((Object)this.cloudLoadBalancerConfig, (Object)that.cloudLoadBalancerConfig)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.resourceTags, that.resourceTags)) {
            return false;
        }
        if (!Objects.equals(this.serviceEndpoints, that.serviceEndpoints)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getRegion() {
        return this.region;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCloudLoadBalancerConfig() {
        return this.cloudLoadBalancerConfig != null;
    }

    public boolean hasMatchingResourceTag(Predicate<AWSResourceTagBuilder> predicate) {
        for (AWSResourceTagBuilder item : this.resourceTags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate) {
        for (AWSServiceEndpointBuilder item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public boolean hasResourceTags() {
        return this.resourceTags != null && !this.resourceTags.isEmpty();
    }

    public boolean hasServiceEndpoints() {
        return this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cloudLoadBalancerConfig, this.region, this.resourceTags, this.serviceEndpoints, this.additionalProperties});
    }

    public A removeAllFromResourceTags(Collection<AWSResourceTag> items) {
        if (this.resourceTags == null) {
            return (A)((Object)this);
        }
        for (AWSResourceTag item : items) {
            AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);
            this._visitables.get((Object)"resourceTags").remove((Object)builder);
            this.resourceTags.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromServiceEndpoints(Collection<AWSServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {
            return (A)((Object)this);
        }
        for (AWSServiceEndpoint item : items) {
            AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
            this._visitables.get((Object)"serviceEndpoints").remove((Object)builder);
            this.serviceEndpoints.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromResourceTags(AWSResourceTag ... items) {
        if (this.resourceTags == null) {
            return (A)((Object)this);
        }
        for (AWSResourceTag item : items) {
            AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);
            this._visitables.get((Object)"resourceTags").remove((Object)builder);
            this.resourceTags.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromServiceEndpoints(AWSServiceEndpoint ... items) {
        if (this.serviceEndpoints == null) {
            return (A)((Object)this);
        }
        for (AWSServiceEndpoint item : items) {
            AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
            this._visitables.get((Object)"serviceEndpoints").remove((Object)builder);
            this.serviceEndpoints.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromResourceTags(Predicate<AWSResourceTagBuilder> predicate) {
        if (this.resourceTags == null) {
            return (A)((Object)this);
        }
        Iterator<AWSResourceTagBuilder> each = this.resourceTags.iterator();
        List visitables = this._visitables.get((Object)"resourceTags");
        while (each.hasNext()) {
            AWSResourceTagBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromServiceEndpoints(Predicate<AWSServiceEndpointBuilder> predicate) {
        if (this.serviceEndpoints == null) {
            return (A)((Object)this);
        }
        Iterator<AWSServiceEndpointBuilder> each = this.serviceEndpoints.iterator();
        List visitables = this._visitables.get((Object)"serviceEndpoints");
        while (each.hasNext()) {
            AWSServiceEndpointBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ResourceTagsNested<A> setNewResourceTagLike(int index, AWSResourceTag item) {
        return new ResourceTagsNested(index, item);
    }

    public ServiceEndpointsNested<A> setNewServiceEndpointLike(int index, AWSServiceEndpoint item) {
        return new ServiceEndpointsNested(index, item);
    }

    public A setToResourceTags(int index, AWSResourceTag item) {
        if (this.resourceTags == null) {
            this.resourceTags = new ArrayList();
        }
        AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);
        if (index < 0 || index >= this.resourceTags.size()) {
            this._visitables.get((Object)"resourceTags").add(builder);
            this.resourceTags.add(builder);
        } else {
            this._visitables.get((Object)"resourceTags").add(builder);
            this.resourceTags.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToServiceEndpoints(int index, AWSServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
        if (index < 0 || index >= this.serviceEndpoints.size()) {
            this._visitables.get((Object)"serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        } else {
            this._visitables.get((Object)"serviceEndpoints").add(builder);
            this.serviceEndpoints.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cloudLoadBalancerConfig != null) {
            sb.append("cloudLoadBalancerConfig:");
            sb.append((Object)this.cloudLoadBalancerConfig);
            sb.append(",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region);
            sb.append(",");
        }
        if (this.resourceTags != null && !this.resourceTags.isEmpty()) {
            sb.append("resourceTags:");
            sb.append(this.resourceTags);
            sb.append(",");
        }
        if (this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty()) {
            sb.append("serviceEndpoints:");
            sb.append(this.serviceEndpoints);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withCloudLoadBalancerConfig(CloudLoadBalancerConfig cloudLoadBalancerConfig) {
        this._visitables.remove((Object)"cloudLoadBalancerConfig");
        if (cloudLoadBalancerConfig != null) {
            this.cloudLoadBalancerConfig = new CloudLoadBalancerConfigBuilder(cloudLoadBalancerConfig);
            this._visitables.get((Object)"cloudLoadBalancerConfig").add(this.cloudLoadBalancerConfig);
        } else {
            this.cloudLoadBalancerConfig = null;
            this._visitables.get((Object)"cloudLoadBalancerConfig").remove((Object)this.cloudLoadBalancerConfig);
        }
        return (A)((Object)this);
    }

    public CloudLoadBalancerConfigNested<A> withNewCloudLoadBalancerConfig() {
        return new CloudLoadBalancerConfigNested(null);
    }

    public CloudLoadBalancerConfigNested<A> withNewCloudLoadBalancerConfigLike(CloudLoadBalancerConfig item) {
        return new CloudLoadBalancerConfigNested(item);
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)((Object)this);
    }

    public A withResourceTags(List<AWSResourceTag> resourceTags) {
        if (this.resourceTags != null) {
            this._visitables.get((Object)"resourceTags").clear();
        }
        if (resourceTags != null) {
            this.resourceTags = new ArrayList();
            for (AWSResourceTag item : resourceTags) {
                this.addToResourceTags(item);
            }
        } else {
            this.resourceTags = null;
        }
        return (A)((Object)this);
    }

    public A withResourceTags(AWSResourceTag ... resourceTags) {
        if (this.resourceTags != null) {
            this.resourceTags.clear();
            this._visitables.remove((Object)"resourceTags");
        }
        if (resourceTags != null) {
            for (AWSResourceTag item : resourceTags) {
                this.addToResourceTags(item);
            }
        }
        return (A)((Object)this);
    }

    public A withServiceEndpoints(List<AWSServiceEndpoint> serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this._visitables.get((Object)"serviceEndpoints").clear();
        }
        if (serviceEndpoints != null) {
            this.serviceEndpoints = new ArrayList();
            for (AWSServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        } else {
            this.serviceEndpoints = null;
        }
        return (A)((Object)this);
    }

    public A withServiceEndpoints(AWSServiceEndpoint ... serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this.serviceEndpoints.clear();
            this._visitables.remove((Object)"serviceEndpoints");
        }
        if (serviceEndpoints != null) {
            for (AWSServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        }
        return (A)((Object)this);
    }

    public class ServiceEndpointsNested<N>
    extends AWSServiceEndpointFluent<ServiceEndpointsNested<N>>
    implements Nested<N> {
        AWSServiceEndpointBuilder builder;
        int index;

        ServiceEndpointsNested(int index, AWSServiceEndpoint item) {
            this.index = index;
            this.builder = new AWSServiceEndpointBuilder(this, item);
        }

        public N and() {
            return (N)AWSPlatformStatusFluent.this.setToServiceEndpoints(this.index, this.builder.build());
        }

        public N endServiceEndpoint() {
            return this.and();
        }
    }

    public class ResourceTagsNested<N>
    extends AWSResourceTagFluent<ResourceTagsNested<N>>
    implements Nested<N> {
        AWSResourceTagBuilder builder;
        int index;

        ResourceTagsNested(int index, AWSResourceTag item) {
            this.index = index;
            this.builder = new AWSResourceTagBuilder(this, item);
        }

        public N and() {
            return (N)AWSPlatformStatusFluent.this.setToResourceTags(this.index, this.builder.build());
        }

        public N endResourceTag() {
            return this.and();
        }
    }

    public class CloudLoadBalancerConfigNested<N>
    extends CloudLoadBalancerConfigFluent<CloudLoadBalancerConfigNested<N>>
    implements Nested<N> {
        CloudLoadBalancerConfigBuilder builder;

        CloudLoadBalancerConfigNested(CloudLoadBalancerConfig item) {
            this.builder = new CloudLoadBalancerConfigBuilder(this, item);
        }

        public N and() {
            return (N)AWSPlatformStatusFluent.this.withCloudLoadBalancerConfig(this.builder.build());
        }

        public N endCloudLoadBalancerConfig() {
            return this.and();
        }
    }
}

