package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TokenIssuerBuilder extends TokenIssuerFluent<TokenIssuerBuilder> implements VisitableBuilder<TokenIssuer,TokenIssuerBuilder>{
  public TokenIssuerBuilder() {
    this(new TokenIssuer());
  }
  
  public TokenIssuerBuilder(TokenIssuerFluent<?> fluent) {
    this(fluent, new TokenIssuer());
  }
  
  public TokenIssuerBuilder(TokenIssuerFluent<?> fluent,TokenIssuer instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TokenIssuerBuilder(TokenIssuer instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TokenIssuerFluent<?> fluent;
  
  public TokenIssuer build() {
    TokenIssuer buildable = new TokenIssuer(fluent.getAudiences(),fluent.buildIssuerCertificateAuthority(),fluent.getIssuerURL());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}