package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TokenClaimValidationRuleFluent<A extends TokenClaimValidationRuleFluent<A>> extends BaseFluent<A>{
  public TokenClaimValidationRuleFluent() {
  }
  
  public TokenClaimValidationRuleFluent(TokenClaimValidationRule instance) {
    this.copyInstance(instance);
  }
  private TokenRequiredClaimBuilder requiredClaim;
  private String type;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TokenClaimValidationRule instance) {
    instance = (instance != null ? instance : new TokenClaimValidationRule());
    if (instance != null) {
          this.withRequiredClaim(instance.getRequiredClaim());
          this.withType(instance.getType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public TokenRequiredClaim buildRequiredClaim() {
    return this.requiredClaim != null ? this.requiredClaim.build() : null;
  }
  
  public A withRequiredClaim(TokenRequiredClaim requiredClaim) {
    this._visitables.remove("requiredClaim");
    if (requiredClaim != null) {
        this.requiredClaim = new TokenRequiredClaimBuilder(requiredClaim);
        this._visitables.get("requiredClaim").add(this.requiredClaim);
    } else {
        this.requiredClaim = null;
        this._visitables.get("requiredClaim").remove(this.requiredClaim);
    }
    return (A) this;
  }
  
  public boolean hasRequiredClaim() {
    return this.requiredClaim != null;
  }
  
  public A withNewRequiredClaim(String claim,String requiredValue) {
    return (A)withRequiredClaim(new TokenRequiredClaim(claim, requiredValue));
  }
  
  public RequiredClaimNested<A> withNewRequiredClaim() {
    return new RequiredClaimNested(null);
  }
  
  public RequiredClaimNested<A> withNewRequiredClaimLike(TokenRequiredClaim item) {
    return new RequiredClaimNested(item);
  }
  
  public RequiredClaimNested<A> editRequiredClaim() {
    return withNewRequiredClaimLike(java.util.Optional.ofNullable(buildRequiredClaim()).orElse(null));
  }
  
  public RequiredClaimNested<A> editOrNewRequiredClaim() {
    return withNewRequiredClaimLike(java.util.Optional.ofNullable(buildRequiredClaim()).orElse(new TokenRequiredClaimBuilder().build()));
  }
  
  public RequiredClaimNested<A> editOrNewRequiredClaimLike(TokenRequiredClaim item) {
    return withNewRequiredClaimLike(java.util.Optional.ofNullable(buildRequiredClaim()).orElse(item));
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TokenClaimValidationRuleFluent that = (TokenClaimValidationRuleFluent) o;
    if (!java.util.Objects.equals(requiredClaim, that.requiredClaim)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(requiredClaim,  type,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (requiredClaim != null) { sb.append("requiredClaim:"); sb.append(requiredClaim + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class RequiredClaimNested<N> extends TokenRequiredClaimFluent<RequiredClaimNested<N>> implements Nested<N>{
    RequiredClaimNested(TokenRequiredClaim item) {
      this.builder = new TokenRequiredClaimBuilder(this, item);
    }
    TokenRequiredClaimBuilder builder;
    
    public N and() {
      return (N) TokenClaimValidationRuleFluent.this.withRequiredClaim(builder.build());
    }
    
    public N endRequiredClaim() {
      return and();
    }
    
  
  }

}