package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TokenClaimMappingsFluent<A extends TokenClaimMappingsFluent<A>> extends BaseFluent<A>{
  public TokenClaimMappingsFluent() {
  }
  
  public TokenClaimMappingsFluent(TokenClaimMappings instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ExtraMappingBuilder> extra = new ArrayList<ExtraMappingBuilder>();
  private PrefixedClaimMappingBuilder groups;
  private TokenClaimOrExpressionMappingBuilder uid;
  private UsernameClaimMappingBuilder username;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TokenClaimMappings instance) {
    instance = (instance != null ? instance : new TokenClaimMappings());
    if (instance != null) {
          this.withExtra(instance.getExtra());
          this.withGroups(instance.getGroups());
          this.withUid(instance.getUid());
          this.withUsername(instance.getUsername());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToExtra(int index,ExtraMapping item) {
    if (this.extra == null) {this.extra = new ArrayList<ExtraMappingBuilder>();}
    ExtraMappingBuilder builder = new ExtraMappingBuilder(item);
    if (index < 0 || index >= extra.size()) {
        _visitables.get("extra").add(builder);
        extra.add(builder);
    } else {
        _visitables.get("extra").add(builder);
        extra.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToExtra(int index,ExtraMapping item) {
    if (this.extra == null) {this.extra = new ArrayList<ExtraMappingBuilder>();}
    ExtraMappingBuilder builder = new ExtraMappingBuilder(item);
    if (index < 0 || index >= extra.size()) {
        _visitables.get("extra").add(builder);
        extra.add(builder);
    } else {
        _visitables.get("extra").add(builder);
        extra.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToExtra(io.fabric8.openshift.api.model.config.v1.ExtraMapping... items) {
    if (this.extra == null) {this.extra = new ArrayList<ExtraMappingBuilder>();}
    for (ExtraMapping item : items) {ExtraMappingBuilder builder = new ExtraMappingBuilder(item);_visitables.get("extra").add(builder);this.extra.add(builder);} return (A)this;
  }
  
  public A addAllToExtra(Collection<ExtraMapping> items) {
    if (this.extra == null) {this.extra = new ArrayList<ExtraMappingBuilder>();}
    for (ExtraMapping item : items) {ExtraMappingBuilder builder = new ExtraMappingBuilder(item);_visitables.get("extra").add(builder);this.extra.add(builder);} return (A)this;
  }
  
  public A removeFromExtra(io.fabric8.openshift.api.model.config.v1.ExtraMapping... items) {
    if (this.extra == null) return (A)this;
    for (ExtraMapping item : items) {ExtraMappingBuilder builder = new ExtraMappingBuilder(item);_visitables.get("extra").remove(builder); this.extra.remove(builder);} return (A)this;
  }
  
  public A removeAllFromExtra(Collection<ExtraMapping> items) {
    if (this.extra == null) return (A)this;
    for (ExtraMapping item : items) {ExtraMappingBuilder builder = new ExtraMappingBuilder(item);_visitables.get("extra").remove(builder); this.extra.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromExtra(Predicate<ExtraMappingBuilder> predicate) {
    if (extra == null) return (A) this;
    final Iterator<ExtraMappingBuilder> each = extra.iterator();
    final List visitables = _visitables.get("extra");
    while (each.hasNext()) {
      ExtraMappingBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ExtraMapping> buildExtra() {
    return this.extra != null ? build(extra) : null;
  }
  
  public ExtraMapping buildExtra(int index) {
    return this.extra.get(index).build();
  }
  
  public ExtraMapping buildFirstExtra() {
    return this.extra.get(0).build();
  }
  
  public ExtraMapping buildLastExtra() {
    return this.extra.get(extra.size() - 1).build();
  }
  
  public ExtraMapping buildMatchingExtra(Predicate<ExtraMappingBuilder> predicate) {
      for (ExtraMappingBuilder item : extra) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingExtra(Predicate<ExtraMappingBuilder> predicate) {
      for (ExtraMappingBuilder item : extra) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withExtra(List<ExtraMapping> extra) {
    if (this.extra != null) {
      this._visitables.get("extra").clear();
    }
    if (extra != null) {
        this.extra = new ArrayList();
        for (ExtraMapping item : extra) {
          this.addToExtra(item);
        }
    } else {
      this.extra = null;
    }
    return (A) this;
  }
  
  public A withExtra(io.fabric8.openshift.api.model.config.v1.ExtraMapping... extra) {
    if (this.extra != null) {
        this.extra.clear();
        _visitables.remove("extra");
    }
    if (extra != null) {
      for (ExtraMapping item : extra) {
        this.addToExtra(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasExtra() {
    return this.extra != null && !this.extra.isEmpty();
  }
  
  public A addNewExtra(String key,String valueExpression) {
    return (A)addToExtra(new ExtraMapping(key, valueExpression));
  }
  
  public ExtraNested<A> addNewExtra() {
    return new ExtraNested(-1, null);
  }
  
  public ExtraNested<A> addNewExtraLike(ExtraMapping item) {
    return new ExtraNested(-1, item);
  }
  
  public ExtraNested<A> setNewExtraLike(int index,ExtraMapping item) {
    return new ExtraNested(index, item);
  }
  
  public ExtraNested<A> editExtra(int index) {
    if (extra.size() <= index) throw new RuntimeException("Can't edit extra. Index exceeds size.");
    return setNewExtraLike(index, buildExtra(index));
  }
  
  public ExtraNested<A> editFirstExtra() {
    if (extra.size() == 0) throw new RuntimeException("Can't edit first extra. The list is empty.");
    return setNewExtraLike(0, buildExtra(0));
  }
  
  public ExtraNested<A> editLastExtra() {
    int index = extra.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last extra. The list is empty.");
    return setNewExtraLike(index, buildExtra(index));
  }
  
  public ExtraNested<A> editMatchingExtra(Predicate<ExtraMappingBuilder> predicate) {
    int index = -1;
    for (int i=0;i<extra.size();i++) { 
    if (predicate.test(extra.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching extra. No match found.");
    return setNewExtraLike(index, buildExtra(index));
  }
  
  public PrefixedClaimMapping buildGroups() {
    return this.groups != null ? this.groups.build() : null;
  }
  
  public A withGroups(PrefixedClaimMapping groups) {
    this._visitables.remove("groups");
    if (groups != null) {
        this.groups = new PrefixedClaimMappingBuilder(groups);
        this._visitables.get("groups").add(this.groups);
    } else {
        this.groups = null;
        this._visitables.get("groups").remove(this.groups);
    }
    return (A) this;
  }
  
  public boolean hasGroups() {
    return this.groups != null;
  }
  
  public A withNewGroups(String claim,String prefix) {
    return (A)withGroups(new PrefixedClaimMapping(claim, prefix));
  }
  
  public GroupsNested<A> withNewGroups() {
    return new GroupsNested(null);
  }
  
  public GroupsNested<A> withNewGroupsLike(PrefixedClaimMapping item) {
    return new GroupsNested(item);
  }
  
  public GroupsNested<A> editGroups() {
    return withNewGroupsLike(java.util.Optional.ofNullable(buildGroups()).orElse(null));
  }
  
  public GroupsNested<A> editOrNewGroups() {
    return withNewGroupsLike(java.util.Optional.ofNullable(buildGroups()).orElse(new PrefixedClaimMappingBuilder().build()));
  }
  
  public GroupsNested<A> editOrNewGroupsLike(PrefixedClaimMapping item) {
    return withNewGroupsLike(java.util.Optional.ofNullable(buildGroups()).orElse(item));
  }
  
  public TokenClaimOrExpressionMapping buildUid() {
    return this.uid != null ? this.uid.build() : null;
  }
  
  public A withUid(TokenClaimOrExpressionMapping uid) {
    this._visitables.remove("uid");
    if (uid != null) {
        this.uid = new TokenClaimOrExpressionMappingBuilder(uid);
        this._visitables.get("uid").add(this.uid);
    } else {
        this.uid = null;
        this._visitables.get("uid").remove(this.uid);
    }
    return (A) this;
  }
  
  public boolean hasUid() {
    return this.uid != null;
  }
  
  public A withNewUid(String claim,String expression) {
    return (A)withUid(new TokenClaimOrExpressionMapping(claim, expression));
  }
  
  public UidNested<A> withNewUid() {
    return new UidNested(null);
  }
  
  public UidNested<A> withNewUidLike(TokenClaimOrExpressionMapping item) {
    return new UidNested(item);
  }
  
  public UidNested<A> editUid() {
    return withNewUidLike(java.util.Optional.ofNullable(buildUid()).orElse(null));
  }
  
  public UidNested<A> editOrNewUid() {
    return withNewUidLike(java.util.Optional.ofNullable(buildUid()).orElse(new TokenClaimOrExpressionMappingBuilder().build()));
  }
  
  public UidNested<A> editOrNewUidLike(TokenClaimOrExpressionMapping item) {
    return withNewUidLike(java.util.Optional.ofNullable(buildUid()).orElse(item));
  }
  
  public UsernameClaimMapping buildUsername() {
    return this.username != null ? this.username.build() : null;
  }
  
  public A withUsername(UsernameClaimMapping username) {
    this._visitables.remove("username");
    if (username != null) {
        this.username = new UsernameClaimMappingBuilder(username);
        this._visitables.get("username").add(this.username);
    } else {
        this.username = null;
        this._visitables.get("username").remove(this.username);
    }
    return (A) this;
  }
  
  public boolean hasUsername() {
    return this.username != null;
  }
  
  public UsernameNested<A> withNewUsername() {
    return new UsernameNested(null);
  }
  
  public UsernameNested<A> withNewUsernameLike(UsernameClaimMapping item) {
    return new UsernameNested(item);
  }
  
  public UsernameNested<A> editUsername() {
    return withNewUsernameLike(java.util.Optional.ofNullable(buildUsername()).orElse(null));
  }
  
  public UsernameNested<A> editOrNewUsername() {
    return withNewUsernameLike(java.util.Optional.ofNullable(buildUsername()).orElse(new UsernameClaimMappingBuilder().build()));
  }
  
  public UsernameNested<A> editOrNewUsernameLike(UsernameClaimMapping item) {
    return withNewUsernameLike(java.util.Optional.ofNullable(buildUsername()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TokenClaimMappingsFluent that = (TokenClaimMappingsFluent) o;
    if (!java.util.Objects.equals(extra, that.extra)) return false;
    if (!java.util.Objects.equals(groups, that.groups)) return false;
    if (!java.util.Objects.equals(uid, that.uid)) return false;
    if (!java.util.Objects.equals(username, that.username)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(extra,  groups,  uid,  username,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (extra != null && !extra.isEmpty()) { sb.append("extra:"); sb.append(extra + ","); }
    if (groups != null) { sb.append("groups:"); sb.append(groups + ","); }
    if (uid != null) { sb.append("uid:"); sb.append(uid + ","); }
    if (username != null) { sb.append("username:"); sb.append(username + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ExtraNested<N> extends ExtraMappingFluent<ExtraNested<N>> implements Nested<N>{
    ExtraNested(int index,ExtraMapping item) {
      this.index = index;
      this.builder = new ExtraMappingBuilder(this, item);
    }
    ExtraMappingBuilder builder;
    int index;
    
    public N and() {
      return (N) TokenClaimMappingsFluent.this.setToExtra(index,builder.build());
    }
    
    public N endExtra() {
      return and();
    }
    
  
  }
  public class GroupsNested<N> extends PrefixedClaimMappingFluent<GroupsNested<N>> implements Nested<N>{
    GroupsNested(PrefixedClaimMapping item) {
      this.builder = new PrefixedClaimMappingBuilder(this, item);
    }
    PrefixedClaimMappingBuilder builder;
    
    public N and() {
      return (N) TokenClaimMappingsFluent.this.withGroups(builder.build());
    }
    
    public N endGroups() {
      return and();
    }
    
  
  }
  public class UidNested<N> extends TokenClaimOrExpressionMappingFluent<UidNested<N>> implements Nested<N>{
    UidNested(TokenClaimOrExpressionMapping item) {
      this.builder = new TokenClaimOrExpressionMappingBuilder(this, item);
    }
    TokenClaimOrExpressionMappingBuilder builder;
    
    public N and() {
      return (N) TokenClaimMappingsFluent.this.withUid(builder.build());
    }
    
    public N endUid() {
      return and();
    }
    
  
  }
  public class UsernameNested<N> extends UsernameClaimMappingFluent<UsernameNested<N>> implements Nested<N>{
    UsernameNested(UsernameClaimMapping item) {
      this.builder = new UsernameClaimMappingBuilder(this, item);
    }
    UsernameClaimMappingBuilder builder;
    
    public N and() {
      return (N) TokenClaimMappingsFluent.this.withUsername(builder.build());
    }
    
    public N endUsername() {
      return and();
    }
    
  
  }

}