package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TestDetailsBuilder extends TestDetailsFluent<TestDetailsBuilder> implements VisitableBuilder<TestDetails,TestDetailsBuilder>{
  public TestDetailsBuilder() {
    this(new TestDetails());
  }
  
  public TestDetailsBuilder(TestDetailsFluent<?> fluent) {
    this(fluent, new TestDetails());
  }
  
  public TestDetailsBuilder(TestDetailsFluent<?> fluent,TestDetails instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TestDetailsBuilder(TestDetails instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TestDetailsFluent<?> fluent;
  
  public TestDetails build() {
    TestDetails buildable = new TestDetails(fluent.getTestName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}