package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OperatorHubBuilder extends OperatorHubFluent<OperatorHubBuilder> implements VisitableBuilder<OperatorHub,OperatorHubBuilder>{
  public OperatorHubBuilder() {
    this(new OperatorHub());
  }
  
  public OperatorHubBuilder(OperatorHubFluent<?> fluent) {
    this(fluent, new OperatorHub());
  }
  
  public OperatorHubBuilder(OperatorHubFluent<?> fluent,OperatorHub instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OperatorHubBuilder(OperatorHub instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OperatorHubFluent<?> fluent;
  
  public OperatorHub build() {
    OperatorHub buildable = new OperatorHub(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}