package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OIDCClientReferenceFluent<A extends OIDCClientReferenceFluent<A>> extends BaseFluent<A>{
  public OIDCClientReferenceFluent() {
  }
  
  public OIDCClientReferenceFluent(OIDCClientReference instance) {
    this.copyInstance(instance);
  }
  private String clientID;
  private String issuerURL;
  private String oidcProviderName;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(OIDCClientReference instance) {
    instance = (instance != null ? instance : new OIDCClientReference());
    if (instance != null) {
          this.withClientID(instance.getClientID());
          this.withIssuerURL(instance.getIssuerURL());
          this.withOidcProviderName(instance.getOidcProviderName());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getClientID() {
    return this.clientID;
  }
  
  public A withClientID(String clientID) {
    this.clientID = clientID;
    return (A) this;
  }
  
  public boolean hasClientID() {
    return this.clientID != null;
  }
  
  public String getIssuerURL() {
    return this.issuerURL;
  }
  
  public A withIssuerURL(String issuerURL) {
    this.issuerURL = issuerURL;
    return (A) this;
  }
  
  public boolean hasIssuerURL() {
    return this.issuerURL != null;
  }
  
  public String getOidcProviderName() {
    return this.oidcProviderName;
  }
  
  public A withOidcProviderName(String oidcProviderName) {
    this.oidcProviderName = oidcProviderName;
    return (A) this;
  }
  
  public boolean hasOidcProviderName() {
    return this.oidcProviderName != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OIDCClientReferenceFluent that = (OIDCClientReferenceFluent) o;
    if (!java.util.Objects.equals(clientID, that.clientID)) return false;
    if (!java.util.Objects.equals(issuerURL, that.issuerURL)) return false;
    if (!java.util.Objects.equals(oidcProviderName, that.oidcProviderName)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clientID,  issuerURL,  oidcProviderName,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clientID != null) { sb.append("clientID:"); sb.append(clientID + ","); }
    if (issuerURL != null) { sb.append("issuerURL:"); sb.append(issuerURL + ","); }
    if (oidcProviderName != null) { sb.append("oidcProviderName:"); sb.append(oidcProviderName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}