package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NutanixPrismEndpointBuilder extends NutanixPrismEndpointFluent<NutanixPrismEndpointBuilder> implements VisitableBuilder<NutanixPrismEndpoint,NutanixPrismEndpointBuilder>{
  public NutanixPrismEndpointBuilder() {
    this(new NutanixPrismEndpoint());
  }
  
  public NutanixPrismEndpointBuilder(NutanixPrismEndpointFluent<?> fluent) {
    this(fluent, new NutanixPrismEndpoint());
  }
  
  public NutanixPrismEndpointBuilder(NutanixPrismEndpointFluent<?> fluent,NutanixPrismEndpoint instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NutanixPrismEndpointBuilder(NutanixPrismEndpoint instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NutanixPrismEndpointFluent<?> fluent;
  
  public NutanixPrismEndpoint build() {
    NutanixPrismEndpoint buildable = new NutanixPrismEndpoint(fluent.getAddress(),fluent.getPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}