package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.Condition;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NetworkStatusFluent<A extends NetworkStatusFluent<A>> extends BaseFluent<A>{
  public NetworkStatusFluent() {
  }
  
  public NetworkStatusFluent(NetworkStatus instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ClusterNetworkEntryBuilder> clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
  private Integer clusterNetworkMTU;
  private List<Condition> conditions = new ArrayList<Condition>();
  private NetworkMigrationBuilder migration;
  private String networkType;
  private List<String> serviceNetwork = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NetworkStatus instance) {
    instance = (instance != null ? instance : new NetworkStatus());
    if (instance != null) {
          this.withClusterNetwork(instance.getClusterNetwork());
          this.withClusterNetworkMTU(instance.getClusterNetworkMTU());
          this.withConditions(instance.getConditions());
          this.withMigration(instance.getMigration());
          this.withNetworkType(instance.getNetworkType());
          this.withServiceNetwork(instance.getServiceNetwork());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToClusterNetwork(int index,ClusterNetworkEntry item) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
    if (index < 0 || index >= clusterNetwork.size()) {
        _visitables.get("clusterNetwork").add(builder);
        clusterNetwork.add(builder);
    } else {
        _visitables.get("clusterNetwork").add(builder);
        clusterNetwork.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToClusterNetwork(int index,ClusterNetworkEntry item) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
    if (index < 0 || index >= clusterNetwork.size()) {
        _visitables.get("clusterNetwork").add(builder);
        clusterNetwork.add(builder);
    } else {
        _visitables.get("clusterNetwork").add(builder);
        clusterNetwork.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToClusterNetwork(io.fabric8.openshift.api.model.config.v1.ClusterNetworkEntry... items) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
  }
  
  public A addAllToClusterNetwork(Collection<ClusterNetworkEntry> items) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
  }
  
  public A removeFromClusterNetwork(io.fabric8.openshift.api.model.config.v1.ClusterNetworkEntry... items) {
    if (this.clusterNetwork == null) return (A)this;
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder); this.clusterNetwork.remove(builder);} return (A)this;
  }
  
  public A removeAllFromClusterNetwork(Collection<ClusterNetworkEntry> items) {
    if (this.clusterNetwork == null) return (A)this;
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder); this.clusterNetwork.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    if (clusterNetwork == null) return (A) this;
    final Iterator<ClusterNetworkEntryBuilder> each = clusterNetwork.iterator();
    final List visitables = _visitables.get("clusterNetwork");
    while (each.hasNext()) {
      ClusterNetworkEntryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ClusterNetworkEntry> buildClusterNetwork() {
    return this.clusterNetwork != null ? build(clusterNetwork) : null;
  }
  
  public ClusterNetworkEntry buildClusterNetwork(int index) {
    return this.clusterNetwork.get(index).build();
  }
  
  public ClusterNetworkEntry buildFirstClusterNetwork() {
    return this.clusterNetwork.get(0).build();
  }
  
  public ClusterNetworkEntry buildLastClusterNetwork() {
    return this.clusterNetwork.get(clusterNetwork.size() - 1).build();
  }
  
  public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
      for (ClusterNetworkEntryBuilder item : clusterNetwork) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
      for (ClusterNetworkEntryBuilder item : clusterNetwork) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withClusterNetwork(List<ClusterNetworkEntry> clusterNetwork) {
    if (this.clusterNetwork != null) {
      this._visitables.get("clusterNetwork").clear();
    }
    if (clusterNetwork != null) {
        this.clusterNetwork = new ArrayList();
        for (ClusterNetworkEntry item : clusterNetwork) {
          this.addToClusterNetwork(item);
        }
    } else {
      this.clusterNetwork = null;
    }
    return (A) this;
  }
  
  public A withClusterNetwork(io.fabric8.openshift.api.model.config.v1.ClusterNetworkEntry... clusterNetwork) {
    if (this.clusterNetwork != null) {
        this.clusterNetwork.clear();
        _visitables.remove("clusterNetwork");
    }
    if (clusterNetwork != null) {
      for (ClusterNetworkEntry item : clusterNetwork) {
        this.addToClusterNetwork(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasClusterNetwork() {
    return this.clusterNetwork != null && !this.clusterNetwork.isEmpty();
  }
  
  public A addNewClusterNetwork(String cidr,Long hostPrefix) {
    return (A)addToClusterNetwork(new ClusterNetworkEntry(cidr, hostPrefix));
  }
  
  public ClusterNetworkNested<A> addNewClusterNetwork() {
    return new ClusterNetworkNested(-1, null);
  }
  
  public ClusterNetworkNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item) {
    return new ClusterNetworkNested(-1, item);
  }
  
  public ClusterNetworkNested<A> setNewClusterNetworkLike(int index,ClusterNetworkEntry item) {
    return new ClusterNetworkNested(index, item);
  }
  
  public ClusterNetworkNested<A> editClusterNetwork(int index) {
    if (clusterNetwork.size() <= index) throw new RuntimeException("Can't edit clusterNetwork. Index exceeds size.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  
  public ClusterNetworkNested<A> editFirstClusterNetwork() {
    if (clusterNetwork.size() == 0) throw new RuntimeException("Can't edit first clusterNetwork. The list is empty.");
    return setNewClusterNetworkLike(0, buildClusterNetwork(0));
  }
  
  public ClusterNetworkNested<A> editLastClusterNetwork() {
    int index = clusterNetwork.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusterNetwork. The list is empty.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  
  public ClusterNetworkNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusterNetwork.size();i++) { 
    if (predicate.test(clusterNetwork.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusterNetwork. No match found.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  
  public Integer getClusterNetworkMTU() {
    return this.clusterNetworkMTU;
  }
  
  public A withClusterNetworkMTU(Integer clusterNetworkMTU) {
    this.clusterNetworkMTU = clusterNetworkMTU;
    return (A) this;
  }
  
  public boolean hasClusterNetworkMTU() {
    return this.clusterNetworkMTU != null;
  }
  
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<Condition> items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public List<Condition> getConditions() {
    return this.conditions;
  }
  
  public Condition getCondition(int index) {
    return this.conditions.get(index);
  }
  
  public Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  
  public Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  
  public Condition getMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<Condition> conditions) {
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (Condition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (Condition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public NetworkMigration buildMigration() {
    return this.migration != null ? this.migration.build() : null;
  }
  
  public A withMigration(NetworkMigration migration) {
    this._visitables.remove("migration");
    if (migration != null) {
        this.migration = new NetworkMigrationBuilder(migration);
        this._visitables.get("migration").add(this.migration);
    } else {
        this.migration = null;
        this._visitables.get("migration").remove(this.migration);
    }
    return (A) this;
  }
  
  public boolean hasMigration() {
    return this.migration != null;
  }
  
  public MigrationNested<A> withNewMigration() {
    return new MigrationNested(null);
  }
  
  public MigrationNested<A> withNewMigrationLike(NetworkMigration item) {
    return new MigrationNested(item);
  }
  
  public MigrationNested<A> editMigration() {
    return withNewMigrationLike(java.util.Optional.ofNullable(buildMigration()).orElse(null));
  }
  
  public MigrationNested<A> editOrNewMigration() {
    return withNewMigrationLike(java.util.Optional.ofNullable(buildMigration()).orElse(new NetworkMigrationBuilder().build()));
  }
  
  public MigrationNested<A> editOrNewMigrationLike(NetworkMigration item) {
    return withNewMigrationLike(java.util.Optional.ofNullable(buildMigration()).orElse(item));
  }
  
  public String getNetworkType() {
    return this.networkType;
  }
  
  public A withNetworkType(String networkType) {
    this.networkType = networkType;
    return (A) this;
  }
  
  public boolean hasNetworkType() {
    return this.networkType != null;
  }
  
  public A addToServiceNetwork(int index,String item) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    this.serviceNetwork.add(index, item);
    return (A)this;
  }
  
  public A setToServiceNetwork(int index,String item) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    this.serviceNetwork.set(index, item); return (A)this;
  }
  
  public A addToServiceNetwork(java.lang.String... items) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    for (String item : items) {this.serviceNetwork.add(item);} return (A)this;
  }
  
  public A addAllToServiceNetwork(Collection<String> items) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    for (String item : items) {this.serviceNetwork.add(item);} return (A)this;
  }
  
  public A removeFromServiceNetwork(java.lang.String... items) {
    if (this.serviceNetwork == null) return (A)this;
    for (String item : items) { this.serviceNetwork.remove(item);} return (A)this;
  }
  
  public A removeAllFromServiceNetwork(Collection<String> items) {
    if (this.serviceNetwork == null) return (A)this;
    for (String item : items) { this.serviceNetwork.remove(item);} return (A)this;
  }
  
  public List<String> getServiceNetwork() {
    return this.serviceNetwork;
  }
  
  public String getServiceNetwork(int index) {
    return this.serviceNetwork.get(index);
  }
  
  public String getFirstServiceNetwork() {
    return this.serviceNetwork.get(0);
  }
  
  public String getLastServiceNetwork() {
    return this.serviceNetwork.get(serviceNetwork.size() - 1);
  }
  
  public String getMatchingServiceNetwork(Predicate<String> predicate) {
      for (String item : serviceNetwork) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingServiceNetwork(Predicate<String> predicate) {
      for (String item : serviceNetwork) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withServiceNetwork(List<String> serviceNetwork) {
    if (serviceNetwork != null) {
        this.serviceNetwork = new ArrayList();
        for (String item : serviceNetwork) {
          this.addToServiceNetwork(item);
        }
    } else {
      this.serviceNetwork = null;
    }
    return (A) this;
  }
  
  public A withServiceNetwork(java.lang.String... serviceNetwork) {
    if (this.serviceNetwork != null) {
        this.serviceNetwork.clear();
        _visitables.remove("serviceNetwork");
    }
    if (serviceNetwork != null) {
      for (String item : serviceNetwork) {
        this.addToServiceNetwork(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasServiceNetwork() {
    return this.serviceNetwork != null && !this.serviceNetwork.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkStatusFluent that = (NetworkStatusFluent) o;
    if (!java.util.Objects.equals(clusterNetwork, that.clusterNetwork)) return false;
    if (!java.util.Objects.equals(clusterNetworkMTU, that.clusterNetworkMTU)) return false;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(migration, that.migration)) return false;
    if (!java.util.Objects.equals(networkType, that.networkType)) return false;
    if (!java.util.Objects.equals(serviceNetwork, that.serviceNetwork)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clusterNetwork,  clusterNetworkMTU,  conditions,  migration,  networkType,  serviceNetwork,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterNetwork != null && !clusterNetwork.isEmpty()) { sb.append("clusterNetwork:"); sb.append(clusterNetwork + ","); }
    if (clusterNetworkMTU != null) { sb.append("clusterNetworkMTU:"); sb.append(clusterNetworkMTU + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (migration != null) { sb.append("migration:"); sb.append(migration + ","); }
    if (networkType != null) { sb.append("networkType:"); sb.append(networkType + ","); }
    if (serviceNetwork != null && !serviceNetwork.isEmpty()) { sb.append("serviceNetwork:"); sb.append(serviceNetwork + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClusterNetworkNested<N> extends ClusterNetworkEntryFluent<ClusterNetworkNested<N>> implements Nested<N>{
    ClusterNetworkNested(int index,ClusterNetworkEntry item) {
      this.index = index;
      this.builder = new ClusterNetworkEntryBuilder(this, item);
    }
    ClusterNetworkEntryBuilder builder;
    int index;
    
    public N and() {
      return (N) NetworkStatusFluent.this.setToClusterNetwork(index,builder.build());
    }
    
    public N endClusterNetwork() {
      return and();
    }
    
  
  }
  public class MigrationNested<N> extends NetworkMigrationFluent<MigrationNested<N>> implements Nested<N>{
    MigrationNested(NetworkMigration item) {
      this.builder = new NetworkMigrationBuilder(this, item);
    }
    NetworkMigrationBuilder builder;
    
    public N and() {
      return (N) NetworkStatusFluent.this.withMigration(builder.build());
    }
    
    public N endMigration() {
      return and();
    }
    
  
  }

}